/*
 * Decompiled with CFR 0.152.
 */
package vscript.interpreter;

import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import vscript.VScriptRunner;
import vscript.interpreter.EventMessageGroup;
import vscript.message.Message;
import vscript.message.MessageNode;
import vscript.parser.Parser;

public class EventTagManager {
    private VScriptRunner vsr;
    private MessageNode messageNode;
    private HashMap eventMessageMap = new HashMap(8);

    public EventTagManager(MessageNode messageNode) {
        this.vsr = VScriptRunner.getVScriptRunner();
        this.messageNode = messageNode;
    }

    public EventTagManager(VScriptRunner vScriptRunner, MessageNode messageNode) {
        this.vsr = vScriptRunner;
        this.messageNode = messageNode;
    }

    public void deliverMessage(String string) {
        Message message = Parser.parseMessage(string);
        this.deliverMessage(message);
    }

    void addEventMessageGroup(EventMessageGroup eventMessageGroup) {
        this.eventMessageMap.put(eventMessageGroup.eventName, eventMessageGroup);
    }

    public boolean processEvent(String string) {
        if (this.eventMessageMap.containsKey(string)) {
            EventMessageGroup eventMessageGroup = (EventMessageGroup)this.eventMessageMap.get(string);
            List list = eventMessageGroup.messageList;
            ListIterator listIterator = list.listIterator(0);
            while (listIterator.hasNext()) {
                Message message = (Message)listIterator.next();
                this.deliverMessage(message);
            }
            return true;
        }
        return false;
    }

    private void deliverMessage(Message message) {
        message.setSourceMessageNode(this.messageNode);
        this.vsr.addToMessageQueue(message);
    }
}

