import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

import vscript.message.Messagable;
import vscript.interpreter.*;
import vscript.message.Message;
import vscript.interpreter.EventTagManager;




public class BeepComponent extends JButton implements Messagable,ActionListener
{

private EventTagManager etm;

	public BeepComponent(String text)
	{
		super(text);
		addActionListener(this);	
	}

	public void actionPerformed(ActionEvent ae)
	{
		Toolkit.getDefaultToolkit().beep();	
		
		etm.processEvent("beep");//Generate beep event
	}

	public void handleMessage(Message message) { //handle beep message
		
		String msg=message.getMessageString();
		
		TagInterpreter.handleMessageGUI(this,message);/*helper method to handle common
										GUI messages like bcolor,border,resize....etc.
										This method may or may not be used and is used only 
										for GUI components.
										*/
		
		if(msg.equals("beep"))
		{
			Toolkit.getDefaultToolkit().beep();	
		
			etm.processEvent("beep");//Generate beep event	
		}
		
	}

	public void setEventTagManager(EventTagManager etm) {
		this.etm=etm;	//Store EventTagManager instance.
	}

	public String getDataValue(String data) {//return 'beeper' if data is requested.
		
		if(data.equals("data"))return "beeper";
		return null;
	}
	
	
}