/*
 * Decompiled with CFR 0.152.
 */
package com.oreilly.servlet;

import com.oreilly.servlet.ParameterNotFoundException;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import javax.servlet.ServletRequest;

public class ParameterParser {
    private ServletRequest req;
    private String encoding;

    public ParameterParser(ServletRequest servletRequest) {
        this.req = servletRequest;
    }

    public void setCharacterEncoding(String string) throws UnsupportedEncodingException {
        new String("".getBytes("8859_1"), string);
        this.encoding = string;
    }

    public String getStringParameter(String string) throws ParameterNotFoundException {
        String[] stringArray = this.req.getParameterValues(string);
        if (stringArray == null) {
            throw new ParameterNotFoundException(string + " not found");
        }
        if (stringArray[0].length() == 0) {
            throw new ParameterNotFoundException(string + " was empty");
        }
        if (this.encoding == null) {
            return stringArray[0];
        }
        try {
            return new String(stringArray[0].getBytes("8859_1"), this.encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return stringArray[0];
        }
    }

    public String getStringParameter(String string, String string2) {
        try {
            return this.getStringParameter(string);
        }
        catch (Exception exception) {
            return string2;
        }
    }

    public boolean getBooleanParameter(String string) throws ParameterNotFoundException, NumberFormatException {
        String string2 = this.getStringParameter(string).toLowerCase();
        if (string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("on") || string2.equalsIgnoreCase("yes")) {
            return true;
        }
        if (string2.equalsIgnoreCase("false") || string2.equalsIgnoreCase("off") || string2.equalsIgnoreCase("no")) {
            return false;
        }
        throw new NumberFormatException("Parameter " + string + " value " + string2 + " is not a boolean");
    }

    public boolean getBooleanParameter(String string, boolean bl) {
        try {
            return this.getBooleanParameter(string);
        }
        catch (Exception exception) {
            return bl;
        }
    }

    public byte getByteParameter(String string) throws ParameterNotFoundException, NumberFormatException {
        return Byte.parseByte(this.getStringParameter(string));
    }

    public byte getByteParameter(String string, byte by) {
        try {
            return this.getByteParameter(string);
        }
        catch (Exception exception) {
            return by;
        }
    }

    public char getCharParameter(String string) throws ParameterNotFoundException {
        String string2 = this.getStringParameter(string);
        if (string2.length() == 0) {
            throw new ParameterNotFoundException(string + " is empty string");
        }
        return string2.charAt(0);
    }

    public char getCharParameter(String string, char c) {
        try {
            return this.getCharParameter(string);
        }
        catch (Exception exception) {
            return c;
        }
    }

    public double getDoubleParameter(String string) throws ParameterNotFoundException, NumberFormatException {
        return new Double(this.getStringParameter(string));
    }

    public double getDoubleParameter(String string, double d) {
        try {
            return this.getDoubleParameter(string);
        }
        catch (Exception exception) {
            return d;
        }
    }

    public float getFloatParameter(String string) throws ParameterNotFoundException, NumberFormatException {
        return new Float(this.getStringParameter(string)).floatValue();
    }

    public float getFloatParameter(String string, float f) {
        try {
            return this.getFloatParameter(string);
        }
        catch (Exception exception) {
            return f;
        }
    }

    public int getIntParameter(String string) throws ParameterNotFoundException, NumberFormatException {
        return Integer.parseInt(this.getStringParameter(string));
    }

    public int getIntParameter(String string, int n) {
        try {
            return this.getIntParameter(string);
        }
        catch (Exception exception) {
            return n;
        }
    }

    public long getLongParameter(String string) throws ParameterNotFoundException, NumberFormatException {
        return Long.parseLong(this.getStringParameter(string));
    }

    public long getLongParameter(String string, long l) {
        try {
            return this.getLongParameter(string);
        }
        catch (Exception exception) {
            return l;
        }
    }

    public short getShortParameter(String string) throws ParameterNotFoundException, NumberFormatException {
        return Short.parseShort(this.getStringParameter(string));
    }

    public short getShortParameter(String string, short s) {
        try {
            return this.getShortParameter(string);
        }
        catch (Exception exception) {
            return s;
        }
    }

    public String[] getMissingParameters(String[] stringArray) {
        Object object;
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < stringArray.length) {
            object = this.getStringParameter(stringArray[n], null);
            if (object == null) {
                vector.addElement(stringArray[n]);
            }
            ++n;
        }
        if (vector.size() == 0) {
            return null;
        }
        object = new String[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }
}

