/*
 * Decompiled with CFR 0.152.
 */
package javazoom.upload;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javazoom.upload.Archiver;
import javazoom.upload.DBStore;
import javazoom.upload.MultipartFormDataRequest;
import javazoom.upload.UploadException;
import javazoom.upload.UploadFile;
import javazoom.upload.UploadListener;
import javazoom.upload.UploadParameters;

public class UploadBean
implements Serializable {
    public static final int MAXUPLOADEDFILES = -1;
    public static final long MAXUPLOADEDFILESIZE = 0x40000000L;
    public static char SEPARATOR = (char)47;
    public static final int MEMORYSTORE = 0;
    public static final int FOLDERSTORE = 1;
    public static final int DATABASESTORE = 2;
    public static final int ZIPFILESTORE = 3;
    public static final int TARGZIPFILESTORE = 4;
    public static final int SERIALIZEDFILESTORE = 5;
    public static final int XMLFILESTORE = 6;
    public static final String EMPTYENTRY = "EmptyFile";
    public static int TRANSFERTBUFFERSIZE = 4096;
    public static String SQLUPLOADTABLE = "UPLOADS";
    public static String SQLUPLOADID = "UPLOADID";
    public static String SQLUPLOADFILENAME = "FILENAME";
    public static String SQLUPLOADFILE = "BINARYFILE";
    public static boolean INSERTASBYTES = false;
    private int _$358 = 0;
    private Vector _$359 = null;
    private Vector _$360 = null;
    private boolean _$361 = true;
    private int _$362 = -1;
    private long _$363 = 0x40000000L;
    private boolean _$364 = false;
    private String _$365 = null;
    private String _$366 = null;
    private String _$367 = "javazoom.upload.DefaultDBStore";
    private DBStore _$369 = null;
    private Vector _$372 = null;
    private Vector _$373 = new Vector();
    private Vector _$374 = null;

    public UploadBean() {
        this._$372 = new Vector();
        this._$359 = new Vector();
        this._$360 = new Vector();
        SEPARATOR = System.getProperty("file.separator").charAt(0);
        this._$374 = new Vector();
    }

    public void addUploadListener(UploadListener uploadListener) {
        if (this._$372 != null) {
            this._$372.addElement(uploadListener);
        }
    }

    public void setStoremodel(int n) throws UploadException {
        if (n != 0 && n != 1 && n != 2 && n != 3 && n != 4 && n != 5 && n != 6) {
            throw new UploadException(UploadException.UNKNOWNSTOREMODEL);
        }
        this._$358 = n;
    }

    public Connection getDatabasestore() {
        if (this._$369 != null) {
            return this._$369.getConnection();
        }
        return null;
    }

    public DBStore getDatabasestoreimplementation() {
        return this._$369;
    }

    public String getZipfilestore() {
        return this._$366;
    }

    public String getFolderstore() {
        return this._$365;
    }

    public Vector getMemorystore() {
        return this._$374;
    }

    public void setMemorystore() throws UploadException {
        this.setStoremodel(0);
    }

    public void setFolderstore(String string) throws UploadException {
        this.setStoremodel(1);
        this._$365 = string;
        this._$365 = this._$365.replace('\\', '/').replace('/', SEPARATOR);
        File file = new File(this._$365 + SEPARATOR);
        if (file.exists()) {
            if (!file.canWrite()) {
                throw new UploadException(UploadException.FOLDERISREADONLY);
            }
        } else if (!file.mkdirs()) {
            throw new UploadException(UploadException.CANNOTCREATEFOLDER);
        }
    }

    public void setZipfilestore(String string) throws UploadException, IOException {
        this.setStoremodel(3);
        string = string.replace('\\', '/').replace('/', SEPARATOR);
        File file = new File(string);
        this._$366 = string;
        if (!file.exists()) {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
            zipOutputStream.putNextEntry(new ZipEntry(EMPTYENTRY));
            zipOutputStream.closeEntry();
            zipOutputStream.close();
            fileOutputStream.close();
        }
    }

    public void setDatabasestoreimplementation(String string) throws UploadException {
        this._$367 = string;
    }

    public void setDatabasestore(String string, String string2, Properties properties) throws Exception {
        this.setStoremodel(2);
        this._$407();
        this._$369.connect(string, string2, properties);
    }

    public void setDatabasestore(Connection connection) throws Exception {
        this.setStoremodel(2);
        this._$407();
        this._$369.connect(connection, null, null);
    }

    public String getBlacklist() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this._$359.size()) {
            if (n > 0) {
                stringBuffer.append(",");
            }
            String string = (String)this._$359.elementAt(n);
            stringBuffer.append(string);
            ++n;
        }
        return stringBuffer.toString();
    }

    public void setBlacklist(String string) {
        this._$359 = new Vector();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreElements()) {
            String string2 = (String)stringTokenizer.nextElement();
            this._$359.addElement(string2);
        }
        this._$361 = true;
    }

    public String getWhitelist() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this._$360.size()) {
            if (n > 0) {
                stringBuffer.append(",");
            }
            String string = (String)this._$360.elementAt(n);
            stringBuffer.append(string);
            ++n;
        }
        return stringBuffer.toString();
    }

    public void setWhitelist(String string) {
        this._$360 = new Vector();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreElements()) {
            String string2 = (String)stringTokenizer.nextElement();
            this._$360.addElement(string2);
        }
        this._$361 = false;
    }

    public boolean isBlacklistEnabled() {
        return this._$361;
    }

    public void setOverwrite(boolean bl) {
        this._$364 = bl;
    }

    public boolean getOverwrite() {
        return this._$364;
    }

    public void setParser(String string) {
        MultipartFormDataRequest.DEFAULTPARSER = string;
    }

    public String getParser() {
        return MultipartFormDataRequest.DEFAULTPARSER;
    }

    public String getParsertmpdir() {
        return MultipartFormDataRequest.PARSERTEMPDIRECTORY;
    }

    public void setParsertmpdir(String string) {
        if (string != null) {
            MultipartFormDataRequest.PARSERTEMPDIRECTORY = string = string.replace('\\', '/').replace('/', SEPARATOR);
            File file = new File(string);
            if (!file.exists()) {
                file.mkdirs();
            }
        }
    }

    public void setMaxfiles(int n) {
        this._$362 = n;
    }

    public int getMaxfiles() {
        return this._$362;
    }

    public long getFilesizelimit() {
        return this._$363;
    }

    public void setFilesizelimit(long l) {
        this._$363 = l;
    }

    private boolean _$435(String string) {
        boolean bl = false;
        int n = 0;
        while (n < this._$359.size()) {
            String string2 = (String)this._$359.elementAt(n);
            String string3 = "";
            String string4 = "";
            int n2 = string2.lastIndexOf(".");
            if (n2 != -1) {
                string3 = string2.substring(0, n2);
                string4 = string2.substring(n2 + 1, string2.length());
            }
            String string5 = "";
            String string6 = "";
            n2 = string.lastIndexOf(".");
            if (n2 != -1) {
                string5 = string.substring(0, n2);
                string6 = string.substring(n2 + 1, string.length());
            }
            if (string3.equals("*") && string4.equalsIgnoreCase(string6)) {
                bl = true;
                break;
            }
            if (string4.equals("*") && string3.equalsIgnoreCase(string5)) {
                bl = true;
                break;
            }
            if (string2.equalsIgnoreCase(string)) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    private boolean _$447(String string) {
        boolean bl = false;
        int n = 0;
        while (n < this._$360.size()) {
            String string2 = (String)this._$360.elementAt(n);
            String string3 = "";
            String string4 = "";
            int n2 = string2.lastIndexOf(".");
            if (n2 != -1) {
                string3 = string2.substring(0, n2);
                string4 = string2.substring(n2 + 1, string2.length());
            }
            String string5 = "";
            String string6 = "";
            n2 = string.lastIndexOf(".");
            if (n2 != -1) {
                string5 = string.substring(0, n2);
                string6 = string.substring(n2 + 1, string.length());
            }
            if (string3.equals("*") && string4.equalsIgnoreCase(string6)) {
                bl = true;
                break;
            }
            if (string4.equals("*") && string3.equalsIgnoreCase(string5)) {
                bl = true;
                break;
            }
            if (string2.equalsIgnoreCase(string)) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    private boolean _$451(String string) {
        if (this._$361) {
            return this._$435(string);
        }
        return !this._$447(string);
    }

    public void store(MultipartFormDataRequest multipartFormDataRequest, String string) throws UploadException, IOException {
        if (this._$358 == 1 && this._$365 != null) {
            this._$454(multipartFormDataRequest, string);
        } else if (this._$358 == 3 && this._$366 != null) {
            this._$455(multipartFormDataRequest, string);
        } else if (this._$358 == 0 && this._$374 != null) {
            this._$456(multipartFormDataRequest, string);
        } else if (this._$358 == 2) {
            this._$457(multipartFormDataRequest, string);
        }
    }

    public void store(MultipartFormDataRequest multipartFormDataRequest) throws UploadException, IOException {
        Hashtable hashtable = multipartFormDataRequest.getFiles();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.store(multipartFormDataRequest, string);
        }
    }

    private void _$454(MultipartFormDataRequest multipartFormDataRequest, String string) throws UploadException, IOException {
        Hashtable hashtable = multipartFormDataRequest.getFiles();
        UploadFile uploadFile = (UploadFile)hashtable.get(string);
        if (uploadFile != null && uploadFile.getFileName() != null && !uploadFile.getFileName().equals("") && uploadFile.getFileSize() >= 0L) {
            if (uploadFile.getFileSize() > this._$363) {
                throw new UploadException(UploadException.UPLOADFILESIZELIMITREACHED + " " + uploadFile.getFileName());
            }
            File file = new File(this.getFolderstore() + SEPARATOR);
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            boolean bl = false;
            int n2 = 0;
            while (n2 < n) {
                if (fileArray[n2].getName().equals(uploadFile.getFileName())) {
                    bl = true;
                }
                ++n2;
            }
            if (this._$362 == -1 || n < this._$362) {
                if (this._$451(uploadFile.getFileName())) {
                    throw new UploadException(UploadException.UPLOADFILENAMEDENIED + " " + uploadFile.getFileName());
                }
                FileOutputStream fileOutputStream = null;
                String string2 = null;
                if (!bl) {
                    fileOutputStream = new FileOutputStream(this.getFolderstore() + SEPARATOR + uploadFile.getFileName());
                } else if (!this._$364) {
                    string2 = uploadFile.getFileName() + "." + System.currentTimeMillis();
                    fileOutputStream = new FileOutputStream(this.getFolderstore() + SEPARATOR + string2);
                } else {
                    fileOutputStream = new FileOutputStream(this.getFolderstore() + SEPARATOR + uploadFile.getFileName());
                }
                InputStream inputStream = uploadFile.getInpuStream();
                byte[] byArray = new byte[TRANSFERTBUFFERSIZE];
                int n3 = 0;
                while ((n3 = inputStream.read(byArray)) != -1) {
                    fileOutputStream.write(byArray, 0, n3);
                }
                fileOutputStream.close();
                inputStream.close();
                UploadParameters uploadParameters = new UploadParameters(uploadFile.getFileName(), uploadFile.getFileSize(), uploadFile.getContentType(), 1, this._$365, string2);
                this._$373.addElement(uploadParameters);
                this._$476(uploadParameters, uploadFile);
            } else {
                throw new UploadException(UploadException.UPLOADLIMITREACHED);
            }
        }
    }

    private void _$455(MultipartFormDataRequest multipartFormDataRequest, String string) throws UploadException, IOException {
        Hashtable hashtable = multipartFormDataRequest.getFiles();
        UploadFile uploadFile = (UploadFile)hashtable.get(string);
        if (uploadFile.getFileName() != null && !uploadFile.getFileName().equals("") && uploadFile.getFileSize() >= 0L) {
            if (uploadFile.getFileSize() > this._$363) {
                throw new UploadException(UploadException.UPLOADFILESIZELIMITREACHED + " " + uploadFile.getFileName());
            }
            if (this._$451(uploadFile.getFileName())) {
                throw new UploadException(UploadException.UPLOADFILENAMEDENIED + " " + uploadFile.getFileName());
            }
            Archiver archiver = Archiver.getInstance();
            String string2 = null;
            string2 = archiver.append(this._$366, uploadFile, this._$362, this._$364);
            UploadParameters uploadParameters = new UploadParameters(uploadFile.getFileName(), uploadFile.getFileSize(), uploadFile.getContentType(), 3, this._$366, string2);
            this._$373.addElement(uploadParameters);
            this._$476(uploadParameters, uploadFile);
        }
    }

    private void _$457(MultipartFormDataRequest multipartFormDataRequest, String string) throws UploadException, IOException {
        Hashtable hashtable = multipartFormDataRequest.getFiles();
        UploadFile uploadFile = (UploadFile)hashtable.get(string);
        if (uploadFile.getFileName() != null && !uploadFile.getFileName().equals("") && uploadFile.getFileSize() >= 0L) {
            if (uploadFile.getFileSize() > this._$363) {
                throw new UploadException(UploadException.UPLOADFILESIZELIMITREACHED + " " + uploadFile.getFileName());
            }
            if (this._$451(uploadFile.getFileName())) {
                throw new UploadException(UploadException.UPLOADFILENAMEDENIED + " " + uploadFile.getFileName());
            }
            try {
                int n = this._$369.countFiles();
                if (this._$362 != -1 && n >= this._$362) {
                    throw new UploadException(UploadException.UPLOADLIMITREACHED);
                }
                this._$369.store(uploadFile, this._$364);
            }
            catch (Exception exception) {
                throw new UploadException(UploadException.DATABASESTOREERROR + " " + exception.getMessage());
            }
            UploadParameters uploadParameters = new UploadParameters(uploadFile.getFileName(), uploadFile.getFileSize(), uploadFile.getContentType(), 2, "database", null);
            this._$373.addElement(uploadParameters);
            this._$476(uploadParameters, uploadFile);
        }
    }

    private void _$456(MultipartFormDataRequest multipartFormDataRequest, String string) throws UploadException, IOException {
        Hashtable hashtable = multipartFormDataRequest.getFiles();
        UploadFile uploadFile = (UploadFile)hashtable.get(string);
        if (uploadFile.getFileName() != null && !uploadFile.getFileName().equals("") && uploadFile.getFileSize() >= 0L) {
            if (uploadFile.getFileSize() > this._$363) {
                throw new UploadException(UploadException.UPLOADFILESIZELIMITREACHED + " " + uploadFile.getFileName());
            }
            if (this._$451(uploadFile.getFileName())) {
                throw new UploadException(UploadException.UPLOADFILENAMEDENIED + " " + uploadFile.getFileName());
            }
            if (this._$362 != -1 && this._$374.size() >= this._$362) {
                throw new UploadException(UploadException.UPLOADLIMITREACHED);
            }
            this._$374.addElement(uploadFile);
            UploadParameters uploadParameters = new UploadParameters(uploadFile.getFileName(), uploadFile.getFileSize(), uploadFile.getContentType(), 0, "memory", null);
            this._$373.addElement(uploadParameters);
            this._$476(uploadParameters, uploadFile);
        }
    }

    public Vector getHistory() {
        return this._$373;
    }

    public void resetStore() throws UploadException, IOException {
        if (this._$358 == 1 && this._$365 != null) {
            File file = new File(this._$365 + SEPARATOR);
            if (file.exists()) {
                if (!file.canWrite()) {
                    throw new UploadException(UploadException.FOLDERISREADONLY);
                }
                File[] fileArray = file.listFiles();
                if (fileArray != null) {
                    int n = 0;
                    while (n < fileArray.length) {
                        if (!fileArray[n].delete()) {
                            throw new UploadException(UploadException.CANNOTDELETESTORE);
                        }
                        ++n;
                    }
                }
                this.setFolderstore(this._$365);
                this._$373.removeAllElements();
            }
        } else if (this._$358 == 3 && this._$366 != null) {
            File file = new File(this._$366);
            if (!file.delete()) {
                throw new UploadException(UploadException.CANNOTDELETESTORE);
            }
            this.setZipfilestore(this._$366);
            this._$373.removeAllElements();
        } else if (this._$358 == 0 && this._$374 != null) {
            int n = 0;
            while (n < this._$374.size()) {
                UploadFile uploadFile = (UploadFile)this._$374.elementAt(n);
                uploadFile.reset();
                ++n;
            }
            this._$374.removeAllElements();
            this._$373.removeAllElements();
        } else if (this._$358 == 2) {
            try {
                this._$369.reset();
            }
            catch (Exception exception) {
                throw new UploadException(UploadException.DATABASESTOREERROR + " " + exception.getMessage());
            }
            this._$373.removeAllElements();
        }
    }

    private void _$476(UploadParameters uploadParameters, UploadFile uploadFile) {
        int n = 0;
        while (n < this._$372.size()) {
            UploadListener uploadListener = (UploadListener)this._$372.elementAt(n);
            uploadListener.fileUploaded(uploadParameters, uploadFile);
            ++n;
        }
    }

    private void _$407() throws UploadException {
        if (this._$367 != null) {
            try {
                DBStore dBStore;
                Class<?> clazz = Class.forName(this._$367);
                Class<?> clazz2 = clazz.getSuperclass();
                if (!clazz2.getName().equals("javazoom.upload.DBStore")) {
                    throw new UploadException("Wrong super class " + this._$367);
                }
                Class[] classArray = new Class[]{};
                Constructor<?> constructor = clazz.getConstructor(classArray);
                this._$369 = dBStore = (DBStore)constructor.newInstance(null);
            }
            catch (Exception exception) {
                throw new UploadException("DBStore error " + exception.getMessage());
            }
        }
    }
}

