// ==============================================================
//
//  Copyright (c) 2003 by Alex Vinokur.
//
//  For conditions of distribution and use, see
//  copyright notice in version.h
//
// ==============================================================


// ##############################################################
//
//  SOFTWARE : Turing Machine with faults, failures and recovery
//             C++ Simulator
//
//  FILE     : common.h
//
//  DESCRIPTION :
//         Common function etc (Declaration)
//
// ##############################################################


// ###############
#ifndef _COMMON_H
#define _COMMON_H

#include <string>
#include <sstream>
#include <vector>
#include <set>
#include <map>
#include <iterator>
#include <numeric>
#include <algorithm>
#include <iostream>
#include <fstream>
#include <iomanip>
#include <assert.h>
using namespace std;

#include "macro.h"

// ===================
unsigned int is_udec (char * const str_i);
unsigned int is_dec (char * const str_i);
unsigned int is_hex (char * const str_i);

#define DEFAULT_ALPHABET	"abcdefghijklmnopqrstuvwxyz" 
string get_next_size_ordered_word (
	const string& cur_str_i, 
	const string& alphabet_i = DEFAULT_ALPHABET
	);


// ===================
template <typename T>
string to_string (
	const T&	value_i, 
	int		width_i = -1, 
	char		fill_i = ' ', 
	bool		align_i = true, // true - left
	const string&	prefix_i = string ()
	)
{
string		ret_string_value;
ostringstream	tmp_osstr;

        // =================================
        tmp_osstr << prefix_i;
        if (width_i > 0)
        {
                tmp_osstr << setw (width_i);
                tmp_osstr << setfill (fill_i);
        }
        tmp_osstr << (align_i ? left : right) << value_i;

        // =================================
        ret_string_value = tmp_osstr.str();
        // =================================
        return ret_string_value;

} // string to_string (T value_i)


// ===================
template <typename T>
size_t get_max_size (const vector<T>& vect_i)
{
size_t	ret_value = 0;
  for (size_t i = 0; i < vect_i.size(); i++)
  {
    ret_value = MAX_VALUE (ret_value, to_string(vect_i[i]).size());
  }
  return ret_value;  
}



// ===================
template <typename T>
void to_out (const vector<T>& v, const string& msg_i = string())
{
  if (!msg_i.empty()) cout << msg_i;
  copy (v.begin(), v.end(), ostream_iterator<T>(cout, " "));
  cout << endl;
}


// ===================
template <typename T>
void to_err (const vector<T>& v, const string& msg_i = string())
{
  if (!msg_i.empty()) cerr << msg_i;
  copy (v.begin(), v.end(), ostream_iterator<T>(cerr, " "));
  cerr << endl;
}


// ===================
template <typename T>
bool belongs_to (const T& t, const vector<T>& v)
{
  return (count (v.begin(), v.end(), t));
}


// ===================
template <typename T, typename S>
bool belongs_to (const T& t, const map<T, S>& m)
{
  return (m.count(t));
}


// ===================
template <typename T>
vector<bool> vcompare (const vector<T>& v1, const vector<T>& v2)
{
vector<bool>  ret_vect;
  assert (v1.size() == v2.size());
  for (size_t i = 0; i < v1.size(); i++)
  {
    ret_vect.push_back ((v1[i] == v2[i]));
  }
  return ret_vect;
  
}


// ===================
template<typename T>
vector<vector<T> > multi_permut (const vector<vector<T> >& v1, const vector<vector<T> >& v2)
{
vector<vector<T> >	ret_vect;

  for (size_t i = 0;  i < v1.size(); i++)
  {
    for (size_t j = 0;  j < v2.size(); j++)
    {
       vector<T> tmp_vect;
       copy (v1[i].begin(), v1[i].end(), back_inserter(tmp_vect));   
       copy (v2[j].begin(), v2[j].end(), back_inserter(tmp_vect));   
       ret_vect.push_back (tmp_vect);
    }
  }
  return ret_vect;

}

// -------------------
bool get_true_vector (const vector<bool>& v1);

#endif	// _COMMON_H
