// ==============================================================
//
//  Copyright (c) 2003 by Alex Vinokur.
//
//  For conditions of distribution and use, see
//  copyright notice in version.h
//
// ==============================================================


// ##############################################################
//
//  SOFTWARE : Turing Machine with faults, failures and recovery
//             C++ Simulator
//
//  FILE     : symbol.cpp
//
//  DESCRIPTION :
//         Classes symbol_t, symbol_mt (Implementation)
//
// ##############################################################


// ================
#include "symbol.h"
// ================


// ===========
// -----------
bool operator== (const symbol_mt& inst1_i, const symbol_mt& inst2_i)
{
  return (inst1_i.symbol_ == inst2_i.symbol_ );
}


bool operator!= (const symbol_mt& inst1_i, const symbol_mt& inst2_i)
{
  return (inst1_i.symbol_ != inst2_i.symbol_ );
}


bool operator< (const symbol_mt& inst1_i, const symbol_mt& inst2_i)
{
  return (inst1_i.symbol_ < inst2_i.symbol_ );
}


bool operator> (const symbol_mt& inst1_i, const symbol_mt& inst2_i)
{
  return (inst1_i.symbol_ > inst2_i.symbol_ );
}


ostream& operator<< (ostream& o, const symbol_mt& inst_i)
{
  return o << inst_i.symbol_;
}


// -----------
vector<symbol_mt> vect_string_to_symbol_mt (const vector<string>& vect_i)
{
vector<symbol_mt>	ret_vect;

  for (size_t i = 0; i < vect_i.size(); i++)
  {
    ret_vect.push_back (symbol_mt (vect_i[i]));
  }

  return ret_vect;
}

vector<vector<symbol_mt> > vect_vect_string_to_symbol_mt (const vector<vector<string> >& vect_i)
{
vector<vector<symbol_mt>	>	ret_vect;

  for (size_t i = 0; i < vect_i.size(); i++)
  {
    ret_vect.push_back (vect_string_to_symbol_mt (vect_i[i]));
  }

  return ret_vect;
}

