// ==============================================================
//
//  Copyright (c) 2003 by Alex Vinokur.
//
//  For conditions of distribution and use, see
//  copyright notice in version.h
//
// ==============================================================


// ##############################################################
//
//  SOFTWARE : Turing Machine with faults, failures and recovery
//             C++ Simulator
//
//  FILE     : t-getval.cpp
//
//  DESCRIPTION :
//         Class TuringMachine : get methods (Implementation)
//
// ##############################################################


// =================
#include "turing-s.h"
// =================


// =========
vector<symbol_mt> TuringMachine::get_all_master_tape_alphabet_symbols () const
{
vector<symbol_mt>	ret_vector;
  copy (user_defined_blank_alphabet_.begin(), user_defined_blank_alphabet_.end(), back_inserter(ret_vector));
  // copy (user_defined_internal_alphabet_.begin(), user_defined_internal_alphabet_.end(), back_inserter(ret_vector));
  // copy (user_defined_input_alphabet_.begin(), user_defined_input_alphabet_.end(), back_inserter(ret_vector));

const vector<symbol_mt> not_blank_symbols (get_all_not_blank_master_tape_alphabet_symbols ());
  copy (not_blank_symbols.begin(), not_blank_symbols.end(), back_inserter(ret_vector));

  return ret_vector;

}



// =========
vector<symbol_mt> TuringMachine::get_all_not_blank_master_tape_alphabet_symbols () const
{
vector<symbol_mt>	ret_vector;

  copy (user_defined_internal_alphabet_.begin(), user_defined_internal_alphabet_.end(), back_inserter(ret_vector));
  copy (user_defined_input_alphabet_.begin(), user_defined_input_alphabet_.end(), back_inserter(ret_vector));

  return ret_vector;

}


// =========
vector<symbol_mt> TuringMachine::get_all_not_marker_master_tape_alphabet_symbols () const
{
const vector<symbol_mt>	all_symbols (get_all_master_tape_alphabet_symbols ());
vector<symbol_mt>	ret_vector;

  for (size_t i = 0; i < all_symbols.size(); i++)
  {
    if (is_user_defined_marker (all_symbols[i])) continue;
    ret_vector.push_back (all_symbols[i]); 
  }

  return ret_vector;

}


// =========
vector<symbol_mt> TuringMachine::get_all_not_marker_and_not_blank_master_tape_alphabet_symbols () const
{
const vector<symbol_mt>	all_symbols (get_all_not_blank_master_tape_alphabet_symbols ());
vector<symbol_mt>	ret_vector;

  for (size_t i = 0; i < all_symbols.size(); i++)
  {
    if (is_user_defined_marker (all_symbols[i])) continue;
    ret_vector.push_back (all_symbols[i]); 
  }

  return ret_vector;

}


// =========
vector<symbol_mt> TuringMachine::get_all_synchronous_tape_alphabet_symbols_s () 
{
vector<symbol_mt>	ret_vector;
  copy (embedded_blank_synchronous_tape_alphabet_s.begin(), embedded_blank_synchronous_tape_alphabet_s.end(), back_inserter(ret_vector));
  // copy (embedded_internal_synchronous_tape_alphabet_s.begin(), embedded_internal_synchronous_tape_alphabet_s.end(), back_inserter(ret_vector));

const vector<symbol_mt> not_blank_symbols (get_all_not_blank_synchronous_tape_alphabet_symbols_s());
  copy (not_blank_symbols.begin(), not_blank_symbols.end(), back_inserter(ret_vector));

  return ret_vector;

}



// =========
vector<symbol_mt> TuringMachine::get_all_not_blank_synchronous_tape_alphabet_symbols_s () 
{
vector<symbol_mt>	ret_vector;
  copy (embedded_internal_synchronous_tape_alphabet_s.begin(), embedded_internal_synchronous_tape_alphabet_s.end(), back_inserter(ret_vector));

  return ret_vector;

}


// =========
vector<symbol_mt> TuringMachine::get_all_not_marker_synchronous_tape_alphabet_symbols_s () 
{
const vector<symbol_mt>	all_symbols (get_all_synchronous_tape_alphabet_symbols_s ());
vector<symbol_mt>	ret_vector;

  for (size_t i = 0; i < all_symbols.size(); i++)
  {
    if (is_embedded_synchronous_tape_marker_s (all_symbols[i])) continue;
    ret_vector.push_back (all_symbols[i]); 
  }

  return ret_vector;

}



// =========
vector<symbol_mt> TuringMachine::get_all_not_marker_and_not_blank_synchronous_tape_alphabet_symbols_s () 
{
const vector<symbol_mt>	all_symbols (get_all_not_blank_synchronous_tape_alphabet_symbols_s ());
vector<symbol_mt>	ret_vector;

  for (size_t i = 0; i < all_symbols.size(); i++)
  {
    if (is_embedded_synchronous_tape_marker_s (all_symbols[i])) continue;
    ret_vector.push_back (all_symbols[i]); 
  }

  return ret_vector;

}


// =========
vector<vector<symbol_mt> > TuringMachine::get_all_tapes_all_alphabet_symbols () const
{
vector<vector<symbol_mt>	> ret_vector (NUMBER_OF_TAPE_KINDS);
  
  ret_vector [MASTER_COMPUTATION_TAPE] = get_all_master_tape_alphabet_symbols();
  ret_vector [SYNCHRONOUS_COMPUTATION_TAPE] = get_all_synchronous_tape_alphabet_symbols_s ();
  ret_vector [BACKUP_COMPUTATION_TAPE] = get_all_master_tape_alphabet_symbols ();
  ret_vector [SYNCHRONOUS_BACKUP_COMPUTATION_TAPE] = get_all_synchronous_tape_alphabet_symbols_s();
  ret_vector [TESTER_TAPE] = get_all_master_tape_alphabet_symbols();

  return ret_vector;

}


// =========
vector<vector<symbol_mt> > TuringMachine::get_all_tapes_alphabets_combinations (size_t k) const
{
  if (k >= NUMBER_OF_TAPE_KINDS) return (get_all_tapes_alphabets_combinations (k - 1));

vector<symbol_mt> cur_alphabet (get_all_tapes_all_alphabet_symbols() [k]);
vector<vector<symbol_mt> > prev_vector ((k == 0) ? vector<vector<symbol_mt> > () : get_all_tapes_alphabets_combinations (k -1));
vector<vector<symbol_mt> > ret_vector; 

  // --------------
  if (prev_vector.empty())
  {
    for (size_t j = 0; j < cur_alphabet.size(); j++)
    {
      ret_vector.push_back (vector<symbol_mt> (1, cur_alphabet[j]));
    }
    return ret_vector;
  }

  // --------------
  for (size_t i = 0; i < prev_vector.size(); i++)
  {
    for (size_t j = 0; j < cur_alphabet.size(); j++)
    {
      vector<symbol_mt>	tmp_vector (prev_vector[i]);
      tmp_vector.push_back(cur_alphabet[j]);
      ret_vector.push_back (tmp_vector);
    }
  }
  return ret_vector;
}


// =========
vector<state_t> TuringMachine::get_all_user_defined_program_states () const
{
vector<state_t>	ret_vector;

  copy (user_defined_initial_program_states_.begin(), user_defined_initial_program_states_.end(), back_inserter(ret_vector));
  copy (user_defined_halting_program_states_.begin(), user_defined_halting_program_states_.end(), back_inserter(ret_vector));
  copy (user_defined_internal_program_states_.begin(), user_defined_internal_program_states_.end(), back_inserter(ret_vector));

  return ret_vector;

}


// =========
vector<state_t> TuringMachine::get_all_extra_program_states () const
{
vector<state_t>	ret_vector;

 copy (neutral_program_states_.begin(), neutral_program_states_.end(), back_inserter(ret_vector));
 copy (pre_initial_program_states_.begin(), pre_initial_program_states_.end(), back_inserter(ret_vector));
 copy (post_halting_program_states_.begin(), post_halting_program_states_.end(), back_inserter(ret_vector));

map<CurSituation, state_t>::const_iterator pos_iter;
  for (pos_iter = user_required_check_point_program_states_.begin();
       pos_iter != user_required_check_point_program_states_.end();
       pos_iter++
       )
  {
    ret_vector.push_back(pos_iter->second);
  }

  for (size_t i = 0; i < embedded_program_states_.size(); i++)
  {
    copy (embedded_program_states_[i].begin(), embedded_program_states_[i].end(), back_inserter(ret_vector));
  }  

  return ret_vector;

}


// =========
state_t TuringMachine::get_neutral_cur_substate_alphabet_symbol () const
{
  assert (NEUTRAL_PROGRAM_STATE_KIND__CUR_NEUTRAL < neutral_program_states_.size());
  return neutral_program_states_[NEUTRAL_PROGRAM_STATE_KIND__CUR_NEUTRAL];
}


// =========
state_t TuringMachine::get_neutral_next_the_same_substate_alphabet_symbol () const
{
  assert (NEUTRAL_PROGRAM_STATE_KIND__NEXT_THE_SAME < neutral_program_states_.size());
  return neutral_program_states_[NEUTRAL_PROGRAM_STATE_KIND__NEXT_THE_SAME];
}



// =========
state_t TuringMachine::get_neutral_next_not_the_same_substate_alphabet_symbol () const
{
  assert (NEUTRAL_PROGRAM_STATE_KIND__NEXT_NOT_THE_SAME < neutral_program_states_.size());
  return neutral_program_states_[NEUTRAL_PROGRAM_STATE_KIND__NEXT_NOT_THE_SAME];
}


// =========
vector<state_t> TuringMachine::get_all_daemon_states_s ()
{
vector<state_t>	ret_vector;

  copy (daemon_passive_states_s.begin(), daemon_passive_states_s.end(), back_inserter(ret_vector));
  copy (daemon_active_states_s.begin(), daemon_active_states_s.end(), back_inserter(ret_vector));
  copy (daemon_aggressive_states_s.begin(), daemon_aggressive_states_s.end(), back_inserter(ret_vector));

  return ret_vector;

}



// =========
vector<state_t> TuringMachine::get_all_tester_states_s ()
{
vector<state_t>	ret_vector;

  copy (tester_tracking_states_s.begin(), tester_tracking_states_s.end(), back_inserter(ret_vector));
  copy (tester_stabilizing_states_s.begin(), tester_stabilizing_states_s.end(), back_inserter(ret_vector));

  return ret_vector;

}


// =========
vector<state_t> TuringMachine::get_all_apparatus_states_s ()
{
vector<state_t>	ret_vector;

  copy (apparatus_normal_states_s.begin(), apparatus_normal_states_s.end(), back_inserter(ret_vector));
  copy (apparatus_emergency_states_s.begin(), apparatus_emergency_states_s.end(), back_inserter(ret_vector));

  return ret_vector;

}

	
// =========
bool TuringMachine::get_check_process_results () const
{
  return check_process_results_;
}


// =========
symbol_mt TuringMachine::get_user_defined_marker () const
{
  return user_defined_internal_alphabet_.front();
}



// =========
symbol_mt TuringMachine::get_embedded_synchronous_tape_marker_s ()
{
  return embedded_internal_synchronous_tape_alphabet_s.front();
}


// =========
symbol_mt TuringMachine::get_embedded_synchronous_tape_right_sign_s ()
{
  assert (embedded_internal_synchronous_tape_alphabet_s.size() > 1);
  return (*embedded_internal_synchronous_tape_alphabet_s.rbegin());
}




// =========
string TuringMachine::getstr_id_info (bool detail_flag_i) const
{
ostringstream oss;
  oss << "< ";
  if (detail_flag_i)
  {
    oss << "TM #"
        << machine_serial_no_
        << ", "
        << "Input #"
        << input_set_no_;
  }
  else
  {
    oss << "Run "
        << machine_serial_no_
        << "."
        << input_set_no_;
  }
  oss << " > ";

  return oss.str();
}


// =========
SymbolTypes TuringMachine::get_symbol_mtype (TapeKinds kind_i, const symbol_mt& symbol_i) const
{
  assert (!is_pseudo_write_nothing_symbol(symbol_i));
  if (is_pseudo_never_mind_symbol (symbol_i)) return NEVER_MIND_PseudoSymbol;
  if (is_pseudo_not_marker_symbol (symbol_i)) return ANY_NOT_MARKER_PseudoSymbol;
  if (is_pseudo_not_marker_and_not_blank_symbol (symbol_i)) return ANY_NOT_MARKER_AND_NOT_BLANK_PseudoSymbol;

  // --------------------------
Tapes_t::const_iterator pos1_iter, pos2_iter;
  for (pos1_iter = tapes_[kind_i].begin(); pos1_iter != tapes_[kind_i].end(); pos1_iter++)
  {
    for (pos2_iter = tapes_[kind_i].begin(); pos2_iter != tapes_[kind_i].end(); pos2_iter++)
    {
      assert (pos1_iter->second.is_input_symbol (symbol_i) == pos2_iter->second.is_input_symbol (symbol_i));
      assert (pos1_iter->second.is_internal_symbol (symbol_i) == pos2_iter->second.is_internal_symbol (symbol_i));
      assert (pos1_iter->second.is_internal_not_marker_symbol (symbol_i) == pos2_iter->second.is_internal_not_marker_symbol (symbol_i));
      assert (pos1_iter->second.is_marker_symbol (symbol_i) == pos2_iter->second.is_marker_symbol (symbol_i));
      assert (pos1_iter->second.is_empty_symbol (symbol_i) == pos2_iter->second.is_empty_symbol (symbol_i));
      assert (pos1_iter->second.is_valid_symbol (symbol_i) == pos2_iter->second.is_valid_symbol (symbol_i));
    }
  }

  // -------------------------
  if (tapes_[kind_i].begin()->second.is_empty_symbol (symbol_i)) return BLANK_Symbol;
  if (tapes_[kind_i].begin()->second.is_input_symbol (symbol_i)) return INPUT_Symbol;
  if (tapes_[kind_i].begin()->second.is_internal_not_marker_symbol (symbol_i)) return INTERNAL_NOT_MARKER_Symbol;
  if (tapes_[kind_i].begin()->second.is_marker_symbol (symbol_i)) return MARKER_INTERNAL_Symbol;

  // -------------------------
  assert (0);
  return UNDEF_SymbolTypes;
}

// =========
vector<SymbolTypes> TuringMachine::get_symbol_mtypes (const vector<symbol_mt>& symbols_i) const
{
vector<SymbolTypes>	ret_vect;
  assert (!symbols_i.empty());

uint total_tapes = 0;
  for (size_t i = 0; i < NUMBER_OF_TAPE_KINDS; i++)
  {
    total_tapes += tapes_[i].size();
  } 

  assert ((symbols_i.size() == total_tapes) || (symbols_i.size() == tapes_[TESTER_TAPE].size()));

size_t	counter = 0;
  for (size_t i = 0; i < NUMBER_OF_TAPE_KINDS; i++)
  {
    for (size_t j = 0; j < tapes_[i].size(); j++)
    {
      ret_vect.push_back (get_symbol_mtype (static_cast<TapeKinds> (i), symbols_i[counter++]));
      assert ((*ret_vect.rbegin()) != UNDEF_SymbolTypes);
      assert ((*ret_vect.rbegin()) < SIZE_OF_SymbolTypes);
    }
  } 

  assert (!ret_vect.empty());
  assert (ret_vect.size() == total_tapes);

  return ret_vect;
}

