// --------------
// FILE : fib.cpp
// --------------

#include "fib.h"


// ############ CONSTANTS ############
static const string all_num_option_CNS = "--all-num";
static const string size_only_option_CNS = "--size-only";



// ###################################
// ############ FUNCTIONS ############ 
// ###################################


// ===================================
bool    stringIsNonnegativeNumber (const string& string_i)
{
  ASSERT (!string_i.empty ());
  for (ulong theIndex= 0; theIndex < string_i.size (); theIndex++)
  {
    if (!isdigit (string_i [theIndex]))
    {
      return false;
    }
  }
 return true;
} // bool    stringIsNonnegativeNumber (const string& string_i)


// ===================================
void    printAllFib (
		ulong		n_i,
		bool		sizes_only_i,
		const string&	msg_i,
		ios_base&	show_base_i (ios_base&)
		)
{
string		print_string;
ostringstream	oss;
  if (!msg_i.empty())
  {
    oss << endl;
    oss << "################################" << endl;
    oss << "###" << "\t" << msg_i << endl;
    oss << "################################" << endl;
  }

  if (!sizes_only_i)
  {
    oss << ClassFibonacci (n_i).getAllNumbers (show_base_i);
  }
  else
  {
    oss << ClassFibonacci (n_i).getAllSizes (show_base_i);
  }

  oss << endl;
  oss << ends;

  print_string = oss.str(); 

  cout << print_string;

} // printAllFib


// ===================================
void    printOneFib (
		ulong        n_i,
		const string&   msg_i,
		ios_base&	show_base_i (ios_base&)
		)
{
string          print_string;
ostringstream       oss;
  if (!msg_i.empty())
  {
    oss << endl;
    oss << "################################" << endl;
    oss << "###" << "\t" << msg_i << endl;
    oss << "################################" << endl;
  }
ClassOneFibonacci       f1;

  oss << ""
      << "Fib#"
      << n_i
      << "\t = "
      << f1.getFibNumber (n_i).getAllInfo (show_base_i)
      << endl;
  oss << endl;
  oss << ends;

  print_string = oss.str(); 

  cout << print_string;

} // printOneFib


// ===================================
void    printSomeFib (
                        const vector<ulong>& vect_i,
                        const string&  msg_i,
                        ios_base&   show_base_i (ios_base&)
                        )
{
string          print_string;
ostringstream       oss;

  if (!msg_i.empty())
  {
    oss << endl;
    oss << "################################" << endl;
    oss << "###" << "\t" << msg_i << endl;
    oss << "################################" << endl;
  }
ClassFibonacci f1;

  for (uint theIndex = 0; theIndex < vect_i.size (); theIndex++)
  {
    oss << ""
        << "Fib#"
        << vect_i [theIndex]
        << "\t = "
        << f1.getFibNumber (vect_i [theIndex]).getAllInfo(show_base_i)
        << endl;
  } // for (uint theIndex = 0;

  oss << endl;

  // ====================
  oss << ends;

  print_string = oss.str(); 

  cout << print_string;
} // printSomeFib



// ===================================
void printErrorUsageMessage (
                int                     argc,
                char                    **argv
                )
{
  cout << endl
       << "FATAR ERROR!"
       << endl
       << "============"
       << endl
       << "USAGE : "
       << argv[0]
       << " "
       << all_num_option_CNS
       << " <nonnegative number>"
       << " ["
       << size_only_option_CNS
       << "]"
       << endl
       << "      : "
       << argv[0]
       << " <nonnegative number> [<nonnegative number> [<nonnegative number>] ...]"
       << endl;
}


// ===================================
bool argv_check (
                int  argc,
                char  **argv,
                ulong  cur_index_i,
                ulong&  cur_numberValue_o
                )
{

  // ============================
  ASSERT (argc >= 2);
  ASSERT (cur_index_i >= 1);

  // ============================
  if (!stringIsNonnegativeNumber (string (argv[cur_index_i])))
  {
    printErrorUsageMessage (argc, argv);
    cout << endl
         << "NOT NONNEGATIVE NUMBER : "
         << "argv ["
         << cur_index_i
         << "] = "
         << argv [cur_index_i]
         << endl;
    return false;
  }

  cur_numberValue_o = strtoul (argv[cur_index_i], (char**)NULL, 10);
  if (cur_numberValue_o == ULONG_MAX)
  {
    cout << endl
         <<  "FATAR ERROR!"
         << endl
         << "============"
         << endl
         << "TOO LARGE VALUE : "
         << "argv ["
         << cur_index_i
         << "] = "
         << argv [cur_index_i]
         << endl;
    return false;
  }
        // =====================
  return true;
} // bool argv_check (ulong cur_index_i)


// ===================================
int     mainFib (int argc, char **argv)
{

ulong  cur_numberValue;
ulong  cur_index;
vector<ulong> vect;
bool  size_only_flag = false;

  for (int i = 0; i < argc; i++)
  {
    if (argv[i] == size_only_option_CNS)
    {
      size_only_flag = true;
    }
  }

  switch (argc)
  {
    case 0 :
      assert (0);
      break;

    case 1 :
      printErrorUsageMessage (argc, argv);
      exit (1);
      break; // unused

    case 2 :
      cur_index = 1;
      if (!argv_check (argc, argv, cur_index, cur_numberValue))
      {
        exit (1);
      }
      printOneFib (cur_numberValue);
      break;

    case 3 :
    case 4 :
      if (argv [1] == all_num_option_CNS)
      {
        if (argc == 4)
        {
          if (!(argv [3] == size_only_option_CNS))
          {
            printErrorUsageMessage (argc, argv);
            exit (1);
          }
        }

        cur_index = 2;
        if (!argv_check (argc, argv, cur_index, cur_numberValue))
        {
          exit (1);
        }
        printAllFib (cur_numberValue, size_only_flag);
        break;
     }

     default :
       for (int theIndex = 1; theIndex < argc; theIndex++)
       {
         cur_index = theIndex;
         if (!argv_check (argc, argv, cur_index, cur_numberValue))
         {
           exit (1);
         }
         vect.push_back (cur_numberValue);
       }
       printSomeFib (vect);
       break;

  } // switch (argc)

  // =================
  return 0;
  // =================
} // int     mainFib (int argc, char **argv)


// ############ END OF FILE ############
