/*
 * Decompiled with CFR 0.152.
 */
package helliker.id3;

import helliker.id3.CorruptHeaderException;
import helliker.id3.ID3v1Tag;
import helliker.id3.ID3v2FormatException;
import helliker.id3.ID3v2Frames;
import helliker.id3.ID3v2Tag;
import helliker.id3.MPEGAudioFrameHeader;
import helliker.id3.NoMPEGFramesException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class MP3File
implements Comparable {
    public static final int BOTH_TAGS = 0;
    public static final int ID3V2_ONLY = 1;
    public static final int ID3V1_ONLY = 2;
    public static final int NO_TAGS = 3;
    public static final int EXISTING_TAGS_ONLY = 4;
    private final int ID3V1 = 5;
    private final int ID3V2 = 6;
    private ID3v1Tag id3v1 = null;
    private ID3v2Tag id3v2 = null;
    private MPEGAudioFrameHeader head = null;
    private File mp3 = null;
    private int tagType = 0;

    public MP3File(String string) throws CorruptHeaderException, ID3v2FormatException, IOException, NoMPEGFramesException, FileNotFoundException {
        this(new File(string));
    }

    public MP3File(File file) throws CorruptHeaderException, ID3v2FormatException, IOException, NoMPEGFramesException, FileNotFoundException {
        this(file, 4);
    }

    public MP3File(String string, int n) throws CorruptHeaderException, ID3v2FormatException, IOException, NoMPEGFramesException, FileNotFoundException {
        this(new File(string), n);
    }

    public MP3File(File file, int n) throws CorruptHeaderException, ID3v2FormatException, IOException, NoMPEGFramesException, FileNotFoundException {
        this.mp3 = file;
        this.tagType = n;
        this.head = new MPEGAudioFrameHeader(file, 0);
        this.id3v1 = new ID3v1Tag(file);
        this.id3v2 = new ID3v2Tag(file, this.head.getLocation());
    }

    public long getPlayingTime() {
        long l = 0L;
        if (this.head.isVBR()) {
            l = this.head.getVBRPlayingTime();
        } else {
            long l2 = this.mp3.length() * (long)8 - (long)this.id3v2.getSize() - (long)this.id3v1.getSize();
            long l3 = this.head.getBitRate() * 1000;
            l = l3 == (long)0 ? 0L : l2 / l3;
        }
        return l;
    }

    public String getPlayingTimeString() {
        long l = this.getPlayingTime();
        long l2 = l / (long)60;
        long l3 = Math.round(((double)l / (double)60 - (double)(l / (long)60)) * (double)60);
        String string = String.valueOf(String.valueOf(l2)).concat(":");
        string = l3 < (long)10 ? String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf("0".concat(String.valueOf(String.valueOf(l3)))))) : String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf("".concat(String.valueOf(String.valueOf(l3))))));
        return string;
    }

    public String getPath() {
        return this.mp3.getAbsolutePath();
    }

    public String getParent() {
        return this.mp3.getParent();
    }

    public String getFileName() {
        return this.mp3.getName();
    }

    public long getFileSize() {
        return this.mp3.length();
    }

    public boolean id3v2Exists() {
        return this.id3v2.tagExists();
    }

    public boolean id3v1Exists() {
        return this.id3v1.tagExists();
    }

    public boolean isMP3() {
        return this.head.isMP3();
    }

    public boolean isVBR() {
        return this.head.isVBR();
    }

    public int getBitRate() {
        return this.head.getBitRate();
    }

    public int getSampleRate() {
        return this.head.getSampleRate();
    }

    public String getMPEGEmphasis() {
        return this.head.getEmphasis();
    }

    public String getMPEGLayer() {
        return this.head.getLayer();
    }

    public String getMPEGVersion() {
        return this.head.getVersion();
    }

    public String getMPEGChannelMode() {
        return this.head.getChannelMode();
    }

    public boolean isMPEGCopyrighted() {
        return this.head.isCopyrighted();
    }

    public boolean isMPEGOriginal() {
        return this.head.isOriginal();
    }

    public boolean isMPEGProtected() {
        return this.head.isProtected();
    }

    public boolean isMPEGPrivate() {
        return this.head.privateBitSet();
    }

    public void removeTags(int n) throws IOException, FileNotFoundException {
        if (this.allow(5, n)) {
            this.id3v1.removeTag();
        }
        if (this.allow(6, n)) {
            this.id3v2.removeTag();
        }
    }

    public void writeTags() throws IOException, FileNotFoundException {
        if (this.allow(6)) {
            this.id3v2.writeTag();
        }
        if (this.allow(5)) {
            this.id3v1.writeTag();
        }
    }

    public void setTitle(String string) {
        if (this.allow(5)) {
            this.id3v1.setTitle(string);
        }
        if (this.allow(6)) {
            this.id3v2.setTextFrame(ID3v2Frames.TITLE, string);
        }
    }

    public void setAlbum(String string) {
        if (this.allow(5)) {
            this.id3v1.setAlbum(string);
        }
        if (this.allow(6)) {
            this.id3v2.setTextFrame(ID3v2Frames.ALBUM, string);
        }
    }

    public void setArtist(String string) {
        if (this.allow(5)) {
            this.id3v1.setArtist(string);
        }
        if (this.allow(6)) {
            this.id3v2.setTextFrame(ID3v2Frames.LEAD_PERFORMERS, string);
        }
    }

    public void setComment(String string) {
        if (this.allow(5)) {
            this.id3v1.setComment(string);
        }
        if (this.allow(6)) {
            this.id3v2.setCommentFrame("", string);
        }
    }

    public void setGenre(String string) {
        if (this.allow(5)) {
            this.id3v1.setGenreString(string);
        }
        if (this.allow(6)) {
            this.id3v2.setTextFrame(ID3v2Frames.CONTENT_TYPE, string);
        }
    }

    public void setYear(String string) {
        if (this.allow(5)) {
            this.id3v1.setYear(string);
        }
        if (this.allow(6)) {
            this.id3v2.setTextFrame(ID3v2Frames.YEAR, string);
        }
    }

    public void setTrack(int n) {
        if (this.allow(5)) {
            this.id3v1.setTrack(n);
        }
        if (this.allow(6)) {
            this.id3v2.setTextFrame(ID3v2Frames.TRACK_NUMBER, String.valueOf(n));
        }
    }

    public void setTrack(String string) throws NumberFormatException {
        if (this.allow(5)) {
            this.id3v1.setTrack(Integer.parseInt(string));
        }
        if (this.allow(6)) {
            this.id3v2.setTextFrame(ID3v2Frames.TRACK_NUMBER, string);
        }
    }

    public void setComposer(String string) {
        if (this.allow(6)) {
            this.id3v2.setTextFrame(ID3v2Frames.COMPOSER, string);
        }
    }

    public void setOriginalArtist(String string) {
        if (this.allow(6)) {
            this.id3v2.setTextFrame(ID3v2Frames.ORIGINAL_ARTIST, string);
        }
    }

    public void setCopyrightInfo(String string) {
        if (this.allow(6)) {
            this.id3v2.setTextFrame(ID3v2Frames.COPYRIGHT_MESSAGE, string);
        }
    }

    public void setUserDefinedURL(String string, String string2) {
        if (this.allow(6)) {
            this.id3v2.setUserDefinedURLFrame(string, string2);
        }
    }

    public void setUserDefinedText(String string, String string2) {
        if (this.allow(6)) {
            this.id3v2.setUserDefinedTextFrame(string, string2);
        }
    }

    public void setEncodedBy(String string) {
        if (this.allow(6)) {
            this.id3v2.setTextFrame(ID3v2Frames.ENCODED_BY, string);
        }
    }

    public void setTextFrame(String string, String string2) {
        if (this.allow(6)) {
            this.id3v2.setTextFrame(string, string2);
        }
    }

    public void setFrameData(String string, byte[] byArray) {
        if (this.allow(6)) {
            this.id3v2.updateFrameData(string, byArray);
        }
    }

    public String getArtist() throws ID3v2FormatException {
        String string = new String();
        if (this.allow(6)) {
            string = this.id3v2.getFrameDataString(ID3v2Frames.LEAD_PERFORMERS);
        } else if (this.allow(5)) {
            string = this.id3v1.getArtist();
        }
        return string;
    }

    public String getAlbum() throws ID3v2FormatException {
        String string = new String();
        if (this.allow(6)) {
            string = this.id3v2.getFrameDataString(ID3v2Frames.ALBUM);
        } else if (this.allow(5)) {
            string = this.id3v1.getAlbum();
        }
        return string;
    }

    public String getComment() throws ID3v2FormatException {
        String string = new String();
        if (this.allow(6)) {
            string = this.id3v2.getFrameDataString(ID3v2Frames.COMMENTS);
        } else if (this.allow(5)) {
            string = this.id3v1.getComment();
        }
        return string;
    }

    public String getGenre() throws ID3v2FormatException {
        String string = new String();
        if (this.allow(6)) {
            string = this.id3v2.getFrameDataString(ID3v2Frames.CONTENT_TYPE);
        } else if (this.allow(5)) {
            string = this.id3v1.getGenreString();
        }
        return string;
    }

    public String getTitle() throws ID3v2FormatException {
        String string = new String();
        if (this.allow(6)) {
            string = this.id3v2.getFrameDataString(ID3v2Frames.TITLE);
        } else if (this.allow(5)) {
            string = this.id3v1.getTitle();
        }
        return string;
    }

    public String getTrackString() throws ID3v2FormatException {
        String string = new String();
        if (this.allow(6)) {
            string = this.id3v2.getFrameDataString(ID3v2Frames.TRACK_NUMBER);
        } else if (this.allow(5)) {
            string = String.valueOf(this.id3v1.getTrack());
        }
        return string;
    }

    public int getTrack() throws ID3v2FormatException {
        String string = this.getTrackString();
        int n = -1;
        int n2 = string.indexOf("/");
        try {
            if (n2 != -1) {
                string = string.substring(0, n2);
            }
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    public int getNumTracks() throws ID3v2FormatException {
        String string = this.getTrackString();
        int n = -1;
        int n2 = string.indexOf("/");
        try {
            if (n2 != -1) {
                string = string.substring(n2 + 1, string.length());
                n = Integer.parseInt(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    public String getYear() throws ID3v2FormatException {
        String string = new String();
        if (this.allow(6)) {
            string = this.id3v2.getFrameDataString(ID3v2Frames.YEAR);
        } else if (this.allow(5)) {
            string = this.id3v1.getYear();
        }
        return string;
    }

    public String getComposer() throws ID3v2FormatException {
        String string = new String();
        if (this.allow(6)) {
            string = this.id3v2.getFrameDataString(ID3v2Frames.COMPOSER);
        }
        return string;
    }

    public String getOriginalArtist() throws ID3v2FormatException {
        String string = new String();
        if (this.allow(6)) {
            string = this.id3v2.getFrameDataString(ID3v2Frames.ORIGINAL_ARTIST);
        }
        return string;
    }

    public String getCopyrightInfo() throws ID3v2FormatException {
        String string = new String();
        if (this.allow(6)) {
            string = this.id3v2.getFrameDataString(ID3v2Frames.COPYRIGHT_MESSAGE);
        }
        return string;
    }

    public String getUserDefinedURL() throws ID3v2FormatException {
        String string = new String();
        if (this.allow(6)) {
            string = this.id3v2.getFrameDataString(ID3v2Frames.USER_DEFINED_URL);
        }
        return string;
    }

    public String getEncodedBy() throws ID3v2FormatException {
        String string = new String();
        if (this.allow(6)) {
            string = this.id3v2.getFrameDataString(ID3v2Frames.ENCODED_BY);
        }
        return string;
    }

    public String getFrameDataString(String string) throws ID3v2FormatException {
        String string2 = new String();
        if (this.allow(6)) {
            string2 = this.id3v2.getFrameDataString(string);
        }
        return string2;
    }

    public byte[] getFrameDataBytes(String string) {
        byte[] byArray = new byte[]{};
        if (this.allow(6)) {
            byArray = this.id3v2.getFrameData(string);
        }
        return byArray;
    }

    public int getTaggingType() {
        return this.tagType;
    }

    public void setTaggingType(int n) {
        this.tagType = n;
    }

    public int getTagSize() {
        return this.getTagSize(this.tagType);
    }

    public int getTagSize(int n) {
        int n2 = 0;
        if (this.allow(5, n)) {
            n2 += this.id3v1.getSize();
        }
        if (this.allow(6, n) && this.id3v2.tagExists()) {
            n2 += this.id3v2.getSize();
        }
        return n2;
    }

    private boolean allow(int n) {
        return this.allow(n, this.tagType);
    }

    private boolean allow(int n, int n2) {
        boolean bl = false;
        if (n == 5) {
            bl = n2 == 4 && this.id3v1.tagExists() || n2 == 2 || n2 == 0;
        } else if (n == 6) {
            bl = n2 == 4 && this.id3v2.tagExists() || n2 == 1 || n2 == 0;
        }
        return bl;
    }

    public String toString() {
        return String.valueOf(String.valueOf(new StringBuffer("MP3File\nPath:\t\t\t\t").append(this.mp3.getAbsolutePath()).append("\nFileSize:\t\t\t").append(this.mp3.length()).append(" bytes\nPlayingTime:\t\t\t").append(this.getPlayingTimeString()).append("\n").append(this.head).append("\n").append(this.id3v1).append("\n").append(this.id3v2)));
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof MP3File) {
            bl = this.getPath().equals(((MP3File)object).getPath());
        }
        return bl;
    }

    public int compareTo(Object object) {
        int n = 1;
        if (object instanceof MP3File) {
            n = this.getPath().compareTo(((MP3File)object).getPath());
        }
        return n;
    }
}

