/*
 * Decompiled with CFR 0.152.
 */
package helliker.id3;

import helliker.id3.BinaryParser;
import helliker.id3.CorruptHeaderException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class XingVBRHeader {
    private final String HEAD_START = "Xing";
    private final int HEAD_SIZE = 4;
    private final int FLAGS_SIZE = 4;
    private final int TOC_SIZE = 100;
    private final double[] TIMEPERFRAME_TABLE = new double[]{-1.0, 1152.0, 1152.0, 384.0};
    private int numFrames = -1;
    private int numBytes = -1;
    private int vbrScale = -1;
    private byte[] toc;
    private int avgBitrate = -1;
    private int playingTime = -1;
    private int length = -1;
    private boolean exists = false;

    public XingVBRHeader(RandomAccessFile randomAccessFile, long l, int n, int n2, int n3, int n4) throws CorruptHeaderException, IOException {
        this.exists = this.checkHeader(randomAccessFile, l, n4, n2);
        if (this.exists) {
            this.readHeader(randomAccessFile);
            this.calcValues(n, n2, n3);
        }
    }

    private boolean checkHeader(RandomAccessFile randomAccessFile, long l, int n, int n2) throws IOException {
        boolean bl = false;
        byte[] byArray = new byte[4];
        if (n2 == 3) {
            if (n == 3) {
                randomAccessFile.seek(l + (long)21);
            } else {
                randomAccessFile.seek(l + (long)36);
            }
        } else if (n == 3) {
            randomAccessFile.seek(l + (long)23);
        } else {
            randomAccessFile.seek(l + (long)21);
        }
        if (randomAccessFile.read(byArray) == byArray.length) {
            bl = "Xing".equals(new String(byArray));
        }
        return bl;
    }

    private void readHeader(RandomAccessFile randomAccessFile) throws CorruptHeaderException, IOException {
        this.length = 4;
        byte[] byArray = new byte[4];
        if (randomAccessFile.read(byArray) != byArray.length) {
            throw new CorruptHeaderException("XingVBRHeader.readHeader: Unexpected end-of-file encountered");
        }
        this.length += byArray.length;
        if (BinaryParser.bitSet(byArray[3], 0)) {
            this.numFrames = randomAccessFile.readInt();
            this.length += 4;
        }
        if (BinaryParser.bitSet(byArray[3], 1)) {
            this.numBytes = randomAccessFile.readInt();
            this.length += 4;
        }
        if (BinaryParser.bitSet(byArray[3], 2)) {
            this.toc = new byte[100];
            if (randomAccessFile.read(this.toc) != this.toc.length) {
                throw new CorruptHeaderException("XingVBRHeader.readHeader: Unexpected end-of-file encountered");
            }
            this.length += 100;
        }
        if (BinaryParser.bitSet(byArray[3], 3)) {
            this.vbrScale = randomAccessFile.readInt();
            this.length += 4;
        }
        if (this.numBytes == -1 || this.numBytes == 0) {
            this.numBytes = (int)randomAccessFile.length();
        }
    }

    private void calcValues(int n, int n2, int n3) {
        double d = this.TIMEPERFRAME_TABLE[n] / (double)n3;
        if (n2 == 2 || n2 == 0) {
            d /= (double)2;
        }
        this.playingTime = (int)(d * (double)this.numFrames);
        this.avgBitrate = (int)((double)(this.numBytes * 8) / (d * (double)this.numFrames * (double)1000));
    }

    public boolean headerExists() {
        return this.exists;
    }

    public int getNumFrames() {
        return this.numFrames;
    }

    public int getNumBytes() {
        return this.numBytes;
    }

    public int getVBRScale() {
        return this.vbrScale;
    }

    public byte[] getTOC() {
        return this.toc;
    }

    public int getAvgBitrate() {
        return this.avgBitrate;
    }

    public int getPlayingTime() {
        return this.playingTime;
    }

    public String toString() {
        return String.valueOf(String.valueOf(new StringBuffer("NumFrames:\t\t\t").append(this.getNumFrames()).append("\nNumBytes:\t\t\t").append(this.getNumBytes()).append(" bytes\nVBRScale:\t\t\t").append(this.getVBRScale()).append("\nLength:\t\t\t\t").append(this.getLength()).append(" bytes")));
    }

    public int getLength() {
        return this.length;
    }
}

