/*
 * Decompiled with CFR 0.152.
 */
package javazoom.spi.vorbis.sampled.file;

import com.jcraft.jogg.Packet;
import com.jcraft.jogg.Page;
import com.jcraft.jogg.StreamState;
import com.jcraft.jogg.SyncState;
import com.jcraft.jorbis.Block;
import com.jcraft.jorbis.Comment;
import com.jcraft.jorbis.DspState;
import com.jcraft.jorbis.Info;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;
import javazoom.spi.vorbis.sampled.file.VorbisEncoding;
import javazoom.spi.vorbis.sampled.file.VorbisFileFormatType;
import org.tritonus.sampled.file.TAudioFileFormat;

public class VorbisAudioFileReader
extends AudioFileReader {
    public static boolean DEBUG = false;
    private SyncState oggSyncState_ = null;
    private StreamState oggStreamState_ = null;
    private Page oggPage_ = null;
    private Packet oggPacket_ = null;
    private Info vorbisInfo = null;
    private Comment vorbisComment = null;
    private DspState vorbisDspState = null;
    private Block vorbisBlock = null;
    private int bufferMultiple_ = 4;
    private int bufferSize_ = this.bufferMultiple_ * 256 * 2;
    private int convsize = this.bufferSize_ * 2;
    private byte[] convbuffer = new byte[this.convsize];
    private byte[] buffer = null;
    private int bytes = 0;
    private int rate = 0;
    private int channels = 0;
    private Vector songComments_ = new Vector();
    private int index = 0;
    private InputStream oggBitStream_ = null;

    public AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        AudioFileFormat audioFileFormat;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            audioFileFormat = this.getAudioFileFormat(fileInputStream, (int)file.length(), -1);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ((InputStream)fileInputStream).close();
            throw throwable;
        }
        ((InputStream)fileInputStream).close();
        return audioFileFormat;
    }

    public AudioFileFormat getAudioFileFormat(URL uRL) throws UnsupportedAudioFileException, IOException {
        AudioFileFormat audioFileFormat;
        InputStream inputStream = uRL.openStream();
        try {
            audioFileFormat = this.getAudioFileFormat(inputStream);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
        return audioFileFormat;
    }

    public AudioFileFormat getAudioFileFormat(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        return this.getAudioFileFormat(inputStream, -1, -1);
    }

    public AudioFileFormat getAudioFileFormat(InputStream inputStream, int n, int n2) throws UnsupportedAudioFileException, IOException {
        return this.getAudioFileFormat(inputStream, null, n, n2);
    }

    protected AudioFileFormat getAudioFileFormat(InputStream inputStream, ByteArrayOutputStream byteArrayOutputStream, int n, int n2) throws UnsupportedAudioFileException, IOException {
        Object object;
        if (DEBUG) {
            System.err.println("getAudioFileFormat");
        }
        if (n2 == -1) {
            n2 = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        this.oggBitStream_ = inputStream;
        this.init_jorbis();
        this.index = 0;
        try {
            this.readHeaders(byteArrayOutputStream);
        }
        catch (IOException iOException) {
            if (DEBUG) {
                iOException.printStackTrace();
            }
            throw new UnsupportedAudioFileException(iOException.getMessage());
        }
        String string = this.vorbisInfo.toString();
        if (DEBUG) {
            System.err.println(string);
        }
        int n3 = string.lastIndexOf("bitrate:");
        String string2 = "0";
        if (n3 != -1) {
            string = string.substring(n3 + 8, string.length());
            object = new StringTokenizer(string, ",");
            ((StringTokenizer)object).nextToken();
            string2 = ((StringTokenizer)object).nextToken();
        }
        object = VorbisEncoding.VORBISENC;
        AudioFormat audioFormat = new AudioFormat((AudioFormat.Encoding)object, this.vorbisInfo.rate, -1, this.vorbisInfo.channels, -1, -1.0f, true);
        AudioFileFormat.Type type = VorbisFileFormatType.VORBIS;
        return new TAudioFileFormat((AudioFileFormat.Type)new VorbisFileFormatType(VorbisFileFormatType.VORBIS + "x" + string2 + "x" + n2, "ogg"), audioFormat, -1, n);
    }

    public AudioInputStream getAudioInputStream(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        return this.getAudioInputStream(inputStream, -1, -1);
    }

    public AudioInputStream getAudioInputStream(InputStream inputStream, int n, int n2) throws UnsupportedAudioFileException, IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        AudioFileFormat audioFileFormat = this.getAudioFileFormat(inputStream, byteArrayOutputStream, n, n2);
        if (DEBUG) {
            System.err.println("getAudioInputStream( InputStream inputStream ) Size : " + byteArrayOutputStream.size());
        }
        SequenceInputStream sequenceInputStream = new SequenceInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), inputStream);
        return new AudioInputStream(sequenceInputStream, audioFileFormat.getFormat(), audioFileFormat.getFrameLength());
    }

    public AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            return this.getAudioInputStream(fileInputStream);
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            ((InputStream)fileInputStream).close();
            throw unsupportedAudioFileException;
        }
        catch (IOException iOException) {
            ((InputStream)fileInputStream).close();
            throw iOException;
        }
    }

    public AudioInputStream getAudioInputStream(URL uRL) throws UnsupportedAudioFileException, IOException {
        InputStream inputStream = uRL.openStream();
        try {
            return this.getAudioInputStream(inputStream);
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            inputStream.close();
            throw unsupportedAudioFileException;
        }
        catch (IOException iOException) {
            inputStream.close();
            throw iOException;
        }
    }

    private void readHeaders(ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        if (DEBUG) {
            System.err.println("readHeaders(ByteArrayOutputStream baos)");
        }
        this.index = this.oggSyncState_.buffer(this.bufferSize_);
        this.buffer = this.oggSyncState_.data;
        this.bytes = this.readFromStream(this.buffer, this.index, this.bufferSize_);
        if (byteArrayOutputStream != null) {
            byteArrayOutputStream.write(this.buffer, this.index, this.bufferSize_);
        }
        if (this.bytes == -1) {
            if (DEBUG) {
                System.err.println("Cannot get any data from selected Ogg bitstream.");
            }
            throw new IOException("Cannot get any data from selected Ogg bitstream.");
        }
        this.oggSyncState_.wrote(this.bytes);
        if (this.oggSyncState_.pageout(this.oggPage_) != 1) {
            if (this.bytes < this.bufferSize_) {
                throw new IOException("OEF");
            }
            if (DEBUG) {
                System.err.println("Input does not appear to be an Ogg bitstream.");
            }
            throw new IOException("Input does not appear to be an Ogg bitstream.");
        }
        this.oggStreamState_.init(this.oggPage_.serialno());
        this.vorbisInfo.init();
        this.vorbisComment.init();
        if (this.oggStreamState_.pagein(this.oggPage_) < 0) {
            if (DEBUG) {
                System.err.println("Error reading first page of Ogg bitstream data.");
            }
            throw new IOException("Error reading first page of Ogg bitstream data.");
        }
        if (this.oggStreamState_.packetout(this.oggPacket_) != 1) {
            if (DEBUG) {
                System.err.println("Error reading initial header packet.");
            }
            throw new IOException("Error reading initial header packet.");
        }
        if (this.vorbisInfo.synthesis_headerin(this.vorbisComment, this.oggPacket_) < 0) {
            if (DEBUG) {
                System.err.println("This Ogg bitstream does not contain Vorbis audio data.");
            }
            throw new IOException("This Ogg bitstream does not contain Vorbis audio data.");
        }
    }

    private int readFromStream(byte[] byArray, int n, int n2) {
        int n3 = 0;
        try {
            n3 = this.oggBitStream_.read(byArray, n, n2);
        }
        catch (Exception exception) {
            if (DEBUG) {
                System.err.println("Cannot Read Selected Song");
            }
            n3 = -1;
        }
        return n3;
    }

    private void init_jorbis() {
        this.oggSyncState_ = new SyncState();
        this.oggStreamState_ = new StreamState();
        this.oggPage_ = new Page();
        this.oggPacket_ = new Packet();
        this.vorbisInfo = new Info();
        this.vorbisComment = new Comment();
        this.vorbisDspState = new DspState();
        this.vorbisBlock = new Block(this.vorbisDspState);
        this.buffer = null;
        this.bytes = 0;
        this.oggSyncState_.init();
    }
}

