/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.convert;

import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import org.tritonus.util.TCircularBuffer;

public abstract class TAsynchronousFilteredAudioInputStream
extends AudioInputStream
implements TCircularBuffer.Trigger {
    private static int DEFAULT_BUFFER_SIZE = 327670;
    protected TCircularBuffer m_circularBuffer;
    private byte[] m_abSingleByte;

    public TAsynchronousFilteredAudioInputStream(AudioInputStream dummy, AudioFormat outputFormat, long lLength) {
        super(dummy, outputFormat, lLength);
        this.m_circularBuffer = new TCircularBuffer(DEFAULT_BUFFER_SIZE, false, true, this);
    }

    public TAsynchronousFilteredAudioInputStream(AudioFormat outputFormat, long lLength) {
        this(outputFormat, lLength, DEFAULT_BUFFER_SIZE);
    }

    public TAsynchronousFilteredAudioInputStream(AudioFormat outputFormat, long lLength, int nBufferSize) {
        super(null, outputFormat, lLength);
        this.m_circularBuffer = new TCircularBuffer(nBufferSize, false, true, this);
    }

    public int read() throws IOException {
        int nReturn;
        if (this.m_abSingleByte == null) {
            this.m_abSingleByte = new byte[1];
        }
        if ((nReturn = this.read(this.m_abSingleByte)) == -1) {
            return -1;
        }
        return this.m_abSingleByte[0];
    }

    public int read(byte[] abData) throws IOException {
        return this.m_circularBuffer.read(abData);
    }

    public int read(byte[] abData, int nOffset, int nLength) throws IOException {
        return this.m_circularBuffer.read(abData, nOffset, nLength);
    }

    public long skip(long lSkip) throws IOException {
        for (long lSkipped = 0L; lSkipped < lSkip; ++lSkipped) {
            int nReturn = this.read();
            if (nReturn != -1) continue;
            return lSkipped;
        }
        return lSkip;
    }

    public int available() throws IOException {
        return this.m_circularBuffer.availableRead();
    }

    public void close() throws IOException {
        this.m_circularBuffer.close();
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int nReadLimit) {
    }

    public void reset() throws IOException {
        throw new IOException("mark not supported");
    }

    public abstract void execute();
}

