/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.file;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;

public abstract class TAudioFileReader
extends AudioFileReader {
    public AudioFileFormat getAudioFileFormat(File file) throws IOException, UnsupportedAudioFileException {
        AudioFileFormat audioFileFormat;
        FileInputStream inputStream = new FileInputStream(file);
        try {
            audioFileFormat = this.getAudioFileFormat(inputStream);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ((InputStream)inputStream).close();
            throw throwable;
        }
        ((InputStream)inputStream).close();
        return audioFileFormat;
    }

    public AudioFileFormat getAudioFileFormat(URL url) throws IOException, UnsupportedAudioFileException {
        AudioFileFormat audioFileFormat;
        InputStream inputStream = url.openStream();
        try {
            audioFileFormat = this.getAudioFileFormat(inputStream);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
        return audioFileFormat;
    }

    public AudioInputStream getAudioInputStream(File file) throws IOException, UnsupportedAudioFileException {
        FileInputStream inputStream = new FileInputStream(file);
        try {
            AudioInputStream audioInputStream = this.getAudioInputStream(inputStream);
            return audioInputStream;
        }
        catch (UnsupportedAudioFileException e) {
            ((InputStream)inputStream).close();
            throw e;
        }
        catch (IOException e) {
            ((InputStream)inputStream).close();
            throw e;
        }
    }

    public AudioInputStream getAudioInputStream(URL url) throws IOException, UnsupportedAudioFileException {
        InputStream inputStream = url.openStream();
        try {
            AudioInputStream audioInputStream = this.getAudioInputStream(inputStream);
            return audioInputStream;
        }
        catch (UnsupportedAudioFileException e) {
            inputStream.close();
            throw e;
        }
        catch (IOException e) {
            inputStream.close();
            throw e;
        }
    }

    public AudioInputStream getAudioInputStream(InputStream inputStream) throws IOException, UnsupportedAudioFileException {
        AudioFileFormat audioFileFormat = this.getAudioFileFormat(inputStream);
        return new AudioInputStream(inputStream, audioFileFormat.getFormat(), audioFileFormat.getFrameLength());
    }

    public int readLittleEndianInt(InputStream is) throws IOException {
        int b3;
        int b2;
        int b1;
        int b0 = is.read();
        if ((b0 | (b1 = is.read()) | (b2 = is.read()) | (b3 = is.read())) < 0) {
            throw new EOFException();
        }
        return (b3 << 24) + (b2 << 16) + (b1 << 8) + (b0 << 0);
    }

    public short readLittleEndianShort(InputStream is) throws IOException {
        int b1;
        int b0 = is.read();
        if ((b0 | (b1 = is.read())) < 0) {
            throw new EOFException();
        }
        return (short)((b1 << 8) + (b0 << 0));
    }

    public double readIeeeExtended(DataInputStream dis) throws IOException {
        double f = 0.0;
        int expon = 0;
        long hiMant = 0L;
        long loMant = 0L;
        double HUGE = 3.4028234663852886E38;
        expon = dis.readUnsignedShort();
        long t1 = dis.readUnsignedShort();
        long t2 = dis.readUnsignedShort();
        hiMant = t1 << 16 | t2;
        t1 = dis.readUnsignedShort();
        t2 = dis.readUnsignedShort();
        loMant = t1 << 16 | t2;
        if (expon == 0 && hiMant == 0L && loMant == 0L) {
            f = 0.0;
        } else if (expon == Short.MAX_VALUE) {
            f = HUGE;
        } else {
            expon -= 16383;
            f = (double)hiMant * Math.pow(2.0, expon -= 31);
            f += (double)loMant * Math.pow(2.0, expon -= 32);
        }
        return f;
    }
}

