/*
 * Decompiled with CFR 0.152.
 */
package com.rathedg.util.log;

import com.rathedg.util.log.LoggerInterface;
import java.io.IOException;
import java.io.OutputStream;
import java.util.GregorianCalendar;

public class StreamLogger
implements LoggerInterface {
    private OutputStream out;
    private String sep = System.getProperty("line.separator");

    public StreamLogger() {
    }

    public StreamLogger(OutputStream outputStream) {
        this();
        this.out = outputStream;
    }

    public OutputStream getStream() {
        OutputStream outputStream = this.out;
        synchronized (outputStream) {
            OutputStream outputStream2 = this.out;
            return outputStream2;
        }
    }

    public void setStream(OutputStream outputStream) {
        OutputStream outputStream2 = outputStream;
        synchronized (outputStream2) {
            this.out = outputStream;
        }
    }

    public final void log(Object object) {
        this.log(object.toString());
    }

    public void log(String string) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        string = Integer.toString(gregorianCalendar.get(1) % 100) + "." + (gregorianCalendar.get(2) + 1) + "." + gregorianCalendar.get(5) + " " + this.zeros((byte)gregorianCalendar.get(11)) + ":" + this.zeros((byte)gregorianCalendar.get(12)) + ":" + this.zeros((byte)gregorianCalendar.get(13)) + " " + string + this.sep;
        try {
            OutputStream outputStream = this.out;
            synchronized (outputStream) {
                this.out.write(string.getBytes());
            }
        }
        catch (IOException iOException) {
            System.out.println(new GregorianCalendar() + " (" + this + ") error writing log file: " + iOException.getMessage());
            iOException.printStackTrace();
        }
    }

    private final String zeros(byte by) {
        if (by < 10) {
            return "0" + String.valueOf(by);
        }
        return String.valueOf(by);
    }

    public String toString() {
        OutputStream outputStream = this.out;
        synchronized (outputStream) {
            String string = "com.rathedg.util.StreamLogger(" + this.out + ")";
            return string;
        }
    }
}

