/*
 * Decompiled with CFR 0.152.
 */
package com.rathedg.util.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public class TCPShutdownClient {
    public static boolean request(InetAddress inetAddress, int n, String string) throws IOException {
        boolean bl;
        Socket socket = null;
        OutputStream outputStream = null;
        InputStream inputStream = null;
        try {
            socket = new Socket(inetAddress, n);
            socket.setSoTimeout(5000);
            socket.setTcpNoDelay(true);
            outputStream = socket.getOutputStream();
            inputStream = socket.getInputStream();
            int n2 = string.length();
            byte[] byArray = string.getBytes();
            outputStream.write(n2);
            outputStream.write(byArray);
            bl = inputStream.read() == 1;
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (socket != null) {
                socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        InetAddress inetAddress = null;
        int n = 0;
        if (stringArray.length != 3) {
            System.out.println("Usage: TCPShutdownClient <address> <port> <password>");
            System.exit(1);
        }
        try {
            inetAddress = InetAddress.getByName(stringArray[0]);
        }
        catch (UnknownHostException unknownHostException) {
            System.out.println("Can not resolve host: " + unknownHostException.toString());
            System.exit(1);
        }
        try {
            n = Integer.parseInt(stringArray[1]);
            if (n < 0 || n > 65535) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("invalid port value, must be 0..65535");
            System.exit(1);
        }
        if (stringArray[2].length() > 126) {
            System.out.println("too long password, maximum password length is 126 characters");
            System.exit(1);
        }
        try {
            if (TCPShutdownClient.request(inetAddress, n, stringArray[2])) {
                System.out.println("shutdown request succeeded");
            } else {
                System.out.println("shutdown request authentication failed");
            }
            System.exit(0);
        }
        catch (IOException iOException) {
            System.out.println("error: " + iOException.toString());
            System.exit(1);
        }
    }
}

