/*
 * Decompiled with CFR 0.152.
 */
package com.rathedg.cachalot.eru;

import com.rathedg.cachalot.Constants;
import com.rathedg.cachalot.ERUConstants;
import com.rathedg.cachalot.eru.RequestHandler;
import com.rathedg.cachalot.eru.ServerResponse;
import com.rathedg.socketserver.ServerException;
import com.rathedg.socketserver.SocketServerClient;
import com.rathedg.util.StringDataConvertor;
import com.rathedg.util.exception.InvalidConfigurationException;
import com.rathedg.util.exception.InvalidValueException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class Client
implements Constants,
ERUConstants {
    private static final String OUTPUT_BANNER = "\nRatheDG Cachalot System 1.2.0. Event Registration Unit Client.\n";
    private static final String OUTPUT_USAGE = "Usage:       Client host port password timeout attempts [username] \nArguments:\n    host     - host name locating ERU server\n    port     - port number locating ERU server\n    password - password to authenticate in ERU server\n    timeout  - socket i/o timeout, ms\n    attempts - a number of attempts to send an event before giving up\n               in case of a failure\n    action   - one of 'startup', 'shutdown', 'logon', 'logoff'\n    username - for 'logon' action only\n";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] stringArray) {
        System.out.println(OUTPUT_BANNER);
        try {
            if (stringArray.length < 6 || stringArray.length > 7) {
                throw new InvalidConfigurationException();
            }
            try {
                byte by;
                int n = StringDataConvertor.toIntervalIntegerNotNullNotEmpty("port", stringArray[1], 0, 65535);
                int n2 = StringDataConvertor.toIntervalIntegerNotNullNotEmpty("timeout", stringArray[3], 0, 65535);
                int n3 = StringDataConvertor.toIntervalIntegerNotNullNotEmpty("number of attempts", stringArray[4], 1, 255);
                ServerResponse serverResponse = null;
                stringArray[5] = stringArray[5].trim();
                String string = stringArray[5].trim().toLowerCase();
                if (string.equals("startup")) {
                    if (stringArray.length != 6) throw new InvalidConfigurationException("no additional arguments required for action '" + stringArray[5] + "'");
                    by = 1;
                } else if (string.equals("shutdown")) {
                    if (stringArray.length != 6) throw new InvalidConfigurationException("no additional arguments required for action '" + stringArray[5] + "'");
                    by = 2;
                } else if (string.equals("logoff")) {
                    if (stringArray.length != 6) throw new InvalidConfigurationException("no additional arguments required for action '" + stringArray[5] + "'");
                    by = 4;
                } else {
                    if (!string.equals("logon")) throw new InvalidConfigurationException("invalid action '" + stringArray[5] + "' specified");
                    if (stringArray.length != 7) throw new InvalidConfigurationException("username missed");
                    by = 3;
                }
                InetAddress inetAddress = InetAddress.getByName(stringArray[0]);
                int n4 = 0;
                while (n4 < n3) {
                    block23: {
                        Exception exception;
                        try {
                            serverResponse = stringArray.length == 6 ? Client.logUserless(stringArray[2], inetAddress, n, n2, by) : Client.logUsered(stringArray[2], inetAddress, n, n2, stringArray[6], by);
                            if (serverResponse.code != RequestHandler.ERROR[0] || n4 == n3 - 1) break;
                            System.out.println("Server-side error occured during attempt " + (n4 + 1) + " of " + n3 + "\n");
                            break block23;
                        }
                        catch (IOException iOException) {
                            exception = iOException;
                        }
                        catch (ServerException serverException) {
                            exception = serverException;
                        }
                        if (n4 == n3 - 1) {
                            throw exception;
                        }
                        System.out.println("Error occured during attempt " + (n4 + 1) + " of " + n3 + ": " + exception.getClass().getName() + ": " + exception.getMessage() + "\n");
                    }
                    ++n4;
                }
                System.out.println(serverResponse);
                if (serverResponse.code != RequestHandler.OK[0]) {
                    System.exit(1);
                }
            }
            catch (UnknownHostException unknownHostException) {
                throw new InvalidValueException("host", "known");
            }
            System.exit(0);
        }
        catch (InvalidValueException invalidValueException) {
            if (invalidValueException.getMessage() != null) {
                System.out.println(invalidValueException.getMessage() + "\n");
            } else {
                System.out.println(OUTPUT_USAGE);
            }
        }
        catch (InvalidConfigurationException invalidConfigurationException) {
            if (invalidConfigurationException.getMessage() != null) {
                System.out.println(invalidConfigurationException.getMessage() + "\n");
            } else {
                System.out.println(OUTPUT_USAGE);
            }
        }
        catch (Throwable throwable) {
            System.out.println("Error occured (" + throwable.getClass().getName() + "): " + throwable.getMessage() + "\n");
            System.exit(1);
        }
        System.exit(1);
    }

    private static ServerResponse logUserless(String string, InetAddress inetAddress, int n, int n2, byte by) throws IOException, ServerException {
        byte[] byArray;
        SocketServerClient socketServerClient = new SocketServerClient(n2, true);
        socketServerClient.connect(inetAddress, n, by);
        try {
            socketServerClient.writeMessage(string.getBytes());
            byArray = socketServerClient.readMessage();
            Object var8_7 = null;
            socketServerClient.disconnect();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            socketServerClient.disconnect();
            throw throwable;
        }
        if (byArray.length == 1) {
            return new ServerResponse(byArray[0], null);
        }
        return new ServerResponse(byArray[0], new String(byArray, 1, byArray.length - 1));
    }

    private static ServerResponse logUsered(String string, InetAddress inetAddress, int n, int n2, String string2, byte by) throws IOException, ServerException {
        byte[] byArray;
        SocketServerClient socketServerClient = new SocketServerClient(n2, true);
        socketServerClient.connect(inetAddress, n, by);
        try {
            byte by2 = (byte)string.length();
            short s = (short)string2.length();
            byte[] byArray2 = new byte[by2 + 1 + s];
            string.getBytes(0, by2, byArray2, 0);
            string2.getBytes(0, s, byArray2, by2 + 1);
            socketServerClient.writeMessage(byArray2);
            byArray = socketServerClient.readMessage();
            Object var12_11 = null;
            socketServerClient.disconnect();
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            socketServerClient.disconnect();
            throw throwable;
        }
        if (byArray.length == 1) {
            return new ServerResponse(byArray[0], null);
        }
        return new ServerResponse(byArray[0], new String(byArray, 1, byArray.length - 1));
    }
}

