/*
 * Decompiled with CFR 0.152.
 */
package com.rathedg.socketserver;

import com.rathedg.util.PropertyExtractor;
import com.rathedg.util.exception.InvalidConfigurationException;
import com.rathedg.util.exception.InvalidValueException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class PropertiesSocketServerConfig {
    public int port = 0;
    public int connections = 0;
    public int threads = 0;
    public InetAddress address = null;
    public String password;

    public PropertiesSocketServerConfig(PropertyExtractor propertyExtractor) throws InvalidConfigurationException, InvalidValueException, UnknownHostException {
        this.password = propertyExtractor.getStringNotNull("shutdown.password", true);
        this.port = propertyExtractor.getIntervalIntegerNotNullNotEmpty("port", 0, 65535, true);
        String string = propertyExtractor.getStringNotEmpty("address", null, true);
        this.address = string == null ? InetAddress.getLocalHost() : InetAddress.getByName(string);
        this.connections = propertyExtractor.getIntervalIntegerNotNullNotEmpty("connections", 1, 65535, true);
        this.threads = propertyExtractor.getIntervalIntegerNotNullNotEmpty("threads", 1, 65535, true);
    }
}

