/*
 * Decompiled with CFR 0.152.
 */
package com.rathedg.util.log;

import com.rathedg.util.PropertyExtractor;
import com.rathedg.util.StringUtils;
import com.rathedg.util.exception.InvalidConfigurationException;
import com.rathedg.util.exception.InvalidNamedValueException;
import com.rathedg.util.log.LoggerDuplicator;
import com.rathedg.util.log.LoggerInterface;
import com.rathedg.util.log.NullLogger;
import com.rathedg.util.log.RotatingFileLogger;
import com.rathedg.util.log.StreamLogger;
import java.io.IOException;

public final class PropertiesLoggerConfig {
    public static final String FILENAME = "log.filename";
    public static final String PERIOD = "log.period";
    public static final String PREFIX = "log.prefix";
    public static final String USESEPARATOR = "log.usefileseparator";
    public static final String CONSOLE = "log.console";

    public static LoggerInterface create(PropertyExtractor propertyExtractor) throws InvalidConfigurationException, InvalidNamedValueException {
        return PropertiesLoggerConfig.create("", propertyExtractor);
    }

    public static LoggerInterface create(String string, PropertyExtractor propertyExtractor) throws InvalidConfigurationException, InvalidNamedValueException {
        byte by;
        LoggerInterface loggerInterface = null;
        String string2 = propertyExtractor.get(string + FILENAME, true);
        if (string2 != null && string2.length() != 0) {
            try {
                by = (byte)propertyExtractor.getEnumeratedStringNotNull(string + PERIOD, "day", new String[]{"hour", "day", "month"}, true, true);
                by = by == 0 ? (byte)0 : (by == 1 ? (byte)1 : 2);
                boolean bl = propertyExtractor.getBooleanNotNullNotEmpty(string + PREFIX, true, true, true);
                boolean bl2 = propertyExtractor.getBooleanNotNullNotEmpty(string + USESEPARATOR, false, true, true);
                if (bl2 && !bl) {
                    throw new InvalidConfigurationException("log.prefix=false and log.usefileseparator=true can not be used together");
                }
                loggerInterface = new RotatingFileLogger(string2, by, bl, bl2);
            }
            catch (IOException iOException) {
                throw new InvalidConfigurationException(StringUtils.formatPatternNAP("Can not open log file %0%", new String[]{string2}), iOException);
            }
        } else {
            propertyExtractor.remove(string + PERIOD);
            propertyExtractor.remove(string + PREFIX);
            propertyExtractor.remove(string + USESEPARATOR);
        }
        byte by2 = by = propertyExtractor.getEnumeratedStringNotNullNotEmpty(string + CONSOLE, new String[]{"on", "off"}, "off", true, true) == 0 ? (byte)1 : 0;
        if (by != 0) {
            loggerInterface = loggerInterface == null ? new StreamLogger(System.out) : new LoggerDuplicator(loggerInterface, new StreamLogger(System.out));
        }
        if (loggerInterface == null) {
            loggerInterface = new NullLogger();
        }
        return loggerInterface;
    }
}

