/*
 * Decompiled with CFR 0.152.
 */
package com.rathedg.util.math;

import com.rathedg.util.exception.InvalidDataException;

public class IntegerInterval {
    public int a;
    public int b;

    public IntegerInterval(int n, int n2) {
        if (n > n2) {
            throw new IllegalArgumentException("left boundary must not be greater than right");
        }
        this.a = n;
        this.b = n2;
    }

    public IntegerInterval(String string) throws InvalidDataException {
        string = string.trim();
        int n = string.indexOf(45);
        if (n == -1) {
            try {
                this.a = this.b = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidDataException("invalid integer interval: '" + string + "'", string);
            }
        }
        try {
            if (n == 0) {
                throw new NumberFormatException();
            }
            this.a = Integer.parseInt(string.substring(0, n).trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidDataException("invalid left boundary of integer interval: '" + string + "'", string);
        }
        try {
            if (n == string.length() - 1) {
                throw new NumberFormatException();
            }
            this.b = Integer.parseInt(string.substring(n + 1).trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidDataException("invalid right boundary of integer interval: '" + string + "'", string);
        }
        if (this.a > this.b) {
            throw new InvalidDataException("left boundary is greater than right: '" + string + "'", string);
        }
    }

    public boolean contains(int n) {
        return n >= this.a && n <= this.b;
    }

    public boolean equals(Object object) {
        if (object instanceof IntegerInterval) {
            IntegerInterval integerInterval = (IntegerInterval)object;
            return integerInterval.a == this.a && integerInterval.b == this.b;
        }
        return false;
    }

    public String toString() {
        if (this.a == this.b) {
            return String.valueOf(this.a);
        }
        return String.valueOf(this.a) + "-" + String.valueOf(this.b);
    }
}

