@rem
@rem RatheDG Cachalot System 1.2.0. Server environment settings.
@rem

@echo off

rem
rem Specify path to installed JDK here.
rem Note that this variable value must not contain " character (double quotes).
rem

rem set JAVA_HOME=path_to_your_JDK_installation

rem
rem Specify path to installed Tomcat here.
rem Note that this variable value must not contain " character (double quotes).
rem

rem set CATALINA_HOME=path_to_your_Tomcat_installation


if not ""%1"" == """" goto SETJDBC

if not defined CACHALOT_HOME set CACHALOT_HOME=%~dp0..

set ERU=%CACHALOT_HOME%\system\server\eru.jar
if not exist "%ERU%" set F=%ERU%& goto ERR

set TRU=%CACHALOT_HOME%\system\server\tru.jar
if not exist "%TRU%" set F=%TRU%& goto ERR

set UIU=%CACHALOT_HOME%\system\server\uiu.war
if not exist "%UIU%" set F=%UIU%& goto ERR

set EXT=%CACHALOT_HOME%\external

rem
rem %JAVA_HOME% contains full path to Java Runtime Environment.
rem
if not defined JAVA_HOME set JAVA_HOME=%EXT%\java

rem
rem %JAVA_HOME%\bin\java must exist and be readable, this is java runtime
rem executable file.
rem
if exist "%JAVA_HOME%\bin\java.exe" goto JAVA_BIN
    echo The JAVA_HOME environment variable is not defined correctly.
    echo This environment variable is needed to run this program.
    exit
:JAVA_BIN

rem
rem %JDBC% contains path to the JDBC driver which Cachalot System
rem will use to connect to the database. We enumerate all JDBC drivers
rem available in %EXT%\jdbc folder and add its to the %CLASSPATH%.
rem
for %%i in ("%EXT%\jdbc\*.jar") do call "%CACHALOT_HOME%\bin\environment.cmd" %%i

rem
rem Directory %EXT%\jdbc\ must contain at least one JDBC driver.
rem
if defined JDBC goto JDBC
    echo We looked in %EXT%\jdbc\ directory and found nothing similar to JDBC driver,
    echo Directory %EXT%\jdbc\ must contain at least one JDBC driver.
    exit
:JDBC

set CACHALOT_CONF=%CACHALOT_HOME%\conf

if defined CLASSPATH set CLASSPATH=%CLASSPATH%;%JDBC%;%ERU%;%TRU%& goto JAVA
set CLASSPATH=%JDBC%;%ERU%;%TRU%

:JAVA
set JAVA="%JAVA_HOME%\bin\java.exe" -DCACHALOT_HOME="%CACHALOT_HOME%"

rem
rem Debug output.
rem
echo Using CACHALOT_HOME:  %CACHALOT_HOME%
echo Using JAVA_HOME:      %JAVA_HOME%
echo Using CLASSPATH:      %CLASSPATH%

goto :EOF

rem
rem Process the first argument.
rem
:SETJDBC

if not defined JDBC set JDBC=%1& goto SHIFT
set JDBC=%JDBC%;%1

:SHIFT
shift

rem
rem Process the remaining arguments.
rem
:SETJDBC2
if ""%1"" == """" goto :EOF
    set JDBC=%JDBC% %1
    shift
goto SETJDBC2

:ERR
echo Can't find file: %F%.
echo This is essential part of the system and is needed to run this program.
exit

