#!/bin/bash
#
# RatheDG Cachalot System 1.2.0. Server environment settings.
#

ERU="$CACHALOT_HOME"/system/server/eru.jar
if [ ! -r "$ERU" ]; then
    echo "Can't find file: $ERU"
    echo "This is essential part of the system and is needed to run this program."
    echo
    exit 1
fi

TRU="$CACHALOT_HOME"/system/server/tru.jar
if [ ! -r "$TRU" ]; then
    echo "Can't find file: $TRU"
    echo "This is essential part of the system and is needed to run this program."
    echo
    exit 1
fi

UIU="$CACHALOT_HOME"/system/server/uiu.war
if [ ! -r "$UIU" ]; then
    echo "Can't find file: $UIU"
    echo "This is essential part of the system and is needed to run this program."
    echo
    exit 1
fi

EXT="$CACHALOT_HOME"/external

#
# $JAVA_HOME contains full path to Java Runtime Environment.
#
if [ -z "$JAVA_HOME" ]; then
    JAVA_HOME="$EXT"/java
fi

#
# $JAVA_HOME/bin/java must exist and be readable, this is java runtime
# executable file.
#
if [ ! -r "$JAVA_HOME"/bin/java ]; then
    echo "The JAVA_HOME environment variable is not defined correctly."
    echo "This environment variable is needed to run this program."
    echo
    exit 1
fi

#
# $JDBC contains path to the JDBC driver which Cachalot System
# will use to connect to the database. We enumerate all JDBC drivers
# available in $EXT/jdbc folder and add its to the $CLASSPATH.
#
JDBC=
PTRN="$EXT"/jdbc/*.jar
for i in $PTRN; do
    if [ -z "$JDBC" ]; then
        JDBC="$i"
    else
        JDBC="$i":"$JDBC"
    fi
done

#
# Directory $EXT/jdbc/ must contain at least one JDBC driver.
#
if [ -z "$JDBC" -o "$JDBC" == "$PTRN:" ]; then
    echo "We looked in $EXT/jdbc/ directory and found nothing similar to JDBC driver,"
    echo "Directory $EXT/jdbc/ must contain at least one JDBC driver."
    echo
    exit 1
fi

CACHALOT_CONF="$CACHALOT_HOME"/conf

if [ -z "$CLASSPATH" ]; then
    CLASSPATH="$JDBC":"$ERU":"$TRU"
else
    CLASSPATH="$CLASSPATH":"$JDBC":"$ERU":"$TRU"
fi


JAVA="$JAVA_HOME/bin/java -server"

export JAVA JAVA_HOME CLASSPATH EXT CACHALOT_CONF

#
# Debug output.
#
echo
echo "Using CACHALOT_HOME:  $CACHALOT_HOME"
echo "Using JAVA_HOME:      $JAVA_HOME"
echo "Using CLASSPATH:      $CLASSPATH"
echo

