#!/bin/bash
#
# RatheDG Cachalot System 1.2.0. List available devices script.
#

# if CACHALOT_HOME not defined
if [ -z "$CACHALOT_HOME" ]; then
    PRG=$0
    # Resolve symlinks.
    while [ -L "$PRG" ]; do
        ls=`ls -ld "$PRG"`
        link=`expr "$ls" : '.*-> \(.*\)$'`
        if expr "$link" : '/' > /dev/null; then
            PRG="$link"
        else
            PRG="`dirname $PRG`/$link"
        fi
    done
    # define CACHALOT_HOME
    CACHALOT_HOME=`dirname "$PRG"`/..
fi

ENV=$CACHALOT_HOME/bin/environment.sh
if [ ! -r "$ENV" ]; then
    echo "Can't find file: $ENV."
    echo "This file is needed to run this program."
    echo
    exit 1
fi

. "$ENV"

CLASSPATH=$CLASSPATH:$EXT/jpcap/jpcap-0.01.13.jar

$JAVA com.rathedg.cachalot.tru.ListDevices

