@rem
@rem RatheDG Cachalot System 1.2.0. TRU stop script.
@rem
@rem Note:
@rem    1) System parameters marked as (!) MUST be configured by deployer.
@rem       System will not work if these parameters are not defined properly.
@rem
@rem    2) System parameters marked as (S) are important for system security.
@rem       It is recommended to configure them after initial system installation
@rem       and configuration.
@rem

@echo off

rem
rem %SERVER% is host where TRU is running.
rem See 'shutdown.address' parameter in tru.conf.
rem
set SERVER=localhost

rem
rem %PORT% is port which TRU is listening for shutdown request.
rem See 'shutdown.port' parameter in tru.conf.
rem
set PORT=9007

rem
rem (S) %PASSWORD% is TRU shutdown password.
rem See 'shutdown.password' parameter in tru.conf.
rem
set PASSWORD=MyTRUShutdownPassword

if not defined CACHALOT_HOME set CACHALOT_HOME=%~dp0..

set ENV=%CACHALOT_HOME%\bin\environment.cmd
if exist "%ENV%" goto ENV
    echo Can't find file: %ENV%.
    echo This file is needed to run this program.
    goto :EOF
:ENV

call "%ENV%"

%JAVA% com.rathedg.cachalot.tru.Shutdown %SERVER% %PORT% %PASSWORD%

