#!/bin/bash
#
# RatheDG Cachalot System 1.2.0. UIU stop script.
#

# if CACHALOT_HOME not defined
if [ -z "$CACHALOT_HOME" ]; then
    PRG=$0
    # Resolve symlinks.
    while [ -L "$PRG" ]; do
        ls=`ls -ld "$PRG"`
        link=`expr "$ls" : '.*-> \(.*\)$'`
        if expr "$link" : '/' > /dev/null; then
            PRG="$link"
        else
            PRG="`dirname $PRG`/$link"
        fi
    done
    # define CACHALOT_HOME
    CACHALOT_HOME=`dirname "$PRG"`/..
fi

ENV=$CACHALOT_HOME/bin/environment.sh
if [ ! -r "$ENV" ]; then
    echo "Can't find file: $ENV."
    echo "This file is needed to run this program."
    echo
    exit 1
fi

. "$ENV"

if [ -z "$CATALINA_HOME" ]; then
    CATALINA_HOME="$EXT"/tomcat
fi

CAT=$CATALINA_HOME/bin/shutdown.sh
if [ ! -r "$CAT" ]; then
    echo "Can't find file: $CAT."
    echo "This is Tomcat shutdown script and is needed to run this program."
    echo
    exit 1
fi

CATALINA_OPTS="-cp $CLASSPATH -DUIU_CONF=$CACHALOT_CONF/uiu.conf"

export CATALINA_HOME CATALINA_OPTS CAT

DO="$CAT"
\su cachalot -m -c "$DO"

