<%@ Language=VBScript %>
<%Option Explicit%>
<%
On Error Resume Next
Response.Expires = -1

' check whether the logged on user can access this page
If Session("AppUserID") = "" Then
	Response.Redirect "UserLogon.asp"
End If
If Session("AppRoleID") <> 1 Then ' not an admin
	Response.Redirect "Error.asp?err=User has no permissions to access this page&backto=UserLogon.asp"
	Response.End
End If

Const cPageTitle = "Event Type Exclusion List"

Dim objGsElg
Set objGsElg = Server.CreateObject("GsElgReportsCom.Reports")

Dim m_objXml
Set m_objXml = Server.CreateObject("Microsoft.XMLDom")

Dim m_sEventExclusionDelete
Dim m_sEventExclusionInsert
Dim m_sEventExclusionListSubmit

' get query string variables
m_sEventExclusionListSubmit = Request.Form("btnEventExclusionListSubmit")
m_sEventExclusionDelete = Request.Form("hEventExclusionDelete")
m_sEventExclusionInsert = Request.Form("hEventExclusionInsert")

If m_sEventExclusionListSubmit = "Submit Changes" Then	' update database
	If objGsElg.ExclusionListSubmit(CStr(m_sEventExclusionDelete), CStr(m_sEventExclusionInsert)) <> 0 Then
		Response.Write "<script>document.location.href = 'Error.asp?err=Error executing query&backto=EventExclusion.asp';</script>"
		Response.End
	End If
End If

Function EventExclusionTableDisplay(ByRef objXml)
	Dim sXml
	Dim nRetVal
	
	nRetVal = objGsElg.EventExclusionGridXmlGet(sXml)
	If nRetVal <> 0 Then
		Set objGsElg = Nothing
		Response.Write "<script>document.location.href = 'Error.asp?err=Error executing query&backto=EventExclusion.asp';</script>"
		Response.End
	End If
	
	objXml.loadXml sXml
	
	EventExclusionHeaderDisplay(objXml)
	EventExclusionGridDisplay(objXml)
	
End Function

Function EventExclusionHeaderDisplay(ByRef objXml)
	Dim objServerList
	Dim objServer
	Dim objEventTypeList
	Dim objEventType
	
	Set objServerList = objXml.documentElement.SelectNodes("SERVER")

	Response.Write "<tr><td style=""font-weight:bold;background:black;color:white"">&nbsp</td>"

	Set objEventTypeList = objServerList(0).SelectNodes("EVENTTYPE")
	' show event type headers
	For Each objEventType In objEventTypeList
		Response.Write "<td style=""font-weight:bold;background:black;color:white"">" & objEventType.getAttribute("EventTypeName") & "</td>"
	Next
	Response.Write "</tr>"
	
	Response.Write "<tr style=""background:white""><td style=""font-weight:bold;background:black;color:white"">All&nbsp;Servers</td>"
	For Each objEventType In objEventTypeList
			Response.Write "<td align=""middle""><input onclick=""MenuCheckOnClick()"" type=""checkbox"" ParentID=""null"" ID=""ckf_" & objEventType.getAttribute("EventTypeID") & "_All"" NAME=""ckf_" & objEventType.getAttribute("EventTypeID") & "_All""></td>"
	Next
				
End Function

Function EventExclusionGridDisplay(ByRef objXml)
	Dim objServerList
	Dim objServer
	Dim objEventTypeList
	Dim objEventType
	Dim sServerID
	Dim sEventTypeID
	
	Set objServerList = objXml.documentElement.SelectNodes("SERVER")
	For Each objServer In objServerList
		sServerID = objServer.getAttribute("ServerID")
		Response.Write "<tr style=""background:whitesmoke""><td style=""font-weight:bold;background:black;color:white"">" & objServer.getAttribute("ServerName") & "</td>"

		Set objEventTypeList = objServer.SelectNodes("EVENTTYPE")
		For Each objEventType In objEventTypeList
			sEventTypeID = objEventType.getAttribute("EventTypeID")
			Response.Write "<td align=""middle""><input onclick=""MenuCheckOnClick()"" type=""checkbox"" ParentID=""ckf_" & sEventTypeID & "_All""" & """ ID=""ckf_" & sEventTypeID & "_" & sServerID & """ NAME=""ckf_" & sEventTypeID & "_" & sServerID & """ ServerID=""" & sServerID & """ EventTypeID=""" & sEventTypeID & """ " & objEventType.getAttribute("IsChecked") & "></td>"
		Next
				
		Response.Write "</tr>" & chr(10)
	Next
End Function
%>
<!--
GsElg Reports Version 1.5 
Copyright 2002-2003 Gravity Square, Inc. - http://www.gravitysquare.com
Developed by Alpentia Software. Inc. - http://www.alpentia.com
-->
<HTML>
<HEAD>
<title>GsElg Reports - <%=cPageTitle%></title>
<link rel="STYLESHEET" href="stylesheets/style.css">
</link>
<script language="JavaScript" src="scripts/global.js"></script>
<script language="JavaScript">
var checkBoxTree = new ActiveXObject("Msxml2.DOMDocument");

function BodyOnLoad(){
/*	var el = null;
	var objNodes = document.all.tags('input');
	var nLength = objNodes.length;
	for(nIdx = 0; nIdx < nLength; nIdx++){
		el = objNodes[nIdx];
		if(el.id.indexOf('ckf_') >= 0 && el.checked == true){
			MenuCheckParent(el);
		}
	}		
*/

	CheckBoxTreeMake();
	
	// get the root checkbox and check the children if necessary
	var el;
	var i;
	var elList = checkBoxTree.documentElement.selectNodes("//input")
	for(i = 0; i < elList.length; i++){
		if(elList[i].getAttribute("checked") == 'true' && elList[i].getAttribute("ParentID") != null){
			MenuCheckParent(elList[i]);
		}
	}
}

function CheckBoxTreeMake(){
	var el = null;
	var objNodes = document.all.tags('input');
	var nLength = objNodes.length;
	var tempNode
	var tempNew

	checkBoxTree.loadXML("<CheckBoxTree />");

	// insert the checkboxes into the Xml doc
	for(nIdx = 0; nIdx < nLength; nIdx++){
		el = objNodes[nIdx];
		
		// see if the node's parent is in the tree
		if((el.id.indexOf('cks_') >= 0 || el.id.indexOf('ckf_') >= 0)){
			tempNode = checkBoxTree.selectSingleNode("//input[@id='" + el.ParentID + "']");
			tempNew = checkBoxTree.createElement("input");

			tempNew.setAttribute('id', el.getAttribute('id'));
			tempNew.setAttribute('name', el.getAttribute('name'));
			if(el.getAttribute('CHECKED')){
				tempNew.setAttribute('checked', 'true');
			}
			else{
				tempNew.setAttribute('checked', 'false');
			}			

			if(tempNode != null){
				tempNew.setAttribute('ParentID', el.ParentID);
				tempNode.appendChild(tempNew);
			}
			else{
				checkBoxTree.documentElement.appendChild(tempNew);
			}
		}
	}		
}

function QuerySubmit(){
	OptionsQueryCreate();

	return true;
}

function OptionsQueryCreate(){
	var sBuffInsert = '';
	var sBuffDelete = '';
	var el = null;

	var objNodes = document.all.tags('input');
	var nLength = objNodes.length;

	for(nIdx = 0; nIdx < nLength; nIdx++){
		el = objNodes[nIdx];
		if(el.id.indexOf('ckf_') >= 0 && el.getAttribute("ServerID") != null){
			if(el.checked == true){	// remove from the exclusion list
				sBuffDelete += '<NODE ServerID="' + el.getAttribute("ServerID") + '" EventTypeID="' + el.getAttribute("EventTypeID") + '" />';
			}
			else{	// add to the exclusion list
				sBuffInsert += '<NODE ServerID="' + el.getAttribute("ServerID") + '" EventTypeID="' + el.getAttribute("EventTypeID") + '" />';
			}
		}
	}		
	
	frmMain.hEventExclusionDelete.value = '<ROOT>' + sBuffDelete + '</ROOT>';
	frmMain.hEventExclusionInsert.value = '<ROOT>' + sBuffInsert + '</ROOT>';
}

</script>
</HEAD>
<BODY onload="BodyOnLoad()" bgcolor="white">
	<table border="0" width="800" bgcolor="whitesmoke">
	<!-- #INCLUDE FILE="include/TopNav.asp" -->
	<tr><td style="height:5;font-size:1;background:white">&nbsp;</tr>
	<tr>
	<td>
		<form method="post" name="frmMain" onsubmit="return QuerySubmit();" action="EventExclusion.asp">
			<input type="hidden" name="hEventExclusionInsert" id="hEventExclusionInsert" value="<ROOT />">
			<input type="hidden" name="hEventExclusionDelete" id="hEventExclusionDelete" value="<ROOT />">
			<table width="100%" cellpadding="0" cellspacing="0" bgcolor="white" border="0">
				<tr>
					<td align="center">
						<table cellpadding="0" cellspacing="0" bgcolor="silver">
							<tr>
								<td align="left" bgcolor="white">
									<b><font size="3">
										&nbsp;<%=cPageTitle%>
									</font></b>
								</td>
							</tr>
							<tr><td style="height:10;font-size:1;background:white">&nbsp;</tr>
							<tr>
								<td align="center">
									<table border="0" cellpadding="3" cellspacing="1" bgcolor="beige">
									<%
									EventExclusionTableDisplay(m_objXml)
									%>
									</table>
								</td>
							</tr>
							<tr><td style="border-top-color:black;border-top-style:outset;border-top-width:2;height:5;font-size:1">&nbsp;</tr>
							<tr>
								<td align="center" bgcolor="silver">
									<input type="submit" NAME="btnEventExclusionListSubmit" value="Submit Changes">&nbsp;
									<input type="button" NAME="btnReset" value="Reset" onclick="document.location.href = document.location.href;">
								</td>
							</tr>
							<tr><td style="border-bottom-color:grey;border-bottom-style:outset;border-bottom-width:2;height:5;font-size:1">&nbsp;</tr>
						</table>
					</td>
				</tr>
			</table>
		</form>
	</td>
	</tr>
	<tr><td>&nbsp;</td></tr>
	<!-- #INCLUDE FILE="include/Footer.inc" -->
	</table>
</BODY>
</HTML>

<%
Set objGsElg = Nothing
%>
