// =================================================================
//
//  Copyright (C) 2001 Maciej Sobczak - Demo1 Application
//  Copyright (C) 2003 Alex Vinokur
//
//  For conditions of distribution and use, see
//  copyright notice in common.h
//
// =================================================================


// #################################################################
//
//  SOFTWARE : C++ Stream-Compatible TCP/IP Sockets Demo Application
//  FILE     : client.cpp
//
//  DESCRIPTION :
//         Client related class implementation
//         Demo1 application
//
// #################################################################



// ================
#include "client.h"
// ================


// ---------------------
// Constructor-1
ClientRun::ClientRun (
		int 		ip_port_no_i, 
		const string&	ip_server_address_i
		) 
		: 
		BasicPartner (CLIENT_NAME, ip_port_no_i), 
		ip_server_address_ (ip_server_address_i),
		stream_ (ip_server_address_i.c_str(), ip_port_no_i)
{
SET_CTOR_TRACE;

ostringstream oss;
  oss << get_connection_ip_desr ();

  cout << "\t" << string (oss.str().size(), '*') << endl;
  cout << "\t" << oss.str() << endl;
  cout << "\t" << string (oss.str().size(), '*') << endl;
  cout << endl;
  cout << endl;


  assert (pre_check_);
  pre_check_ = pre_check_ && check_ip_server_address ();
  assert (pre_check_);

}


// ---------------------
// Destructor
ClientRun::~ClientRun()
{
SET_DTOR_TRACE;
}


// ---------------------
bool ClientRun::check_ip_server_address () const
{
SET_TRACE;
  return true; // TBD
}



// ---------------------
string ClientRun::get_ip_server_address () const
{
SET_TRACE;
  return ip_server_address_;
}




// ---------------------
string ClientRun::get_peer_ip_address () const
{
SET_TRACE;
  return get_ip_server_address();
}


// ---------------------
string ClientRun::get_connection_ip_desr () const
{
SET_TRACE;

ostringstream oss;
 oss << "Server IP Address = "
     <<  get_ip_server_address ()
     << ", Port No = "
     << get_ip_port_no ();

  return oss.str();
}


// ---------------------
string ClientRun::get_peer_name () const
{
SET_TRACE;

  return SERVER_NAME;
}




// ---------------------
string ClientRun::get_outcoming_packet_desr () const
{
SET_TRACE;
  return "SentRequest";
}

// ---------------------
string ClientRun::get_incoming_packet_desr () const
{
SET_TRACE;
  return "RecvReply";
}

// ---------------------
void ClientRun::set_local_sent_packets () 
{
SET_TRACE;
  if (prev_request_id_ != cur_request_id_) 
  {
    local_sent_packets_ = 0;
    local_recv_packets_ = 0;
  }

}


// ---------------------
void ClientRun::set_local_recv_packets () 
{
SET_TRACE;
  // Empty
}



// ---------------------
void ClientRun::read_from_stream (string& data_o) 
{
SET_TRACE;
  assert (get_partner_name() == CLIENT_NAME);

  stream_ >> data_o;

}

// ---------------------
bool ClientRun::write_to_stream (const string& data_i, const string& msg_i) 
{
SET_TRACE;
bool ret_bool = true;

  assert (get_partner_name() == CLIENT_NAME);

  try
  {
    assert (data_i.size() < BUFSIZE_DEFAULT);
    stream_ << data_i << endl;
  }
  catch (const SocketRunTimeException &e)
  {
    ret_bool = false;
    assert (!msg_i.empty());
    MOUT (  get_partner_name() 
         << " * " 
         << msg_i 
         << " ---> Writing to stream exception : " 
         << e.what() 
         << endl
         );
  }

  return ret_bool;

}


// ---------------------
size_t ClientRun::read_size_from_stream()
{
SET_TRACE;
  assert (get_partner_name() == CLIENT_NAME);

size_t ret_size_value;
  stream_ >> ret_size_value;

  assert (ret_size_value > 0);
  return ret_size_value;

}


// ---------------------
#include <complex>
void ClientRun::demo1 ()
{
SET_TRACE;
string		string_msg;
complex<double>	complex_msg;
int		integer_msg;

  SHOW1_TRACE ("CLIENT DEMO");

  try
  {
    bool oncemore = true;
    int command;
    while (oncemore)
    {
      cout << "1 - Request for a string" << endl;
      cout << "2 - Request for a number" << endl;
      cout << "3 - Request for a complex number" << endl;
      cout << "Other - end" << endl;

      cin >> command;
      SHOW1_TRACE ("BEFORE : posting request & getting reply");
      stream_ << command << endl;

      switch (command)
      {
        case 1:
          SHOW1_TRACE ("Request-" + to_string (command) + " : PERFORM getting reply --> string_msg");
          do
          {
            getline(stream_, string_msg);
          } while (string_msg.empty());
          cout << "   Received : " << string_msg << endl << endl;
          break;

        case 2:
          SHOW1_TRACE ("Request-" + to_string (command) + " : PERFORM getting reply --> integer_msg");
          stream_ >> integer_msg;
          cout << "   Received : " << integer_msg << endl << endl;
          break;

        case 3:
          SHOW1_TRACE ("Request-" + to_string (command) + " : PERFORM getting reply --> complex");
          stream_ >> complex_msg;
          cout << "   Received : " << complex_msg << endl << endl;
          break;

        default:
          cout << endl << "END of posting requests" << endl;
          SHOW1_TRACE ("END of posting requests : " + to_string (command));
          oncemore = false;
          break;
      }	// switch
    } // while
  }
  catch (const SocketRunTimeException &e)
  {
    MOUT ("socket exception: " << e.what() << endl);
  }

} // demo1


