// =================================================================
//
//  Copyright (C) 2003 Alex Vinokur
//
//  For conditions of distribution and use, see
//  copyright notice in common.h
//
// =================================================================


// #################################################################
//
//  SOFTWARE : C++ Stream-Compatible TCP/IP Sockets Demo Application
//  FILE     : macro.h
//
//  DESCRIPTION :
//         Various macro
//
// #################################################################


////////////////////////
#ifndef INCLUDED_MACRO_H
#define INCLUDED_MACRO_H
////////////////////////


#define	OUT_PREFIX_TEXT \
		  "[ " \
		<< std::left \
		<< setw (12) \
		<< __FILE__ \
		<< " , #" \
		<< std::right \
		<< setw(4) \
		<< __LINE__ \
		<< " ] "


#if (MILESTONE_LOG)
#define MOUT(t)	mout << OUT_PREFIX_TEXT << t
#else
#define MOUT(t)
#endif


// ---------------------------------
#define TEMPLATE_MSG(x) string ("[ " + to_string(__FILE__) + " , #" + to_string(__LINE__) + " ]  " + to_string (x)).c_str() 

#define MSG_THROW(x)	TEMPLATE_MSG(x)

// ---------------------------------
#if (TRACE_LOG)
  #define SET_DETAILED_TRACE(x)	\
	ostringstream tmp_oss; tmp_oss << x; \
	ClassTrace trace_inst (__FILE__, __LINE__, __FUNCTION__, __PRETTY_FUNCTION__, tmp_oss.str())
  #define SHOW1_TRACE(x)		trace_inst.show_trace("STEP", x, "", __LINE__)
  #define SHOW2_TRACE(x, t)	trace_inst.show_trace("STEP", x, t, __LINE__)
#else
  #define SET_DETAILED_TRACE(x)
  #define SHOW1_TRACE(x)
  #define SHOW2_TRACE(x,t)
#endif

#define SET_TRACE		SET_DETAILED_TRACE("")
#define SET_CTOR_TRACE		SET_DETAILED_TRACE("Ctor")
#define SET_DTOR_TRACE		SET_DETAILED_TRACE("Dtor")

#define MAX_VALUE(x,y)  ((x) > (y) ? (x) : (y))

#define WARNING(x)  if (!(x)) \
	{ cerr << OUT_PREFIX_TEXT \
               << "WARNING!  " \
               << "`" \
               << #x \
               << "\'  FAILED" \
               << endl; \
               }

//////
#endif
//////
