// =================================================================
//
//  Copyright (C) 2001 Maciej Sobczak - Demo1 Application
//  Copyright (C) 2003 Alex Vinokur
//
//  For conditions of distribution and use, see
//  copyright notice in common.h
//
// =================================================================


// #################################################################
//
//  SOFTWARE : C++ Stream-Compatible TCP/IP Sockets Demo Application
//  FILE     : server.cpp
//
//  DESCRIPTION :
//         Server related class implementation
//         Demo1 application
//
// #################################################################


// ================
#include "server.h"
// ================

// ---------------------

// ---------------------
// ---------------------
// Constructor-1
PreServer::PreServer (int ip_port_no_i)
		:
		BasicPartner (SERVER_NAME, ip_port_no_i)
{
SET_CTOR_TRACE;
  sockserver_.listen(ip_port_no_);
}


// ---------------------
// Destructor
PreServer::~PreServer ()
{
SET_DTOR_TRACE;
}



// ---------------------
// ---------------------
// Constructor-1
ServerRun::ServerRun (int ip_port_no_i)
		:
		PreServer (ip_port_no_i),
		sock_(sockserver_.accept()),
		stream_(sock_)

{
SET_TRACE;

ostringstream oss;
  oss << get_connection_ip_desr ();

  cout << "\t" << string (oss.str().size(), '*') << endl;
  cout << "\t" << oss.str() << endl;
  cout << "\t" << string (oss.str().size(), '*') << endl;
  cout << endl;
  cout << endl;


}


// ---------------------
// Destructor
ServerRun::~ServerRun ()
{
SET_TRACE;
}



// ---------------------
string ServerRun::get_outcoming_packet_desr () const
{
SET_TRACE;
  return "SentReply";
}

// ---------------------
string ServerRun::get_incoming_packet_desr () const
{
SET_TRACE;
  return "RecvRequest";
}


// ---------------------
string ServerRun::get_peer_name () const
{
SET_TRACE;

  return CLIENT_NAME;
}



// ---------------------
string ServerRun::get_connection_ip_desr () const
{
SET_TRACE;

ostringstream oss;
  oss << "Port No = " << get_ip_port_no ();
  oss << "; Connected Client IP Address = " << get_connected_client_ip_address();
  oss << "; Socket Family = " << sock_.get_sockaddress().sin_family;

  return oss.str();
}


// ---------------------
string ServerRun::get_connected_client_ip_address () const
{
SET_TRACE;
  return inet_ntoa (sock_.get_sockaddress().sin_addr);
}


// ---------------------
string ServerRun::get_peer_ip_address () const
{
SET_TRACE;
  return get_connected_client_ip_address();
}


// ---------------------
void ServerRun::set_local_sent_packets () 
{
SET_TRACE;
  // Empty
}


// ---------------------
void ServerRun::set_local_recv_packets () 
{
SET_TRACE;
  if (prev_request_id_ != cur_request_id_) 
  {
    local_recv_packets_ = 0;
    local_sent_packets_ = 0;
  }
  prev_request_id_ = cur_request_id_;
}



// ---------------------
void ServerRun::read_from_stream (string& data_o) 
{
SET_TRACE;

  assert (get_partner_name() == SERVER_NAME);

  stream_ >> data_o;

}

// ---------------------
bool ServerRun::write_to_stream (const string& data_i, const string& msg_i) 
{
SET_TRACE;
bool ret_bool = true;

  assert (get_partner_name() == SERVER_NAME);

  try
  {
    assert (data_i.size() < BUFSIZE_DEFAULT);
    stream_ << data_i << endl;
  }
  catch (const SocketRunTimeException &e)
  {
    ret_bool = false;
    assert (!msg_i.empty());
    MOUT (  get_partner_name() 
         << " * " 
         << msg_i 
         << " ---> Writing to stream exception : " 
         << e.what() 
         << endl
         );
  }

  return ret_bool;

}


// ---------------------
#include <complex>
void ServerRun::demo1 ()
{
SET_TRACE;

string		string_msg  ("Hello Socket!");
complex<double>	complex_msg (1.0, 2.0);
int		integer_msg (1357);

  SHOW1_TRACE ("SERVER DEMO");

  try 
  {
    bool oncemore = true;
    int command;
    while (oncemore)
    {
      // read the command
      SHOW1_TRACE ("BEFORE : getting request & posting reply");
      stream_ >> command;
      SHOW1_TRACE ("AFTER  : getting request-" + to_string (command));
      cout << "Received : Request-" << command << endl;
      switch (command)
      {
        case 1:
          SHOW1_TRACE ("Reply-" + to_string (command) + " : PERFORM posting reply --> string_msg <" + to_string (string_msg) + ">" );
          stream_ << string_msg << endl;
          cout << "    Sent : " << string_msg << endl << endl;
          break;

        case 2:
          SHOW1_TRACE ("Reply-" + to_string (command) + " : PERFORM posting reply --> integer_msg <" + to_string (integer_msg) + ">" );
          stream_ << integer_msg << endl;
          cout << "    Sent : " << integer_msg << endl << endl;
          break;

        case 3:
          SHOW1_TRACE ("Reply-" + to_string (command) + " : PERFORM posting reply --> complex <" + to_string (complex_msg) + ">" );
          stream_ << complex_msg << endl;
          cout << "    Sent : " << complex_msg << endl << endl;
          break;

        default:
          cout << "END of getting requests" << endl;
          SHOW1_TRACE ("END of getting requests");
          oncemore = false;
          break;

      }	// switch
    } // while
  }
  catch (const SocketRunTimeException &e)
  {
    MOUT (  "socket exception: "
         << e.what() 
         << endl
         );
  }

} // demo1


