#!/usr/bin/perl

###############################################################################
#
# FUserProfile.cgi - Display/Edit User Profile
#
# AUTHOR:	Shawn Stepper, wiTHinc Inc.
# AUTHOR:	George Toye, wiTHinc Inc.
# DATE:		$Date: 2001/08/21 17:50:51 $ (last modified)
# COPYRIGHT:	1998, 1999, 2000, 2001 wiTHinc Inc. All Rights Reserved.
#
###############################################################################

$FileRevision = '$Id: FUserProfile.cgi,v 1.29.2.2 2001/08/21 17:50:51 stepper Exp $';
$Version = '1.4.0';

if (@ARGV[0] eq "-v" || @ARGV[0] eq "--version") {
	print "File:		$0\n";
	print "Revision:	$FileRevision\n";
	print "Version:	$Version\n";
	exit();
}

require "F_Init.pl";
require "U_Init.pl";
require "NewClass_Init.pl";

$Class = $CGIQuery->param('fid');
$user = $CGIQuery->param('user');
$func = $CGIQuery->param('func');

if ($user eq "") {
	$user = $CGIEnvUser;
}

$foundclass = &lookupClass($Class);

if (! $foundclass) {
	$colors = &lookupColors(1);
	&loadColors($colors);
	
	&showErrorBackHTML("No $corf was specified or the specified $corf was not found.");
	exit();
}

# Load up color variables
&loadColors($ColorQueryString);

$BodyTag = &makeBodyTag("Content");

if ($C_UserProfile == 0 && $C_UserProfile ne "") {
	&showErrorBackHTML("User Profiles are turned off for this $corf.");
	exit();
}

###############################################################################
#
# Process submitted data

if ($func eq "doedit") {
	if ($Demo) {
		print $CGIQuery->redirect("Demo.html");
		exit();
	}
	&doModProfile($CGIEnvUser);
	exit();
} else {
	# Show login page
	&showProfile($user);
}

sub showProfile {
	local($user, $static, $msg) = @_;
	local($status) = &lookupUser($user);
	
	if ($status) {
		# User not found
		&showErrorBackHTML("The specified user, $user was not found.");
		exit();
	}
	
	$helplink = "<a href=\"#\" ";
	$helplink .= "onClick=\"openwin('$CGI_ForumHelp?func=summary&file=Customizing";
	if ($Edu) {
		$helplink .= "EDU";
	} else {
		$helplink .= "CORP";
	}
	$novice = $CGIQuery->cookie('IS_NOVICE');
	if ($novice == 1 || $novice eq "") {
		 $helplink .= "_Nv";
	} else {
		$helplink .= "_Ex";
	}
	$helplink .= ".html&anchor=EditUserProfileSummary&helptitle=User%20Profile";
	$helplink .= "',640,480,'HelpWin')\">";
	$helplink .= $BtnInfo . "</a>";
	$helplink .= "<img src=$ImgSrcClearDot width=3 height=14 align=absmiddle>";
	
	print $CGIQuery->header(-expires=>'-1d', -cache-control=>'max-age=1, must-revalidate');
	print "<html><head><title>User profile for $U_NameFirst $U_NameLast ($user)</title></head>\n";
	print $BodyTag, "\n";
	print $FontFace, $FontSize, "\n";
	
	print "<table cellpadding=0 cellspacing=0 border=0 width=100%>\n";
	
	print "<tr><td valign=middle bgcolor=";
	print $FCheaderback;
	print ">";
	print $FontFace, $FontSize3, "&nbsp;</font>";
	print $FontSize2, "<font color=";
	print $FCheadertext;
	print ">";
	print $helplink;
	print "<b>User profile for $U_NameFirst $U_NameLast ($user)</b></font></td>";
	print "</tr>\n";
	print "</table>\n\n";
	
	# &showHeaderBackHTML("$helplink User profile for $U_NameFirst $U_NameLast ($user)", "<br>\n",0,0,1);
	print $FontFace, $FontSize;

	&printJavascript;

	if (&IS_FAC($U_Perms)) {
		$highlight = $Ffacultyhilight;
	} else {
		$highlight = $Fstudenthilight;
	}
	
	if ($msg ne "") {
		print $FontRed, $FontSize2, $msg, "</font></font><p>\n";
	}
	
	print "<table border=0 cellpadding=0 cellspacing=1 width=100%>\n";
		
	if ($user eq $CGIEnvUser && $static != 1) {
		print "<form action=$CGIEnvScript method=POST enctype=multipart/form-data>\n";
	}
	
	print "<tr>";
	print "<td rowspan=8 width=44 valign=top>";
	# Large Photo
	if ($C_ShowPhoto ne "0") {
		print "<table cellpadding=0 cellspacing=0 border=0 width=36><tr>";
		print "<td valign=middle align=center height=46 width=36 bgcolor=$highlight nowrap>";
		$absphoto = $C_photodir . $U_PhotoNameLarge;
		if (-e $absphoto) {
			print "<img src=", $U_PhotoLarge, "?", time(), " border=0 name=", $getuser, "_large width=32 height=42>";
		} else {
			print "<img src=", $C_photourl, "Guest.jpg border=0 name=$getuser", "_large width=32 height=42>";
		}

		print "</td></tr></table>";	
	} else {
		print "&nbsp;";
	}
	print "</td>\n";

	print "<td bgcolor=$FTheaderback width=90%>", $FontFace, $FontSize;
	print "<img src=", $ImgSrcClearDot, " width=20 height=2></td></tr>\n";

	# Name	
	print "<tr>";
	print "<td width=90%>", $FontFace, $FontSize;
	print "<b>Full Name:</b><br>";
	if ($user eq $CGIEnvUser && $static != 1) {
		print "$ImgClear88<input type=text size=16 maxlength=100 name=U_NameFirst ";
		print "value=\"$U_NameFirst\">";
		print "<input type=text size=16 maxlength=100 name=U_NameLast ";
		print "value=\"$U_NameLast\">\n<br>&nbsp;";
	} else {
		print $ImgClear88, "$U_NameFirst $U_NameLast\n<br>&nbsp;";
	}
	print "</td></tr>\n";
	
	print "<tr>";
	print "<td bgcolor=$FTheaderback width=90%>", $FontFace, $FontSize;
	print "<img src=", $ImgSrcClearDot, " width=20 height=2></td></tr>\n";
	
	# Email
	print "<tr>";
	print "<td width=90%>", $FontFace, $FontSize;
	print "<b>Email Address:</b><br>";
	if ($user eq $CGIEnvUser && $static != 1) {
		print $ImgClear88, "<input type=text size=24 maxlength=100 name=U_Email ";
		print "value=\"$U_Email\">\n";
		print "&nbsp;&nbsp;&nbsp;&nbsp;";
		print "<input type=checkbox name=U_HideEmail value=1";
		if ($U_HideEmail eq "1") {
			print " checked";
		}
		print "> Hide My Email Address from Other Users\n";
	} else {
		if ($U_HideEmail eq "1") {
			print $ImgClear88, "(Private)\n";
		} else {
			print $ImgClear88, "<a href=\"mailto:$U_Email\">$U_Email</a>\n";
		}
	}
	print "<br>&nbsp;\n";
	print "</td></tr>\n";

	# Phone
	print "<tr>";
	print "<td bgcolor=$FTheaderback width=90%>", $FontFace, $FontSize;
	print "<img src=", $ImgSrcClearDot, " width=20 height=2></td></tr>\n";
	
	print "<tr>";
	print "<td width=90%>", $FontFace, $FontSize;
	print "<b>Phone Number:</b><br>";
	if ($user eq $CGIEnvUser && $static != 1) {
		print $ImgClear88, "<input type=text size=24 maxlength=100 name=U_Phone ";
		print "value=\"$U_Phone\">\n<br>&nbsp;";
	} else {
		print $ImgClear88, "$U_Phone\n<br>&nbsp;";
	}
	print "</td></tr>\n";
	
	# Section
	print "<tr>";
	print "<td bgcolor=$FTheaderback width=90%>", $FontFace, $FontSize;
	print "<img src=", $ImgSrcClearDot, " width=20 height=2></td></tr>\n";
	
	print "<tr>";
	print "<td width=90%>", $FontFace, $FontSize;
	print "<b>$SorG:</b><br>";
	if ($U_C_Sect =~ /\:/) {
		($junk, $sn) = split(/\:/, $U_C_Sect);
	} else {
		$sn = $U_C_Sect;
	}
	print $ImgClear88, $C_Sects{$sn}{"name"}, "\n<br>&nbsp;";
	print "</td></tr>\n";
	
	# User Profile
	if ($U_ProfileText ne "" || $user eq $CGIEnvUser) {
		print "<tr>";
		print "<td width=44>", $FontFace, $FontSize, "</td>\n";
		print "<td bgcolor=$FTheaderback width=90%>", $FontFace, $FontSize;
		print "<img src=", $ImgSrcClearDot, " width=20 height=2></td></tr>\n";
	
		print "<tr>";
		print "<td width=44>", $FontFace, $FontSize, "</td>\n";
		print "<td width=90%>", $FontFace, $FontSize;
		print "<b>Personal Information:</b><br>";
		if ($user eq $CGIEnvUser && $static != 1) {
			print $ImgClear88, "<textarea wrap=virtual name=U_ProfileText rows=4 cols=50>";
			print $U_ProfileText;
			print "</textarea>\n<br>&nbsp;";
		} else {
			print "<table border=0 cellpadding=0 cellspacing=0><tr><td>";
			print $ImgClear88, "</td><td>", $FontSize, $FontFace;
			if ($U_ProfileText =~ /\<.*\>/) {
				print &safeHTML($U_ProfileText);
			} else {
				print &makeHTML($U_ProfileText);
			}
			print "</td></tr></table>\n";
		}
		print "</td></tr>\n";
	}
	
	# Signature
	print "<tr>";
	print "<td width=44>", $FontFace, $FontSize, "</td>\n";
	print "<td bgcolor=$FTheaderback width=90%>", $FontFace, $FontSize;
	print "<img src=", $ImgSrcClearDot, " width=20 height=2></td></tr>\n";
	
	print "<tr>";
	print "<td width=44>", $FontFace, $FontSize, "</td>\n";
	print "<td width=90%>", $FontFace, $FontSize;
	print "<b>Signature:</b><br>\n";
	if ($user eq $CGIEnvUser && $static != 1) {
		print $ImgClear88, "Can be appended to your posts. No HTML allowed.<br>\n";
	}
	if ($user eq $CGIEnvUser && $static != 1) {
		print $ImgClear88, "<input type=text name=U_Sig size=50 maxlength=200";
		if ($U_Sig ne "") {
			$U_Sig =~ s/\"/\\\"/g;
			print " value=\"", $U_Sig, "\"";
		}
		print ">\n<br>&nbsp;";
	} else {
		print $ImgClear88, "$U_Sig\n<br>&nbsp;";
	}
	print "</td></tr>\n";
	
	
	# Photo Upload
	if (($C_UserPhotoUp eq "" || $C_UserPhotoUp eq "1") && $user eq $CGIEnvUser && $static != 1 && $C_ShowPhoto ne "0") {
		print "<tr>";
		print "<td width=44>", $FontFace, $FontSize, "</td>\n";
		print "<td bgcolor=$FTheaderback width=90%>", $FontFace, $FontSize;
		print "<img src=", $ImgSrcClearDot, " width=20 height=2></td></tr>\n";
		#print "<font color=$FTheadertext><b>Upload your own Photo:</b></font></td></tr>\n";
		
		print "<tr>";
		print "<td width=44>", $FontFace, $FontSize, "</td>\n";
		print "<td width=90%>", $FontFace, $FontSize;
		print "<b>Upload your own Photo:</b><br>";
		print $ImgClear88, "For best results, upload a jpg image, 32 pixels wide and 42 pixels high, 100% image quality.<br>\n";
		print $ImgClear88, "<input type=file name=upload size=40>";
		print "</td></tr>\n";
	}
	
	if ($user eq $CGIEnvUser && $static != 1) {
		print "<input type=hidden name=fid value=\"$Class\">\n";
		print "<input type=hidden name=func value=\"doedit\">\n";
		print "<tr>";
		print "<td width=44>", $FontFace, $FontSize, "&nbsp;</td>\n";
		print "<td width=90%>", $FontFace, $FontSize;
		if ($Demo) {
			print $BtnFormSubmitDemo;
		} else {
			print $BtnFormSubmit;
		}
		print "</td></tr>\n";
		print "</form>\n";
	}
	
	print "</table><p>\n\n";
	
	if ($user eq $CGIEnvUser && $static == 1) {
		print "<a href=$CGIEnvScript?fid=$Class\&user=$user>";
		print "Return to Editing</a><p>\n";
	}
	
	# Show stats
	if (-e $CGI_ForumStats && ($C_ShowStats == 1 || $C_ShowStats eq "")) {
		$arg = "fid=" . $Class;
		$arg .= "\&user=" . $user;
		$arg .= "\&fontsize=" . $FontBase;
	
		print "<table border=0 cellpadding=0 cellspacing=1 width=100%>\n";
		print "<tr>";
		print "<td bgcolor=$FTheaderback width=100%>", $FontFace, $FontSize;
		print "<img src=", $ImgSrcClearDot, " width=20 height=2></td></tr>\n";
		print "<tr><td>", $FontFace, $FontSize;
		print "<b>Posting Statistics:</b><br><br>";
		print "</td></tr>\n";
		
		print "<tr><td>";
		print `./$CGI_ForumStats \"$arg\"`;
		print "</td></tr>\n</table>\n";
	}
	
	print "<br>\n<a href=# onClick=window.close()>$BtnClose</a>\n";
	
	print "</body></html>";
}

sub doModProfile {
	# Lookup the user
	local($user) = @_;
	local($status) = &lookupUser($user);
	local($retval);

	# Read in submitted variables and check them for correctness
	$fname = &cleanTabs($CGIQuery->param("U_NameFirst"));
	$lname = &cleanTabs($CGIQuery->param("U_NameLast"));
	$email = &cleanTabs($CGIQuery->param("U_Email"));
	
	# First and last name can't be null
	if ($fname ne "") {
		$U_NameFirst = $fname;
		$U_NamePref = $fname;
	}
	if ($lname ne "") {
		$U_NameLast = $lname;
	}
	
	# Check for valid email address
	$updatemail = 0;
	if ($email ne $U_Email) {
		# Email address changed
		$updatemail = 1;
	}
	if ($email =~ /.*\@.*\..*/) {
		# Valid email address
		$U_Email = $email;
	} else {
		$updatemail = 0;
	}
	
	$U_HideEmail = $CGIQuery->param("U_HideEmail");
	if ($U_HideEmail eq "") {
		$U_HideEmail = "0";
	}
	
	# This can be anything.
	$U_Phone = &cleanTabs($CGIQuery->param("U_Phone"));
	
	# This just needs cleansing
	$U_ProfileText = &cleanTabs($CGIQuery->param("U_ProfileText"));
	
	$U_Sig = &cleanHTML(&cleanTabs($CGIQuery->param("U_Sig")));
	$U_Sig =~ s/\"/\&quot\;/g;
	
	# Turn on signal Handling
	$trapSignals = 1;
	
	$retval = &addtodb($user);
	if ($retval) {
		&userDBError($retval);
	}
	
	if ($updatemail) {
		&rebuildmail;
	}
	
	# Process Uploaded photo
	if (($C_UserPhotoUp eq "" || $C_UserPhotoUp eq "1") && $user eq $CGIEnvUser) {
		$upload = $CGIQuery->param('upload');
		
		if ($upload ne "") {
			$dir = $C_photodir . "tmp";
			&confmakedir($dir);
		
			$savefile = $dir . "/" . $user;
		
			open (filesave, ">$savefile");
			binmode(filesave);
			while (<$upload>) {
				print filesave $_;
			}
			close (filesave);
			
			# Find out what type of file this is.
			if ($isWin) {
				@ident = split(/\s+/, `$IMGidentify -ping \"$savefile\"`);
			} else {
				@ident = split(/\s+/, `$IMGidentify $savefile`);
			}
			$ident[1] =~ s/\+.*//;
			($width, $height) = split(/x/, $ident[1]);

			if ($ident[4] =~ /JPEG/i && $width == 32 && $height == 42) {
				# jpg is good, just make a gif
				$errno = system("$IMGmogrify -geometry \"16x21!\" -sharpen 10 -format gif \"$savefile\" >.imlog");
				if (-e $savefile . ".gif") {
					&copy($savefile . ".gif", $C_photodir . $U_PhotoName);
					&copy($savefile, $C_photodir . $U_PhotoNameLarge);
				} else {
					$msg = "Invalid Format for Uploaded Image (JPG)";
				}
			} elsif ($ident[5] =~ /GIF/i && $width == 16 && $height == 21) {
				# gif is good, just make a jpg.
				$errno = system("$IMGmogrify -geometry \"32x42!\" -sharpen 10 -format jpg \"$savefile\" >.imlog");
				if (-e $savefile . ".jpg") {
					&copy($savefile, $C_photodir . $U_PhotoName);
					&copy($savefile . ".jpg", $C_photodir . $U_PhotoNameLarge);
				} else {
					$msg = "Invalid Format for Uploaded Image (GIF)";
				}
			} else {
				# MAke a gif and a jpg
				$errno = system("$IMGmogrify -geometry \"16x21!\" -sharpen 10 -format gif \"$savefile\" -geometry 32x42! -sharpen 10 -format jpg \"$savefile\" >.imlog");
		
				if (-e $savefile . ".gif" && -e $savefile . ".jpg") {
					&copy($savefile . ".gif", $C_photodir . $U_PhotoName);
					&copy($savefile . ".jpg", $C_photodir . $U_PhotoNameLarge);
				} else {
					$msg = "Invalid Format for Uploaded Image (???)";
				}
			}
		
			# Lastly, delete the files
			unlink($savefile);
			unlink($savefile . ".gif");
			unlink($savefile . ".jpg");
		}
	}
	
	# If we got a signal, exit here.
	if ($gotSignal) {
		close(DEVNULL);
		exit(0);
	}
	
	&showProfile($user, 1, $msg);
}
