#!/usr/bin/perl

###############################################################################
#
# NewClass_Init.pl - Functions used in class creation/editing
#
# AUTHOR:	Shawn Stepper, wiTHinc Inc.
# AUTHOR:	George Toye, wiTHinc Inc.
# DATE:		$Date: 2001/08/21 17:50:51 $ (last modified)
# COPYRIGHT:	1998, 1999, 2000, 2001 wiTHinc Inc. All Rights Reserved.
#
###############################################################################

$FileRevision = '$Id: NewClass_Init.pl,v 1.16.2.2 2001/08/21 17:50:51 stepper Exp $';
$Version = '1.4.0';

if (@ARGV[0] eq "-v" || @ARGV[0] eq "--version") {
	print "File:		$0\n";
	print "Revision:	$FileRevision\n";
	print "Version:	$Version\n";
	exit();
}

1;

sub classDBError {
	local ($errmsg) = @_;
	
	&showErrorBackHTML();
	
	if ($errmsg =~ /^ERROR/) {
		print "<b>", $FontSize2, $errmsg, "</font></b><p>\n";
		if ($errmsg =~ /License/ || $errmsg =~ /Address/ || 
								($errmsg =~ /Max/ && $errmsg =~ /Exceeded/)) {
		# License Error. Give links
		print "To upgrade or purchase a panFora license, go to ",
			"<a href=http://www.withinc.com target=_blank>",
			"http://www.withinc.com</a> .<p>\n";
		print "If you have a valid panFora license key, you can enter it in ",
			"the <a href=\"", $CGI_License, "?fid=", $Class, "\" target=_blank>",
			"License Key Entry Form</a>.<p>\n";
		print "If you are having problems with your license key, contact ",
			"wiTHinc technical support at: ",
			"<a href=\"mailto:$TechSupport\">$TechSupport</a>.<p>\n";
		}
	} else {
		print $errmsg, "<p>\n";
	}
	
	print "<p><a href=javascript:history.go(-1)>[Back]</a>\n";
	
	exit();
}

sub makeapacheauth {
	local($newclass, $hta, $htg, $htp) = @_;
	local($i);
	open (hf, "newclass/htaccess");
	@hfd = <hf>;
	close (hf);
	
	$panForaURL = &lookuppanForaURL;
	
	for ($i=0; $i < @hfd; $i++) {
		@hfd[$i] =~ s/GROUPS_FILE/$C_rootpath\/$htg/;
		@hfd[$i] =~ s/CLASS_TITLE/$C_title/;
		@hfd[$i] =~ s/PASSWD_FILE/$C_rootpath\/$htp/;
		@hfd[$i] =~ s/CLASS_ID/$newclass/;
		@hfd[$i] =~ s/SELF_ADD_SCRIPT/$panForaURL\/$CGI_ForumUserAddSelf/;
	}
		
	open (hf, ">$C_rootpath/$hta");
	print hf @hfd;
	close (hf);
}

sub pwd {
	use Cwd;
	return(cwd);
}

# This is not good.
sub oldpwd {
	local($di,$dd,$pi,$pd,@getpwd,@tmppwd,$p,$pw);
	
	if ($ENV{'SCRIPT_FILENAME'} ne "") {
		@tmppwd = split(/\//, $ENV{'SCRIPT_FILENAME'});
		for ($p=0; $p < @tmppwd; $p++) {
			if (@tmppwd[$p] ne "") {
				push(@getpwd, @tmppwd[$p]);
			}
		}
		$pw = "";
		for ($p=0; $p < @getpwd - 1; $p++) {
			if ($p == 0 && $isWin && @getpwd[$p] =~ /^\w\:/) {
				$pw = @getpwd[$p];
				next;
			} else {
				$pw .= "/" . @getpwd[$p];
			}
		}
		return($pw);
	}

	if ($ENV{'PWD'}) {
		local($dd,$di) = stat('.');
		local($pd,$pi) = stat($ENV{'PWD'});
		if ($di == $pi && $dd == $pd) {
			return ($ENV{'PWD'});
		}
	}
	
	chop($ENV{'PWD'} = `pwd`);
	return ($ENV{'PWD'});
}
