#!/usr/bin/perl

###############################################################################
#
# _AClassEdit.cgi - Modify an existing class
#
# AUTHOR:	Shawn Stepper, wiTHinc Inc.
# AUTHOR:	George Toye, wiTHinc Inc.
# DATE:		$Date: 2001/09/10 22:01:44 $ (last modified)
# COPYRIGHT:	1998, 1999, 2000, 2001 wiTHinc Inc. All Rights Reserved.
#
###############################################################################

$FileRevision = '$Id: _AClassEdit.cgi,v 1.71.2.3 2001/09/10 22:01:44 stepper Exp $';
$Version = '1.4.0';

if (@ARGV[0] eq "-v" || @ARGV[0] eq "--version") {
	print "File:		$0\n";
	print "Revision:	$FileRevision\n";
	print "Version:	$Version\n";
	exit();
}

require "F_Init.pl";
require "NewClass_Init.pl";
require "U_Init.pl";

$adminpass = $CGIQuery->cookie('panForaAdmin');
$forumadmin = &checkAdminPass($adminpass);

$Class = $CGIQuery->param('fid');

&lookupClass;
&lookupUser($CGIEnvUser);

# Load up color variables
&loadColors($ColorQueryString);

if (!$forumadmin) {
	&checkCookieGuest($CGIEnvUser, $C_authtype);
}

# Kick the user out if they have the wrong permissions
if (!&IS_ADMIN($U_Perms) && !$forumadmin) {
	&showErrorBackHTML("You do not have permission to access this resource, or have not logged on properly.", 0);
	exit();
}

$what = $CGIQuery->param('what');
$func = $CGIQuery->param('func');
$show = $CGIQuery->param('show');
$start = $CGIQuery->param('start');

if ($show eq "nothing") {
	$func = "nothing";
}

$nexturl = escape(&buildNextURL);

if ($func eq "menu") {
	$BodyTag = &makeBodyTag("Threads");
} else {
	$BodyTag = &makeBodyTag("Content");
}

###############################################################################
#
# Process submitted data

if ($func eq "domod") {
	if ($Demo) {
		print $CGIQuery->redirect("Demo.html");
		exit();
	}
	&doclassmod;
	exit();
} elsif ($func eq "dodisplay") {
	if ($Demo) {
		print $CGIQuery->redirect("Demo.html");
		exit();
	}
	&dodisplaymod;
	exit();
} elsif ($func eq "dosections") {
	if ($Demo) {
		print $CGIQuery->redirect("Demo.html");
		exit();
	}
	&dosectedits;
	exit();
} elsif ($func eq "dofac") {
	if ($Demo) {
		print $CGIQuery->redirect("Demo.html");
		exit();
	}
	&dofacedits;
	exit();
} elsif ($func eq "donotif") {
	if ($Demo) {
		print $CGIQuery->redirect("Demo.html");
		exit();
	}
	&donotifedits;
	exit();
} elsif ($func eq "addusers") {
	print $CGIQuery->redirect(-URL=>"$CGI_ForumEditUserSingle?fid=$Class&usertype=faculty&start=$start&func=menu");
	exit();
} elsif ($func eq "menu") {
	# Show upper frame

	if ($forumadmin) {
		$cookie = $CGIQuery->cookie(-name=>'panForaAdmin',
								-value=>"$cryptAdminPass",
								-path=>'/');
	} else {
		$cookie = "";
	}
	
	$helplink = "file=ConfigureCORP_Admin.html";
	$helplink .= "&anchor=ForumConfigTskFSummary";
	$helplink .= "&helptitle=Edit%20Forum%20Configuration";

	# Start html output
	&showHeaderBackHTML("Edit $CorF - $Class", "", 0, 1, 0, $helplink, $cookie);
	
	# Some javascript to check the radio buttons.
	print "<script language=javascript>\n<!--\n";
	print "function selStep(whichone) {\n";
	print "	for (var i=0; i < document.forms[0].func.length; i++) {\n";
	print "		if (document.forms[0].func[i].value == whichone) {\n";
	print "			document.forms[0].func[i].checked = true;\n";
	print "		}\n";
	print "	}\n";
	print "}\n";
	print "// -->\n</script>\n\n";
	
	# Start form table
	print "<form action=$CGIEnvScript method=POST target=classedit>\n";
	
	print "For new forums, complete all steps sequentially.<br>\n";
	
	print "<table border=0 cellpadding=0 cellspacing=0>\n";
	print "<tr>";
	print "<td valign=top>",$FontFace, $FontSize;
	print "1. <input type=radio name=func value=general checked ";
	print "onclick=this.form.submit()> ";
	print "General $CorF Parameters<br>\n";
	
	print "2. <input type=radio name=func value=display ";
	print "onclick=this.form.submit()> ";
	print "Look and Feel<br>\n";
	
	print "3. <input type=radio name=func value=addusers ";
	print "onclick=this.form.submit()> ";
	print "Add $ForMs<br>\n";

	print "4. <input type=radio name=func value=sections ";
	print "onclick=this.form.submit()> ";
	print "$CorF $SorGs<br>\n";
	
	print "5. <input type=radio name=func value=notif ";
	print "onclick=this.form.submit()> ";
	print "Email Notification List<br>\n";
	
	print "</td>\n";
	
	#Spacer
	print "<td valign=top>",$FontFace, $FontSize;
	print $ImgIndent;
	print "</td>\n";
	
	print "</tr>\n";
	
	print "</table>\n\n";

	print "<input type=hidden name=fid value=$Class>\n";
	print "</form>\n\n";

} elsif ($func eq "display") {
	$helplink = "file=ConfigureLookCORP_Admin.html";
	$helplink .= "&anchor=ForumLookFeelEdtFSummary";
	$helplink .= "&helptitle=Edit%20Look%20and%20Feel";

	&showHeaderBackHTML("Editing Look and Feel for $CorF - $Class",
		"<br>", 0, 0, 0, $helplink);
	
	&printPreview;
	
	print "<form action=$CGIEnvScript method=POST>\n";
	print "<input type=hidden name=func value=dodisplay>\n";
	print "<input type=hidden name=fid value=$Class>\n";
	print "<input type=hidden name=start value=$start>\n";
	
	print "<table border=0 cellpadding=0 cellspacing=0 width=100%>\n";
	print "<tr><td valign=top>";
	
	print "<table cellpadding=0 cellspacing=0 border=0 width=100%>\n";
	
	# Title bar
	print "<tr><td width=100% bgcolor=$FTheaderback>";
	print "<img src=$ImgSrcClearDot width=20 height=2>";
	print "</td></tr>\n";
	print "<tr><td width=100%>";
	print $FontFace, $FontSize, "<b>Forum Display</b><br><br></td></tr>\n";
	
	# Start framed or frameless
	print "<tr><td valign=bottom>",$FontFace, $FontSize;
	print "Default View for New Users&nbsp;";
	print "</td></tr>\n";	
	print "<tr><td valign=top>",$FontFace, $FontSize;
	print "<input type=radio name='C_DefaultLayout' value='0'";
	if ($C_DefaultLayout == 0 || $C_DefaultLayout eq "") { print " checked"; }
	print "> Frames&nbsp;";
	print "<input type=radio name='C_DefaultLayout' value='1'";
	if ($C_DefaultLayout != 0 && $C_DefaultLayout ne "") { print " checked"; }
	print "> No Frames&nbsp;";
	print "</td></tr>\n";
	
	# Show Photos
	print "<tr><td valign=bottom>",$FontFace, $FontSize;
	print "Show user photos in Forum Display?&nbsp;";
	print "</td></tr>\n";	
	print "<tr><td valign=top>",$FontFace, $FontSize;
	print "<input type=radio name='C_ShowPhoto' value='1'";
	if ($C_ShowPhoto == 1 || $C_ShowPhoto eq "") { print " checked"; }
	print "> Yes&nbsp;";
	print "<input type=radio name='C_ShowPhoto' value='0'";
	if ($C_ShowPhoto != 1 && $C_ShowPhoto ne "") { print " checked"; }
	print "> No&nbsp;";
	print "</td></tr>\n";
	
	# Show Stats
	print "<tr><td valign=bottom>",$FontFace, $FontSize;
	print "Show Posting Statistics to Users after Posting and in User Profile?&nbsp;";
	print "</td></tr>\n";	
	print "<tr><td valign=top>",$FontFace, $FontSize;
	print "<input type=radio name='C_ShowStats' value='1'";
	if ($C_ShowStats == 1 || $C_ShowStats eq "") { print " checked"; }
	print "> Yes&nbsp;";
	print "<input type=radio name='C_ShowStats' value='0'";
	if ($C_ShowStats != 1 && $C_ShowStats ne "") { print " checked"; }
	print "> No&nbsp;";
	print "</td></tr>\n";
	
	# Show User Profile
	print "<tr><td valign=bottom>",$FontFace, $FontSize;
	print "Show User Profiles?&nbsp;";
	print "</td></tr>\n";	
	print "<tr><td valign=top>",$FontFace, $FontSize;
	print "<input type=radio name='C_UserProfile' value='1'";
	if ($C_UserProfile == 1 || $C_UserProfile eq "") { print " checked"; }
	print "> Yes&nbsp;";
	print "<input type=radio name='C_UserProfile' value='0'";
	if ($C_UserProfile != 1 && $C_UserProfile ne "") { print " checked"; }
	print "> No&nbsp;";
	print "</td></tr>\n";
	
	# Color Scheme
	# Start third row
	print "<tr><td>";
	print "<table cellpadding=0 cellspacing=0 border=0>\n";
	print "<tr><td valign=bottom>",$FontFace, $FontSize;
	print "Color Scheme&nbsp;";
	print "</td>\n</tr>\n";

	print "<tr><td valign=top>",$FontFace, $FontSize;
	print "<select name=scheme>\n";
	$getsch = new CGI($ColorQueryString);
	$ColorScheme = $getsch->param('scheme');
	local (%cschemes) = &lookupColorSchemes;
	@snames = sort(@allschemenames);
	for ($i=0; $i < @snames; $i++) {
		$name = @snames[$i];
		$num = $cschemes{"$name"};
		print "<option value=", $num;
		if ($ColorScheme == $num) {
			print " selected";
		}
		print "> ", $name, "\n";
	}
	print "</select>\n";
	print "<a href=javascript:Preview()> $BtnFormPreview</a>";
	print "</td>\n</tr>\n";
	print "</table>\n";
	
	print "</td></tr>\n";
	
	# Spacer
	print "<tr><td width=100%>";
	print "<img src=$ImgSrcClearDot width=20 height=8>";
	print "</td></tr>\n";
	
	print "</table>\n";
	
	print "</td>\n";
	print "<td valign=top>", $ImgClear88, "</td>\n";
	print "<td valign=top>";
	
	# Pagination
	print "<table border=0 cellpadding=0 cellspacing=0 width=100%>";
	print "<tr><td bgcolor=$FTheaderback>";
	print "<img src=$ImgSrcClearDot width=20 height=2>";
	print "</td></tr>\n";
	
	print "<tr><td>";
	print $FontFace, $FontSize, "<b>Pagination Defaults</b><br><br>";
	print "</td></tr>\n";
	
	# Topics
	print "<tr><td>", $FontFace, $FontSize;
	print "<b>Topics Frame:</b><br>";
	print $ImgClear88, "Expert - Top level topics per page ";
	print "<select name=C_TopicsPage>\n";
	&printPagOptions($C_TopicsPage);
	print "</select><br>\n";
	print $ImgClear88, "Novice - Minimum topics per page ";
	print "<select name=C_TopicsPageNov>\n";
	&printPagOptions($C_TopicsPageNov);
	print "</select><br>\n";	
	print "</td></tr>\n";
	
	# Threads
	print "<tr><td>", $FontFace, $FontSize;
	print "<b>Threads Frame:</b><br>";
	print $ImgClear88, "Expert - Complete threads per page ";
	print "<select name=C_ThreadsPage>\n";
	&printPagOptions($C_ThreadsPage);
	print "</select><br>\n";
	print $ImgClear88, "Novice - Minimum messages per page ";
	print "<select name=C_ThreadsPageNov>\n";
	&printPagOptions($C_ThreadsPageNov);
	print "</select><br>\n";	
	print "</td></tr>\n";
	
	# Content
	print "<tr><td valign=top>", $FontFace, $FontSize;
	print "<b>Content Frame:</b><br>";
	print $ImgClear88, "Messages per page ";
	print "<select name=C_ContentPage>\n";
	&printPagOptions($C_ContentPage);
	print "</select><br>\n";
	#print "Auto-Pagination limit";
	#print "<select name=C_ContentPageAuto>\n";
	#&printPagOptions($C_ContentPageAuto);
	#print "</select><br>\n";	
	print "</td></tr>\n";
	
	# New / 2me
	print "<tr><td>", $FontFace, $FontSize;
	print "<b>New / 2me View:</b><br>";
	print $ImgClear88, "Messages per page ";
	print "<select name=C_NewPage>\n";
	&printPagOptions($C_NewPage);
	print "</select><br>\n";
	print "</td></tr>\n";
	
	# Authors
	print "<tr><td>", $FontFace, $FontSize;
	print "<b>Authors View:</b><br>";
	print $ImgClear88, "Authors per page ";
	print "<select name=C_AuthorsPage>\n";
	&printPagOptions($C_AuthorsPage);
	print "</select><br>\n";
	print "</td></tr>\n";
	print "</table>\n";
	
	print "</td></tr>\n";
	
	# Spacer
	print "<tr><td colspan=3>";
	print "<img src=$ImgSrcClearDot width=20 height=8>";
	print "</td></tr>\n";
	
	# Submission row
	print "<tr><td bgcolor=$FTheaderback colspan=3>";
	print "<img src=$ImgSrcClearDot width=20 height=2>";
	print "</td></tr>\n";
	
	print "<tr><td valign=bottom colspan=3>",$FontFace, $FontSize;
	if ($Demo) {
		print $BtnFormSubmitDemo;
	} else {
		print $BtnFormSubmit;
	}
	print "</td></tr>\n";
	
	print "</table>";
	
	print "</form>\n";
	print "</body></html>\n";

} elsif ($func eq "sections") {
	# Start html output
	$helplink = "file=ConfigureAddGroupsCORP_Admin.html";
	$helplink .= "&anchor=ForumAddGroupsEdtFSummary";
	$helplink .= "&helptitle=Add%20and%20Edit%20Groups";
	
	&showHeaderBackHTML("Editing $SorGs for $CorF - $Class",
		"", 0, 0, 0, $helplink);
	
	print "<form action=$CGIEnvScript method=POST>\n";
	print "<input type=hidden name=fid value=$Class>\n";
	print "<input type=hidden name=func value=dosections>\n";
	print "<input type=hidden name=start value=$start>\n";
	
	print "<table border=0 cellpadding=0 cellspacing=2>\n";
	print "<tr>";
	print "<td>",$FontFace, $FontSize, "Delete&nbsp;&nbsp;</td>\n";
	print "<td>",$FontFace, $FontSize, $FontRed, "$SorG Name&nbsp;</td>\n";
	if ($Edu) {
		print "<td>",$FontFace, $FontSize, $FontRed, "$SorG Leader&nbsp;</td>\n";
	} else {
		print "<td>",$FontFace, $FontSize, $FontRed, "Lead $ForM &nbsp;</td>\n";
	}
	# print "<td>",$FontFace, $FontSize, "$SorG Time</td>\n";
	# print "<td>",$FontFace, $FontSize, "$SorG Location</td>\n";
	print "</tr>\n";
	
	# @fac = &lookupFacAdminList;
	@fac = &lookupFacList;
	
	$loop = $C_Sect_n + 4;
	if ($loop < 5) { $loop = 5; }
	for ($i=1; $i <= $loop; $i++) {
		print "<tr>";
		
		# Deletion thingy
		print "<td>",$FontFace, $FontSize;
		if ($i == 1) {
			print "&nbsp;";
		} else {
			print "<input type=checkbox name=C_Sect_", $i, ":del value=YES>";
		}
		print "</td>\n";
		
		# Section Name
		print "<td>",$FontFace, $FontSize;
		print "<input type=text name=C_Sect_", $i, ":name size=16 value=";
		print "\"", $C_Sects{$i}{"name"}, "\">&nbsp;";
		print "</td>\n";
		
		# Section Leader
		print "<td>",$FontFace, $FontSize;
		print "<select name=C_Sect_", $i,":fac>\n";
		print "<option value=\"(NULL)\"";
		if ($C_Sects{$i}{"fac"} eq "") {
			print " selected";
		}
		print "> -Click to Select-\n";
		for ($j=0; $j < @fac; $j++) {
			$id = @fac[$j];
			$id =~ s/.*\(//;
			chop($id);
			print "<option value=\"", $id, "\"";
			if ($id eq $C_Sects{$i}{"fac"}) {
				print " selected";
			}
			print "> ", @fac[$j], "\n";
		}
		print "</select>&nbsp;";
		print "</td>\n";
		
		# Section Time
		#print "<td>",$FontFace, $FontSize;
		#print "<input type=text name=C_Sect_", $i, ":time size=20 value=";
		#print "\"", $C_Sects{$i}{"time"}, "\">&nbsp;";
		#print "</td>\n";
		
		# Section Location
		#print "<td>",$FontFace, $FontSize;
		#print "<input type=text name=C_Sect_", $i, ":location size=20 value=";
		#print "\"", $C_Sects{$i}{"location"}, "\">&nbsp;";
		#print "</td>\n";
		
		print "</tr>\n";
	}
	
	print "</table>\n";
	
	print "<input type=hidden name=numsects value=$loop>\n";
	
	print "<table border=0 cellpadding=0 cellspacing=0>\n";
	
	print "<tr><td colspan=3>", $FontFace, $FontSize, $FontRed;
	print "Note:</font> To add more $sorgs, fill the empty $sorgs and click submit.\n";
	print "You will then be given more empty $sorgs to fill.<br>\n&nbsp;";
	print "</td></tr>\n";
	
	print "<tr><td colspan=3 bgcolor=$FTheaderback>";
	print "<img src=$ImgSrcClearDot width=20 height=2>";
	print "</td></tr>\n";
		
	print "</table>\n";
	if ($Demo) {
		print $BtnFormSubmitDemo;
	} else {
		print $BtnFormSubmit;
	}
	print "</form>\n";

	print "</body></html>";
	
} elsif ($func eq "notif") {
	# Modify Notification List
	$helplink = "file=ConfigureEmailNotificationCORP_Admin.html";
	$helplink .= "&anchor=ForumEmailNotificationEdtFSummary";
	$helplink .= "&helptitle=Edit%20Email%20Notification%20List";
	
	&showHeaderBackHTML("Editing Notification List for $CorF - $Class",
		"", 0, 0, 0, $helplink);
	
	print "<form action=$CGIEnvScript method=POST>\n";
	print "<input type=hidden name=fid value=$Class>\n";
	print "<input type=hidden name=func value=donotif>\n";
	print "<input type=hidden name=start value=$start>\n";
	
	print "<table border=0 cellpadding=0 cellspacing=2>\n";
	print "<tr>";
	print "<td>",$FontFace, $FontSize, "&nbsp;</td>\n";
	print "<td>",$FontFace, $FontSize, $FontRed, "&nbsp;</td>\n";
	print "<td colspan=7>",$FontFace, $FontSize, "Recipients&nbsp;</td>\n";
	print "</tr>\n";
	
	print "<tr>";
	print "<td nowrap>",$FontFace, $FontSize, "Delete&nbsp;</td>\n";
	print "<td nowrap>",$FontFace, $FontSize, $FontRed, "Label *&nbsp;</td>\n";
	# Recipients
	print "<td nowrap>",$FontFace, $FontSize, "Self&nbsp;</td>\n";
	print "<td nowrap>",$FontFace, $FontSize, "Replyee&nbsp;</td>\n";
	#if ($Edu) {
	#	print "<td nowrap>",$FontFace, $FontSize, "$SorG Leader&nbsp;</td>\n";
	#} else {
		print "<td nowrap>",$FontFace, $FontSize, "$SorG Lead $ForM &nbsp;</td>\n";
	#}
	print "<td nowrap>",$FontFace, $FontSize, "My $SorG &nbsp;</td>\n";
	print "<td nowrap>",$FontFace, $FontSize, "All $ForMs &nbsp;</td>\n";
	print "<td nowrap>",$FontFace, $FontSize, "Entire $CorF &nbsp;</td>\n";
	print "<td nowrap>",$FontFace, $FontSize, "Others (comma delimited email addresses)&nbsp;</td>\n";
	print "</tr>\n";
	
	open(f, "$C_rootpath/$DIR_CONFIG/$FILE_FNOTIF");
	@notif = <f>;
	close(f);
	
	$loop = @notif +2;
	if ($loop < 5) { $loop = 5; }
	for ($i=1; $i <= $loop; $i++) {
		($label, $recip) = split(/\t/, @notif[$i]);
		
		$others = "";
		splice(@others,0);
		
		# Split off "Others"
		if ($recip =~ /\,/) {
			($recip, @others) = split(/\,/, $recip);
			$others = join(",", @others);
		}
	
		print "<tr>";
		
		# Deletion thingy
		print "<td>",$FontFace, $FontSize;
		print "<input type=checkbox name=Notif_", $i, ":del value=YES>";
		print "</td>\n";
		
		# Label
		print "<td>",$FontFace, $FontSize;
		print "<input type=text name=Notif_", $i, ":name size=20 value=";
		print "\"", $label, "\">&nbsp;";
		print "</td>\n";
		
		# Checkboxes
		
		# Self
		print "<td align=center>",$FontFace, $FontSize;
		print "<input type=checkbox name=Notif_", $i, ":U value=YES";
		if ($recip =~ /U/) {print " checked";}
		print "></td>\n";
		
		# Replyee
		print "<td align=center>",$FontFace, $FontSize;
		print "<input type=checkbox name=Notif_", $i, ":R value=YES";
		if ($recip =~ /R/) {print " checked";}
		print "></td>\n";
		
		# Section Leader
		print "<td align=center>",$FontFace, $FontSize;
		print "<input type=checkbox name=Notif_", $i, ":L value=YES";
		if ($recip =~ /L/) {print " checked";}
		print "></td>\n";
		
		# Section
		print "<td align=center>",$FontFace, $FontSize;
		print "<input type=checkbox name=Notif_", $i, ":S value=YES";
		if ($recip =~ /S/) {print " checked";}
		print "></td>\n";
		
		# Faculty
		print "<td align=center>",$FontFace, $FontSize;
		print "<input type=checkbox name=Notif_", $i, ":F value=YES";
		if ($recip =~ /F/) {print " checked";}
		print "></td>\n";
		
		# Class
		print "<td align=center>",$FontFace, $FontSize;
		print "<input type=checkbox name=Notif_", $i, ":A value=YES";
		if ($recip =~ /A/) {print " checked";}
		print "></td>\n";
		
		# Others
		print "<td>",$FontFace, $FontSize;
		print "<input type=text name=Notif_", $i, ":Others value=\"$others";
		print "\" size=20>";
		print "</td>\n";
		
		print "</tr>\n\n";
	}
	
	print "<input type=hidden name=numnotif value=$loop>\n";
	
	print "<tr><td rowspan=3 valign=top>", $FontFace, $FontSize;
	print $FontRed, "* Note:</font></td>\n";
	print "<td colspan=8>",$FontFace, $FontSize;
	print "\@N in the label will be replaced by ";
	print "the name and userid of the replyee.</td></tr>\n";
	print "<tr><td colspan=8>", $FontFace, $FontSize;
	print "\@L in the label will be replaced by the userid of the Lead $ForM ";
	print "for the user's $SorG.</td></tr>\n";
	print "<tr><td colspan=8>", $FontFace, $FontSize;
	print "\@S in the label will be replaced by the name of the user's $SorG.";
	print "</td></tr>\n";
	
	#print "<tr><td colspan=9>";
	#print "<table border=0 cellpadding=0 cellspacing=0 width=100%>\n";
	print "<tr><td colspan=9 bgcolor=$FTheaderback>";
	print "<img src=$ImgSrcClearDot width=20 height=2>";
	print "</td></tr>\n";
	#print "</table>\n";
	#print "</td></tr>\n";
	
	print "</table>\n";
	
	if ($Demo) {
		print $BtnFormSubmitDemo;
	} else {
		print $BtnFormSubmit;
	}
	print "<p>\n";

	print "</form>\n";

	print "</body></html>";

} elsif ($func eq "general") {
	# print out general class editing page.
	
	# Does the chosen class ID already exist?
	if (!&lookupClass($Class)) {
		&showErrorBackHTML("There was an error getting the $corf data. Please check that the $corf was initialized properly by the $corf administrator.",0);
		exit();
	}
	
	if ($forumadmin) {
		$cookie = $CGIQuery->cookie(-name=>'panForaAdmin',
								-value=>"$cryptAdminPass",
								-path=>'/');
	} else {
		$cookie = "";
	}
	
	$helplink = "file=ConfigureGeneralCORP_Admin.html";
	$helplink .= "&anchor=ForumGeneralConfigEdtFSummary";
	$helplink .= "&helptitle=Edit%20Forum%20General%20Parameters";
	
	&showHeaderBackHTML("Editing $CorF - $Class", "",
										0, 0, 0, $helplink, $cookie);
	
	&printclassinput;

} else {
	# Print a Frameset
	
	if ($start ne "") {
		print $CGIQuery->redirect("$CGIEnvScript?fid=$Class&func=$start&start=$start");
		exit();
	}
	
	if ($CGIQuery->param('AdminLogout') eq "1") {
		$cookie = $CGIQuery->cookie(-name=>'panForaAdmin',
									-value=>"",
									-expires=>'-1s',
									-path=>'/');
		
		if ($C_authtype =~ /cookie/i && ($CGIEnvUser eq "Guest" || !&IS_ADMIN($U_Perms))) {
			local($redir) = $CGI_ForumCookieLogin . "?fid=" . $Class;
			$redir .= "&nexturl=" . escape($ENV{'SCRIPT_NAME'} . "?" . $ENV{'QUERY_STRING'});
			print $CGIQuery->redirect(-location=>$redir, -cookie=>$cookie);
		} else {
			# print $CGIQuery->header(-cookie=>$cookie, -expires=>'-1d');
			print $CGIQuery->header(-cookie=>$cookie);
		}
	} elsif ($forumadmin) {
		$cookie = $CGIQuery->cookie(-name=>'panForaAdmin',
								-value=>"$cryptAdminPass",
								-path=>'/');
		print $CGIQuery->header(-cookie=>$cookie);
	} else {
		# print $CGIQuery->header(-expires=>'-1d');
		print $CGIQuery->header;
	}
	
	print "<html><head><title>$Class Forum Editing</title>\n";
	&printJavascript();
	print "</head>\n";
	print "<frameset rows='160,*' border=2>\n";
	print "	<frame name=classmenu src=$CGIEnvScript?fid=$Class&func=menu ";
	print "frameborder=1 marginheight=0 marginwidth=0>\n";
	print "	<frame name=classedit src=\"";
	if ($start ne "") {
		print "$CGIEnvScript?fid=$Class&func=$start";
	} else {
		print "$CGIEnvScript?fid=$Class&func=general";
	}
	print "\" frameborder=1 marginheight=0 marginwidth=0>\n";
	print "</frameset>\n";
}

#
########

sub printclassinput {
	
	# number of columns, for colspans
	$cols = 3;
	
	# Encryption Warning
	print "<script language=javascript>\n";
	print "<!--\n";
	print "function warnEncrypt() {\n";
	print "	if (document.forms[0].C_EncryptUserPass.checked) {\n";
	print "		var conf = confirm('WARNING! Once you turn on encryption and click\\n";
	print "the submit button, you can not switch back!\\n";
	print "View the Help File for details.\\n\\n";
	print "Are you sure you want to encrypt user passwords?');\n";
	print "		document.forms[0].C_EncryptUserPass.checked = conf;\n";
	print "	}\n";
	print "}\n";
	print "// -->\n";
	print "</script>\n\n";
	
	print "<form action=$CGIEnvScript method=POST>\n";
	print "<input type=hidden name=func value=domod>\n";
	print "<input type=hidden name=fid value=$Class>\n";
	print "<input type=hidden name=start value=$start>\n";
	
	print "<table cellpadding=0 cellspacing=0 border=0 width=100%>\n";
	print "<tr><td valign=top>\n";
	
	print "<table cellpadding=0 cellspacing=0 border=0 width=100%>\n";
	
	# Title bar
	print "<tr><td width=100% bgcolor=$FTheaderback colspan=$cols>";
	print "<img src=$ImgSrcClearDot width=20 height=2>";
	print "</td></tr>\n\n";
	print "<tr><td width=100% colspan=$cols>";
	print $FontFace, $FontSize, "<b>Naming";
	# if ($forumadmin) {
		print " / Directories";
	# }
	print " / Administrator";
	print "</b><br><br></td></tr>\n\n";
	
	# Start first row
	print "<tr><td colspan=$cols>";
	# First row of headings
	print "<table cellpadding=0 cellspacing=0 border=0 width=100%>\n";
	print "<tr>";
	#print "<td valign=bottom>",$FontFace, $FontSize;
	#print $FontRed, "Class Name&nbsp;";
	#print "</td>\n";
	print "<td valign=bottom colspan=$cols>",$FontFace, $FontSize;
	print $FontRed, "$CorF Title&nbsp;";
	print "</td>\n</tr>\n\n";
	
	# First row of input fields
	print "<tr>";
	print "<td valign=top colspan=$cols>",$FontFace, $FontSize;
	print "<input type=text name=C_title value=\"$C_title\" size=24>&nbsp;";
	print "</td>\n";
	#print "<td valign=top>",$FontFace, $FontSize;
	#print "<input type=text name=C_name value=\"$C_name\" size=24>&nbsp;";
	#print "</td>\n";
	print "</tr>\n\n";
	print "</table>\n";
	
	print "</td></tr>\n\n";
	# End first Row

	# If the user is logged in as forumadmin also, show the
	# directory/path fields also.

	$padding = 2;
	$spacing = 2;
	if ($forumadmin) {
		$padding = 0;
		$spacing = 0;
	}

	print "<tr><td colspan=$cols>";
	# row of headings
	print "<table cellpadding=$padding cellspacing=$spacing border=0 width=100%>\n";
	print "<tr><td valign=bottom>",$FontFace, $FontSize;
	if (!$forumadmin) {
		print $FontRed, " * </font>";
	}
	print $FontRed, "$CorF Directory (absolute)&nbsp;";
	print "</td>\n<td valign=bottom>",$FontFace, $FontSize;
	if (!$forumadmin) {
		print $FontRed, " * </font>";
	}
	print $FontRed, "Top Level URL (absolute)&nbsp;";
	print "</td>\n</tr>\n\n";
	
	# row of input fields
	print "<tr><td valign=top>",$FontFace, $FontSize;
	if ($forumadmin) {
		print "<input type=text name=rootpath value=\"$C_rootpath\" size=24>&nbsp;";
	} else {
		print $C_rootpath, "&nbsp;";
	}
	print "</td>\n<td valign=top>",$FontFace, $FontSize;
	if ($forumadmin) {
		print "<input type=text name=rooturl value=\"$C_rooturl\" size=24>&nbsp;";
	} else {
		print $C_rooturl, "&nbsp;";
	}
	print "</td>\n</tr>\n\n";
	print "</table>\n";
	print "</td></tr>\n\n";
		
	print "<tr><td colspan=$cols>";
	# row of headings
	print "<table cellpadding=$padding cellspacing=$spacing border=0 width=100%>\n";
	print "<tr><td valign=bottom width=50%>",$FontFace, $FontSize;
	if (!$forumadmin) {
		print $FontRed, " * </font>";
	}
	print $FontRed, "Photo Directory (absolute)&nbsp;";
	print "</td>\n<td valign=bottom width=50%>",$FontFace, $FontSize;
	if (!$forumadmin) {
		print $FontRed, " * </font>";
	}
	print $FontRed, "Photo URL (absolute)&nbsp;";
	print "</td>\n</tr>\n\n";
	
	# row of input fields
	print "<tr><td valign=top width=50%>",$FontFace, $FontSize;
	if ($forumadmin) {
		print "<input type=text name=C_photodir value=\"$C_photodir\" size=24>&nbsp;";
	} else {
		print $C_photodir, "&nbsp;";
	}
	print "</td>\n<td valign=top width=50%>",$FontFace, $FontSize;
	if ($forumadmin) {
		print "<input type=text name=C_photourl value=\"$C_photourl\" size=24>&nbsp;";
	} else {
		print $C_photourl, "&nbsp;";
	}
	print "</td>\n</tr>\n\n";
	print "</table>\n";
	print "</td></tr>\n\n";
		
	print "<tr><td colspan=$cols>";
	# row of headings
	print "<table cellpadding=$padding cellspacing=$spacing border=0>\n";
	print "<tr><td valign=bottom>",$FontFace, $FontSize;
	if (!$forumadmin) {
		print $FontRed, " * </font>";
	}
	print $FontRed, "Mailing List Directory (absolute)&nbsp;";
	print "</td>\n</tr>\n\n";
	
	# row of input fields
	print "<tr><td valign=top>",$FontFace, $FontSize;
	if ($forumadmin) {
		print "<input type=text name=C_listdir value=\"$C_listdir\" size=36>&nbsp;";
	} else {
		print $C_listdir, "<br>&nbsp;";
	}
	print "</td>\n</tr>\n\n";
	print "</table>\n\n";
	
	# Note for non-forumadmin
	if (!$forumadmin) {
		print $FontFace, $FontSize;
		print $FontRed, "*</font> You must ";
		print "<a href=# onClick=parent.openwin('_AClassCreate.cgi?what=login&newwin=true&fid=Free',350,350,'SUWin')>";
		print "log in as the ";
		print "<b>panFora System Administrator</b></a><br>\n ";
		print "to edit the Directories and URLs above.<br>&nbsp;";
	}
	
	print "</td></tr>\n\n";

	
	# Primary Administrator
	print "<tr><td valign=bottom colspan=$cols>",$FontFace, $FontSize;
	print "Primary Administrator&nbsp;";
	print "</td></tr>\n\n";
	print "<tr><td valign=bottom colspan=$cols>",$FontFace, $FontSize;
	@admin = &lookupAdminList;
	print "<select name=C_FirstAdmin>\n";
	for ($j=0; $j < @admin; $j++) {
		$id = @admin[$j];
		$id =~ s/.*\(//;
		chop($id);
		print "<option value=\"", $id, "\"";
		if ($id eq $C_FirstAdmin) {
			print " selected";
		}
		print "> ", @admin[$j], "\n";
	}
	print "</select>&nbsp;";
	print "</td></tr>\n\n";	
	
	# Spacer
	print "<tr><td width=100% colspan=$cols>";
	print "<img src=$ImgSrcClearDot width=20 height=8>";
	print "</td></tr>\n\n";
	
	# Title bar
	print "<tr><td width=100% bgcolor=$FTheaderback colspan=$cols>";
	print "<img src=$ImgSrcClearDot width=20 height=2>";
	print "</td></tr>\n\n";
	print "<tr><td width=100% colspan=$cols>";
	print $FontFace, $FontSize, "<b>Access and Security</b><br><br></td></tr>\n\n";
	
	# Start second row
	# print "<tr><td valign=top>";
	
	# Auth type
	print "<tr><td valign=bottom colspan=$cols>",$FontFace, $FontSize;
	print "User Authentication Method&nbsp;";
	print "</td></tr>\n\n";	
	print "<tr><td valign=top colspan=$cols>",$FontFace, $FontSize;
	print "<select name=C_authtype>\n";
	print "<option value=cookies> Cookies\n";
	if ($ENV{'SERVER_SOFTWARE'} !~ /Microsoft-IIS/) {
		print "<option value=apache";
		if ($C_authtype eq "apache") {
			print " selected";
		}
		print "> Apache/NCSA (Basic)\n";

		if ($ENV{'SERVER_NAME'} =~ /stanford.edu/i || $ENV{'HTTP_HOST'} =~ /stanford.edu/i) {
			print "<option value=webauth";
			if ($C_authtype eq "webauth") {
				print " selected";
			}
			print "> Stanford University WebAuth\n";
			print "<option value=\"webauth and apache\"";
			if ($C_authtype eq "webauth and apache") {
				print " selected";
			}
			print "> SU WebAuth and Apache Backdoor\n";
		}
	}
	
	#print "<option value=external";
	#if ($C_authtype eq "external") {
	#	print " selected";
	#}
	#print "> External\n";
	print "</select>\n";
	print "</td></tr>\n\n";
	
	# Allow guest Access
	print "<tr><td valign=bottom colspan=$cols>",$FontFace, $FontSize;
	print "Allow Guest Access?&nbsp;";
	print "</td></tr>\n\n";
	print "<tr><td valign=top colspan=$cols>",$FontFace, $FontSize;
	print "<input type=radio name=ForumAllowGuest value=1";
	if ($ForumAllowGuest == 1) { print " checked"; }
	print "> Yes";
	print "<input type=radio name=ForumAllowGuest value=0";
	if ($ForumAllowGuest != 1) { print " checked"; }
	print "> No&nbsp;";
	print "</td></tr>\n\n";
	
	# Allow Guest Reading of Content
	print "<tr><td valign=bottom>",$FontFace, $FontSize;
	print $ImgClear88;
	print $ImgClear88;
	print "</td>\n";
	print "<td valign=bottom colspan=", $cols - 1, ">",$FontFace, $FontSize;
	print "Allow Guests to Read Message Content?&nbsp;";
	print "</td></tr>\n\n";
	print "<tr><td valign=top>",$FontFace, $FontSize;
	print $ImgClear88;
	print $ImgClear88;
	print "</td>\n";
	print "<td valign=bottom colspan=", $cols - 1, ">",$FontFace, $FontSize;
	print "<input type=radio name=ForumReadGuest value=1";
	if ($ForumReadGuest == 1) { print " checked"; }
	print "> Yes";
	print "<input type=radio name=ForumReadGuest value=0";
	if ($ForumReadGuest != 1) { print " checked"; }
	print "> No&nbsp;";
	print "</td></tr>\n\n";

	# Allow Guest Posting
	print "<tr><td valign=bottom>",$FontFace, $FontSize;
	print $ImgClear88;
	print $ImgClear88;
	print "</td>\n";
	print "<td valign=bottom colspan=", $cols - 1, ">",$FontFace, $FontSize;
	print "Allow Guest Posting?&nbsp;";
	print "</td></tr>\n\n";
	print "<tr><td valign=top>",$FontFace, $FontSize;
	print $ImgClear88;
	print $ImgClear88;
	print "</td>\n";
	print "<td valign=bottom colspan=", $cols - 1, ">",$FontFace, $FontSize;
	print "<input type=radio name=ForumPostGuest value=1";
	if ($ForumPostGuest == 1) { print " checked"; }
	print "> Yes";
	print "<input type=radio name=ForumPostGuest value=0";
	if ($ForumPostGuest != 1) { print " checked"; }
	print "> No&nbsp;";
	print "</td></tr>\n\n";
	
	# Allow Guest to enter name/email
	print "<tr><td valign=bottom>",$FontFace, $FontSize;
	print $ImgClear88;
	print $ImgClear88;
	print "</td>\n";
	print "<td valign=bottom>",$FontFace, $FontSize;
	print $ImgClear88;
	print $ImgClear88;
	print "</td>\n";
	print "<td valign=bottom colspan=", $cols - 2, ">",$FontFace, $FontSize;
	print "Allow Guests to Choose a Name and Email Address for their Posts?&nbsp;";
	print "</td></tr>\n\n";
	print "<tr><td valign=top>",$FontFace, $FontSize;
	print $ImgClear88;
	print $ImgClear88;
	print "</td>\n";
	print "<td valign=bottom>",$FontFace, $FontSize;
	print $ImgClear88;
	print $ImgClear88;
	print "</td>\n";
	print "<td valign=bottom colspan=", $cols - 2, ">",$FontFace, $FontSize;
	print "<input type=radio name=C_GuestName value=1";
	if ($C_GuestName == 1) { print " checked"; }
	print "> Yes";
	print "<input type=radio name=C_GuestName value=0";
	if ($C_GuestName != 1) { print " checked"; }
	print "> No&nbsp;";
	print "</td></tr>\n\n";
	
	# Allow Anonymous
	print "<tr><td valign=bottom colspan=$cols>",$FontFace, $FontSize;
	print "Allow Anonymous Posting?&nbsp;";
	print "</td>\n</tr>\n\n";
	print "<tr><td valign=top colspan=$cols>",$FontFace, $FontSize;
	print "<input type=radio name=ForumPostAnon value=1";
	if ($ForumPostAnon == 1) { print " checked"; }
	print "> Yes";
	print "<input type=radio name=ForumPostAnon value=0";
	if ($ForumPostAnon != 1) { print " checked"; }
	print "> No&nbsp;";
	print "</td>\n</tr>\n\n";

	# Add self
	print "<tr><td valign=bottom colspan=$cols>",$FontFace, $FontSize;
	print "Allow Users to Add Themselves to the $CorF?&nbsp;";
	print "</td></tr>\n\n";	
	print "<tr><td valign=top colspan=$cols>",$FontFace, $FontSize;
	print "<input type=radio name=C_Public value=1";
	if ($C_Public == 1) { print " checked"; }
	print "> Yes";
	print "<input type=radio name=C_Public value=0";
	if ($C_Public != 1) { print " checked"; }
	print "> No&nbsp;";
	print "</td></tr>\n\n";
	
	# Encrypt User Passwords?
	# Windows does not support crypt()
	#if ((! $C_EncryptUserPass) && (! $isWin)) {
	if (! $C_EncryptUserPass) {
		print "<tr><td valign=bottom colspan=$cols>",$FontFace, $FontSize;
		print "Encrypt Passwords in Users Database?&nbsp;";
		print "</td></tr>\n\n";	
		print "<tr><td valign=top colspan=$cols>",$FontFace, $FontSize;
		print "<input type=checkbox name=C_EncryptUserPass value=1";
		if ($C_EncryptUserPass == 1) { print " checked"; }
		print " onClick=warnEncrypt()> Yes";
		#print "<input type=radio name=C_EncryptUserPass value=0";
		#if ($C_EncryptUserPass != 1) { print " checked"; }
		#print "> No&nbsp;";
		print "</td></tr>\n\n";
	} elsif ($C_EncryptUserPass) {
		print "<tr><td valign=bottom colspan=$cols>",$FontFace, $FontSize, $FontRed;
		print "User Passwords are Encrypted in the Database";
		print "</td></tr>\n\n";
	}
	
	print "</table>\n";
	
	print "</td>\n";
	print "<td valign=top>", $ImgClear88, "</td>";
	print "<td valign=top>\n";
	
	###################### Second Column ###############################
	
	print "<table cellpadding=0 cellspacing=0 border=0 width=100%>\n";
	
	##### Moderation #####
	# Title bar
	print "<tr><td width=100% bgcolor=$FTheaderback colspan=$cols>";
	print "<img src=$ImgSrcClearDot width=20 height=2>";
	print "</td></tr>\n\n";
	print "<tr><td width=100% colspan=$cols>";
	print $FontFace, $FontSize, "<b>Moderator Capabilities</b><br><br></td></tr>\n\n";
	
	# Allow Moderators to Edit others Posts?
	print "<tr><td valign=bottom colspan=$cols>",$FontFace, $FontSize;
	print "Allow Moderators to Edit Other Users' Posts?&nbsp;";
	print "</td></tr>\n\n";	
	print "<tr><td valign=top colspan=$cols>",$FontFace, $FontSize;
	print "<input type=radio name='C_ModEdit' value='1'";
	if ($C_ModEdit == 1 || $C_ModEdit eq "") { print " checked"; }
	print "> Yes";
	print "<input type=radio name='C_ModEdit' value='0'";
	if ($C_ModEdit != 1 && $C_ModEdit ne "") { print " checked"; }
	print "> No&nbsp;";
	print "</td></tr>\n\n";
	
	# Allow Moderators to Edit ALL Posts or just for moderated section?
	print "<tr><td valign=bottom>",$FontFace, $FontSize;
	print $ImgClear88;
	print $ImgClear88;
	print "</td>\n";
	print "<td valign=bottom colspan=", $cols - 1, ">",$FontFace, $FontSize;
	print "Moderators can Edit:&nbsp;";
	print "</td></tr>\n\n";	
	print "<tr><td valign=top>",$FontFace, $FontSize;
	print $ImgClear88;
	print $ImgClear88;
	print "</td>\n";
	print "<td valign=bottom colspan=", $cols - 1, ">",$FontFace, $FontSize;
	print "<input type=radio name='C_ModEditAll' value='1'";
	if ($C_ModEditAll == 1) { print " checked"; }
	print "> Any Post ";
	print "<input type=radio name='C_ModEditAll' value='0'";
	if ($C_ModEditAll != 1 || $C_ModEditAll eq "") { print " checked"; }
	print "> Moderated Users' Posts $FontRed *</font>&nbsp;";
	print "</td></tr>\n\n";
	
	# Allow Moderators to Delete others Posts?
	print "<tr><td valign=bottom colspan=$cols>",$FontFace, $FontSize;
	print "Allow Moderators to Delete Other Users' Posts?&nbsp;";
	print "</td></tr>\n\n";	
	print "<tr><td valign=top colspan=$cols>",$FontFace, $FontSize;
	print "<input type=radio name='C_ModDelete' value='1'";
	if ($C_ModDelete == 1 || $C_ModDelete eq "") { print " checked"; }
	print "> Yes";
	print "<input type=radio name='C_ModDelete' value='0'";
	if ($C_ModDelete != 1 && $C_ModDelete ne "") { print " checked"; }
	print "> No&nbsp;";
	print "</td></tr>\n\n";
	
	# Allow Moderators to Edit ALL Posts or just for moderated section?
	print "<tr><td valign=bottom>",$FontFace, $FontSize;
	print $ImgClear88;
	print $ImgClear88;
	print "</td>\n";
	print "<td valign=bottom colspan=", $cols - 1, ">",$FontFace, $FontSize;
	print "Moderators can Delete:&nbsp;";
	print "</td></tr>\n\n";	
	print "<tr><td valign=top>",$FontFace, $FontSize;
	print $ImgClear88;
	print $ImgClear88;
	print "</td>\n";
	print "<td valign=bottom colspan=", $cols - 1, ">",$FontFace, $FontSize;
	print "<input type=radio name='C_ModDeleteAll' value='1'";
	if ($C_ModDeleteAll == 1) { print " checked"; }
	print "> Any Post ";
	print "<input type=radio name='C_ModDeleteAll' value='0'";
	if ($C_ModDeleteAll != 1 || $C_ModDeleteAll eq "") { print " checked"; }
	print "> Moderated Users' Posts $FontRed *</font>&nbsp;";
	print "</td></tr>\n\n";
	
	# Spacer
	print "<tr><td width=100% colspan=$cols>";
	print "<img src=$ImgSrcClearDot width=20 height=8>";
	print "</td></tr>\n\n";
	
	# Note about moderation
	print "<tr><td valign=bottom colspan=$cols>",$FontFace, $FontSize;
	print $FontRed, "*</font> Posts by Users in Group for which Moderator is Group Leader.";
	print "</td></tr>\n\n";
	
	# Spacer
	print "<tr><td width=100% colspan=$cols>";
	print "<img src=$ImgSrcClearDot width=20 height=8>";
	print "</td></tr>\n\n";
	
	##### User Capabilities #####
	# Title bar
	print "<tr><td width=100% bgcolor=$FTheaderback colspan=$cols>";
	print "<img src=$ImgSrcClearDot width=20 height=2>";
	print "</td></tr>\n\n";
	print "<tr><td width=100% colspan=$cols>";
	print $FontFace, $FontSize, "<b>User Capabilities</b><br><br></td></tr>\n\n";
	
	# Allow User Photo Uploads?
	print "<tr><td valign=bottom colspan=$cols>",$FontFace, $FontSize;
	print "Allow Users to Upload their own Photos? (Requires User Profiles)&nbsp;";
	print "</td></tr>\n\n";	
	print "<tr><td valign=top colspan=$cols>",$FontFace, $FontSize;
	print "<input type=radio name='C_UserPhotoUp' value='1'";
	if ($C_UserPhotoUp == 1 || $C_UserPhotoUp eq "") { print " checked"; }
	print "> Yes";
	print "<input type=radio name='C_UserPhotoUp' value='0'";
	if ($C_UserPhotoUp != 1 && $C_UserPhotoUp ne "") { print " checked"; }
	print "> No&nbsp;";
	print "</td></tr>\n\n";
	
	# Allow HTML in Posts
	print "<tr><td valign=bottom colspan=$cols>",$FontFace, $FontSize;
	print "Allow Users to use HTML in their Posts?&nbsp;";
	print "</td></tr>\n\n";	
	print "<tr><td valign=top colspan=$cols>",$FontFace, $FontSize;
	print "<input type=radio name='C_UserPostHTML' value='1'";
	if ($C_UserPostHTML == 1 || $C_UserPostHTML eq "") { print " checked"; }
	print "> Yes";
	print "<input type=radio name='C_UserPostHTML' value='0'";
	if ($C_UserPostHTML != 1 && $C_UserPostHTML ne "") { print " checked"; }
	print "> No&nbsp;";
	print "</td></tr>\n\n";
	
	# Allow Email Notification
	print "<tr><td valign=bottom colspan=$cols>",$FontFace, $FontSize;
	print "Allow User Email Notification with Posts?&nbsp;";
	print "</td></tr>\n\n";	
	print "<tr><td valign=top colspan=$cols>",$FontFace, $FontSize;
	print "<input type=radio name='C_UserNotify' value='1'";
	if ($C_UserNotify == 1 || $C_UserNotify eq "") { print " checked"; }
	print "> Yes";
	print "<input type=radio name='C_UserNotify' value='0'";
	if ($C_UserNotify != 1 && $C_UserNotify ne "") { print " checked"; }
	print "> No&nbsp;";
	print "</td></tr>\n\n";
	
	
	# Allow Post Editing
	print "<tr><td valign=bottom colspan=$cols>",$FontFace, $FontSize;
	print "Allow Users to Edit their own Posts?&nbsp;";
	print "</td></tr>\n\n";	
	print "<tr><td valign=top colspan=$cols>",$FontFace, $FontSize;
	print "<input type=radio name='C_UserEdit' value='1'";
	if ($C_UserEdit == 1 || $C_UserEdit eq "") { print " checked"; }
	print "> Yes";
	print "<input type=radio name='C_UserEdit' value='0'";
	if ($C_UserEdit != 1 && $C_UserEdit ne "") { print " checked"; }
	print "> No&nbsp;";
	print "</td></tr>\n\n";
	
	# Editing Time Limit
	print "<tr><td valign=bottom>",$FontFace, $FontSize;
	print $ImgClear88;
	print $ImgClear88;
	print "</td>\n";
	print "<td valign=bottom colspan=", $cols - 1, ">",$FontFace, $FontSize;
	print "For how long are users allowed to edit their posts?&nbsp;";
	print "</td></tr>\n\n";
	print "<tr><td valign=top>",$FontFace, $FontSize;
	print $ImgClear88;
	print $ImgClear88;
	print "</td>\n";
	print "<td valign=bottom colspan=", $cols - 1, ">",$FontFace, $FontSize;
	@limits = (0, 1, 7, 28, 182, 365);
	@limitt = ("No Limit", "One Day", "One Week", "Four Weeks", "Six Months", "One Year");
	print "<select name=C_UserEditTime>\n";
	for ($i=0; $i < @limits; $i++) {
		print "<option value='", @limits[$i], "'";
		if ($C_UserEditTime == @limits[$i]) {
			print " selected";
		}
		print ">", @limitt[$i], "\n";
	}
	print "</select>\n";
	print "</td></tr>\n\n";
	
	
	# Allow File Attachments
	print "<tr><td valign=bottom colspan=$cols>",$FontFace, $FontSize;
	print "Allow Users to attach Files to their Posts?&nbsp;";
	print "</td></tr>\n\n";	
	print "<tr><td valign=top colspan=$cols>",$FontFace, $FontSize;
	print "<input type=radio name='C_UserAttach' value='1'";
	if ($C_UserAttach == 1 || $C_UserAttach eq "") { print " checked"; }
	print "> Yes";
	print "<input type=radio name='C_UserAttach' value='0'";
	if ($C_UserAttach != 1 && $C_UserAttach ne "") { print " checked"; }
	print "> No&nbsp;";
	print "</td></tr>\n\n";
	
	# Safehtml filtering on uploaded html files
	print "<tr><td valign=bottom>",$FontFace, $FontSize;
	print $ImgClear88;
	print $ImgClear88;
	print "</td>\n";
	print "<td valign=bottom colspan=", $cols - 1, ">",$FontFace, $FontSize;
	print "Filter Javascript from Uploaded HTML Files?&nbsp;";
	print "</td></tr>\n\n";	
	print "<tr><td valign=top>",$FontFace, $FontSize;
	print $ImgClear88;
	print $ImgClear88;
	print "</td>\n";
	print "<td valign=bottom colspan=", $cols - 1, ">",$FontFace, $FontSize;
	print "<input type=radio name=\"C_FilterHTML\" value=\"1\"";
	if ($C_FilterHTML eq "1") {
		print " checked";
	}
	print "> Always Filter&nbsp;&nbsp;";
	print "<input type=radio name=\"C_FilterHTML\" value=\"0\"";
	if ($C_FilterHTML ne "1") {
		print " checked";
	}
	print "> Let User Decide&nbsp;";
	print "</td></tr>\n\n";
	
	# File attachment maximum size
	print "<tr><td valign=bottom>",$FontFace, $FontSize;
	print $ImgClear88;
	print $ImgClear88;
	print "</td>\n";
	print "<td valign=bottom colspan=", $cols - 1, ">",$FontFace, $FontSize;
	if (!$forumadmin) {
		print $FontRed, " * </font>";
	}
	print "Maximum File Size for Attachments:&nbsp;";
	print "</td></tr>\n\n";	
	print "<tr><td valign=top>",$FontFace, $FontSize;
	print $ImgClear88;
	print $ImgClear88;
	print "</td>\n";
	print "<td valign=bottom colspan=", $cols - 1, ">",$FontFace, $FontSize;
	@limits = (0, 100, 500, 1024, 2048, 5120, 10240, 25600, 51200, 102400, 204800, 512000);
	@limitt = ("No Limit", "100 Kilobytes", "500 Kilobytes", "1 Megabyte", "2 Megabytes", "5 Megabytes", "10 Megabytes", "25 Megabytes", "50 Megabytes", "100 Megabytes", "200 Megabytes", "500 Megabytes");
	if ($forumadmin) {
		print "<select name=C_FileSizeLimit>\n";
		for ($i=0; $i < @limits; $i++) {
			print "<option value='", @limits[$i], "'";
			if ($C_FileSizeLimit == @limits[$i]) {
				print " selected";
			}
			print ">", @limitt[$i], "\n";
		}
		print "</select>\n";
	} else {
		print "<select>\n";
		for ($i=0; $i < @limits; $i++) {
			if ($C_FileSizeLimit == @limits[$i]) {
				print "<option>";
				print @limitt[$i];
				print "</option>\n";
			}
		}
		print "</select>\n";
	}
	print "&nbsp;</td></tr>\n\n";
	
	# Total File attachment disk space
	print "<tr><td valign=bottom>",$FontFace, $FontSize;
	print $ImgClear88;
	print $ImgClear88;
	print "</td>\n";
	print "<td valign=bottom colspan=", $cols - 1, ">",$FontFace, $FontSize;
	if (!$forumadmin) {
		print $FontRed, " * </font>";
	}
	print "Maximum Total Disk Space for all Attachments:&nbsp;";
	print "</td></tr>\n\n";	
	print "<tr><td valign=top>",$FontFace, $FontSize;
	print $ImgClear88;
	print $ImgClear88;
	print "</td>\n";
	print "<td valign=bottom colspan=", $cols - 1, ">",$FontFace, $FontSize;
	@limits = (0, 5, 10, 25, 50, 100, 200, 500, 1024, 2048, 5120, 10240);
	@limitt = ("No Limit", "5 Megabytes", "10 Megabytes", "25 Megabytes", "50 Megabytes", "100 Megabytes", "200 Megabytes", "500 Megabytes", "1 Gigabyte", "2 Gigabytes", "5 Gigabytes", "10 Gigabytes");
	if ($forumadmin) {
		print "<select name=C_UploadDiskSpace>\n";
		for ($i=0; $i < @limits; $i++) {
			print "<option value='", @limits[$i], "'";
			if ($C_UploadDiskSpace == @limits[$i]) {
				print " selected";
			}
			print ">", @limitt[$i], "\n";
		}
		print "</select>\n";
	} else {
		print "<select>\n";
		for ($i=0; $i < @limits; $i++) {
			if ($C_UploadDiskSpace == @limits[$i]) {
				print "<option>";
				print @limitt[$i];
				print "</option>\n";
			}
		}
		print "</select>\n";
	}
	print "&nbsp;</td></tr>\n\n";
	
	# What if the disk space goes over the limit?
	print "<tr><td valign=bottom>",$FontFace, $FontSize;
	print $ImgClear88;
	print $ImgClear88;
	print "</td>\n";
	print "<td valign=bottom>",$FontFace, $FontSize;
	print $ImgClear88;
	print $ImgClear88;
	print "</td>\n";
	print "<td valign=bottom colspan=", $cols - 2, ">",$FontFace, $FontSize;
	if (!$forumadmin) {
		print $FontRed, " * </font>";
	}
	print "What action should be taken if the maximum space limit is exceded?&nbsp;";
	print "</td></tr>\n\n";	
	print "<tr><td valign=top>",$FontFace, $FontSize;
	print $ImgClear88;
	print $ImgClear88;
	print "</td>\n";
	print "<td valign=bottom>",$FontFace, $FontSize;
	print $ImgClear88;
	print $ImgClear88;
	print "</td>\n";
	print "<td valign=bottom colspan=", $cols - 2, ">",$FontFace, $FontSize;
	if ($forumadmin) {
		print "<select name=C_DiskSpaceAction>\n";
		print "<option value='delete'";
		if ($C_DiskSpaceAction eq "delete") {
			print " selected";
		}
		print "> Automatically delete oldest attachments\n";
		print "<option value='notify'";
		if ($C_DiskSpaceAction eq "notify") {
			print " selected";
		}
		print "> Notify the Primary Administrator\n";
		print "</select>\n";
	} else {
		print "<select>\n";
		print "<option>";
		if ($C_DiskSpaceAction eq "delete") {
			print "Automatically delete oldest attachments";
		} else {
			print "Notify the Primary Administrator";
		}
		print "</option>\n";
		print "</select>\n";
	}
	print "&nbsp;</td></tr>\n\n";
	
	# Note for non-forumadmin
	if (!$forumadmin) {
		print "<tr><td valign=bottom colspan=$cols>",$FontFace, $FontSize;
		print $FontRed, "*</font> You must ";
		print "<a href=# onClick=parent.openwin('_AClassCreate.cgi?what=login&newwin=true&fid=Free',350,350,'SUWin')>";
		print "log in as the ";
		print "<b>panFora System Administrator</b></a><br>\n ";
		print "to edit the Upload Size and Disk Space Limits above.<br>&nbsp;";
		print "</td></tr>\n\n";
	}

	# End second Row
	
	print "</table>\n";
	print "</td></tr>\n\n";
	
	# Spacer
	print "<tr><td colspan=3>";
	print "<img src=$ImgSrcClearDot width=20 height=8>";
	print "</td></tr>\n\n";
	
	# Submission row
	print "<tr><td bgcolor=$FTheaderback colspan=3>";
	print "<img src=$ImgSrcClearDot width=20 height=2>";
	print "</td></tr>\n\n";
	
	print "<tr><td valign=bottom colspan=3>",$FontFace, $FontSize;
	if ($Demo) {
		print $BtnFormSubmitDemo;
	} else {
		print $BtnFormSubmit;
	}
	print "</td></tr>\n\n";
	
	print "</table>\n";
	print "</form>";
	
	print "</body></html>";
}

sub printPagOptions {
	local($whichone) = @_;
	
	print "<option value=0";
	if ($whichone == 0) { print " selected";}
	print "> All\n";
	print "<option value=5";
	if ($whichone == 5) { print " selected";}
	print "> 5\n";
	print "<option value=10";
	if ($whichone == 10) { print " selected";}
	print "> 10\n";
	print "<option value=20";
	if ($whichone == 20) { print " selected";}
	print "> 20\n";
	print "<option value=30";
	if ($whichone == 30) { print " selected";}
	print "> 30\n";
	print "<option value=50";
	if ($whichone == 50) { print " selected";}
	print "> 50\n";
	print "<option value=100";
	if ($whichone == 100) { print " selected";}
	print "> 100\n";
}

sub doclassmod {
	local (@names, $i);

	@names = $CGIQuery->param;

	$origrootpath = $C_rootpath;
	$origrooturl = $C_rooturl;
	$origphotodir = $C_photodir;
	$origphotourl = $C_photourl;
	$origlistdir = $C_listdir;
	$origpublic = $C_Public;
	$origtitle = $C_title;
	$origauthtype = $C_authtype;

	$C_page = "";
	for ($i=0; $i < @names; $i++) {
		if (@names[$i] =~ /^C\_/) {
			$val = $CGIQuery->param(@names[$i]);
			eval "\$@names[$i]=\"$val\";";
			
			if (@names[$i] =~ /^C\_/ && @names[$i] =~ /Page/) {
				#Pagination variable
				$C_page .= @names[$i] . "\t" . $val . "\n";
			}
		}
	}

	# Read in all submitted variables
	$Class = $CGIQuery->param('fid');
	$C_title = &cleanTabs($CGIQuery->param('C_title'));
	$C_name = $C_title;
	if ($forumadmin) {
		$C_rootpath = &replaceNonAlpha($CGIQuery->param('rootpath'));
		$C_rooturl = &replaceNonAlpha($CGIQuery->param('rooturl'));
		$C_photodir = &replaceNonAlpha($CGIQuery->param('C_photodir'));
		$C_photourl = &replaceNonAlpha($CGIQuery->param('C_photourl'));
		$C_listdir = &replaceNonAlpha($CGIQuery->param('C_listdir'));
	}
	$ColorScheme = $CGIQuery->param('scheme');
	$ForumAllowGuest = $CGIQuery->param('ForumAllowGuest');
	$ForumPostGuest = $CGIQuery->param('ForumPostGuest');
	$ForumReadGuest = $CGIQuery->param('ForumReadGuest');
	$ForumPostAnon = $CGIQuery->param('ForumPostAnon');
	#$C_GuestName = $CGIQuery->param('C_GuestName');
	#$C_authtype = $CGIQuery->param('C_authtype');
	
	#$C_Public = $CGIQuery->param('C_Public');
	#$C_ShowPhoto = $CGIQuery->param('C_ShowPhoto');
	#$C_UserProfile = $CGIQuery->param('C_UserProfile');
	#$C_ShowStats = $CGIQuery->param('C_ShowStats');
	#$C_UserAttach = $CGIQuery->param('C_UserAttach');
	#$C_UserEdit = $CGIQuery->param('C_UserEdit');
	#$C_UserEditTime = $CGIQuery->param('C_UserEditTime');
	#$C_UserPhotoUp = $CGIQuery->param('C_UserPhotoUp');

	if ($ForumAllowGuest != 1) {
		$ForumPostGuest = 0;
		$ForumReadGuest = 0;
	}

	# Remove any trailing slashes
	$C_rootpath =~ s/\/$//;
	$C_rooturl =~ s/\/$//;
	$C_photodir =~ s/\/$//;
	$C_photourl =~ s/\/$//;
	$C_listdir =~ s/\/$//;
	
	#$C_colors = &lookupColors("$ColorScheme");

	if ($C_rootpath ne "" && $forumadmin) {
		if ($origrootpath ne $C_rootpath) {
			if (!-e $C_rootpath && ! rename($origrootpath, $C_rootpath)) {
				&showErrorBackHTML("Unable to move $origrootpath to $C_rootpath. Make sure the necessary directories exist and are writable by the web server.", 1);
				exit();
			}

			# $origphotodir =~ s/^$origrootpath/$C_rootpath/;
			# $C_photodir =~ s/^$origrootpath/$C_rootpath/;
			# $origlistdir =~ s/^$origrootpath/$C_rootpath/;
			# $C_listdir =~ s/^$origrootpath/$C_rootpath/;
		}
		
		# Turn on signal Handling
		$trapSignals = 1;
		
		# Modify classes.db
		$dbfile = $DBFILE_CLASSID;
		
		@retval = `$setDB $dbfile -thash -k \"$Class\" -d \"$C_rootpath\"`;
		$status = &dbErrorCheck($?, @retval[0]);
		if ($status) {
			&showErrorBackHTML("$status<p>Unable to write to $dbfile. Check file permissions and try again.", 1);
			exit();
		}
		
		# If we got a signal, exit here.
		if ($gotSignal) {
			close(DEVNULL);
			exit(0);
		} else {
			# Turn off signal Handling
			$trapSignals = 0;
		}
	} elsif ($C_rootpath eq "") {
		$C_rootpath = $origrootpath;
		$C_rooturl = $origrooturl;
		$C_photodir = $origphotodir;
		$C_photourl = $origphotourl;
		$C_listdir = $origlistdir;
	}
	
	if ($C_title eq "") {
		# This is a big problem
		&showErrorBackHTML("You MUST specify a Title.", 1);
		exit();
	}
	
	# Turn on signal Handling
	$trapSignals = 1;
	
	$dbfile = $C_rootpath . "/" . $DIR_CONFIG . "/" . $DBFILE_CLASSINFO;
	
	$putstring = "";
	$putstring .= "C_name\t" . $C_name . "\n";
	$putstring .= "C_title\t" . $C_title . "\n";
	
	if ($C_rootpath ne "" && $forumadmin) {
		$putstring .= "C_rootpath\t" . $C_rootpath . "\n";
	}
	if ($C_photodir ne "" && $forumadmin) {
		if ($origphotodir ne $C_photodir) {
			if (! -e $C_photodir) {
				&confmakedir($C_photodir);
			}
			if (! -w $C_photodir) {
				&showErrorBackHTML("Unable to copy photos to new Photo Directory: $C_photodir. Check file permissions and try again.", 1);
				exit();
			}
			@files = glob("$origphotodir/*");
			for ($j=0; $j < @files; $j++) {
				@tmp = split(/\//, @files[$j]);
				$len = @tmp;
				if (! -e $C_photodir . "/" . @tmp[$len - 1]) {
					if (-d @files[$j]) {
						`cp -dpR @files[$j] $C_photodir`;
					} else {
						&copy(@files[$j], $C_photodir . "/" . @tmp[$len - 1]);
					}
				}
			}
		}
		$putstring .= "C_photodir\t" . $C_photodir . "\n";
	}
	if ($C_photourl ne "" && $forumadmin) {
		# $C_photourl =~ s/^$origrooturl/$C_rooturl/;
		
		$putstring .= "C_photourl\t" . $C_photourl . "\n";
	}
	if ($C_listdir ne "" && $forumadmin) {
		if ($origlistdir ne $C_listdir) {
			&confmakedir($C_listdir);
			@files = glob("$origlistdir/$Class-*");
			for ($j=0; $j < @files; $j++) {
				@get = split(/\//, @files[$j]);
				$newfile = $C_listdir . "/" . pop @get;
				rename(@files[$j], $newfile);
			}			
		}
		
		$putstring .= "C_listdir\t" . $C_listdir . "\n";
	}
	if ($C_rooturl ne "" && $forumadmin) {
		$putstring .= "C_rooturl\t" . $C_rooturl . "\n";
	}
	
	# Primary Administrator
	&lookupUser($C_FirstAdmin);
	$putstring .= "C_FirstAdmin\t" . $C_FirstAdmin . "\n";
	$putstring .= "C_FirstAdminEmail\t" . $U_Email . "\n";
	
	# General
	$putstring .= "ForumPostGuest\t" . $ForumPostGuest . "\n";
	$putstring .= "ForumReadGuest\t" . $ForumReadGuest . "\n";
	$putstring .= "ForumPostAnon\t" . $ForumPostAnon . "\n";
	$putstring .= "ForumAllowGuest\t" . $ForumAllowGuest . "\n";
	$putstring .= "C_GuestName\t" . $C_GuestName . "\n";
	$putstring .= "C_Public\t" . $C_Public . "\n";
	
	#$putstring .= "C_colors\t" . $C_colors . "\n";
	#$putstring .= "C_ShowPhoto\t" . $C_ShowPhoto . "\n";
	#$putstring .= "C_ShowStats\t" . $C_ShowStats . "\n";
	#$putstring .= "C_UserProfile\t" . $C_UserProfile . "\n";
	
	# Moderation
	$putstring .= "C_ModEdit\t" . $C_ModEdit . "\n";
	$putstring .= "C_ModEditAll\t" . $C_ModEditAll . "\n";
	$putstring .= "C_ModDelete\t" . $C_ModDelete . "\n";
	$putstring .= "C_ModDeleteAll\t" . $C_ModDeleteAll . "\n";
	
	# User Capabilities
	$putstring .= "C_UserAttach\t" . $C_UserAttach . "\n";
	$putstring .= "C_FilterHTML\t" . $C_FilterHTML . "\n";
	$putstring .= "C_FileSizeLimit\t" . $C_FileSizeLimit . "\n";
	$putstring .= "C_UploadDiskSpace\t" . $C_UploadDiskSpace . "\n";
	$putstring .= "C_DiskSpaceAction\t" . $C_DiskSpaceAction . "\n";
	$putstring .= "C_UserEdit\t" . $C_UserEdit . "\n";
	$putstring .= "C_UserEditTime\t" . $C_UserEditTime . "\n";
	$putstring .= "C_UserPhotoUp\t" . $C_UserPhotoUp . "\n";
	$putstring .= "C_UserPostHTML\t" . $C_UserPostHTML . "\n";
	$putstring .= "C_UserNotify\t" . $C_UserNotify . "\n";
	
	# Handle change of Authtype
	if ($C_authtype ne $origauthtype) {
		# Best way to handle this is to regenerate the files on every change.
		
		# Cookies or External
		if ($C_authtype eq "cookies" || $C_authtype eq "external") {
			# Unlink the .htaccess and .baaccess files
			unlink($C_rootpath . "/.htaccess");
			unlink($C_rootpath . "/.baaccess");
			
			# Copy the Cookies htaccess file over
			&copy("./$DIR_NEWCLASS/htcookies", $C_rootpath . "/.htaccess");
			
		# Apache
		} elsif ($C_authtype eq "apache") {
			&makeapacheauth($Class, ".htaccess", ".htgroup", ".htpasswd");
			&rebuildhtaccess(".htaccess");
			&rebuildhtpasswd;
			&rebuildmail;
		# Webauth or webauth and apache
		} elsif ($C_authtype =~ /webauth/) {
			open (wf, "./$DIR_NEWCLASS/webauth");
			@wfd = <wf>;
			close (wf);
		
			for ($i=0; $i < @wfd; $i++) {
				@wfd[$i] =~ s/GROUPS_FILE/$C_rootpath\/\.htgroup/;
			}
		
			open (wf, ">$C_rootpath/.htaccess");
			print wf @wfd;
			close (wf);
		
			if ($C_authtype =~ /apache/) {
				&makeapacheauth($Class, ".baaccess", ".htgroup", ".htpasswd");
			}
		
			# To allow public access
			&copy("./$DIR_NEWCLASS/webauth.pub", $C_rootpath . "/.webauth.pub");
			
			&rebuildhtaccess(".htaccess");
			if ($C_authtype =~ /apache/) {
				&rebuildhtaccess(".baaccess");
			}
			&rebuildhtpasswd;
			&rebuildmail;
			
			if ($origpublic) {
				&copy($C_rootpath . "/.htaccess", $C_rootpath . "/.webauth.priv");
				&copy($C_rootpath . "/.webauth.pub", $C_rootpath . "/.htaccess");
			}
		}
		
		$putstring .= "C_authtype\t" . $C_authtype . "\n";
	}
	
	# Handle Encryption of user passwords
	$C_EncryptUserPass = $CGIQuery->param('C_EncryptUserPass');
	if ($C_EncryptUserPass eq "1") {
		# User switched to Encrypted passwords. Encrypt all user passwords
		&encryptUserPass;
		
		$putstring .= "C_EncryptUserPass\t1\n";
	}
		
	# Add pagination variables
	#$putstring .= $C_page;
	
	# Commit changes to the database.
	if (! open (p, "| $setDB $dbfile -thash -a")) {
		&showErrorBackHTML("$status<p>Unable to write to $dbfile. Check file permissions and try again.", 1);
		exit();
	}
	print p $putstring;
	close(p);
	
	if ($origpublic ne $C_Public && $C_authtype =~ /webauth/) {
		if ($C_Public) {
			&copy($C_rootpath . "/.htaccess", $C_rootpath . "/.webauth.priv");
			&copy($C_rootpath . "/.webauth.pub", $C_rootpath . "/.htaccess");
		} else {
			&copy($C_rootpath . "/.webauth.priv", $C_rootpath . "/.htaccess");
		}
	}
	
	# Modify htaccess files
	if ($origtitle ne $C_title || $origrootpath ne $C_rootpath) {
		$htf = $C_rootpath . "/.htaccess";
		$baf = $C_rootpath . "/.baaccess";
		if (-e $baf) {
			open(f, $baf);
			@ht = <f>;
			close(f);
			open(f, ">$baf");
			for ($i=0; $i < @ht; $i++) {
				if (@ht[$i] =~ /^AuthUserFile/) {
					@ht[$i] =~ s/$origrootpath/$C_rootpath/;
				}
				if (@ht[$i] =~ /^AuthGroupFile/) {
					@ht[$i] =~ s/$origrootpath/$C_rootpath/;
				}
				if (@ht[$i] =~ /^StanfordAuthGroups/) {
					@ht[$i] =~ s/$origrootpath/$C_rootpath/;
				}
				if (@ht[$i] =~ /^AuthName/) {
					@ht[$i] = "AuthName" . "\t" . "\"" . $C_title . "\"\n";
				}
				print f @ht[$i];
			}
			close(f);
		}
		if (-e $htf) {
			open(f, $htf);
			@ht = <f>;
			close(f);
			open(f, ">$htf");
			for ($i=0; $i < @ht; $i++) {
				if (@ht[$i] =~ /^AuthUserFile/) {
					@ht[$i] =~ s/$origrootpath/$C_rootpath/;
				}
				if (@ht[$i] =~ /^AuthGroupFile/) {
					@ht[$i] =~ s/$origrootpath/$C_rootpath/;
				}
				if (@ht[$i] =~ /^StanfordAuthGroups/) {
					@ht[$i] =~ s/$origrootpath/$C_rootpath/;
				}
				if (@ht[$i] =~ /^AuthName/) {
					@ht[$i] = "AuthName" . "\t" . "\"" . $C_title . "\"\n";
				}
				print f @ht[$i];
			}
			close(f);
		}
	}
	
	# Class modification finished.
	
	# If we got a signal, exit here.
	if ($gotSignal) {
		close(DEVNULL);
		exit(0);
	}
	
	# Show success page
	
	&showHeaderBackHTML("$CorF modification successful");
	
	print "<p>The requested $corf modifications have been successfully committed ";
	print "to the $corf database.<p>";
	
	if ($start eq "") {
		print "<a href=$CGIEnvScript?fid=$Class&func=display ";
		print "onClick=parent.classmenu.selStep('display')>";
		print "Continue to the next ";
		print "step: Look and Feel</a>&nbsp;&nbsp;";
		
		print "<a href=$CGIEnvScript?fid=$Class&func=display ";
		print "onClick=parent.classmenu.selStep('display')>";
		print $BtnNextStep, "</a>";
	}

	print "</body></html>";
}

sub dodisplaymod {
	local (@names, $i);

	@names = $CGIQuery->param;

	$C_page = "";
	for ($i=0; $i < @names; $i++) {
		if (@names[$i] =~ /^C\_/) {
			$val = $CGIQuery->param(@names[$i]);
			eval "\$@names[$i]=\"$val\";";
			
			if (@names[$i] =~ /^C\_/ && @names[$i] =~ /Page/) {
				#Pagination variable
				$C_page .= @names[$i] . "\t" . $val . "\n";
			}
		}
	}

	# Read in all submitted variables
	$Class = $CGIQuery->param('fid');
	$ColorScheme = $CGIQuery->param('scheme');
	
	$C_colors = &lookupColors("$ColorScheme");
	
	$dbfile = $C_rootpath . "/" . $DIR_CONFIG . "/" . $DBFILE_CLASSINFO;
	
	$putstring = "";
	$putstring .= "C_colors\t" . $C_colors . "\n";

	$putstring .= "C_DefaultLayout\t" . $C_DefaultLayout . "\n";
	$putstring .= "C_ShowPhoto\t" . $C_ShowPhoto . "\n";
	$putstring .= "C_ShowStats\t" . $C_ShowStats . "\n";
	$putstring .= "C_UserProfile\t" . $C_UserProfile . "\n";
	
	# Add pagination variables
	$putstring .= $C_page;
	
	# Turn on signal Handling
	$trapSignals = 1;
	
	# Commit changes to the database.
	if (! open (p, "| $setDB $dbfile -thash -a")) {
		&showErrorBackHTML("$status<p>Unable to write to $dbfile. Check file permissions and try again.", 1);
		exit();
	}
	print p $putstring;
	close(p);
	
	# Class Display modification finished.
	
	# If we got a signal, exit here.
	if ($gotSignal) {
		close(DEVNULL);
		exit(0);
	}
	
	# Show success page
	
	&showHeaderBackHTML("$CorF modification successful");
	
	print "<p>The requested display modifications have been successfully committed ";
	print "to the $corf database.<p>";
	
	if ($start eq "") {
		print "<a href=$CGI_ForumEditUserSingle?fid=$Class&usertype=faculty&func=menu ";
		print "onClick=parent.classmenu.selStep('addusers')>";
		print "Continue to the next ";
		print "step: Adding $ForMs</a>&nbsp;&nbsp;";
		
		print "<a href=$CGI_ForumEditUserSingle?fid=$Class&usertype=faculty&func=menu ";
		print "onClick=parent.classmenu.selStep('addusers')>";
		print $BtnNextStep, "</a>";
	}

	print "</body></html>";
}


sub dosectedits {
	@qnames = $CGIQuery->param;
	$numsects = $CGIQuery->param('numsects');
	$confirm = $CGIQuery->param('confirm');

	$origC_Sect_n = $C_Sect_n;
	
	if ($confirm eq "NO") {
		&showHeaderBackHTML("ALL $SorG Edits Cancelled", "Since you did not confirm deletion of some $sorg, $FontRed ALL</font> $sorg edits have been cancelled. You can go back and make changes and resubmit if you like.", 2);
		exit();
	}
	
	for ($i=0; $i < @qnames; $i++) {
		for ($j=1; $j <= $numsects; $j++) {
			$sectname = "C_Sect_" . $j;
			if (@qnames[$i] =~ /$sectname\:/) {
				($junk, $val) = split(/\:/, @qnames[$i]);
				$C_Sects{$j}{"$val"} = &cleanTabs($CGIQuery->param(@qnames[$i]));
				
				if ($C_Sects{$j}{"$val"} =~ /^\s+$/) {
					$C_Sects{$j}{"$val"} = "";
				}
				
				if ($val eq "fac" && $CGIQuery->param(@qnames[$i]) eq "(NULL)") {
					push(@delsect, $j);
				}
				
				if ($val eq "del" && $CGIQuery->param(@qnames[$i]) eq "YES") {
					push(@delsect, $j);
				}
				
				if ($val eq "name" && $C_Sects{$j}{"name"} eq "") {
					# This one should be deleted
					push(@delsect, $j);
				}
			}
		}
	}

	@delsect = &unique(@delsect);
		
	@delsect = sort {$a <=> $b} @delsect;
	
	@usersectdel = @delsect;
	
	# Now check for confirmation of deletion
	if ($confirm eq "" && @delsect > 0 && @delsect[0] <= $origC_Sect_n) {
		&dosectconf;
		exit();
	}
	
	# Fill an array with the original section names (used in the ACK)
	for ($i=0; $i < @delsect; $i++) {
		$origsectnames{"@delsect[$i]"} = $C_Sects{@delsect[$i]}{"name"};
	}
	
	# Collapse the list to get rid of sections to be deleted
	for ($i=0; $i < @delsect; $i++) {
		for ($j=@delsect[$i]; $j <= $numsects; $j++) {
			$inc = $j+1;
			$C_Sects{$j}{"name"} = $C_Sects{$inc}{"name"};
			$C_Sects{$j}{"fac"} = $C_Sects{$inc}{"fac"};
			$C_Sects{$j}{"time"} = $C_Sects{$inc}{"time"};
			$C_Sects{$j}{"location"} = $C_Sects{$inc}{"location"};
		}
		
		for ($j=0; $j < @delsect; $j++) {
			@delsect[$j]--;
		}
	}
	
	$C_Sect_n = $numsects - @delsect;
	
	# Turn on signal Handling
	$trapSignals = 1;
	
	# Modify the class database
	$dbfile = $C_rootpath . "/" . $DIR_CONFIG . "/" . $DBFILE_CLASSINFO;

	@retval = `$setDB $dbfile -thash -k \"C_Sect_n\" -d \"$C_Sect_n\"`;
	
	$status = &dbErrorCheck($?, @retval[0]);
	if ($status) {
		&showErrorBackHTML("$status<p>Unable to write to $dbfile. Check file permissions and try again.", 1);
		exit();
	}
	
	for ($i=1; $i <= $C_Sect_n; $i++) {
		$DB_Key = "C_Sect_" . $i;
		$value = $i . "\\t" . $C_Sects{$i}{"name"} . "\\t" . $C_Sects{$i}{"fac"};
		$value .= "\\t" . $C_Sects{$i}{"time"} . "\\t" . $C_Sects{$i}{"location"};
		$value .= "\\t" . $Class . "-Sect" . $i;
				
		@retval = `$setDB $dbfile -thash -q -k \"$DB_Key\" -d \"$value\"`;
		
		$status = &dbErrorCheck($?, @retval[0]);
		if ($status) {
			&showErrorBackHTML("$status<p>Unable to write to $dbfile. Check file permissions and try again.", 1);
			exit();
		}
	}
	
	# remove any sections that should not be there
	if ($origC_Sect_n > $C_Sect_n) {
		for ($i = $C_Sect_n + 1; $i <= $origC_Sect_n; $i++) {
			$DB_Key = "C_Sect_" . $i;
			
			@retval = `$delDB $dbfile -thash -k \"$DB_Key\"`;
			
			$status = &dbErrorCheck($?, @retval[0]);
			if ($status) {
				&showErrorBackHTML("$status<p>Unable to delete $sorg $DB_Key from $dbfile.", 1);
				exit();
			}
		}
	}
	
	# Now assign orphaned users to sections
	if (@usersectdel > 0) {
		$dbfile = $C_rootpath . "/" . $DIR_CONFIG . "/" . $DBFILE_USERINFO;
		foreach (`$prtDB $dbfile -thash -q -a`) {
			($DB_Key, @value) = split(/\t/, &UnEscape($_));
			#($DB_Key, @value) = split(/\t/, $_);
			$U_C_Sect = @value[8];
		
			$status = &dbErrorCheck($?, $DB_Key);
			if ($status) {
				&showErrorBackHTML("$status<p>Unable to read from $dbfile.");
				exit();
			}
		
			if ($U_C_Sect =~ /\:/) {
				($junk, $sectnum) = split(/\:/, $U_C_Sect);
			} else {
				$sectnum = $U_C_Sect;
			}
		
			for ($i=0; $i < @usersectdel; $i++) {
				if ($sectnum == @usersectdel[$i]) {
					# Must move this user
					if ($sectnum - 1 <= $C_Sect_n) {
						$sectnum--;
					} else {
						$sectnum = $C_Sect_n;
					}
					
					push(@uids, $DB_Key);
					@value[8] = $class . ":" . $sectnum;
					$val = join("\t", @value);
					$val = &Escape($val);
					push(@uvalues, $val);
					$msg = "<li>User $DB_Key was moved from $sorg" . ": "; 
					$msg .= $origsectnames{"@usersectdel[$i]"};
					$msg .= " to $sorg" . ": ";
					$msg .= $C_Sects{$sectnum}{"name"} . ".<br>\n";
					push(@usermods, $msg);
				}
			}
		}
	}
	
	if (@uids > 0) {
		for ($i=0; $i < @uids; $i++) {
			@retval = `$setDB $dbfile -thash -q -k \"@uids[$i]\" -d \"@uvalues[$i]\"`;
			$status = &dbErrorCheck($?, @retval[0]);
			if ($status) {
				&showErrorBackHTML("$status<p>Unable to update @uids[$i] in Users database: $dbfile. Check file permissions and try again.", 1);
				exit();
			}
		}
		
		# rebuild mailing lists and htaccess files from scratch
		&rebuildmail;
	}
	
	# If we got a signal, exit here.
	if ($gotSignal) {
		close(DEVNULL);
		exit(0);
	}
	
	&showHeaderBackHTML("$SorG modification successful");
	
	print "<p>The requested $sorg modifications have been successfully committed ";
	print "to the $corf database.<p>";
	
	if (@usermods > 0) {
		print "The following user modifications were made to accomodate the ";
		print "the deletion of $sorg(s):";
		print "<ul>\n";
		print @usermods;
		print "</ul\n";
		print "<p>\n";
	}
	
	if ($start eq "") {
		print "<a href=$CGIEnvScript?fid=$Class&func=notif ";
		print "onClick=parent.classmenu.selStep('notif')>";
		print "Continue to the next ";
		print "step: Modifying the Email Notification List</a>&nbsp;&nbsp;";
		
		print "<a href=$CGIEnvScript?fid=$Class&func=notif ";
		print "onClick=parent.classmenu.selStep('notif')>";
		print $BtnNextStep, "</a>\n";
	}

	print "</body></html>";
}

sub donotifedits {
	@qnames = $CGIQuery->param;
	$numnotif = $CGIQuery->param('numnotif');
	
	for ($i=0; $i < @qnames; $i++) {
		for ($j=1; $j <= $numnotif; $j++) {
			$notifname = "Notif_" . $j;
			if (@qnames[$i] =~ /$notifname\:/) {
				($junk, $val) = split(/\:/, @qnames[$i]);
				$Notif{$j}{"$val"} = &cleanTabs($CGIQuery->param(@qnames[$i]));
				
				if ($Notif{$j}{"$val"} =~ /^\s+$/) {
					$Notif{$j}{"$val"} = "";
				}
				
				if ($val eq "del" && $CGIQuery->param(@qnames[$i]) eq "YES") {
					push(@delnotif, $j);
				} elsif ($CGIQuery->param(@qnames[$i]) eq "YES") {
					$Notif{$j}{"$val"} = "$val";
				}
				
				if ($val eq "name" && $Notif{$j}{"name"} eq "") {
					# This one should be deleted
					push(@delnotif, $j);
				}
			}
		}
	}
	
	# Remove duplicates
	@delnotif = &unique(@delnotif);
	@delnotif = sort {$a <=> $b} @delnotif;
	
	# Collapse the list to get rid of items to be deleted
	for ($i=0; $i < @delnotif; $i++) {
		for ($j=@delnotif[$i]; $j <= $numnotif; $j++) {
			$inc = $j+1;
			$Notif{$j}{"name"} = $Notif{$inc}{"name"};
			$Notif{$j}{"U"} = $Notif{$inc}{"U"};
			$Notif{$j}{"R"} = $Notif{$inc}{"R"};
			$Notif{$j}{"L"} = $Notif{$inc}{"L"};
			$Notif{$j}{"S"} = $Notif{$inc}{"S"};
			$Notif{$j}{"F"} = $Notif{$inc}{"F"};
			$Notif{$j}{"A"} = $Notif{$inc}{"A"};
			$Notif{$j}{"Others"} = $Notif{$inc}{"Others"};
		}
		
		for ($j=0; $j < @delnotif; $j++) {
			@delnotif[$j]--;
		}
	}
	
	$Notif_n = $numnotif - @delnotif;
	
	# Turn on signal Handling
	$trapSignals = 1;
	
	# Generate the new file
	open(f, ">$C_rootpath/$DIR_CONFIG/$FILE_FNOTIF");
	print f "None\t\@\n";
	for ($i=1; $i <= $Notif_n; $i++) {	
		print f $Notif{$i}{"name"}, "\t\@";
		print f $Notif{$i}{"U"}, $Notif{$i}{"R"}, $Notif{$i}{"L"};
		print f $Notif{$i}{"S"}, $Notif{$i}{"F"}, $Notif{$i}{"A"};
		if ($Notif{$i}{"Others"} ne "") {
			print f ",", $Notif{$i}{"Others"};
		}
		print f "\n";
	}
	close(f);
	
	# If we got a signal, exit here.
	if ($gotSignal) {
		close(DEVNULL);
		exit(0);
	}
	
	&showHeaderBackHTML("Notification List modification successful");
	
	print "<p>The Notification List has been modified as requested.<p>\n";
	
	# Provide a link here if necessary
	print <<end_print;
	<script language=javascript>
	<!--
	var found = 0;
	for (var i = 0; i < top.frames.length; i++) {
		if (top.frames[i].name == "AdminMenu") {
			found = 1;
		}
	}
	if (!found) {
		document.writeln("<hr width=100%>");
		document.writeln("$FontSize2" + "<b>Congratulations!</b></font><p>\\n" +
			"You have successfully created  and configured the $Class forum.<br>\\n" +
			"Please go to the " +
			"<a href=\\"$CGI_ForumAdminMenu?fid=$Class\\" target=_top>" +
			"Main Administration Page</a> if you would like to make " +
			"further modifications and customizations of this forum.<p>");

		document.writeln("Important: Before users may post messages and " +
			"discuss topics in the forum, topics must be created.<br>\\n" +
			"You may do so now (or anytime in the future) by going to the " +
			"<a href=\\"$CGI_ForumAdminMenu?fid=$Class\\" target=_top>" +
			"Main Administration Page</a> and selecting " +
			"&quot;Topics: Add&quot; from the left panel " +
			"Administration Menu there. <br>\\nOr click " +
			"<a href=\\"$CGI_ForumAdminMenu?fid=$Class" +
			"\&start=$CGI_ForumEditSubjectsMult\\" target=_top>here</a> " +
			"to go directly to topic editing.<p>");

		document.writeln("Suggestion: If you and/or your users are new to "+
			"panFora, you may create a topic named &quot;Practice&quot; via the " +
			"<a href=\\"$CGI_ForumAdminMenu?fid=$Class\\" target=_top>" +
			"Main Administration Page</a>, so that users may more freely " +
			"explore all of panFora's exciting discussion forum and " +
			"collaboration features in this &quot;Practice&quot; area.");
	}
	// -->
	</script>
	
end_print

	print "</body></html>";
}


sub encryptUserPass {
	local(@allusers, $i, $dbfile);

	$dbfile = $C_rootpath . "/" . $DIR_CONFIG . "/" . $DBFILE_USERINFO;
	
	if (! -e $dbfile) {
		return;
	}
	
	foreach (`$prtDB $dbfile -thash -a -q`) {
		push(@allusers, &UnEscape($_));
	}
	
	for ($i=0; $i < @allusers; $i++) {
		($DB_Key, $U_SUID, $U_Pass, $U_NameFirst, $U_NameLast, $U_NamePref, $U_Email, $U_Phone, $U_Perms, $U_C_Sect, $U_Photo, $U_Classify, $U_ProfileText, $U_Sig, $U_HideEmail) = split(/\t/, @allusers[$i]);
		$U_Pass = &cryptPass($U_Pass);
		$value = "$U_SUID\t$U_Pass\t$U_NameFirst\t$U_NameLast\t$U_NamePref\t$U_Email\t$U_Phone\t$U_Perms\t$U_C_Sect\t$U_Photo\t$U_Classify\t$U_ProfileText\t$U_Sig\t$U_HideEmail";
	
		$value = &Escape($value);
		@retval = `$setDB $dbfile -thash -q -k \"$DB_Key\" -d \"$value\"`;
		$status = &dbErrorCheck($?, @retval[0]);
		if ($status) {
			&showErrorBackHTML("$status<p>Unable to modify $DB_Key in Users database: $dbfile. Check file permissions and try again.", 1);
			exit();
		}
	}
}

sub dosectconf {
	&showHeaderBackHTML("Are you sure?");
	print "You have marked the following $sorgs for deletion, either ";
	print "by checking the delete box, leaving the $sorg name blank ";
	print "or leaving the $sorg leader blank. $FontRed Are you sure you ";
	print "want to delete these $sorgs?</font><p>";
	
	print "<table border=1 cellpadding=1 cellspacing=0>\n";
	print "<tr><td align=left>", $FontFace, $FontSize;
	print "$SorG ID</td>";
	print "<td align=left>", $FontFace, $FontSize;
	print "$SorG Name</td>";
	print "<td align=left>", $FontFace, $FontSize;
	print "$SorG Leader</td>";
	#print "<td align=left>", $FontFace, $FontSize;
	#print "Section Time</td>";
	#print "<td align=left>", $FontFace, $FontSize;
	#print "Section Location</td>";
	print "</tr>\n";
	
	for ($i=0; $i < @delsect; $i++) {
		$id = @delsect[$i];
		if ($id <= $origC_Sect_n) {
			print "<tr><td align=left>", $FontFace, $FontSize;
			print $id;
			print "&nbsp;</td>\n";
			print "<td align=left>", $FontFace, $FontSize;
			print $CGIQuery->param("C_Sect_$id:name");
			print "&nbsp;</td>\n";
			print "<td align=left>", $FontFace, $FontSize;
			print $CGIQuery->param("C_Sect_$id:fac");
			print "&nbsp;</td>\n";
			#print "<td align=left>", $FontFace, $FontSize;
			#print $CGIQuery->param("C_Sect_$id:time");
			#print "&nbsp;</td>\n";
			#print "<td align=left>", $FontFace, $FontSize;
			#print $CGIQuery->param("C_Sect_$id:location");
			#print "&nbsp;</td>\n";
			print "</tr>\n";
		}
	}
	
	print "</table><br>\n";
	
	print "<form action=$CGIEnvScript method=POST>\n";
	for ($i=0; $i < @qnames; $i++) {
		print "<input type=hidden name=\"", @qnames[$i],"\" value=\"";
		print $CGIQuery->param("@qnames[$i]"), "\">\n";
	}
	print "<input type=radio name=confirm value='YES'> Yes\n";
	print "<input type=radio name=confirm value='NO'> No<br>\n";
	print $BtnFormSubmit;
	print "\n</form>\n";
}

sub dofacconf {

	########### This is obsolete! ##########################

	&showHeaderBackHTML("Are you sure?");
	print "You have marked the following $forms for deletion, either ";
	print "by checking the delete box, ";
	print "or leaving the user name blank. $FontRed Are you sure you ";
	print "want to delete these $forms?</font><p>";
	
	print "<table border=1 cellpadding=1 cellspacing=0>\n";
	print "<tr><td align=left>", $FontFace, $FontSize;
	print "Faculty ID</td>";
	print "<td align=left>", $FontFace, $FontSize;
	print "User ID</td>";
	print "<td align=left>", $FontFace, $FontSize;
	print "Office Hours</td></tr>";
	
	for ($i=0; $i < @delsect; $i++) {
		$id = @delsect[$i];
		if ($id <= $origC_Fac_n) {
			print "<tr><td align=left>", $FontFace, $FontSize;
			print $id;
			print "&nbsp;</td>\n";
			print "<td align=left>", $FontFace, $FontSize;
			print $CGIQuery->param("C_Fac_$id:login");
			print "&nbsp;</td>\n";
			print "<td align=left>", $FontFace, $FontSize;
			print $CGIQuery->param("C_Fac_$id:officehours");
			print "&nbsp;</td>\n";
			print "</tr>\n";
		}
	}
	
	print "</table><br>\n";

	print "<form action=$CGIEnvScript method=POST>\n";
	for ($i=0; $i < @qnames; $i++) {
		print "<input type=hidden name=\"", @qnames[$i],"\" value=\"";
		print $CGIQuery->param("@qnames[$i]"), "\">\n";
	}
	print "<input type=radio name=confirm value='YES'> Yes\n";
	print "<input type=radio name=confirm value='NO'> No<br>\n";
	print $BtnFormSubmit;
	print "\n</form>\n";
}

sub printPreview {
	print <<end_print;
	
	<script language=javascript>

	<!-- 
	// window.onerror=null;

	function Preview() {
		hei = 360;
        wid = 500;
		
		var doc = "$CGI_ClassViewColor" + "?scheme=";
		doc += document.forms[0].scheme.options[document.forms[0].scheme.selectedIndex].value;

        var winname = "CSchemePreview";

        options = "location=0,toolbar=0,menubar=0,resizable=1,scrollbars=1,width=" + wid + ",height=" + hei;
 
        window.open(doc, winname, options);
	}
	// -->
	</script>
	
end_print
}

