#!/usr/bin/perl

###############################################################################
#
# _AFEdUserSngl.cgi - Edit one user or add new user.
#
# AUTHOR:	Shawn Stepper, wiTHinc Inc.
# AUTHOR:	George Toye, wiTHinc Inc.
# DATE:		$Date: 2001/08/21 17:50:52 $ (last modified)
# COPYRIGHT:	1998, 1999, 2000, 2001 wiTHinc Inc. All Rights Reserved.
#
###############################################################################

$FileRevision = '$Id: _AFEdUserSngl.cgi,v 1.44.2.3 2001/08/21 17:50:52 stepper Exp $';
$Version = '1.4.0';

if (@ARGV[0] eq "-v" || @ARGV[0] eq "--version") {
	print "File:		$0\n";
	print "Revision:	$FileRevision\n";
	print "Version:	$Version\n";
	exit();
}

require "F_Init.pl";
require "U_Init.pl";

# Forum admin has to be allowed to add a user.
$adminpass = $CGIQuery->cookie('panForaAdmin');
$forumadmin = &checkAdminPass($adminpass);

$Class = $CGIQuery->param('fid');
$adduser = &maxLength(&cleanNonAlpha($CGIQuery->param('adduser')), 16);
# $adduser = &maxLength(&cleanUser($CGIQuery->param('adduser')), 16);
$what = $CGIQuery->param('what');
$start = $CGIQuery->param('start');
$sorting = $CGIQuery->param('sorting');
$menulimit = $CGIQuery->param('menulimit');
$returnto = $CGIQuery->param('returnto');
$func = $CGIQuery->param('func');
$usertype = $CGIQuery->param('usertype');

# Process lists to get $getuser
if ($adduser eq "") {
	$founduser = 0;
	@names = $CGIQuery->param;
	for ($i=0; $i < @names; $i++) {
		$thename = @names[$i];
		if ($thename =~ /^getuser/) {
			$theval = $CGIQuery->param("$thename");
			if ($theval ne "(NULL)") {
				$founduser++;
				if ($founduser > 1) {
					&showErrorHTML("Please select only ONE user.");
					exit();
				}
				$getuser = $theval;
			}
		}
	}
}

if (!$forumadmin) {
	&checkCookieGuest($CGIEnvUser, $C_authtype);
}
	
if ($CGIEnvUser eq "" && !$forumadmin) {
	&showErrorHTML("You are not properly logged in. Please log in and come back.");
	exit();
}

&lookupClass;
if ($CGIEnvUser ne "") {
	&lookupUser($CGIEnvUser);
	$adminemail = $U_Email;
}

# Load up color variables
&loadColors($ColorQueryString);

# Kick the user out if they have the wrong permissions
if (!&IS_ADMIN($U_Perms) && !$forumadmin) {
	&showErrorBackHTML("You do not have permission to access this resource.");
	exit();
}

if ($func eq "menu") {
	$BodyTag = &makeBodyTag("Threads");
} else {
	$BodyTag = &makeBodyTag("Content");
}

###############################################################################
#
# Process submitted data

if ($func eq "doedit") {
	if ($Demo) {
		print $CGIQuery->redirect("Demo.html");
		exit();
	}
	&douseredit;
	exit();
} elsif ($func eq "chooseuser" && $getuser ne "") {
	# Class and user chosen, print out user editing page.
	
	# Get user data
	$found = &lookupUser($getuser);
	
	if ($found == 0) {
		$header = "Editing User - $getuser";
	} else {
		$header = "User $getuser Not Found";
	}
	
	# print $CGIQuery->header(-expires=>'-1d');
	print $CGIQuery->header;
	print $BodyTag;
	print $FontFace, $FontSize, "\n";
	
	$helplink = "file=UsersEditCORP_Admin.html&anchor=EditSingleUserEdtFSummary";
	$helplink .= "&helptitle=Edit%20User%20Editing%20Frame";
	
	# Print header bar
	print "<table cellpadding=0 cellspacing=0 border=0 width=100%>\n";
	print "<tr><td valign=middle bgcolor=$FCheaderback>";
	print "<img src=$ImgSrcClearDot width=3 height=14>";
	print "<a href=\"#\" onClick=\"parent.openwin(\'$CGI_AdminHelp";
	print "?fid=$Class\&func=summary\&", $helplink;
	print "',640,480,'AdminInfoWin')\">";
	print $BtnInfo;
	print "</a>";
	print "<img src=$ImgSrcClearDot width=3 height=14>";
	print "</td>\n";
	print "<td valign=middle bgcolor=$FCheaderback width=99%>";
	print $FontFace, $FontSize2, "<font color=$FCheadertext>";
	print "<b>$header</b></font></td>\n";
	print "<td align=right valign=middle bgcolor=$FCheaderback nowrap>";
	print "<a href=#copymove>";
	print $BtnUserCp,$BtnUserMv,$BtnDel;
	print "</a>";
	print  $ImgClear88, $ImgClear88;
	print "</td>";
	print "</tr>\n\n";
	
	# Spacer Row
	print "<tr><td colspan=2>$ImgClear88</td></tr>\n\n";
	
	if ($found != 0) {
		print "<tr><td colspan=2>", $FontFace, $FontSize2;
		print "The user you selected, $getuser, could not be found in the ";
		print "database of users.</td></tr>";
		print "</table>";
		exit();
	}
	
	print "</table>";
	
	&printuserinput;
	
	print "<a name=copymove>";
	&printuserdel($CGI_ForumEditUserDelete);
	
} elsif ($func eq "chooseuser" && $adduser ne "") {
	# Add a new user
	
	# Get user data
	$found = &lookupUser($adduser);
	
	if ($found eq "0") {
		$header = "User Exists!";
	} elsif ($returnto eq "") {
		$header = "Adding User - $adduser";
	} else {
		$header = "Adding Admin User - $adduser";
	}
	
	$helplink = "file=UsersAddCORP_Admin.html&anchor=AddUserEdtFSummary";
	$helplink .= "&helptitle=Add%20User%20Editing%20Frame";
	&showHeaderBackHTML("$header", "", 0, 0, 0, $helplink);
	
	if ($found eq "0") {
		print $FontFace, $FontSize;
		print "The user ID you selected, $adduser, already exists in the ";
		print "database of users. To edit this user, click the Edit ";
		print "button below.<br><form action=$CGIEnvScript method=POST>";
		print "<input type=hidden name=fid value=\"$Class\">";
		print "<input type=hidden name=func value=\"chooseuser\">";
		print "<input type=hidden name=getuser value=\"$adduser\">";
		print $BtnFormEdit;
		print "<p>\n";
		print "<a href='javascript:history.back()'>[Back]</a>\n";
		
		print "</body></html>\n";
		exit();
	}
	
	# Set up some defaults for the user
	$U_SUID = "";
	$U_NameFirst = "";
	$U_NameLast = "";
	$U_NamePref = "";
	$U_Pass = "pass";
	if ($C_authtype =~ /webauth/i) {
		$U_Email = $adduser . '@leland.stanford.edu';
	} else {
		$U_Email = "";
	}
	$U_Phone = "";
	$U_Perms = 3;
	$U_C_Sect = $Class . ":" . "1";
	$U_Photo = $adduser . ".gif";
	$U_PhotoLarge = $adduser . ".jpg";
	$U_Classify = "1";
	$U_ProfileText = "No Personal Information Provided";
	$U_Sig = "";
	$U_HideEmail = "0";
	
	if ($CGIQuery->param('newperms') ne "") {
		$U_Perms = $CGIQuery->param('newperms');
	}
	
	&printuserinput;	
	
} elsif ($func eq "menu") {
	# User selection

	if ($usertype =~ /faculty/) {
		$printType = $ForM;
		$BodyTag = &makeBodyTag("Content");
		$helplink = "file=ConfigureAddModeratorsCORP_Admin.html&anchor=ForumAddModeratorEdtFSummary";
		$helplink .= "&helptitle=Add%20Moderators";
		&showHeaderBackHTML("Add $printType User for $CorF - $Class",
			"", 0, 0, 0, $helplink);
	} else {
		$helplink = "file=UsersAddCORP_Admin.html&anchor=AddUserTskFSummary";
		$helplink .= "&helptitle=Edit%20Users%20Editing%20Frame";
		&showHeaderBackHTML("Add $printType User for $CorF - $Class",
			"", 0, 1, 0, $helplink);
	}
	
	&printResetJavascript;
	
	print "<table border=0 cellpadding=0 cellspacing=0>\n";
	print "<tr>";
	print "<td valign=middle colspan=2>",$FontFace, $FontSize;
	print "<b>New User ID:</b></td>\n";
	if ($usertype =~ /faculty/) {
		print "<td>$ImgIndent</td>\n";
		print "<td valign=middle>",$FontFace, $FontSize;
		print "<b>Existing $ForMs:</b>";
		print "</td>\n";
		
		print "<td nowrap>$ImgClear88$ImgClear88</td>\n";
		print "<td valign=top>", $FontFace, $FontSize;
		if ($start eq "") {
			print "When you are done adding $forms: ";
		}
		print "</td>\n";
	}
	print "</tr>\n";
			
	print "<tr>";
	print "<form action=$CGIEnvScript method=POST";
	if ($usertype !~ /faculty/) {
		print " target=suseredit";
	}
	print ">";
	print "<td valign=top align=left>", $FontFace, $FontSize;
	print "<input type=hidden name=fid value=\"$Class\">\n";
	print "<input type=hidden name=func value=chooseuser>\n";
	print "<input type=hidden name=usertype value=\"$usertype\">\n";
	print "<input type=text size=10 name='adduser'>\n";
	print "</td><td valign=top align=left>", $FontFace, $FontSize;
	print $BtnFormAdd, "\n";
	print $BtnFormClear;
	print "</td>\n";
	
	if ($usertype =~ /faculty/) {
		@fac = &lookupFacList;
		print "<td>$ImgIndent</td>\n";
		print "<td valign=top>", $FontFace, $FontSize;
		if (@fac > 0) {
			for ($i=0; $i < @fac; $i++) {
				print "&#0149; ", @fac[$i], "<br>\n";
			}
		} else {
			print "&#0149; (No Existing $ForMs)";
		}
		print "</td>\n";
		
		# Link to next step
		print "<td nowrap>$ImgClear88$ImgClear88</td>\n";
		print "<td valign=top>", $FontFace, $FontSize;
		if ($start eq "") {
			print "<a href=$CGI_ClassEdit?fid=$Class&func=sections ";
			print "onClick=parent.classmenu.selStep('sections')>";
			print "Continue to the next ";
			print "step: Adding $SorGs</a>&nbsp;&nbsp;";
			
			print "<a href=$CGI_ClassEdit?fid=$Class&func=sections ";
			print "onClick=parent.classmenu.selStep('sections')>";
			print $BtnNextStep, "</a>\n";
		}
		print "</td>\n";
	}
	
	print "</tr></form>\n";
	
	print "</table>\n\n";
	
} elsif ($func eq "nothing") {
	# Show the lower frame, no user selected.

	&printEmptyTaskFrame("Enter a new User ID in the frame above.");
	
} else {

	# No function chosen. Print out frameset
	# print $CGIQuery->header(-expires=>'-1d');
	print $CGIQuery->header;
	print "<html><head><title>$Class Forum User Editing</title>\n";
	&printJavascript();
	print "</head>\n";
	print "<frameset rows='120,*' border=2>\n";
	print "	<frame name=susermenu src=$CGIEnvScript?fid=$Class&func=menu";
	print "&usertype=$usertype&start=$start ";
	print "frameborder=1 marginheight=0 marginwidth=0>\n";
	print "	<frame name=suseredit src=$CGIEnvScript?fid=$Class&func=nothing";
	print "&usertype=$usertype&start=$start ";
	print "frameborder=1 marginheight=0 marginwidth=0>\n";
	print "</frameset>\n";
}


sub douseredit {
	&clearUserData;

	$newid = &maxLength(&cleanNonAlpha($CGIQuery->param('newid')), 16);
	#$newid = &maxLength(&cleanUser($CGIQuery->param('newid')), 16);
	$getuser = &maxLength(&cleanNonAlpha($CGIQuery->param('getuser')), 16);
	$adduser = &maxLength(&cleanNonAlpha($CGIQuery->param('adduser')), 16);
	#$adduser = &maxLength(&cleanUser($CGIQuery->param('adduser')), 16);
	
	if ($newid eq "" || ($getuser eq "" && $adduser eq "")) {
		&showErrorBackHTML("You must provide a user ID.",1);
		exit();
	}
	
	if ($newid ne $getuser && $getuser ne "") {
		# this is an id change
		# we need to make sure that the new one doesn't already exist...
		$status = &lookupUser($newid);
		if ($status == 0) {
			&showErrorBackHTML("The new user name you have chosen already exists. If you would like to overwrite this one, you must first delete it.",1);
			exit();
		}
	}
	
	$U_SUID = &cleanTabs($CGIQuery->param('SUID'));
	# $U_Pass = &replaceWhiteSpace($CGIQuery->param('pass'));
	$U_Pass = &cleanTabs($CGIQuery->param('pass'));
	$U_NameFirst = &cleanTabs($CGIQuery->param('firstname'));
	$U_NameLast = &cleanTabs($CGIQuery->param('lastname'));
	$U_NamePref = &cleanTabs($CGIQuery->param('prefname'));
	$U_Email = &cleanTabs($CGIQuery->param('email'));
	$origemail = $CGIQuery->param('origemail');
	$origperms = $CGIQuery->param('origperms');
	$U_Phone = &cleanTabs($CGIQuery->param('phone'));
	
	$permread = $CGIQuery->param('permread');
	$permwrite = $CGIQuery->param('permwrite');
	$permfac = $CGIQuery->param('permfac');
	if ($usertype eq "faculty") {
		$permfac = 4;
	}
	$permadmin = $CGIQuery->param('permadmin');
	$U_Perms = $permread + $permwrite + $permfac + $permadmin;
	if ($U_Perms eq "") { $U_Perms = 0;}
	$newperms = $U_Perms;
	
	$U_C_Sect = $CGIQuery->param('classsection');
	$origsect = $CGIQuery->param('origsect');
	$U_Photo = $CGIQuery->param('photo');
	$U_PhotoLarge = $CGIQuery->param('photo2');
	$U_Classify = $CGIQuery->param('classification');
	$U_ProfileText = &cleanTabs($CGIQuery->param('profile'));
	$U_Sig = &cleanHTML(&cleanTabs($CGIQuery->param('sig')));
	$U_Sig =~ s/\"/\&quot\;/g;
	$U_HideEmail = $CGIQuery->param('hideemail');
	
	$emailpassword = &cleanTabs($CGIQuery->param("emailpassword"));
	
	if ($C_EncryptUserPass && $adduser eq "") {
		$newpass = &replaceWhiteSpace($CGIQuery->param('newpass'));
		if ($newpass ne "") {
			$U_Pass = &cryptPass($newpass);
		}
	}
	
	if ($C_EncryptUserPass && $adduser ne "") {
		$newpass = $U_Pass;
		$U_Pass = &cryptPass($U_Pass);
	}
	
	if ($otherclassification ne "" && $U_Classify eq "Other") {
		$U_Classify = $otherclassification;
	}
	
	if ($U_C_Sect eq "") {
		$U_C_Sect = $Class . ":1";
	}
	
	if ($U_Photo eq "") {
		$U_Photo = "Guest.gif";
	}
	if ($U_PhotoLarge eq "") {
		$U_PhotoLarge = "Guest.jpg";
	}
	
	if ($U_NameFirst eq "" && $U_NameLast eq "" && $U_NamePref eq "") {
		&showErrorBackHTML("You must provide a name.",1);
		exit();
	}
	
	$DB_Key = $newid;
	
	# Turn on signal Handling
	$trapSignals = 1;

	##########################################################
	# Add user to database
	$retval = &addtodb($DB_Key);
	if ($retval) {
		&userDBError($retval);
	}
	#
	##########################################################
	
	if ($DB_Key ne $getuser && $getuser ne "" && $getuser ne "Anonymous" && $getuser ne "Guest") {
		# if this is an id change, need to delete the old one.
		$status = &delfromdb($getuser);
		if ($status != 0) {
			&showErrorBackHTML("User deletion failure!!! User = $DB_Key",1);
			exit();
		}
		# Delete from htgroup file
		#&delfromht($getuser);
		# Delete photo
		# Don't delete photo or it disappears from their posts
		# &delphoto($getuser);
		# Delete from mailing list
		#&delfrommail($getuser);
	}
	#if ($origemail ne $U_Email) {
	#	&delfrommail($getuser);
	#}
		
	#if ($origsect ne $U_C_Sect) {
	#	&delfromht($getuser);
	#	&delfrommail($getuser);
	#}
		
	if ($status != 0) {
		&showErrorBackHTML("Database write failure!!!",1);
		exit();
	}
	
	##########################################################
	# Add user to htgroup
	#if ($DB_Key ne "Anonymous") {
	#	&addtoht($DB_Key, $U_C_Sect);
	#}
	#
	##########################################################
	
	##########################################################
	# Add user photos
	if ($DB_Key ne "Anonymous" && $DB_Key ne "Guest") {
		&addphoto($DB_Key);
	}
	#
	##########################################################
	
	##########################################################
	# Modify mailing lists as needed
	#if ($DB_Key ne "Anonymous" && $DB_Key ne "Guest") {
	#	&addtomail($DB_Key);
	#}
	#
	##########################################################
	
	# rebuild mailing lists and ht files from scratch
	&rebuildAllMailAndHT();
	
	# If this is a faculty user, put the user in the class database as
	# a faculty member.
	if ($usertype eq "faculty" || &IS_FAC($U_Perms)) {
		&addToClassFac($DB_Key);
	}

	# If they were a faculty member, but are no longer, remove them from
	# The class db as faculty
	if ((!&IS_FAC($newperms)) && &IS_FAC($origperms)) {
		&delFromClassFac($DB_Key);
	}
	
	# If this is the first admin user, put the user as the section
	# leader for the default sections.
	if ($usertype eq "firstadmin") {
		# First read the info for C_Sect_1 from the class database
		# If the section leader is "Nobody" replace Nobody with new user name.
		$dbfile = $C_rootpath . "/" . $DIR_CONFIG . "/" . $DBFILE_CLASSINFO;
		
		($key, @value) = split(/\t/, `$prtDB $dbfile -thash -k \"C_Sect_1\"`);
		$status = &dbErrorCheck($?, $key);

		if (! $status) {
			if (@value[2] eq "Nobody") {
				@value[2] = $newid;
				$value = join("\\t", @value);
				@retval = `$setDB $dbfile -thash -q -k \"C_Sect_1\" -d \"$value\"`;
			}
		} else {
			@retval = `$setDB $dbfile -thash -q -k \"C_Sect_1\" -d \"1\\tNon-Student\\t$newid\\t\\t\\t$newclass-Sect1\"`;
		}
		
		$status = &dbErrorCheck($?, @retval[0]);
		if ($status) {
			&showErrorBackHTML("$status<p>Unable to write to $dbfile Check file permissions and try again.", 1);
			exit();
		}
		
		($key, @value) = split(/\t/, `$prtDB $dbfile -thash -k \"C_Sect_2\"`);
		$status = &dbErrorCheck($?, $key);
		
		if (! $status) {
			if (@value[2] eq "Nobody") {
				@value[2] = $newid;
				$value = join("\\t", @value);
				@retval = `$setDB $dbfile -thash -q -k \"C_Sect_1\" -d \"$value\"`;
			}
		} else {
			@retval = `$setDB $dbfile -thash -q -k \"C_Sect_2\" -d \"2\\tStudent (Unassigned)\\t$newid\\t\\t\\t$newclass-Sect2\"`;
		}
		
		$status = &dbErrorCheck($?, @retval[0]);
		if ($status) {
			&showErrorBackHTML("$status<p>Unable to write to $dbfile Check file permissions and try again.", 1);
			exit();
		}
	}
	
	# Email the user his account information, if requested
	if ($emailpassword eq "YES") {
		&emailUserAccountInfo($DB_Key, $adminemail);
	}
	
	# If we got a signal, exit here.
	if ($gotSignal) {
		close(DEVNULL);
		exit(0);
	}
	
	# Show the results to the Admin
	if ($returnto ne "") {
		print $CGIQuery->redirect("$returnto");
		exit();
	} elsif ($usertype =~ /faculty/i) {
		print $CGIQuery->redirect(-URL=>"$CGI_ForumEditUserSingle?fid=$Class&usertype=faculty&start=$start&func=menu");
		exit();
	}
	
	&showHeaderBackHTML("User $getuser Changed", "<br>");
	
	&lookupUser($newid);
	&printuserstatic;
}


sub printuserinput {
	# Print out photo chooser javascript
	&printphotochooser;

	# Warn if user id was changed to clean it up
	if ($adduser ne $CGIQuery->param('adduser')) {
		print $FontRed, "Warning:</font> ";
		print "The user id you selected was modified. The maximum length ";
		print "for the id is 16 characters. Only alphanumeric characters ";
		print "(a-z, A-Z, 0-9, - and _) are allowed.";
		print "<p>\n";
	}

	# Start Form
	print "<form action=$CGIEnvScript method=POST>\n";
	
	# Special flag so we know what we are doing
	print "<input type=hidden name=func value=\"doedit\">\n";
	
	print "<input type=hidden name=returnto value=\"$returnto\">\n\n";
	print "<input type=hidden name=usertype value=\"$usertype\">\n\n";
	
	print "<input type=hidden name=fid value=\"$Class\">\n";
	
	# Varibale for section and email change
	print "<input type=hidden name=origsect value=\"$U_C_Sect\">\n";
	print "<input type=hidden name=origemail value=\"$U_Email\">\n";
	print "<input type=hidden name=origperms value=\"$U_Perms\">\n";
	
	if ($adduser ne "") {
		print "<input type=hidden name=adduser value=\"$adduser\">\n\n";
	} else {
		print "<input type=hidden name=getuser value=\"$getuser\">\n\n";
	}
	
	print "<table cellpadding=0 cellspacing=0 border=0 width=100%>\n";
	# Print dividing line
	# print "<tr><td valign=middle bgcolor=$FCheaderback>";
	# print "$ImgClear88</td></tr>";	
	
	# Print out all database fields
	print "<tr><td>", $FontFace, $FontSize;
	
	# Print inner table for first row
	print "<table cellpadding=0 cellspacing=0 border=0>\n";
	# First row of headings
	print "<tr>";
	print "<td valign=bottom nowrap>", $FontFace,$FontSize, $FontRed;
	print "User ID&nbsp;</td>\n";
	if ($Edu) {
		print "<td valign=bottom nowrap>", $FontFace,$FontSize;
		print "University ID&nbsp;</td>\n";
	} elsif ($C_authtype !~ /external/i) {
		print "<td valign=bottom nowrap>", $FontFace,$FontSize;
		print "Password Hint&nbsp;</td>\n";
	}
	#if ($adduser eq "") {
		print "<td valign=bottom nowrap>", $FontFace,$FontSize, $FontRed;
		print "Password&nbsp;</td>\n";
	#}
	
	print "</tr>";
	
	# First row of entry fields.
	if ($adduser ne "") {
		print "<td valign=middle nowrap>", $FontFace,$FontSize;
		print "<input type=hidden name=newid value=\"$adduser\">\n";
		print $adduser, "&nbsp;";
	} else {
		print "<td valign=top nowrap>", $FontFace,$FontSize;
		print "<input type=text name=newid size=12 maxlength=16 value=\"$getuser\">";
	}
	print "&nbsp;";
	print "</td>\n";
	
	if ($C_authtype !~ /external/i) {
		print "<td valign=top nowrap>", $FontFace,$FontSize;
		print "<input type=text name=SUID size=10 value=\"$U_SUID\">";
		print "&nbsp;";
		print "</td>\n";
	}
	
	if ($C_EncryptUserPass && $adduser eq "") {
		&printWarnChgEncrypted;
	
		print "<td valign=top nowrap>", $FontFace,$FontSize;
		print "<input type=hidden name=pass value=\"$U_Pass\">";
		print "<input type=text name=newpass size=10 value=\"\" maxlength=8 ";
		print "onFocus=\"warnEncryptedNewPass(this, \'$getuser\')\"";
		print ">";
		print "&nbsp;";
		print "</td>\n";
	} else {
		print "<td valign=top nowrap>", $FontFace,$FontSize;
		print "<input type=text name=pass size=10 value=\"$U_Pass\" maxlength=8>";
		print "&nbsp;";
		print "</td>\n";
	}
		
	# Email password to user
	print "<td align=left valign=top>", $FontFace, $FontSize;
	print "<input type=checkbox name=\"";
	print "emailpassword\" value=YES>";
	print "Email Account Information to ";
	#if ($getuser ne "") {
	#	print $getuser;
	#} else {
	#	print $adduser;
	#}
	print "this User</td>\n";
	
	print "</tr></table></td></tr>\n\n";

	# Second row of headings
	print "<tr><td>";
	print "<table cellpadding=0 cellspacing=0 border=0>\n";
	print "<tr>";
	print "<td valign=bottom nowrap>", $FontFace,$FontSize, $FontRed;
	print "First Name</td>\n";
	print "<td valign=bottom nowrap>", $FontFace,$FontSize, $FontRed;
	print "Last Name</td>\n";
	print "<td valign=bottom nowrap>", $FontFace,$FontSize;
	print "Preferred Name</td>\n";
	print "</tr>";

	# Second row of input fields
	print "<tr>";
	print "<td valign=top nowrap>", $FontFace,$FontSize;
	print "<input type=text name=firstname size=16 value=\"$U_NameFirst\">";
	print "&nbsp;";
	print "</td>\n";

	print "<td valign=top nowrap>", $FontFace,$FontSize;
	print "<input type=text name=lastname size=16 value=\"$U_NameLast\">";
	print "&nbsp;";
	print "</td>\n";
	
	print "<td valign=top nowrap>", $FontFace,$FontSize;
	print "<input type=text name=prefname size=16 value=\"$U_NamePref\">";
	print "&nbsp;";
	print "</td>\n";
	print "</tr></table></td></tr>\n\n";
	
	# Third row of headings
	print "<tr><td>";
	print "<table cellpadding=0 cellspacing=0 border=0>\n";
	print "<tr>";
	print "<td valign=bottom nowrap>", $FontFace,$FontSize, $FontRed;	
	print "Email Address</td>\n";
	print "<td valign=bottom nowrap>", $FontFace,$FontSize;
	print "Phone Number</td>\n";
	print "</tr>\n";
	
	# Third row of input fields
	print "<td valign=top nowrap>", $FontFace,$FontSize;
	print "<input type=text name=email size=30 value=\"$U_Email\">";
	print "&nbsp;";
	print "</td>\n";

	print "<td valign=top nowrap>", $FontFace,$FontSize;
	print "<input type=text name=phone size=16 value=\"$U_Phone\">";
	print "&nbsp;";
	print "</td>\n";
	print "</tr></table></td></tr>\n\n";
	
	# Fourth row of headings
	print "<tr><td>";
	print "<table cellpadding=0 cellspacing=0 border=0>\n";
	print "<tr>";
	print "<td valign=bottom nowrap>", $FontFace,$FontSize, $FontRed;
	print "Permissions</td>\n";
	print "</tr>";

	# Fourth row of input fields
	print "<tr>";
	
	#### Permissions

	print "<td valign=top nowrap>", $FontFace,$FontSize;
	print "<input type=checkbox name=permread value=2";
	if (&HAS_READ($U_Perms)) {
		print " checked";
	}
	print ">Read ";
		
	print "<input type=checkbox name=permwrite value=1";
	if (&HAS_WRITE($U_Perms)) {
		print " checked";
	}
	print ">Write ";
		
	print "<input type=checkbox name=permfac value=4";
	if (&IS_FAC($U_Perms) || $usertype eq "faculty") {
		print " checked";
	}
	print ">$ForM ";

	if ($CGIEnvUser eq $getuser || $returnto ne "") {
		print "&nbsp; <b>X</b> Admin";
		print "<input type=hidden name=permadmin value=8>";
	} else {
		print "<input type=checkbox name=permadmin value=8";
		if (&IS_ADMIN($U_Perms)) {
			print " checked";
		}
		print ">Admin ";
	}

	print "&nbsp;";
	print "</td>\n";
	######

	print "</tr></table></td></tr>\n\n";

	if ($returnto eq "") {
		# Fourth row of headings
		print "<tr><td>";
		print "<table cellpadding=0 cellspacing=0 border=0>\n";
		print "<tr>";
		print "<td valign=bottom nowrap>", $FontFace ,$FontSize, $FontRed;
		print "$CorF $SorG</td>\n";	
		print "<td valign=bottom nowrap>", $FontFace, $FontSize, $FontRed;
		print "Put User on $SorG Email List&nbsp;&nbsp;&nbsp;&nbsp;</td>\n";
		print "<td valign=bottom nowrap>", $FontFace, $FontSize, $FontRed;
		print "Hide User's Email</td>\n";
		print "</tr>";

		# User section, classification - Student, Faculty etc.
		print "<tr>";
	
		print "<td valign=top nowrap>", $FontFace,$FontSize;
		($junk, $sectnum) = split(/\:/, $U_C_Sect);
		print "<select name=classsection>";
		for ($i=1; $i <= $C_Sect_n; $i++) {
			print "<option value='", $Class, ":", $C_Sects{$i}{"num"}, "'";
			if ($sectnum == $C_Sects{$i}{"num"}) {
				print " selected";
			}
			print ">";
			print $C_Sects{$i}{"name"}, "\n";
		}
		print "</select>";
		print "&nbsp;";
		print "</td>\n";
	
		print "<td valign=top nowrap>", $FontFace,$FontSize;
		
		print "<input type=radio name=\"classification\"";
		$onlist = 0;
		if ($U_Classify == 1 || $U_Classify =~ /student/i) {
			print " checked";
			$onlist = 1;
		}
		print " value='1'>";
		print "Yes \n";
		
		print "<input type=radio name=\"classification\"";
		if (! $onlist) {
			print " checked";
		}
		print " value='0'>";
		print "No \n";

		print "</td>\n";
		
		print "<td valign=top nowrap>", $FontFace, $FontSize;	
		
		print "<input type=radio name=\"hideemail\"";
		if ($U_HideEmail =~ /^1/) {
			print " checked";
		}
		print " value='1'>";
		print "Yes \n";
		
		print "<input type=radio name=\"hideemail\"";
		if ($U_HideEmail !~ /^1/) {
			print " checked";
		}
		print " value='0'>";
		print "No \n";
		
		print "</td>\n";
		
		print "</tr></table></td></tr>\n\n";
	} else {
		# We are adding an Admin, as part of class creation
		print "<input type=hidden name=classification value=\"Admin\">\n";
		print "<input type=hidden name=classsection value=\"$Class:1\">\n";
	}

	if ($returnto eq "") {
		# Fifth row of headings - User Profile
		print "<tr><td>";
		print "<table cellpadding=0 cellspacing=0 border=0>\n";
		print "<tr>";
		print "<td valign=middle nowrap>", $FontFace,$FontSize;
		print "Personal Information</td></tr>\n";
		print "<tr><td>", $FontFace, $FontSize;
		print "<textarea name=profile rows=4 cols=50 wrap=virtual>$U_ProfileText</textarea>";
		print "</td></tr>\n\n";
		print "</table></td></tr>";
		
		# Signature
		print "<tr><td>";
		print "<table cellpadding=0 cellspacing=0 border=0>\n";
		print "<tr>";
		print "<td valign=middle nowrap>", $FontFace,$FontSize;
		print "Signature</td></tr>\n";
		print "<tr><td>", $FontFace, $FontSize;
		$U_Sig =~ s/\"/\&quot\;/g;
		print "<input type=text name=sig size=50 maxlength=200 ";
		print "value=\"", $U_Sig, "\">";
		print "</td></tr>\n\n";
		print "</table></td></tr>";

		# Sixth row of headings - Photos
		print "<tr><td>";
		print "<table cellpadding=0 cellspacing=0 border=0>\n";
	
		print "<td valign=bottom nowrap>", $FontFace,$FontSize, $FontRed;
		print "Small Photo &nbsp;</td>\n";
		print "<td valign=bottom nowrap>", $FontFace,$FontSize, $FontRed;
		print "Large Photo</td>\n";
		print "</tr>\n";
	
		# Sixth row of input fields
		if (&IS_FAC($U_Perms)) {
			$highlight = $Ffacultyhilight;
		} else {
			$highlight = $Fstudenthilight;
		}
	
		if ($adduser ne "") {
			if (-e $C_photodir . $adduser . ".gif") {
				$U_PhotoName = $adduser . ".gif";
				$U_Photo = $C_photourl . $U_PhotoName;
				$U_PhotoLarge = $U_Photo;
				$U_PhotoLarge =~ s/\.gif$/\.jpg/i;
				$U_PhotoNameLarge = $adduser . ".jpg";
			} else {
				$U_PhotoName = "Guest.gif";
				$U_Photo = $C_photourl . $U_PhotoName;
				$U_PhotoLarge = $U_Photo;
				$U_PhotoLarge =~ s/\.gif$/\.jpg/i;
				$U_PhotoNameLarge = "Guest.jpg";
				$highlight = $Fstudenthilight;
			}
		}
	
		print "<tr>";
		print "<input type=hidden name=photo value=\"$U_PhotoName\">";
	
		print "<td valign=middle align=center nowrap>", $FontFace,$FontSize;
		print "<table cellpadding=0 cellspacing=0 border=0 width=20><tr>";
		print "<td valign=middle align=center height=25 width=20 bgcolor=$highlight nowrap>";

		if ($adduser eq "") {
			print "<a href=javascript:PhotoChooser(\'$getuser\','small')>";
			print "<img src=", $U_Photo, "?", time(), " border=0 name=small width=16 height=21>";
			print "</a>";
		} else {
			print "<a href=javascript:PhotoChooser(\'$adduser\','small')>";
			print "<img src=", $U_Photo, " border=0 name=small width=16 height=21>";
			print "</a>";
		}
		print "</td></tr></table>";
		print "</td>\n";

		print "<input type=hidden name=photo2 value=\"$U_PhotoNameLarge\">";
	
		print "<td valign=middle align=center nowrap>", $FontFace,$FontSize;
		print "<table cellpadding=0 cellspacing=0 border=0 width=36><tr>";
		print "<td valign=middle align=center height=46 width=36 bgcolor=$highlight nowrap>";

		if ($adduser eq "") {
			print "<a href=javascript:PhotoChooser(\'$getuser\','large')>";
			print "<img src=", $U_PhotoLarge, "?", time(), " border=0 name=large width=32 height=42>";
			print "</a>";
		} else {
			print "<a href=javascript:PhotoChooser(\'$adduser\','large')>";
			print "<img src=", $U_PhotoLarge, " border=0 name=large width=32 height=42>";
			
			print "</a>";
		}
		print "</td></tr></table>";
		print "</td>\n";
	
		print "<td valign=middle align=left>", $FontFace, $FontSize;
		print "Click photos to make changes</td>";
	
		print "</tr></table></td></tr>\n\n";
	} else {
		print "<input type=hidden name=photo value=\"Guest.gif\">\n";
		print "<input type=hidden name=photo2 value=\"Guest.jpg\">\n";
	}
		

	# Print dividing line
	print "<tr><td valign=middle>";
	print "<img src=$ImgSrcClearDot width=20 height=8></td></tr>";	
	
	# Submission
	
	print "<tr><td>", $FontFace,$FontSize;
	if ($Demo) {
		print $BtnFormSubmitDemo;
	} else {
		print $BtnFormSubmit;
	}
	print "&nbsp;&nbsp;&nbsp;&nbsp;";
	print $FontRed, "Red Highlighted</font>";
	print " fields must be filled before submitting<br><br>";
	print "</td></tr>\n\n";
	
	# Print dividing line
	print "<tr><td valign=middle bgcolor=$FTheaderback>";
	print "<img src=$ImgSrcClearDot width=20 height=2></td></tr>";	
	
	print "</table>";
	
	print "</form>\n\n";
	print "<!-- End of user input -->\n\n";
}

