#!/usr/local/bin/perl

###############################################################################
#
# initialize.pl - panFora initialization script
#
# AUTHOR:	Shawn Stepper, wiTHinc Inc.
# AUTHOR:	George Toye, wiTHinc Inc.
# DATE:		$Date: 2001/07/16 21:07:51 $ (last modified)
# COPYRIGHT:	1998, 1999, 2000, 2001 wiTHinc Inc. All Rights Reserved.
#
###############################################################################

use Config;

$FileRevision = '$Id: initialize.pl,v 1.19.2.1 2001/07/16 21:07:51 stepper Exp $';
$Version = '1.4.0';

$instemail = 'installed@withinc.com';

if (@ARGV[0] eq "-v" || @ARGV[0] eq "--version") {
	print "File:		$0\n";
	print "Revision:	$FileRevision\n";
	print "Version:	$Version\n";
	exit();
}

# $< is the numerical user id
$uid = getpwuid($<);

# Perl version
$version = $];

print "\n";
print "This installer will walk you through the steps required to set\n";
print "up the panFora system. Perl version 5.004 or greater is required\n";
print "to set up and run panFora. It is highly\n";
print "recommended that you be logged in as root during the install\n";
print "process.\n\n";

print "This installer will ask you several questions. Defaults will be\n";
print "provided in brackets after each question (e.g. [YES]). Just hit\n";
print "the enter key to accept the default, or you can type in a different\n";
print "value.\n\n";

print "Press the Enter key to continue. ";
&readinput;
print "\n";

# Force agreement to the license
if (! -e "./.licenseAgree") {
	if (! -e "./LICENSE") {
		print "ERROR\n";
		print "License file not found! Please contact wiTHinc technical\n";
		print "support at techsupp\@withinc.com to request a license file.\n\n";
		exit();
	}

	print "To install panFora, you must agree to the following license ";
	print "agreement.\n\n";

	open(f, "./LICENSE");
	@licfile = <f>;
	close(f);
	
	for ($i=0; $i < @licfile; $i++) {
		if ($i % 20 == 0 && $i != 0) {
			print "\n";
			print "[Press the Enter key to continue]";
			&readinput;
			print "\n";
		}
		print @licfile[$i];
	}
	
	print "\nDo you agree to the terms of the license (Y/N)? [N]: ";
	if ( ! &yesno("N")) {
		&doCancel;
	}
	print "\n";
	
	open(f, ">./.licenseAgree");
	print f "License-Agree=I Agree to the License Terms";
	close(f);
}

# Is this person root?
$isroot = ($uid eq "root");

if (! $isroot) {
	print "You are not logged in as root. Would you like to continue with\n";
	print "the installation anyway (Y/N)? [N]: ";
	if ( ! &yesno("N")) {
		&doCancel;
	}
}

print "\n";

# Perl path
$perlpath = @ARGV[0];
if ($perlpath eq "") {
	$perlpath = $Config{"perlpath"};
	
	if ($perlpath !~ /perl/i) {
		$perlpath = "/usr/local/bin/perl";
	}
	$perlloc = $perlpath;
	
	$vers = `$perlloc \-e "print $]"`;
	
	while ($vers < 5) {
		print "Please enter the full path to your perl 5 interpreter [$perlpath]: ";
		$perlloc = &readinput;
		
		if ($perlloc eq "") {
			$perlloc = $perlpath;
		}
	
		$vers = `$perlloc \-e "print $]"`;
	}
	$perlpath = $perlloc;
}

$vers = `$perlpath \-e "print $]"`;

$goodvers = 5.004;
$goodvers = -1;
if ($vers < $goodvers) {
	print "\nYour version of perl: $vers is less than the required version: $goodvers.\n";
	print "If you continue with the installation, you will need to rebuild\n";
	print "the CGI and DB_File perl modules. This program will attempt to\n";
	print "rebuild them for you. Continue (Y/N)? [N]: ";
	if ( ! &yesno("N")) {
		&doCancel;
	} else {
	
		# Attempt to build  modules
		$make = `make -v 2>/dev/null`;
		
		if ($make eq "") {
			print "Cannot find \"make\" to build the perl modules. You will\n";
			print "need to install \"make\" and a C compiler to build the Perl modules.";
			print "You can then build the modules by running the \"buildmods\"\n";
			print "shell script in this directory.";
			print "\n\n";
	
			print "Continue (Y/N)? [N]: ";
			if ( ! &yesno("N")) {
				&doCancel;
			}
			print "\n";
		} else {
			print "Atempting to build Perl modules...\n";
			print "Building DB_File.pm...\n";
			
			system("./buildmods");
			wait;
			
			print "Finished building perl modules.\n\n";
		}
	}
}

# Run fixperl to change #!/usr/local/bin/perl to what it should be in
# all programs.

print "Please enter the location of perl on your system. Hit Enter to\n";
print "accept the default.\n\n";

print "Found perl version $vers at $perlpath...\n\n";

print "Location of perl [$perlpath]: ";
$pp = &readinput;
if ($pp eq "") {
	$pp = $perlpath;
}

while ((! -e $pp && ! -x $pp) || -d $pp) {
	print "The specified location was invalid.\n";
	print "Location of perl [$perlpath]: ";
	$pp2 = &readinput;
	if ($pp2 ne "") {
		$pp = $pp2;
	}
}
$perlpath = $pp;

print "\n\n";

print "Changing the loction of perl in all programs.\n\n";

@results = `$perlpath ./fixperl.pl PerlFileList $perlpath`;
print @results;
print "\nFinished changing perl location in all programs.\n\n";

# Find out the webserver user id and group
if ($isroot) {
	$psflags = "auxw";
	if ($^O !~ /linux/i) {
		$psflags = "-afe";
	}

	print "Please enter the User ID of your web server process. If you don't\n";
	print "know what it is, you can run \"ps $psflags\" at the Unix command line\n";
	print "to see the User ID that is running the web server. Typically the\n";
	print "User ID is \"nobody\". ";
	
	# Try to get the user ID.
	@ps = `ps $psflags |grep httpd`;
	if (@ps > 0) {
		($defuid, @junk) = split(/\s+/, @ps[0]);
	}
	
	print "[", $defuid, "]: ";
	$httpduid = &readinput;
	if ($httpduid eq "") {
		$httpduid = $defuid;
	}
	
	print "\n";
	
	$defgid = "nogroup";

	# Do a lookup of the group, based on the user.
	($junk, $junk, $junk, $gid, @junk) = getpwnam($httpduid);
	$gname = getgrgid($gid);
	if ($gname ne "") {
		$defgid = $gname;
	}
	
	print "Please enter the Group ID of your web server process. This is\n";
	print "typically \"nogroup\". [$defgid]: ";
	$httpdgid = &readinput;
	if ($httpdgid eq "") {
		$httpdgid = $defgid;
	}
	
	print "\n";
	
	if ($httpduid ne "") {
		print "Changing ownership of all panFora files to $httpduid...\n";
		system("chown -R $httpduid .");
	} else {
		&warnOwnership;
		# Make directory world writable.
		system("chmod a+w .");
	}
	if ($httpdgid ne "") {
		print "Changing group of all panFora files to $httpdgid...\n";
		system("chgrp -R $httpdgid .");
	}
	print "\n";
} else {
	&warnOwnership;
	
	# Make directory world writable.
	system("chmod a+w .");
}

# Where is sendmail?
print "Please enter the location of the \"sendmail\" binary on your system.\n";
print "This is typically /usr/lib/sendmail or /usr/sbin/sendmail. Sendmail\n";
print "is required for all email functions in panFora.\n\n";
print "Checking for sendmail...";
if (-e "/usr/lib/sendmail" && -x "/usr/lib/sendmail") {
	print "..found sendmail at /usr/lib/sendmail.\n";
	$sendmail = "/usr/lib/sendmail";
} elsif (-e "/usr/sbin/sendmail" && -x "/usr/sbin/sendmail") {
	print "..found sendmail at /usr/sbin/sendmail.\n";
	$sendmail = "/usr/sbin/sendmail";
} else {
	print "..could not find sendmail.\n";
}
print "Location of sendmail [$sendmail]: ";
$sm = &readinput;
if ($sm eq "") {
	$sm = $sendmail;
}

while ((! -e $sm && ! -x $sm && $sm !~ /none/i) || -d $sm) {
	print "The specified location was invalid.\n";
	print "Location of sendmail (enter \"none\" to skip)[$sm]: ";
	$sm2 = &readinput;
	if ($sm2 ne "") {
		$sm = $sm2;
	}
}

print "\n";

if (-e $sm && -x $sm) {
	open(f, ">.conf");
	print f "sendmail\t$sm\n";
	close(f);
	if ($httpdgid ne "" && $httpduid ne "") {
		system("chgrp $httpdgid .conf");
		system("chown $httpduid .conf");
	} else {
		system("chmod a+w .conf");
	}
} else {
	print "You have not entered a valid location for sendmail. All mail \n";
	print "functions will be disabled!\n\n";
}

# Send email to installed@withinc.com
if (-e $sm && -x $sm && ! -e "./.sentInitMail") {
	if (open(f, "| $sm -t -oi")) {
		use Cwd;
		use Socket;
		
		$pwd = cwd;
	
		print f "To: $instemail\n";
		print f "From: $instemail\n";
		print f "Subject: New panFora Installation\n\n";
		print f "New panFora Installation\n\n";
		print f "Initialize Date:\n";
		print f &formatDate , "\n\n";
		print f "Server Address:\n";
		print f $ENV{"HOSTNAME"}, "\n\n";
		print f "Server IP Address:\n";
		print f inet_ntoa(inet_aton($ENV{'HOSTNAME'})), "\n\n";
		print f "Install Path:\n";
		print f $pwd, "\n\n";
		
		close(f);
		
		if (open(f, "> ./.sentInitMail")) {
			print f "Initialized=", &formatDate;
			close(f);
			if ($httpdgid ne "" && $httpduid ne "") {
				system("chgrp $httpdgid ./.sentInitMail");
				system("chown $httpduid ./.sentInitMail");
			} else {
				system("chmod a+w ./.sentInitMail");
			}
		}
	}
}

# Now ask for the panFora System Administrator Password.
print "Please choose a password for the panFora System Administrator. This\n";
print "is the password required to create and delete individual Forums.\n";
print "Choose this password carefully as it give full access to ALL Forums\n";
print "on the server.\n";

$pass = &getPassword;
&setPassword($pass);
if ($httpdgid ne "" && $httpduid ne "") {
	system("chgrp $httpdgid ./.forumadmin");
	system("chown $httpduid ./.forumadmin");
} else {
	system("chmod a+w ./.forumadmin");
}

print "\npanFora initialization finished!\n\n";

# Subroutines
sub yesno {
	local($default) = @_;
	local($response) = &readinput;
	
	if ($response eq "") {
		$response = $default;
	}
	if ($response =~ /^y/i) {
		return(1);
	}
	
	return(0);
}

sub readinput {
	local($linein);
	
	chomp($linein = <STDIN>);
	return($linein);
}

sub doCancel {
	print "\n*** Installation Cancelled ***\n\n";
	exit;
}

sub warnOwnership {
	print "It was not possible to change onwnership of the panFora files.\n";
	print "In order for the system to work, the panFora directory has been\n";
	print "made world writable. This action could be considered a security\n";
	print "hazard. It is recommended that you change the ownership of all\n";
	print "files in the panFora directory to the User ID of the web server.\n";
	print "Then you can remove world write permission from the panFora\n";
	print "directory. You will need to be logged in as root to change the\n";
	print "ownership as required.\n\n";
}

sub getPassword {
	print "Password: ";
	$pass1 = &readinput;
	print "Verify Password: ";
	$pass2 = &readinput;
	
	if ($pass1 ne $pass2) {
		print "\nThe passwords you entered do not match. Try again.\n\n";
		&getPassword;
	}
	
	return $pass1;
}

sub setPassword {
	local($pass) = @_;
	
	require "_STR.pl";
	
	$pw = &cryptPass($pass);
        
	open(f, ">./.forumadmin");
	print f $pw;
	close(f);

}

sub formatDate {
	($sec, $min, $hr, $day, $mon, $yr, $dow, $doy, $dls) = localtime(time());
	$mon += 1;
	if ($yr >= 100) { $yr = $yr - 100; }
	$postdate = sprintf("%02d-%02d-%02d", $mon, $day, $yr);
	
	# Put the time in 12 hour time
	if ($hr >= 12) {
		$hr -= 12;
		if ($hr == 0) { $hr = 12; }
		
		$ampm = "PM";
	} else {
		if ($hr == 0) {$hr = 12; }
		
		$ampm = "AM";
	}
	
	# Minutes are not preceded by a zero
	if (length($min) != 2) {
		$min = "0" . $min;
	}
	
	# Add the time to the date
	$posttime = "$hr:$min $ampm";
	$postdaytime = $postdate . " - " . $posttime;
	$retval = $postdaytime;
	
	return $retval;
}
