#!/usr/bin/perl

###############################################################################
#
# FUserAddSelf.cgi - Allow Users to add themselves to the forum
#
# AUTHOR:	Shawn Stepper, wiTHinc Inc.
# AUTHOR:	George Toye, wiTHinc Inc.
# DATE:		$Date: 2001/08/21 17:50:51 $ (last modified)
# COPYRIGHT:	1998, 1999, 2000, 2001 wiTHinc Inc. All Rights Reserved.
#
###############################################################################

$FileRevision = '$Id: FUserAddSelf.cgi,v 1.37.2.2 2001/08/21 17:50:51 stepper Exp $';
$Version = '1.4.0';

if (@ARGV[0] eq "-v" || @ARGV[0] eq "--version") {
	print "File:		$0\n";
	print "Revision:	$FileRevision\n";
	print "Version:	$Version\n";
	exit();
}

require "F_Init.pl";
require "U_Init.pl";

$sendmail = &lookupSendMail;

$Class = $CGIQuery->param('fid');
$adduser = $CGIQuery->param('adduser');
$what = $CGIQuery->param('what');
$func = $CGIQuery->param('func');
$newwin = $CGIQuery->param('newwin');

##### Support old cgi parameters
if ($Class eq "" ) {
	$oldparm = $CGIQuery->param('class');
	if ($oldparm ne "") {
		$Class = $oldparm;
	}
}

$foundclass = &lookupClass($Class);

if (! $foundclass) {
	$colors = &lookupColors(1);
	&loadColors($colors);
	
	&showErrorBackHTML("No $corf was specified or the specified $corf was not found.");
	exit();
}

# Load up color variables
&loadColors($ColorQueryString);

if ($func eq "menu") {
	$BodyTag = &makeBodyTag("Threads");
} else {
	$BodyTag = &makeBodyTag("Content");
}

if (!$C_Public) {
	# User is not allowed to self add. Instruct them to ask for an account
	&showHeaderBackHTML("Access Denied","<br>You need a user account to access the $corf. Please contact the $CorF Administrator to request an account.");
	exit();
}

$found = &lookupUser($CGIEnvUser);

###############################################################################
#
# Process submitted data

$FURL = "http://" . $ENV{'SERVER_NAME'};
if ($ENV{'SERVER_PORT'} ne "" && $ENV{'SERVER_PORT'} ne "80") {
	$FURL .= ":" . $ENV{'SERVER_PORT'};
}
if (! $isWin) {
	$FURL .= $C_rooturl . "/";
	$FURLHOME = $FURL;
	$PassURL = $FURL . $DIR_CGI . "/";
	$PassURL .= $CGI_ForumChangePass . "?fid=" . $Class;
	$FURL .= $DIR_CGI . "/" . $CGI_Forum . "?fid=" . $Class;
} else {
	$FURLHOME = $FURL . $C_rooturl . "/";
	$PassURL = $FURL . $DIR_CGI . "/";
	$PassURL .= $CGI_ForumChangePass . "?fid=" . $Class;
	$FURL .= $DIR_CGI . "/" . $CGI_Forum . "?fid=" . $Class;
}

if ($func eq "doedit") {
	&douseredit;
	exit();
} elsif ($func eq "dosect") {
	&doSectChange;
	exit();
} else {
	if ($found == 0 && $C_authtype =~ /webauth/i && $CGIEnvUser ne "Guest") {
		&showSectChange;
		exit();
	}
	
	# Add a new user
	
	&showHeaderBackHTML("Add Yourself to the $Class Forum", "<br>",0,0,1);
	
	if (($C_authtype =~ /webauth/i && $ENV{'SU_AUTH_USER'} eq "") || $C_authtype !~ /webauth/i) {
		print "In order to login to this forum, you will need a personal <b>User ";
		print "ID</b> and <b>Password</b> to uniquely identify yourself to the ";
		print "system.<p>\n";
	
		print "Please choose a User ID that is at least 3 characters long. ";
		print "If the ID you choose is already taken, you will be asked to ";
		print "choose another.\n";
		
		print "In order for your posted messages to be correctly attributed to ";
		print "you by name, your First Name and Last Name must be entered when ";
		print "establishing your account.<p>\n";
	} else {
		print "Your User ID and Email Address are shown below. If the ID ";
		print "shown is not yours, please <a href=/webauth-logout>";
		print "logout</a> and then come back. If the ID is correct \n";
		print "but the email address, first or last name is incorrect, ";
		print "please correct the incorrect fields.<p>\n";
	}
	
	if ($ForumAllowGuest && $newwin ne "true") {
		print "If you prefer not to add yourself as a user, you can ";
		print "<a href=$FURL target=_top>return to the $Class Forum</a> ";
		print "and log in as user Guest, with password Guest.<p>\n";
	}
	
	# Set up some defaults for the user
	$U_SUID = "";
	$U_NameFirst = "";
	$U_NameLast = "";
	$U_NamePref = "";
	$U_Pass = "";
	$U_Email = "";
	$U_Phone = "";
	$U_Perms = 3;
	$U_C_Sect = $Class . ":" . "1";
	$U_Photo = "Guest.gif";
	$U_PhotoLarge = "Guest.jpg";
	$U_Classify = "1";
	$U_ProfileText = "No Personal Information Provided";
	$U_HideEmail = "0";
	
	&printuserinput;	
}

sub doSectChange {
	local($retval);
	$U_C_Sect = $CGIQuery->param('section');
	
	# Turn on signal Handling
	$trapSignals = 1;
	
	##########################################################
	# Add user to database
	$retval = &addtodb($CGIEnvUser);
	if ($retval) {
		&userDBError($retval);
	}
	#
	##########################################################
	
	##########################################################
	# Add user to htgroup
	&delfromht($CGIEnvUser);
	&addtoht($CGIEnvUser, $U_C_Sect);
	#
	##########################################################
	
	##########################################################
	# Modify mailing lists as needed
	&delfrommail($CGIEnvUser);
	&addtomail($CGIEnvUser);
	#
	##########################################################

	# rebuild mailing lists from scratch
	&rebuildmail;
	
	# If we got a signal, exit here.
	if ($gotSignal) {
		close(DEVNULL);
		exit(0);
	}
	
	&showHeaderBackHTML("Your $SorG has been Successfully Changed", "<br>",0,0,1);
	
	if ($newwin eq "true") {
		print "<center>\n";
		print "<form>";
		print "<input type=button value='Close Window' onClick=window.close()>";
		print "</form>\n";
	} else {
		print "You can enter the Forum at:<p>\n";
		print "<a href=$FURL";
		if ($newwin eq "true") {
			print " target=ForumMain";
		} else {
			print " target=_top";
		}
		print ">$FURL</a><p>\n";
	}
}

sub douseredit {
	&clearUserData;
	&loadSubInfo;
	
	if ($adduser =~ /[^\d\w]/ || length($adduser) < 3) {
		&showErrorBackHTML("$FontRed Please choose a User ID containing only letters and numbers. Your ID must be at least 3 characters long.</font>",0);
		&printuserinput;
		exit();
	}

	# we need to make sure that the new id doesn't already exist...
	local($status) = &lookupUser($adduser);
	&clearUserData;
	&loadSubInfo;
	
	if ($status == 0 || $adduser eq "Guest" || $adduser eq "Anonymous") {
		&showErrorBackHTML("$FontRed The new User ID you have chosen already exists. Please choose a different ID.</font>",0);
		&printuserinput;
		exit();
	}
	
	
	if ($adduser eq "") {
		&showErrorBackHTML("$FontRed You must provide a User ID.</font>");
		&printuserinput;
		exit();
	}
	
	if ($U_Email !~ /.*\@.*\..*/) {
		# Check that email has something@something.something
		&showErrorBackHTML("$FontRed You must enter a VALID email address.</font>");
		&printuserinput;
		exit();
	}
	
	if (length($U_SUID) == 7) {
		$U_SUID = "0" . $U_SUID;
	}
	if ($C_authtype =~ /webauth/i && ($U_SUID =~ /\D/ || length($U_SUID) != 8)) {
		&showErrorBackHTML("$FontRed You must enter your full Stanford University ID (SUID)</font>");
		&printuserinput;
		exit();
	}

	
	if ($U_NameFirst eq "" || $U_NameLast eq "") {
		&showErrorBackHTML("$FontRed You must provide a first and last name.</font>");
		&printuserinput;
		exit();
	}

	$U_Pass = &genPass;
	
	# Turn on signal Handling
	$trapSignals = 1;

	##########################################################
	# Add user to database
	$retval = &addtodb($adduser);
	if ($retval) {
		&userDBError($retval);
	}
	#
	##########################################################
	
	##########################################################
	# Add user to htgroup
	&addtoht($adduser, $U_C_Sect);
	#
	##########################################################
	
	##########################################################
	# Add user photos
	&addphoto($adduser);
	#
	##########################################################
	
	##########################################################
	# Modify mailing lists as needed
	&addtomail($adduser);
	#
	##########################################################
	
	# send an email to the new user
	if ($C_authtype !~ /webauth/i) {
		&sendUserPass;
	}
	
	# rebuild mailing lists from scratch
	&rebuildmail;
	
	# If we got a signal, exit here.
	if ($gotSignal) {
		close(DEVNULL);
		exit(0);
	}
	
	# Done!
	
	&showHeaderBackHTML("You have been added to the $Class Forum", "<br>",0,0,1);

	if ($C_authtype !~ /webauth/i) {
		print "Your password has been mailed to the email address given. <p>\n";
		print "Once you receive your password, you can log in to the Forum at:<p>\n";
		print "<a href=$FURL";
		if ($newwin eq "true") {
			print " target=ForumMain";
		}
		print ">$FURL</a><p>\n";
		
		print "Once you have logged in, you can change your password by clicking ";
		print "on the \"New Pass\" button.<p>\n";
	} else {
		print "You can log in to the Forum at:<p>\n";
		print "<a href=$FURL";
		if ($newwin eq "true") {
			print " target=ForumMain";
		}
		print ">$FURL</a><p>\n";
	}
	
	if ($C_authtype =~ /apache/i && $C_authtype !~ /webauth/i) {
		print $FontRed, "Note:</font> You will have to quit your browser and ";
		print "then return to the Forum in order to log in with your new ID.\n";
		print "<p>\n";
	}
	
	if ($newwin eq "true") {
		print "<center>\n";
		print "<form>";
		print "<input type=button value='Close Window' onClick=window.close()>";
		print "</form>\n";
	}
}


sub printuserinput {
	# Print out photo chooser jsavascript
	# &printphotochooser;

	print $FontSize, $FontFace;
	print $FontRed, "Red Highlighted</font>";
	print " fields must be filled before submitting<br><br>";

	# Start Form
	print "<form action=$CGIEnvScript method=POST>\n";
	
	# Special flag so we know what we are doing
	print "<input type=hidden name=func value=\"doedit\">\n\n";
	
	print "<input type=hidden name=returnto value=\"$returnto\">\n\n";
	
	print "<input type=hidden name=fid value=\"$Class\">";
	print "<input type=hidden name=newwin value=\"$newwin\">";
	
	&printUserAddSelf;

	print "<table cellpadding=0 cellspacing=0 border=0 width=100%>\n";
	
	if ($C_authtype !~ /webauth/i) {
		print "<tr><td valign=middle>", $FontFace, $FontSize, $FontRed;
		print "Note:</font> It is very important that you enter your real email ";
		print "address. You password will be emailed to the address you ";
		print "provide here. Please double check your email address for correctness.";
		print "</td></tr>";
	}
	
	# Print dividing line
	print "<tr><td valign=middle>", $FontFace,$FontSize;
	print "&nbsp;</td></tr>\n";
	
	# Submission
	
	print "<tr><td>", $FontFace,$FontSize2;
	print "<input type=submit name=submit value=Submit></font></font>\n";
	print "</td></tr>\n\n";
	
	print "</table>\n";
	
	print "</form>\n\n";
	print "<!-- End of user input -->\n\n";
	
	# Get panfora root url
	if (-e ".conf") {
		open(conf, ".conf");
		while(<conf>) {
			$line = $_;
			chomp($line);
			if ($line =~ /^panForaURL/) {
				($junk, $panForaURL) = split(/\t/, $line);
			}
		}
		close(conf);
	}
		
	if ($C_authtype =~ /cookie/i) {
		print $FontRed, "* ";
		print "Already have an account?</font> <a href=$CGI_ForumCookieLogin";
		print "?fid=$Class&newwin=$newwin onClick=resizeWin(300,200)>";
		print "Click here to login!</a><p>";
		
		print "<a href=";
		if ($panForaURL ne "") {
			print $panForaURL, "/";
		}
		print "$CGI_ForumChangePass?func=forgot\&";
		print "fid=$Class&newwin=$newwin onClick=resizeWin(300,200)>";
		print "Forgot your password?</a><p>";
	} elsif ($C_authtype !~ /webauth/i && $C_authtype !~ /external/i) {
		# Need to use the panFora root url here.
	
		print $FontRed, "* ";
		print "Already have an account, but </font>";
		print "<a href=";
		if ($panForaURL ne "") {
			print $panForaURL, "/";
		}
		print "$CGI_ForumChangePass?func=forgot\&";
		print "fid=$Class&newwin=$newwin onClick=resizeWin(300,200)>";
		print "Forgot your password?</a><p>";
	}
	
	print "<script language=javascript>\n<!--\n";
	print "function resizeWin(w,h) {\n";
	if ($newwin eq "true") {
		print "	self.resizeTo(w,h);\n";
	}
	print "}\n";
	print "//-->\n</script>\n";
}

sub showSectChange {
	&showHeaderBackHTML("Change Your $SorG in the $Class Forum", "<br>",0,0,1);
	
	print "Your current $sorg is selected. You may change $sorgs by ";
	print "changing the selection and clicking the Submit button.<p>\n";
	
	# Start Form
	print "<form action=$CGIEnvScript method=POST>\n";
	
	# Special flag so we know what we are doing
	print "<input type=hidden name=func value=\"dosect\">\n\n";
	
	print "<input type=hidden name=returnto value=\"$returnto\">\n\n";
	
	print "<input type=hidden name=fid value=\"$Class\">";
	print "<input type=hidden name=newwin value=\"$newwin\">";
	
	print "<select name=section>";
	for ($j=1; $j <= $C_Sect_n; $j++) {
		print "<option value='", $Class, ":", $C_Sects{$j}{"num"}, "'";
		
		if ($U_C_Sect eq $Class . ":" . $C_Sects{$j}{"num"}) {
			print " selected";
		}
		
		print ">";
		print $C_Sects{$j}{"name"}, "\n";
	}
	print "</select><p>";
	
	print $BtnFormSubmit;

	print "</form>\n";
}

sub loadSubInfo {
	$adduser = $CGIQuery->param('adduser');
	$U_SUID = $CGIQuery->param('SUID');
	$U_NameFirst = $CGIQuery->param('firstname');
	$U_NameLast = $CGIQuery->param('lastname');
	$U_NamePref = $CGIQuery->param('prefname');
	$U_Email = $CGIQuery->param('email');
	$U_Phone = $CGIQuery->param('phone');
	
	$U_Perms = 3;
	$section = $CGIQuery->param('section');
	if ($section eq "") {
		$U_C_Sect = $CGIQuery->param('classsection');
	} else {
		$U_C_Sect = $section;
	}
	$U_Classify = "1";
	$U_ProfileText = "No Personal Information Provided";
	$U_HideEmail = "0";
	
	$U_Photo = $CGIQuery->param('photo');
	$U_PhotoLarge = $CGIQuery->param('photo2');
}

sub sendUserPass {

	open (M, "| $sendmail ");
	print M <<end_print;
To: $U_Email
From: $Class Forum <$U_Email>
Subject: Your $Class Forum login information
MIME-Version: 1.0
X-Mailer: panFora $Version
Content-Type: multipart/alternative; boundary="------------1234567890987654321"

This is a multi-part message in MIME format.

--------------1234567890987654321
Content-Type: text/plain; charset=us-ascii
Content-Transfer-Encoding: 7bit

Welcome: $U_NameFirst $U_NameLast

Here is your login id for accessing the $Class Forum: $adduser
Here is your password for accessing the $Class Forum: $U_Pass

Note that your username and password are both case sensitive.

You can access the Forum Website using Netscape 4.0 or greater,
or Microsoft Internet Explorer 4.0 or greater at:	

$FURLHOME

and the Forum, directly, at:

$FURL

Once you have logged in, you can change your password by clicking the 
"New Pass" button.

If you don\'t know why you are receiving this email, it can safely be ignored.

--------------1234567890987654321
Content-Type: text/html; charset=us-ascii
Content-Transfer-Encoding: 7bit

<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<html>
Welcome: $U_NameFirst $U_NameLast
<p>
Here is your login id for accessing the $Class Forum: <b>$adduser</b><br>
Here is your password for accessing the $Class Forum: <b>$U_Pass</b><p>

Note that your username and password are both case sensitive.<p>

You can access the Forum Website using Netscape 4.0 or greater,<br>
or Microsoft Internet Explorer 4.0 or greater at:<p>

&nbsp;&nbsp;&nbsp; <a href=\"$FURLHOME\">$FURLHOME</a><p>

and the Forum, directly, at:<p>

&nbsp;&nbsp;&nbsp; <a href=\"$FURL\">$FURL</a><p>

Once you have logged in, you can change your password by clicking the <br>
\"New Pass\" button.

If you don\'t know why you are receiving this email, it can safely be ignored.
</html>

--------------1234567890987654321--

end_print
	
	close(M);
}
