#!/usr/bin/perl

###############################################################################
#
# _AFEdFile.cgi - Text File Upload, edit
#
# AUTHOR:	Shawn Stepper, wiTHinc Inc.
# AUTHOR:	George Toye, wiTHinc Inc.
# DATE:		$Date: 2001/08/21 17:50:52 $ (last modified)
# COPYRIGHT:	1998, 1999, 2000, 2001 wiTHinc Inc. All Rights Reserved.
#
###############################################################################

$FileRevision = '$Id: _AFEdFile.cgi,v 1.34.2.3 2001/08/21 17:50:52 stepper Exp $';
$Version = '1.4.0';

if (@ARGV[0] eq "-v" || @ARGV[0] eq "--version") {
	print "File:		$0\n";
	print "Revision:	$FileRevision\n";
	print "Version:	$Version\n";
	exit();
}

require "F_Init.pl";

$adminpass = $CGIQuery->cookie('panForaAdmin');
$forumadmin = &checkAdminPass($adminpass);

$Class = $CGIQuery->param('fid');
$func = $CGIQuery->param('func');
$mode = $CGIQuery->param('mode');
$start = $CGIQuery->param('start');
$file = $CGIQuery->param('file');

&lookupClass;
&lookupUser($CGIEnvUser);

&loadColors($ColorQueryString);


if ($func ne "menu") {
	$BodyTag = &makeBodyTag("Content");
} else {
	$BodyTag = &makeBodyTag("Threads");
}

if ($CGIEnvUser ne "Guest" && $CGIEnvUser ne "") {
	&checkCookieGuest($CGIEnvUser, $C_authtype);
}

# Kick the user out if they have the wrong permissions
if (!&IS_ADMIN($U_Perms) && !&IS_FAC($U_Perms) && !$forumadmin) {
	&showErrorBackHTML("You do not have permission to access this resource.");
	exit();
}

if ($mode eq "db" && !$forumadmin) {
		#$nexturl = escape($ENV{'SCRIPT_NAME'} . "?fid=$Class" . "&mode=db");
		$nexturl = escape(&buildNextURL);
		print $CGIQuery->redirect("$CGI_ClassCreate?what=login&fid=$Class&nexturl=$nexturl");
		exit();
}

###############################################################################
#
# Process submitted data

if ($func eq "doedits") {
	if ($Demo) {
		print $CGIQuery->redirect("Demo.html");
		exit();
	}
	&doFileEdits;	
} elsif ($func eq "dorestore") {
	if ($Demo) {
		print $CGIQuery->redirect("Demo.html");
		exit();
	}
	&doRestore;
} elsif ($func eq "dorestoreorig") {
	if ($Demo) {
		print $CGIQuery->redirect("Demo.html");
		exit();
	}
	&doRestoreOrig;
} elsif ($func eq "addfile") {
	&addFile;
} elsif ($func eq "rename") {
	if ($Demo) {
		print $CGIQuery->redirect("Demo.html");
		exit();
	}
	&renameFile;
} elsif ($func eq "confdelete") {
	&confDelFile;
} elsif ($func eq "dodelete") {
	if ($Demo) {
		print $CGIQuery->redirect("Demo.html");
		exit();
	}
	&doDelFile;
} elsif ($func eq "showedit" || ($start ne "" && $func eq "nothing")) {
	# File chosen, print out editing page.
	
	if (($file !~ /^$C_rootpath/ || $file =~ /\.\.\//) && $file ne "classes.db") {
		&showErrorBackHTML("Illegal file choice.");
		print "FILE = $file\n";
		exit();
	}

	if ($file =~ /\.db$/ && $mode eq "db" && $forumadmin) {
		&dumpdb($file);
		exit();
	}
	
	$fname = $file;
	$fname =~ s/$C_rootpath\///;
	
	$fileurl = $file;
	$fileurl =~ s/^$C_rootpath/$C_rooturl/;
	
	if ($start eq "home") {
		$file = $C_rootpath . "/" . "home.html";
		$wrap = "none";
	}
	
	if ($wrap ne "none" && $wrap ne "") {
		$wrap = "wrap=" . $wrap;
	} else {
		$wrap = "";
	}
	
	if (! -e $file && $file =~ /\.html$/) {
		# Rebuild the file from the template file.
		if ($isWin) {
			$template = "./" . $DIR_NEWCLASS . "/";
		} else {
			$template .= $C_rootpath . "/" . $DIR_CGI . "/" . $DIR_NEWCLASS . "/";
		}
		@getfname = split(/\//, $file);
		$lastone = @getfname - 1;
		$template .= @getfname[$lastone];
		if (-e $template) {
			&genFile($template, $file);
		} else {
			&showErrorBackHTML("File does not exist.");
			exit();
		}
	}
	
	if (! -w $file) {
		&showHeaderBackHTML("Permission Denied", "<br>");
		print "You do not have permission to edit the selected file. Please ";
		print "contact the panFora System Administrator and request that you be given ";
		print "write permission to the file: $file.";
		exit();
	}
	
	$helplink = "file=EditHTMLPagesCORP_Admin.html";
	$helplink .= "&anchor=EditHTMLEdtFSummary";
	$helplink .= "&helptitle=Edit/Upload%20HTML%20Pages";
	
	&showHeaderBackHTML("Editing File: $fileurl", "<br>", 0, 0, 0, $helplink);
	
	print "<table cellpadding=0 cellspacing=0 border=0 width=100%>\n";
	
	# Start Form
	print "<form action=$CGIEnvScript method=POST enctype='multipart/form-data'>\n";
	print "<input type=hidden name=fid value=\"$Class\">\n";
	print "<input type=hidden name=file value=\"$file\">\n";
	print "<input type=hidden name=func value=\"doedits\">\n";
	
	# Warning for .ht, .ba and .webauth files
	if ($fname =~ /^\.ht|^\.ba|^\.webauth/) {
		print "<tr><td>", $FontFace, $FontSize2, $FontRed;
		print "Warning!!!</font> ";
		print "Modifying this file may cause your Forum to become ";
		print "inaccessible for some or all users!";
		print "<br>&nbsp;";
		print "</td></tr>\n";
	}

	# Image
	if ($file =~ /\.jpg$|\.gif$|\.jpeg$|\.png$|\.bmp$|\.tif$/i) {
		$filetype = "image";
	
		print "<tr><td>", $FontFace, $FontSize2;
		print "Image\n";
		print "</td></tr>\n";
		
		print "<tr><td>", $FontFace, $FontSize;
		print "<br><blockquote>";
		print "<img src=\"$fileurl\">";
		print "</blockquote>";
		print  "</td></tr>\n";
	# Link to the file
	} elsif ($file =~ /\.doc$|\.xls$|\.pdf$|\.mpg$|\.wav$|\.mov$|
						\.zip$|\.sit$|\.gz$|\.tgz$|\.tar$/isx) {
		$filetype = "unknown";
		print "<tr><td>", $FontFace, $FontSize2;
		print "Unknown File Type\n";
		print "</td></tr>\n";

		print "<tr><td>", $FontFace, $FontSize;
		print "<br><blockquote>";
		print "<a href=\"$fileurl\" target=_blank>";
		print $fileurl, "</a>";
		print "</blockquote>";
		print  "</td></tr>\n";
	# Text File (Default)
	} else {
		$filetype = "text";
		print "<tr><td>", $FontFace, $FontSize2;
		print "Manual Editing\n";
		print "</td></tr>\n";

		print "<tr><td>", $FontFace, $FontSize;
		print "<textarea rows=16 cols=80 name=edits $wrap>";
	
		open(f, $file);
		while (<f>) {
			$tmp = $_;
			# escape &'s
			$tmp =~ s/\&/\&amp\;/g;
			print $tmp;
		}
		close(f);
	
		print "</textarea>\n";
		print "</td></tr>";
	}
	
	# Submit button
	if ($filetype eq "text") {
		print "<tr><td>";
		print $FontFace, $FontSize;
		# Include a base href tag for the preview?
		$base = 0;
		#if ($file !~ /home.html$/ && $file !~ /\/$DIR_CLASSFORUM\//) {
			$base = 1;
		#}
		print "<a href=javascript:Preview($base)>$BtnFormPreview</a> &nbsp;";
		if ($Demo) {
			print $BtnFormSubmitDemo;
		} else {
			print $BtnFormSubmit;
		}
		print " File Edits</td></tr>\n";
	}
	print "</form>";
	
	# Spacers and Dividing line
	print "<tr><td width=100%>";
	print "<img src=$ImgSrcClearDot width=20 height=4>";
	print "</td></tr>\n";
	print "<tr><td bgcolor=$FCheaderback width=100%>";
	print "<img src=$ImgSrcClearDot width=20 height=2>";
	print "</td></tr>\n";
	print "<tr><td width=100%>";
	print "<img src=$ImgSrcClearDot width=20 height=4>";
	print "</td></tr>\n";

	# Start Form
	print "<form action=$CGIEnvScript method=POST enctype='multipart/form-data'>\n";
	print "<input type=hidden name=fid value=\"$Class\">\n";
	print "<input type=hidden name=file value=\"$file\">\n";
	print "<input type=hidden name=func value=\"doedits\">\n";

	print "<tr><td>", $FontFace, $FontSize2;
	print "Upload Replacement File (MUST be same file type!)\n";
	print "</td></tr>\n";
	
	# Upload Field
	print "<tr><td>", $FontFace, $FontSize;
	print "<input type=file name=upload size=40>";
	print "</td></tr>\n";
	
	# Submit button
	print "<tr><td>";
	print $FontFace, $FontSize;	
	if ($Demo) {
		print $BtnFormSubmitDemo;
	} else {
		print $BtnFormSubmit;
	}
	print " New File</td></tr>\n";
	
	print "</form>";
	
	# Show option to restore previous version
	if (-e $file . ".bak") {
	
		# Spacers and Dividing line
		print "<tr><td width=100%>";
		print "<img src=$ImgSrcClearDot width=20 height=4>";
		print "</td></tr>\n";
		print "<tr><td bgcolor=$FCheaderback width=100%>";
		print "<img src=$ImgSrcClearDot width=20 height=2>";
		print "</td></tr>\n";
		print "<tr><td width=100%>";
		print "<img src=$ImgSrcClearDot width=20 height=4>";
		print "</td></tr>\n";
	
		print "<form action=$CGIEnvScript method=POST>\n";
		print "<input type=hidden name=fid value=\"$Class\">\n";
		print "<input type=hidden name=file value=\"$file\">\n";
		print "<input type=hidden name=func value=\"dorestore\">\n";
	
		print "<tr><td>", $FontFace, $FontSize2;
		print "If you made a mistake you can revert to the previous version.\n";
		print "</td></tr>\n";
		
		# Spacer
		print "<tr><td width=100%>";
		print "<img src=$ImgSrcClearDot width=20 height=4>";
		print "</td></tr>\n";
		
		# Submit button
		print "<tr><td>";
		print $FontFace, $FontSize;
		print "<input type=checkbox name=restore value=YES> Restore Backup ";
		if ($Demo) {
			print $BtnFormSubmitDemo;
		} else {
			print $BtnFormSubmit;
		}
		print "</td></tr>\n";
	
		print "</form>\n";
	}
	
	# Show option to restore original
	
	if ($filetype eq "text" && 
		$file =~ /\/nav\.html$|\/index\.html$|\/home\.html$/) {
		# Spacers and Dividing line
		print "<tr><td width=100%>";
		print "<img src=$ImgSrcClearDot width=20 height=4>";
		print "</td></tr>\n";
		print "<tr><td bgcolor=$FCheaderback width=100%>";
		print "<img src=$ImgSrcClearDot width=20 height=2>";
		print "</td></tr>\n";
		print "<tr><td width=100%>";
		print "<img src=$ImgSrcClearDot width=20 height=4>";
		print "</td></tr>\n";
	
		print "<form action=$CGIEnvScript method=POST>\n";
		print "<input type=hidden name=fid value=\"$Class\">\n";
		print "<input type=hidden name=file value=\"$file\">\n";
		print "<input type=hidden name=func value=\"dorestoreorig\">\n";
	
		print "<tr><td>", $FontFace, $FontSize2;
		print "You can restore the original default file.\n";
		print "</td></tr>\n";
	
		# Spacer
		print "<tr><td width=100%>";
		print "<img src=$ImgSrcClearDot width=20 height=4>";
		print "</td></tr>\n";
	
		# Submit button
		print "<tr><td>";
		print $FontFace, $FontSize;
		print "<input type=checkbox name=restore value=YES> Restore Original ";
		if ($Demo) {
			print $BtnFormSubmitDemo;
		} else {
			print $BtnFormSubmit;
		}
		print "</td></tr>\n";
	
		print "</form>\n";
		
	} else {
		# Rename or Delete file, but not the central 3 files that we include
		
		#Rename
		print "<form action=$CGIEnvScript method=POST>\n";
		print "<input type=hidden name=fid value=\"$Class\">\n";
		print "<input type=hidden name=file value=\"$file\">\n";
		print "<input type=hidden name=func value=\"rename\">\n";
		
		# Spacers and Dividing line
		print "<tr><td width=100%>";
		print "<img src=$ImgSrcClearDot width=20 height=4>";
		print "</td></tr>\n";
		print "<tr><td bgcolor=$FCheaderback width=100%>";
		print "<img src=$ImgSrcClearDot width=20 height=2>";
		print "</td></tr>\n";
		print "<tr><td width=100%>";
		print "<img src=$ImgSrcClearDot width=20 height=4>";
		print "</td></tr>\n";
		
		print "<tr><td>", $FontFace, $FontSize2;
		print "Rename. Enter a new filename and click Submit.\n";
		print "</td></tr>\n";
				
		# Spacer
		print "<tr><td width=100%>";
		print "<img src=$ImgSrcClearDot width=20 height=4>";
		print "</td></tr>\n";
		
		print "<tr><td>", $FontFace, $FontSize;
		print "<input type=text size=40 maxlength=64 name=newfilename value=\"$fname\">";
		if ($Demo) {
			print $BtnFormSubmitDemo;
		} else {
			print $BtnFormSubmit;
		}
		print "</td></tr>\n";
	
		print "</form>\n";
		
		# Delete
		print "<form action=$CGIEnvScript method=POST>\n";
		print "<input type=hidden name=fid value=\"$Class\">\n";
		print "<input type=hidden name=file value=\"$file\">\n";
		print "<input type=hidden name=func value=\"confdelete\">\n";
		
		# Spacers and Dividing line
		print "<tr><td width=100%>";
		print "<img src=$ImgSrcClearDot width=20 height=4>";
		print "</td></tr>\n";
		print "<tr><td bgcolor=$FCheaderback width=100%>";
		print "<img src=$ImgSrcClearDot width=20 height=2>";
		print "</td></tr>\n";
		print "<tr><td width=100%>";
		print "<img src=$ImgSrcClearDot width=20 height=4>";
		print "</td></tr>\n";
		
		print "<tr><td>", $FontFace, $FontSize2;
		print "Click the Delete button to permanently delete this file.\n";
		print "</td></tr>\n";
				
		# Spacer
		print "<tr><td width=100%>";
		print "<img src=$ImgSrcClearDot width=20 height=4>";
		print "</td></tr>\n";
		
		print "<tr><td>", $FontFace, $FontSize2;
		if ($Demo) {
			print $BtnFormDelDemo;
		} else {
			print $BtnFormDel;
		}
		print "</td></tr>\n";
	
		print "</form>\n";
	}
	
	print "</table>\n\n";

	&printJSPreview;
	
# End of data processing
#
##########################################################	

} elsif ($func eq "menu") {

	#####################################################
	# Class chosen show list of editable files
	#####################################################
	
	if ($mode eq "db") {
		$cookie = $CGIQuery->cookie(-name=>'panForaAdmin',
								-value=>"$cryptAdminPass",
								-path=>'/');
	
		$helplink = "file=ForumViewDatabaseCORP_Admin.html";
		$helplink .= "&anchor=ViewDatabaseTskFSummary";
		$helplink .= "&helptitle=View%20Database%20Content%20Task%20Frame";
		
		&showHeaderBackHTML("View Database Contents for $CorF - $Class",
							"", 0, 1, 0, $helplink, $cookie);
	} else {
		$helplink = "file=EditHTMLPagesCORP_Admin.html";
		$helplink .= "&anchor=EditHTMLTskFSummary";
		$helplink .= "&helptitle=Upload%20/%20Edit%20HTML%20Pages%20Task%20Frame";
		
		&showHeaderBackHTML("Edit Files for $CorF - $Class",
							"", 0, 1, 0, $helplink);
	}

	# Start Form
	print "<form action=$CGIEnvScript method=GET target=fileedit>\n";
	print "<input type=hidden name=fid value=\"$Class\">\n";
	print "<input type=hidden name=mode value=$mode>\n";
	print "<input type=hidden name=func value=showedit>\n\n";
	
	# Print form
	print "<table cellpadding=0 cellspacing=0 border=0>\n";
	print "<tr><td valign=bottom colspan=2>";
	print $FontFace, $FontSize, $ImgClear88;
	if ($forumadmin && $mode eq "db") {
		print "Choose Database to View: ";
	} else {
		print "Edit file: ";
	}
	print "</td>\n";
	
	if ($mode ne "db") {
		print "<td>$ImgClear88</td>\n";
		print "<td width=2 bgcolor=$FTheaderback>";
		print "<img src=$ImgSrcClearDot width=2></td>\n";
		print "<td>$ImgClear88</td>\n";
	
		print "<td valign=bottom>";
		print $FontFace, $FontSize;
		print "Add New File:";
		print "</td>\n";
	}
	print "</tr>\n";
	 
	# Second row
	print "<tr><td valign=middle>";
	print $FontFace, $FontSize, $ImgClear88;
	print "<select name=file>\n";
	
	# Options for raw dbfile dump
	if ($forumadmin && $mode eq "db") {
		if ($isWin) {
			print "<option value='", $DBFILE_CLASSID;
		} else {
			print "<option value='", $C_rootpath . "/" . $DIR_CGI . "/" . $DBFILE_CLASSID;
		}
		print "'> panFora Database\n";
		print "<option value='", $C_rootpath . "/" . $DIR_CONFIG . "/" . $DBFILE_CLASSINFO;
		print "'> $CorF Database\n";
		print "<option value='", $C_rootpath . "/" . $DIR_CLASSFORUM . "/" . $DBFILE_FSUBJ;
		print "'> Topics Database\n";
		print "<option value='", $C_rootpath . "/" . $DIR_CONFIG . "/" . $DBFILE_USERINFO;
		print "'> Users Database\n";
		$newDB = $C_rootpath . "/" . $DIR_CLASSFORUM . "/" . $DBFILE_FALL;
		if (! -e $newDB) {
			$newDB = $C_rootpath . "/" . $DIR_CLASSFORUM . "/" . $DBFILE_FNEW;
		}
		print "<option value='", $newDB;
		print "'> New Posts Database\n";
		print "<option value='", $C_rootpath . "/" . $DIR_CLASSFORUM . "/" . $DBFILE_STATS;
		print "'> Stats Database\n";
	} else {
		print "<option value='", $C_rootpath , "/" . "index.html";
		print "'> Home Page (", $C_rooturl , "/" . "index.html)\n";
		print "<option value='", $C_rootpath , "/" . "nav.html";
		print "'> Home Page Navigation Menu (", $C_rooturl , "/" . "nav.html)\n";
		#print "<option value='", $C_rootpath , "/" , "home.html";
		#print "'> ", $C_rooturl , "/" , "home.html";
		
		# Get additional files
		@ls = glob($C_rootpath . "/*");
		push(@ls, glob($C_rootpath . "/.*"));
		for ($i=0; $i < @ls; $i++) {
			if (-d @ls[$i] || -l @ls[$i]) {
				next;
			}
			if (@ls[$i] =~ /.bak$/i || @ls[$i] =~ /index.html$/ || 
					@ls[$i] =~ /nav.html$/ || @ls[$i] =~ /.lock$/i) {
				next;
			}
			print "<option value=\"" . @ls[$i] . "\"> ";
			@ls[$i] =~ s/^$C_rootpath/$C_rooturl/;
			print @ls[$i], "\n";
		}
	}
	print "</select></td>\n";
	
	#print "<td valign=middle>";
	#print $FontFace, $FontSize, $ImgClear88;
	#print "<input type=radio value='none' name=wrap checked>None \n";
	#print "<input type=radio value='virtual' name=wrap>Soft \n";
	#print "<input type=radio value='hard' name=wrap>Hard \n";
	#print "</td>\n";
	
	print "<td valign=middle align=left>", $FontSize, $FontFace;
	# print $ImgClear88;
	if ($mode eq "db") {
		print $BtnFormSubmit;
	} else {
		print $BtnFormEdit;
	}
	print "</td>\n";
	
	print "</form>\n";
	
	# Add New File
	if ($mode ne "db") {
		print "<td>$ImgClear88</td>\n";
		print "<td width=2 bgcolor=$FTheaderback>";
		print "<img src=$ImgSrcClearDot width=2></td>\n";
		print "<td>$ImgClear88</td>\n";
		
		print "<form action=$CGIEnvScript method=GET target=fileedit>\n";
		print "<input type=hidden name=fid value=\"$Class\">\n";
		print "<input type=hidden name=mode value=$mode>\n";
		print "<input type=hidden name=func value=addfile>\n\n";
		
		print "<td>", $FontFace, $FontSize;
		print $BtnFormAdd;
		print "</td>\n";
		
		print "</form>\n";
	}
	
	print "</tr>\n\n";

	print "</table>\n";
	print "</body></html>\n";
	
} elsif ($func eq "nothing") {
	# User input nothing, tell them to select something
	&printEmptyTaskFrame("Please select a file above.");
	
} else {
	# Print out frameset
	if ($forumadmin) {
		$cookie = $CGIQuery->cookie(-name=>'panForaAdmin',
								-value=>"$cryptAdminPass",
								-path=>'/');
								
		print $CGIQuery->header(-cookie=>$cookie);
	} else {
		print $CGIQuery->header;
	}
	
	print "<html><head><title>$Class Forum File Editing</title>\n";
	&printJavascript;
	print "</head>\n";
	print "<frameset rows='120,*' border=2>\n";
	print "	<frame name=filemenu ";
	print "src=$CGIEnvScript?fid=$Class&func=menu&start=$start&mode=$mode ";
	print "frameborder=1 marginheight=0 marginwidth=0>\n";
	print "	<frame name=fileedit ";
	print "src=$CGIEnvScript?fid=$Class&func=nothing&start=$start&mode=$mode ";
	print "frameborder=1 marginheight=0 marginwidth=0>\n";
	print "</frameset>\n";
}

#
########

sub doFileEdits {
	$file = $CGIQuery->param('file');
	$edits = $CGIQuery->param('edits');
	$upload = $CGIQuery->param('upload');
	
	# Turn on signal Handling
	$trapSignals = 1;
	
	rename($file, $file . ".bak");

	if ($upload ne "") {
		open(f, ">$file");
		while(<$upload>) {
			print f $_;
		}
		close(f);
	} else {
		open(f, ">$file");
		print f $edits;
		close(f);
	}
	
	# If we got a signal, exit here.
	if ($gotSignal) {
		close(DEVNULL);
		exit(0);
	}

	&showHeaderBackHTML("Changes Saved", "<br>");
	print "The file has been saved.";

}

sub doRestore {
	$file = $CGIQuery->param('file');
	$restore = $CGIQuery->param('restore');
	
	if ($restore eq "YES") {
		# Do it.
		rename($file . ".bak", $file);
		&showHeaderBackHTML("Previous Version Restored", "<br>");
		print "The previous version of the document has been restored.\n";
	} else {
		# Don't do it
		&showHeaderBackHTML("No Changes Made", "You must check the checkbox to perform a restore action.", 1);
	}
}

sub doRestoreOrig {
	$file = $CGIQuery->param('file');
	$restore = $CGIQuery->param('restore');
	
	if ($restore eq "YES") {
		# Do it.
		
		# Turn on signal Handling
		$trapSignals = 1;
		
		rename($file, $file . ".bak");
		
		# Rebuild the file from the template file.
		if ($isWin) {
			$template = $DIR_CGI . "/" . $DIR_NEWCLASS . "/";
		} else {
			$template = $C_rootpath . "/" . $DIR_CGI . "/" . $DIR_NEWCLASS . "/";
		}
		@getfname = split(/\//, $file);
		$lastone = @getfname - 1;
		$template .= @getfname[$lastone];
		&genFile($template, $file);
		
		# If we got a signal, exit here.
		if ($gotSignal) {
			close(DEVNULL);
			exit(0);
		}
		
		&showHeaderBackHTML("Orignal Version Restored", "<br>");
		print "The original version of the file has been restored.";
	} else {
		# Don't do it
		&showHeaderBackHTML("No Changes Made", "You must check the checkbox to perform a restore action.", 1);
	}
}

sub addFile {
	$upload = $CGIQuery->param('upload');
	$altfilename = $CGIQuery->param('altfilename');
	
	if ($upload eq "" && $altfilename eq "") {
		# Print file upload page
		$helplink = "file=EditHTMLPagesCORP_Admin.html";
		$helplink .= "&anchor=EditHTMLEdtFSummary";
		$helplink .= "&helptitle=Add%20Files";
	
		&showHeaderBackHTML("Add a new file", "<br>", 0, 0, 0, $helplink);
		
		print "You may upload files one at a time. ";
		print "Any file formats are allowed. All files will be placed in ";
		print "the  root directory of your $CorF. ";
		print "This directory is accesible through your web browser at: ";
		print $C_rooturl, ". <p>";
		print "You can optionally enter an alternate filename in the text ";
		print "field below. By default, the file will be saved under the ";
		print "same name as uploaded.<p>";
		print "<p>\n";
		print "You can create a new, blank HTML file by leaving the upload ";
		print "field blank, and entering a new filename in the \"Alternate ";
		print "Filename\" field.<p>\n";
		print $FontRed, "Be sure to give your file the correct filename ";
		print "extension!!!</font><p>\n";
		
		print "<form action=$CGIEnvScript method=POST enctype='multipart/form-data'>\n";
		
		print "<input type=hidden name=fid value=\"$Class\">\n";
		print "<input type=hidden name=func value=\"$func\">\n";
		
		print "<table border=0 cellpadding=0 cellspacing=4>\n";
		print "<tr><td>", $FontFace, $FontSize;
		print "Upload: </td>\n";
		print "<td>", $FontFace, $FontSize;
		print "<input type=file name=upload size=40></td></tr>\n";
		
		print "<tr><td>", $FontFace, $FontSize;
		print "Alternate Filename: </td>\n";
		print "<td>", $FontFace, $FontSize;
		print "<input type=text name=altfilename size=40></td></tr>\n";
		
		print "</table>\n\n";
		
		print "<table border=0 cellpadding=0 cellspacing=1 width=100%>\n";
		print "<tr><td bgcolor=$FTheaderback>", $FontFace, $FontSize;	
		print "<img src=$ImgSrcClearDot width=20 height=2>";
		print "</td></tr>\n";
		print "</table>\n";
		
		if ($Demo) {
			print $BtnFormSubmitDemo;
		} else {
			print $BtnFormSubmit;
		}
		print "\n</form>\n";
		print "</body></html>";
	} else {
		if ($Demo) {
			print $CGIQuery->redirect("Demo.html");
			exit();
		}
	
		# Process uploaded file
		if ($CGIEnvUserAgent =~ /mac/i) {
			@getname = split(/:/, $upload);
		} elsif ($CGIEnvUserAgent =~ /win/i) {
			@getname = split(/\\/, $upload);
		} else {
			@getname = split(/\//, $upload);
		}
		$temp = @getname;
		$filename = @getname[$temp-1];
		
		if ($altfilename ne "") {
			$filename = $altfilename;
			if ($upload eq "") {
				if ($filename !~ /\.htm$|\.html/i) {
					$filename .= ".html";
				}
			}
		}
		
		$filename =~ s/\s+$//g;
		$filename =~ s/\s+/_/g;
		$filename =~ s/[^_\-0-9a-zA-Z\.]+/_/g;
		
		$savefile = $C_rootpath . "/" . $filename;
		
		# Does the file already exist?
		if (-e $savefile) {
			&fileExists;
		}
		
		if ($upload eq "") {
			open (filesave, ">$savefile") || &fileErr($savefile, "w");
			print filesave "<html>\n<body bgcolor=\"#FFFFFF\">\n\n";
			print filesave "</body></html>\n";
			close (filesave);
		} else {
			open (filesave, ">$savefile") || &fileErr($savefile, "w");
			binmode(filesave);
			while (<$upload>) {
				print filesave $_;
			}
			close (filesave);
		}
		
		&showHeaderBackHTML("File Added");
		print "Your file has been saved as ";
		print $C_rooturl, "/" , $filename, ".<p>\n";
		
		print "You may edit the file by selecting it in the pulldown menu ";
		print "above, and clicking the Edit button.\n"; 
		
		print "<script language=javascript>\n<!--\n";
		print "parent.filemenu.document.location.reload();\n";
		print "// -->\n</script>\n";
		
		print "</body></html>\n";
	}
	
	exit();
}

sub fileExists {
	&showHeaderBackHTML("File Exists", "<br>");
	
	print "The file you are attempting to add already exists. ";
	print "Please go back and give your file a different name. If you are ";
	print "trying to replace an existing file, you can do so by selecting the ";
	print "file for editing in the menu above.<p>\n";
	
	print "<a href=javascript:history.go(-1)>[Back]</a>\n";
	print "</body></html>\n";
	
	exit();
}

sub renameFile {
	$file = $CGIQuery->param('file');
	$newfilename = $CGIQuery->param('newfilename');
	
	$fileurl = $file;
	$fileurl =~ s/^$C_rootpath/$C_rooturl/;
	$fname = $file;
	$fname =~ s/$C_rootpath\///;
	
	$newfileurl = $C_rooturl . "/" . $newfilename;
	$newfilename = $C_rootpath . "/" . $newfilename;
	
	if (-e $newfilename) {
		&showHeaderBackHTML("Unable to rename file", "<br>The file: $newfileurl already exists. Please go back and choose a different name.", 1);
		exit();
	}
	
	rename($file, $newfilename);
	
	if (! -e $newfilename) {
		&showHeaderBackHTML("Rename Failed", "<br>Unable to rename $fileurl to $newfileurl. Please check permissions and try again.", 1);
		exit();
	}
	
	&showHeaderBackHTML("Rename Successful", "<br>$fileurl has been renamed to $newfileurl.");

	print "<script language=javascript>\n<!--\n";
	print "parent.filemenu.document.location.reload();\n";
	print "// -->\n</script>\n";
	
	exit();
}

sub confDelFile {
	$file = $CGIQuery->param('file');
	
	$fileurl = $file;
	$fileurl =~ s/^$C_rootpath/$C_rooturl/;
	
	&showHeaderBackHTML("Are you sure?");
	
	print $FontFace,$FontSize;
	
	print "<form action=$CGIEnvScript method=POST>\n";
	
	print "$FontRed Are you sure you ";
	print "want to delete the file: $fileurl? </font>";
	print "<ul>";
	for ($i=0; $i < @delsubject; $i++) {
		print "<li>";
		print "<input type=hidden name=delsubject value=\"";
		print @delsubject[$i], "\" checked>\n";
		&printHdrTxtPretty(&unEscapeTopic(@delsubject[$i]));
		print "</li>\n";
	}
	print "</ul><p>";

	print "<input type=hidden name=func value=dodelete>\n";
	print "<input type=hidden name=fid value=\"$Class\">\n";
	print "<input type=hidden name=file value=\"$file\">\n";
	print "&nbsp;&nbsp;<input type=radio name=confirm value='YES'> Yes &nbsp;\n";
	print "<input type=radio name=confirm value='NO'> No<br>\n";
	
	print "<table border=0 cellpadding=0 cellspacing=1 width=100%>\n";
	print "<tr><td bgcolor=$FTheaderback>", $FontFace, $FontSize;	
	print "<img src=$ImgSrcClearDot width=20 height=2>";
	print "</td></tr>\n";
	print "</table>\n";
	
	print $BtnFormSubmit;
	print "\n</form>\n";
	
	exit();
}

sub doDelFile {
	$file = $CGIQuery->param('file');
	$confirm = $CGIQuery->param('confirm');
	
	$fileurl = $file;
	$fileurl =~ s/^$C_rootpath/$C_rooturl/;
	
	if ($confirm ne "YES") {
		&showHeaderBackHTML("File Deletion Cancelled", "<br>You have cancelled deletion of the file: $fileurl.");
		exit();
	}
	
	unlink($file);
	
	if (-e $file) {
		&showHeaderBackHTML("File Deletion Failed", "<br>Unable to delete file: $file. Check file permissions and try again.", 1);
		exit();
	}
	
	&showHeaderBackHTML("File Deleted", "<br>The file: $fileurl has been deleted.");
	
	print "<script language=javascript>\n<!--\n";
	print "parent.filemenu.document.location.reload();\n";
	print "// -->\n</script>\n";
	
	exit();
}

sub dumpdb {
	local($dbfile) = @_;
	
	if ($dbfile =~ /$DBFILE_USERINFO$/) {
		$nicename = "Users Database";
	} elsif ($dbfile =~ /$DBFILE_CLASSINFO$/) {
		$nicename = "$CorF Database";
	} elsif ($dbfile =~ /$DBFILE_CLASSID$/) {
		$nicename = "$CorFs Database";
	} elsif ($dbfile =~ /$DBFILE_FSUBJ$/) {
		$nicename = "Topics Database";
	} elsif ($dbfile =~ /$DBFILE_FNEW$/ || $dbfile =~ /$DBFILE_FALL$/) {
		$nicename = "Most Recent Posts Database";
	} elsif ($dbfile =~ /$DBFILE_STATS$/) {
		$nicename = "Posting Statistics Database";
	}
	
	$cookie = $CGIQuery->cookie(-name=>'panForaAdmin',
								-value=>"$cryptAdminPass",
								-path=>'/');
	
	$helplink = "file=ForumViewDatabaseCORP_Admin.html";
	$helplink .= "&anchor=ViewDatabaseEdtFSummary";
	$helplink .= "&helptitle=View%20Database%20Content";
	
	&showHeaderBackHTML("Viewing Database: $nicename", "<br>",
									0, 0, 0, $helplink, $cookie);

	$sort = "-thash";
	if ($dbfile =~ /$DBFILE_FSUBJ$|$DBFILE_FALL$|$DBFILE_FNEW$|$DBFILE_STATS$/) {
		$sort = "-tbtree";
	}
	
	$max = 0;
		
	foreach (`$prtDB $dbfile $sort -q -a`) {
		# NOTE: \n, \t, \\ and \r have been escaped (-q)
		($key, $value) = split(/\t/, $_);
		$value = &UnEscape($value);
		# print $key, "\t", $value;
		
		chomp($value);
		push (@keys, $key);
		push (@values, $value);
		
		$tmp = split(/\t/, $value);
		if ($tmp > $max) {
			$max = $tmp;
		}
	}
	
	print "<table border=1 cellpadding=2 cellspacing=0>\n";
	
	
	######## Header Row
	if ($dbfile =~ /$DBFILE_USERINFO$/) {
		print "<tr><td nowrap bgcolor=$FCheaderback>";
		print "<font color=$FCheadertext>", $FontFace, $FontSize;
		print "<b>User ID</b></td>\n";
		print "<td nowrap bgcolor=$FCheaderback>";
		print "<font color=$FCheadertext>", $FontFace, $FontSize;
		if ($Edu) {
			print "<b>University ID</b></td>\n";
		} else {
			print "<b>Password Hint</b></td>\n";
		}
		print "<td nowrap bgcolor=$FCheaderback>";
		print "<font color=$FCheadertext>", $FontFace, $FontSize;
		print "<b>Password</b></td>\n";
		print "<td nowrap bgcolor=$FCheaderback>";
		print "<font color=$FCheadertext>", $FontFace, $FontSize;
		print "<b>First Name</b></td>\n";
		print "<td nowrap bgcolor=$FCheaderback>";
		print "<font color=$FCheadertext>", $FontFace, $FontSize;
		print "<b>Last Name</b></td>\n";
		print "<td nowrap bgcolor=$FCheaderback>";
		print "<font color=$FCheadertext>", $FontFace, $FontSize;
		print "<b>Preferred Name</b></td>\n";
		print "<td nowrap bgcolor=$FCheaderback>";
		print "<font color=$FCheadertext>", $FontFace, $FontSize;
		print "<b>Email Address</b></td>\n";
		print "<td nowrap bgcolor=$FCheaderback>";
		print "<font color=$FCheadertext>", $FontFace, $FontSize;
		print "<b>Phone Number</b></td>\n";
		print "<td nowrap bgcolor=$FCheaderback>";
		print "<font color=$FCheadertext>", $FontFace, $FontSize;
		print "<b>Permissions</b></td>\n";
		print "<td nowrap bgcolor=$FCheaderback>";
		print "<font color=$FCheadertext>", $FontFace, $FontSize;
		print "<b>$SorG</b></td>\n";
		print "<td nowrap bgcolor=$FCheaderback>";
		print "<font color=$FCheadertext>", $FontFace, $FontSize;
		print "<b>Photo</b></td>\n";
		print "<td nowrap bgcolor=$FCheaderback>";
		print "<font color=$FCheadertext>", $FontFace, $FontSize;
		print "<b>On Email List?</b></td>\n";
		print "<td nowrap bgcolor=$FCheaderback>";
		print "<font color=$FCheadertext>", $FontFace, $FontSize;
		print "<b>Personal Information</b></td>\n";
		print "<td nowrap bgcolor=$FCheaderback>";
		print "<font color=$FCheadertext>", $FontFace, $FontSize;
		print "<b>Signature</b></td>\n";
		print "<td nowrap bgcolor=$FCheaderback>";
		print "<font color=$FCheadertext>", $FontFace, $FontSize;
		print "<b>Hide Email</b></td>\n";
		print "</tr>\n\n";
	} elsif ($dbfile =~ /$DBFILE_CLASSINFO$/) {
		# Header row does not work here
	} elsif ($dbfile =~ /$DBFILE_CLASSID$/) {
		print "<tr><td nowrap bgcolor=$FCheaderback>";
		print "<font color=$FCheadertext>", $FontFace, $FontSize;
		print "<b>$CorF ID</b></td>\n";
		print "<td nowrap bgcolor=$FCheaderback>";
		print "<font color=$FCheadertext>", $FontFace, $FontSize;
		print "<b>Root Path</b></td>\n";
		print "</tr>\n\n";
	} elsif ($dbfile =~ /$DBFILE_FSUBJ$/) {
		print "<tr><td nowrap bgcolor=$FCheaderback>";
		print "<font color=$FCheadertext>", $FontFace, $FontSize;
		print "<b>Topic ID</b></td>\n";
		print "<td nowrap bgcolor=$FCheaderback>";
		print "<font color=$FCheadertext>", $FontFace, $FontSize;
		print "<b>Last Post</b></td>\n";
		print "<td nowrap bgcolor=$FCheaderback>";
		print "<font color=$FCheadertext>", $FontFace, $FontSize;
		print "<b>Nice Name</b></td>\n";
		print "<td nowrap bgcolor=$FCheaderback>";
		print "<font color=$FCheadertext>", $FontFace, $FontSize;
		print "<b>Indents</b></td>\n";
		print "<td nowrap bgcolor=$FCheaderback>";
		print "<font color=$FCheadertext>", $FontFace, $FontSize;
		print "<b>Has Child</b></td>\n";
		print "<td bgcolor=$FCheaderback>";
		print "<font color=$FCheadertext>", $FontFace, $FontSize;
		print "<b>Parent</b></td>\n";
		print "<td nowrap bgcolor=$FCheaderback>";
		print "<font color=$FCheadertext>", $FontFace, $FontSize;
		print "<b>Allow Post</b></td>\n";
		print "<td nowrap bgcolor=$FCheaderback>";
		print "<font color=$FCheadertext>", $FontFace, $FontSize;
		print "<b>Posts</b></td>\n";
		print "</tr>\n\n";
	} elsif ($dbfile =~ /$DBFILE_FALL$/ || $dbfile =~ /$DBFILE_FNEW$/) {
		print "<tr><td nowrap bgcolor=$FCheaderback>";
		print "<font color=$FCheadertext>", $FontFace, $FontSize;
		print "<b>Post Time</b></td>\n";
		print "<td nowrap bgcolor=$FCheaderback>";
		print "<font color=$FCheadertext>", $FontFace, $FontSize;
		print "<b>Message ID</b></td>\n";
		print "<td nowrap bgcolor=$FCheaderback>";
		print "<font color=$FCheadertext>", $FontFace, $FontSize;
		print "<b>Topic</b></td>\n";
		print "<td bgcolor=$FCheaderback>";
		print "<font color=$FCheadertext>", $FontFace, $FontSize;
		print "<b>Title</b></td>\n";
		print "<td nowrap bgcolor=$FCheaderback>";
		print "<font color=$FCheadertext>", $FontFace, $FontSize;
		print "<b>Poster</b></td>\n";
		print "<td nowrap bgcolor=$FCheaderback>";
		print "<font color=$FCheadertext>", $FontFace, $FontSize;
		print "<b>Poster Permissions</b></td>\n";
		print "<td nowrap bgcolor=$FCheaderback>";
		print "<font color=$FCheadertext>", $FontFace, $FontSize;
		print "<b>Attachment</b></td>\n";
		if ($dbfile =~ /$DBFILE_FALL$/) {
			print "<td nowrap bgcolor=$FCheaderback>";
			print "<font color=$FCheadertext>", $FontFace, $FontSize;
			print "<b>Post Number</b></td>\n";
		}
		print "</tr>\n\n";
	} elsif ($dbfile =~ /$DBFILE_STATS$/) {
		print "<tr><td nowrap bgcolor=$FCheaderback>";
		print "<font color=$FCheadertext>", $FontFace, $FontSize;
		print "<b>Date/User</b></td>\n";
		print "<td nowrap bgcolor=$FCheaderback>";
		print "<font color=$FCheadertext>", $FontFace, $FontSize;
		print "<b>Total Posts</b></td>\n";
		print "<td nowrap bgcolor=$FCheaderback>";
		print "<font color=$FCheadertext>", $FontFace, $FontSize;
		print "<b>Original Posts</b></td>\n";
		print "<td bgcolor=$FCheaderback>";
		print "<font color=$FCheadertext>", $FontFace, $FontSize;
		print "<b>Replies</b></td>\n";
		print "<td nowrap bgcolor=$FCheaderback>";
		print "<font color=$FCheadertext>", $FontFace, $FontSize;
		print "<b>Last Post</b></td>\n";
		print "<td nowrap bgcolor=$FCheaderback>";
		print "<font color=$FCheadertext>", $FontFace, $FontSize;
		print "<b>Post for Date -&gt;</b></td>\n";
		print "<td nowrap bgcolor=$FCheaderback>";
		print "<font color=$FCheadertext>", $FontFace, $FontSize;
		print "<b>Date</b></td>\n";
		print "</tr>\n\n";
	}
	######### End Header Row
	
	for ($i=0; $i < @keys; $i++) {
		print "<tr>";
		
		print "<td nowrap>", $FontFace, $FontSize;
		print @keys[$i];
		print "</td>\n";
		
		@line = split(/\t/, @values[$i]);
		for ($j=0; $j < $max; $j++) {
			print "<td nowrap>";
			if ($dbfile =~ /$DBFILE_USERINFO$/ && $j == $max - 1) {
				print "<pre>";
			}
			print $FontFace, $FontSize;
			if (@line[$j] eq "") {
				print "&nbsp;";
			} else {
				print @line[$j];
			}
			print "</td>\n";
		}
		print "</tr>\n\n";
	}
	
	print "</table>\n";
		
	print "</body></html>\n";
}

sub printJSPreview {
	print <<end_print;
	
	<script language=javascript>

	<!-- 
	// window.onerror=null;

	function Preview(base) {
		hei = 400;
		wid = 600;
		
		cont = document.forms[0].edits.value;

		var winname = "preview";

		options = "location=0,toolbar=0,menubar=0,resizable=1,scrollbars=1,width=" + wid + ",height=" + hei;
 
		preWin = window.open("", winname, options);
		// preWin.document.writeln("<html>");
		// preWin.document.writeln("$BodyTag");
		if(base){
			preWin.document.write("<BASE HREF='" + document.location.protocol + "//" + document.location.host);
			if (document.location.port != "" && document.location.host.indexOf(document.location.port) == -1) {
				preWin.document.write(":" + document.location.port);
			}
			preWin.document.writeln("$C_rooturl", "/'>");
		}
		preWin.document.writeln(cont);
		preWin.document.close();
	}
	// -->
	</script>
	
end_print
}
