#!/usr/bin/perl

###############################################################################
#
# _AFShowVersion.cgi - Show versions of all programs
#
# AUTHOR:	Shawn Stepper, wiTHinc Inc.
# AUTHOR:	George Toye, wiTHinc Inc.
# DATE:		$Date: 2001/08/21 17:50:53 $ (last modified)
# COPYRIGHT:	1998, 1999, 2000, 2001 wiTHinc Inc. All Rights Reserved.
#
###############################################################################

$FileRevision = '$Id: _AFShowVersion.cgi,v 1.14.2.2 2001/08/21 17:50:53 stepper Exp $';
$Version = '1.4.0';

if (@ARGV[0] eq "-v" || @ARGV[0] eq "--version") {
	print "File:		$0\n";
	print "Revision:	$FileRevision\n";
	print "Version:	$Version\n";
	exit();
}

use Config;

if ($ENV{'SCRIPT_NAME'} ne "" && @ARGV[0] ne "textonly") {
	require "F_Init.pl";
	
	$adminpass = $CGIQuery->cookie('panForaAdmin');
	$forumadmin = &checkAdminPass($adminpass);

	$Class = $CGIQuery->param('fid');
	
	if (!$forumadmin) {
		$nexturl = escape(&buildNextURL);
		print $CGIQuery->redirect("$CGI_ClassCreate?what=login&fid=$Class&nexturl=$nexturl");
		exit();
	}

	$foundclass = 0;
	if ($Class ne "") {
		$foundclass = &lookupClass($Class);
	}

	if (! $foundclass) {
		$ColorQueryString = &lookupColors(1);
	}

	# Load up color variables
	&loadColors($ColorQueryString);

	$BodyTag = &makeBodyTag("Content");
} else {
	# What OS is this? Pull in extra modules as needed
	$isWin = 0;
	$isNT = 0;
	if ($ENV{'COMSPEC'} ne "" && $ENV{'WINDIR'} ne "") {
        	# This is a windows machine
        	require Win32;
        	$isWin = 1;
        	$isNT = Win32::IsWinNT();
	}
}



$perlpath = $Config{"perlpath"};
        
if ($perlpath !~ /perl/i) {
	$perlpath = "/usr/local/bin/perl";
}

###############################################################################
#
# Process submitted data

if ($ENV{'SCRIPT_NAME'} ne "" && @ARGV[0] ne "textonly") {
	$cookie = $CGIQuery->cookie(-name=>'panForaAdmin',
								-value=>"$cryptAdminPass",
								-path=>'/');

	$helplink = "file=ForumSoftwareVersionsCORP_Admin.html";
	$helplink .= "&anchor=ForumSoftwareEdtFSummary";
	$helplink .= "&helptitle=Software%20Versions";

	&showHeaderBackHTML("Forum Software Versions", "<br>\n",
									0, 0, 1, $helplink, $cookie);
									
	print "<pre>\n", $FontFace, $FontSize;
}

if ($isWin) {
	@files = glob("*.pl *.cgi *.exe");
	@files = sort(@files);
	$xfiles = "|mogrify.exe|identify.exe|tar.exe";
	$xfiles .= "|unzip.exe|gzip.exe|PAEXT.EXE";
	$xfiles .= "|mkHTML.exe|safehtml.exe";
	$xfiles .= "|crypt.exe|encodeUser.exe|decodeUser.exe";
	$xfiles .= "|update.pl|printenv.cgi|fixperl.pl";
	$xfiles .= "|";
} else {
	@files = glob("*.pl *.cgi");
	$xfiles = "|update.pl|printenv.cgi|fixperl.pl|";
}

for ($i=0; $i < @files; $i++) {
	if (index($xfiles,"|@files[$i]|") < 0) {	
	# if (@files[$i] !~ "/$xfile/") {
		#print "$x = ",@files[$i], "\n";
		if ($isWin) {
			if (@files[$i] =~ /\.pl$/i && ! -x @files[$i]) {
				# print "$perlpath ./@files[$i] -v\n";
				print `$perlpath ./@files[$i] -v`;
			} elsif (@files[$i] =~ /\.cgi$/i && ! -x @files[$i]) {
				# print "$perlpath ./@files[$i] -v\n";
				print `$perlpath ./@files[$i] -v`;
			} else {
				# print "./@files[$i] -v\n";
				print `./@files[$i] -v`;
			}
		} else {
			if (@files[$i] =~ /\.pl$/i && ! -x @files[$i]) {
				# print "$perlpath ./@files[$i] -v\n";
				print `$perlpath ./@files[$i] -v`;
			} else {
				# print "./@files[$i] -v\n";
				print `./@files[$i] -v`;
			}
		}
		print "\n";
	}
}

if ($ENV{'SCRIPT_NAME'} ne "" && @ARGV[0] ne "textonly") {
	print "</pre></body></html>\n";
}
