#!/usr/bin/perl

###############################################################################
#
# _AFTechSupp.cgi - Tech Support Request Form
#
# AUTHOR:	Shawn Stepper, wiTHinc Inc.
# AUTHOR:	George Toye, wiTHinc Inc.
# DATE:		$Date: 2001/08/21 17:50:53 $ (last modified)
# COPYRIGHT:	1998, 1999, 2000, 2001 wiTHinc Inc. All Rights Reserved.
#
###############################################################################

$FileRevision = '$Id: _AFTechSupp.cgi,v 1.12.2.2 2001/08/21 17:50:53 stepper Exp $';
$Version = '1.4.0';

if (@ARGV[0] eq "-v" || @ARGV[0] eq "--version") {
	print "File:		$0\n";
	print "Revision:	$FileRevision\n";
	print "Version:	$Version\n";
	exit();
}

require "F_Init.pl";

use Config;
	
$adminpass = $CGIQuery->cookie('panForaAdmin');
$forumadmin = &checkAdminPass($adminpass);

$Class = $CGIQuery->param('fid');
$foundclass = 0;
if ($Class ne "") {
	$foundclass = &lookupClass($Class);
}

if (! $foundclass) {
	$ColorQueryString = &lookupColors(1);
}

# Load up color variables
&loadColors($ColorQueryString);

if ($foundclass) {
	&lookupUser($CGIEnvUser);
}

if ($CGIEnvUser ne "Guest" && $CGIEnvUser ne "" && $foundclass) {
	&checkCookieGuest($CGIEnvUser, $C_authtype);
}
	
if (!$forumadmin && !&IS_ADMIN($U_Perms)) {
	$nexturl = escape(&buildNextURL);
	print $CGIQuery->redirect("$CGI_ClassCreate?what=login&fid=$Class&nexturl=$nexturl");
	exit();
}

$BodyTag = &makeBodyTag("Content");

###############################################################################
#
# Process submitted data

if ($forumadmin) {
	$cookie = $CGIQuery->cookie(-name=>'panForaAdmin',
							-value=>"$cryptAdminPass",
							-path=>'/');
}

$func = $CGIQuery->param('func');
if ($func eq "send") {
	&sendRequest;
	exit();
}

$helplink = "file=ForumSoftwareVersionsCORP_Admin.html";
$helplink .= "&anchor=ForumSoftwareEdtFSummary";
$helplink .= "&helptitle=Software%20Versions";

&showHeaderBackHTML("Technical Support Request Form", "<br>\n",
									0, 0, 1, $helplink, $cookie);
									
print "Use this form to submit a technical support request by email to ";
print "wiTHinc.<p>\n";

print "<form action=$CGIEnvScript method=POST>\n";
print "<table border=0 cellpadding=2 cellspacing=0>\n";

# License Key
#print "<tr><td>", $FontFace, $FontSize;
#print "<b>License Key</b></td>\n";
#print "<td>", $FontFace, $FontSize;
#print "<textarea name=\"License_Key\" wrap=virtual cols=80 rows=5>";
# Print license key here
#$dbfile = "./" . $DBFILE_LICENSE;
#if (-e $dbfile) {
#	foreach (`$prtDB $dbfile -tbtree -q -a`) {
		# NOTE: \n, \t, \\ and \r have been escaped (-q)
#		($key, $value) = split(/\t/, $_);
#		$value = &UnEscape($value);
		# print $key, "\t", $value;
		
#		chomp($value);
#	}
#	if (-e "./.Demo") {
#		print "Demo Only";
#	} elsif ($value ne "") {
#		print $value;
#	}
#}
#print "</textarea></td>\n";
#print "</tr>\n\n";

# Name
print "<tr><td>", $FontFace, $FontSize;
print "<b>Your Full Name</b></td>\n";
print "<td>", $FontFace, $FontSize;
print "<input type=text name=\"Full_Name\" value=\"";
print $U_NameFirst, " ", $U_NameLast;
print "\" size=60></td>\n";
print "</tr>\n\n";

#Email
print "<tr><td>", $FontFace, $FontSize;
print "<b>Your Email Address</b></td>\n";
print "<td>", $FontFace, $FontSize;
print "<input type=text name=\"Email_Address\" value=\"";
print $U_Email;
print "\" size=60></td>\n";
print "</tr>\n\n";

# Problem Type
print "<tr><td>", $FontFace, $FontSize;
print "<b>Type of Problem</b></td>\n";
print "<td>", $FontFace, $FontSize;
print "<select name=\"Problem_Type\">\n";
print "<option value=\"Other\"> -- Select One --\n";
print "<option value=\"Installation\"> Installation\n";
print "<option value=\"Administration\"> Administration\n";
print "<option value=\"Lost Password or Key\"> Lost Password or Key\n";
print "<option value=\"Upgrade\"> Upgrade\n";
print "<option value=\"Forum View\"> Forum View\n";
print "<option value=\"Other\"> Other\n";
print "</select></td>\n";
print "</tr>\n\n";

#Problem Description
print "<tr><td>", $FontFace, $FontSize;
print "<b>Description of Problem</b></td>\n";
print "<td>", $FontFace, $FontSize;
print "<textarea name=\"Problem_Description\" rows=8 cols=72 wrap=virtual>";
print "</textarea></td>\n";
print "</tr>\n\n";

# Submit
print "<tr><td>", $FontFace, $FontSize, "&nbsp;</td>\n";
print "<td>", $FontFace, $FontSize;
if ($Demo) {
	print $BtnFormSubmitDemo;
} else {
	print $BtnFormSubmit;
}
print "</td>\n</tr>\n\n";

print "</table>\n";

print "<input type=hidden name=fid value=$Class>\n";
print "<input type=hidden name=func value=send>\n";
print "</form>\n\n";
print "</body></html>\n";

sub sendRequest {
	$sendmail = &lookupSendMail;
	$date = &formatDate(time(), "fulldate");
	
	# Read in submitted variables
	$License_ent = $CGIQuery->param('License_Key');
	$Name_ent = $CGIQuery->param('Full_Name');
	$Email_ent = $CGIQuery->param('Email_Address');
	$Problem_Type = $CGIQuery->param('Problem_Type');
	$Problem_Description = $CGIQuery->param('Problem_Description');
	
	open (M, "| $sendmail ");
	# open (M, ">techsupp.log");

	print M "To: $TechSupport\n";
	print M "From: $Name_ent <$Email_ent>\n";
	print M "Subject: Tech Support\: $Problem_Type\n";
	print M "X-Mailer: panFora $Version\n\n";
	
	print M "Tech Support Request:	$Problem_Type\n";
	print M "Time:	$date\n\n";
	
	print M "Information Entered by User:\n";
	#print M "License:	$License_ent\n";
	print M "Name:		$Name_ent\n";
	print M "Email:		$Email_ent\n";
	print M "Problem Type:	$Problem_Type\n";
	print M "Problem Description:\n";
	print M $Problem_Description;
	print M "\n\n";
	
	if ($Class ne "" && $CGIEnvUser ne "Guest") {
		print M "Information from $CorF Databases:\n";
		#print M "License:	\n";
		print M "C_id:		$Class\n";
		print M "C_rootpath:	$C_rootpath\n";
		print M "C_rooturl:	$C_rooturl\n";
		print M "Primary Admin:	$C_FirstAdmin - $C_FirstAdminEmail \n";
		print M "User Info:	$CGIEnvUser - $U_NameFirst $U_NameLast - $U_Email\n";
		print M "\n";
	}
	
	print M "-" x 72, "\n";
	print M "Software Versions:\n\n";

	# Print reply page
	&showHeaderBackHTML("Technical Support Request Sent", "<br>\n",
									0, 0, 1, "", $cookie);
									
	print "Your technical support request will be sent to wiTHinc.\n";	
	
	print "<p>Collecting versions information to send.\n";		
	
	#if ($isWin) {
	#	@tmp = `$perlpath ./$CGI_ForumVersion textonly`;
	#} else {
	#	@tmp = `./$CGI_ForumVersion textonly`;
	#}
	#print M @tmp;
	&showVersions();
	close(M);
	#system("$sendmail <techsupp.log");
	
	print "<p>Finished.\n";		
	
	print "</body></html>\n";
}

sub showVersions {
	local($xfiles,@files,$i,$perlpath);

	$perlpath = $Config{"perlpath"};
	if ($perlpath !~ /perl/i) {
		$perlpath = "/usr/local/bin/perl";
	}

	if ($isWin) {
		@files = glob("*.pl *.cgi *.exe");
		@files = sort(@files);
		$xfiles = "|mogrify.exe|identify.exe|tar.exe";
		$xfiles .= "|unzip.exe|gzip.exe|PAEXT.EXE";
		$xfiles .= "|mkHTML.exe|safehtml.exe";
		$xfiles .= "|initialize.pl|sedAllCGI.pl|sedAllpl.pl";
		$xfiles .= "|crypt.exe|encodeUser.exe|decodeUser.exe";
		$xfiles .= "|update.pl|printenv.cgi|fixperl.pl";
		$xfiles .= "|";
	} else {
		@files = glob("*.pl *.cgi");
		$xfiles = "|update.pl|printenv.cgi|fixperl.pl|";
	}

	for ($i=0; $i < @files; $i++) {
		if (index($xfiles,"|@files[$i]|") < 0) {	
			#print "<p>$x = ",@files[$i], "\n";
			if ($isWin) {
				if (@files[$i] =~ /\.pl$/i && ! -x @files[$i]) {
					#print "<br>$perlpath ./@files[$i] -v\n";
					#print `$perlpath ./@files[$i] -v`;
					print M `$perlpath ./@files[$i] -v`;
				} elsif (@files[$i] =~ /\.cgi$/i && ! -x @files[$i]) {
					#print "<br>$perlpath ./@files[$i] -v\n";
					#print `$perlpath ./@files[$i] -v`;
					print M `$perlpath ./@files[$i] -v`;
				} else {
					#print "<br>./@files[$i] -v\n";
					#print `./@files[$i] -v`;
					print M `./@files[$i] -v`;
				}
			} else {
				if (@files[$i] =~ /\.pl$/i && ! -x @files[$i]) {
					# print "$perlpath ./@files[$i] -v\n";
					print M `$perlpath ./@files[$i] -v`;
				} else {
					# print "./@files[$i] -v\n";
					print M `./@files[$i] -v`;
				}
			}
			print M "\n";
		}
	}
	#print "done!\n";
}
