<%
//	Created by:	Lineasoft Sagl
//	Web site:	www.lineasoft.ch
//	Version:	1.2  (01.10.2002)
//	File:		node.inc
//
//	Copyright  2002, Lineasoft Sagl (Switzerland)
%>	

<%

	////////////////////////////////////////////////////////////////////////////////////////////
	// Object Node
	////////////////////////////////////////////////////////////////////////////////////////////
	function Node(	id, 
					level, 
					textMenu, 
					menuNormalImage, 
					menuActiveImage, 
					menuMouseOverImage, 
					link, 
					contentLink, 
					linkNodeId, 
					linkFrameTarget,
					contentLinkFrameTarget, 
					bExternalLink, 
					bHasContents, 
					hierarchy)
	{
		this.id					= id;
		this.level				= level;
		this.textMenu			= textMenu;
		this.menuNormalImage	= menuNormalImage;
		this.menuActiveImage	= menuActiveImage;
		this.menuMouseOverImage = menuMouseOverImage;
		this.link				= link;
		this.contentLink		= contentLink;
		this.linkNodeId			= linkNodeId;
		this.linkFrameTarget	= linkFrameTarget;
		this.contentLinkFrameTarget = contentLinkFrameTarget;
		this.bExternalLink		= bExternalLink;
		this.bHasContents		= bHasContents;
		this.hierarchy			= new String(hierarchy);
		
		this.left = null;
		this.right = null;
		this.down = null;
		this.up = null;
		
		// Internal methods
		this.GetLink			= GetLink;
		this.GetContentLink		= GetContentLink;

		// Public methods
		this.GetNextSibling		= GetNextSibling;
		this.GetPrevSibling		= GetPrevSibling;
		this.GetParent			= GetParent;
		this.GetChildByOrder	= GetChildByOrder;
		
		this.HasChilds			= HasChilds;
		this.HasContents		= HasContents;
		this.IsLink				= IsLink;
		this.IsExternalLink		= IsExternalLink;
		this.IsAncestorOf		= IsAncestorOf;
		this.IsEqualOf			= IsEqualOf;
		
		this.GetId				= GetId;
		this.GetLevel			= GetLevel;
		this.GetTextMenu		= GetTextMenu;
		this.GetImageMenuNormal = GetImageMenuNormal;
		this.GetImageMenuActive = GetImageMenuActive;
		this.GetImageMenuMouseOver = GetImageMenuMouseOver;
	}

	
	////////////////////////////////////////////////////////////////////////////////////////////
	function GetNextSibling()
	{
		return this.down;
	}
	
	
	////////////////////////////////////////////////////////////////////////////////////////////
	function GetPrevSibling()
	{
		return this.up;
	}

	
	////////////////////////////////////////////////////////////////////////////////////////////
	function GetParent()
	{
		return this.left;
	}
	
	
	////////////////////////////////////////////////////////////////////////////////////////////
	function GetChildByOrder(order)
	{
		var p = this.right;
		if (p == null)
			return null;
		
		for (var i=0; i < order; i++)
		{
			p = p.down;		
			if (p == null)
				return null;
		}
		return p;
	}
	
	
	////////////////////////////////////////////////////////////////////////////////////////////
	function HasChilds()
	{
		return this.right != null ? true : false;
	}
	
	
	////////////////////////////////////////////////////////////////////////////////////////////
	function HasContents()
	{
		return this.bHasContents;
	}

	
	////////////////////////////////////////////////////////////////////////////////////////////
	function IsLink()
	{
		if (this.link != null)
			return true;
		return false;
	}

	
	////////////////////////////////////////////////////////////////////////////////////////////
	function IsExternalLink()
	{
		return this.bExternalLink;
	}

	
	////////////////////////////////////////////////////////////////////////////////////////////
	function IsEqualOf(nodeToCompare)
	{
		if (nodeToCompare != null && nodeToCompare.id == this.id)
			return true;
		return false;
	}
	
	
	////////////////////////////////////////////////////////////////////////////////////////////
	function IsAncestorOf(nodeToCompare)
	{
		if (nodeToCompare != null && nodeToCompare.id != this.id && nodeToCompare.hierarchy.substr(0, this.hierarchy.length) == this.hierarchy)
			return true;
		return false;
	}

	
	////////////////////////////////////////////////////////////////////////////////////////////
	function GetId() 
	{ 
		return this.id;
	}
	
	
	////////////////////////////////////////////////////////////////////////////////////////////
	function GetLevel() 
	{ 
		return this.level;
	}
	
	
	////////////////////////////////////////////////////////////////////////////////////////////
	function GetTextMenu()
	{ 
		return this.textMenu;
	}
	
	
	////////////////////////////////////////////////////////////////////////////////////////////
	function GetLink(bIncludeTarget, extra_params)
	{
		var sLink = "";
		
		if (this.link != null)
		{
			if (!this.bExternalLink)
			{
				if (bIncludeTarget)
					sLink = "\"";
				sLink += this.link + "?nid=" + this.linkNodeId;
					
				if (extra_params != null)
					for (var i=0; i < extra_params.length; i++)
						sLink += "&" + extra_params[i];
				
				if (bIncludeTarget)
					sLink += "\" target=\"" + this.linkFrameTarget + "\"";
			}			
			else 
			{
				if (bIncludeTarget)
					sLink = "\"" + this.link + "\"" + " target=\"" + this.linkFrameTarget + "\"";
				else
					sLink = this.link;
			}
		}
		else
			sLink = "#";
		
		return sLink;
	}
	
	
	////////////////////////////////////////////////////////////////////////////////////////////
	function GetContentLink(bIncludeTarget, extra_params)
	{
		var sLink = "";
		
		if (this.contentLink != null)
		{
			if (bIncludeTarget)
				sLink = "\"";
			sLink += this.contentLink + "?nid=" + this.linkNodeId;
					
			if (extra_params != null)
				for (var i=0; i < extra_params.length; i++)
					sLink += "&" + extra_params[i];	
				
			if (bIncludeTarget)
				sLink += "\" target=\"" + this.contentLinkFrameTarget + "\"";
		}
		else
			sLink = "#";
		
		return sLink;
	}
	
	
	////////////////////////////////////////////////////////////////////////////////////////////
	function GetImageMenuNormal()
	{
		return this.menuNormalImage;
	}
	
	
	////////////////////////////////////////////////////////////////////////////////////////////
	function GetImageMenuActive()
	{
		if (this.menuActiveImage != "")
			return this.menuActiveImage;

		if (this.menuMouseOverImage != "")
			return this.menuMouseOverImage;
		
		return this.menuNormalImage;
	}
	
	
	////////////////////////////////////////////////////////////////////////////////////////////
	function GetImageMenuMouseOver()
	{
		if (this.menuMouseOverImage != "")
			return this.menuMouseOverImage;

		if (this.menuActiveImage != "")
			return this.menuActiveImage;
		
		return this.menuNormalImage;
	}

%>