unit QzHtmlLabel;
{*********************************************************}
{*                    QzHTMLLabel.pas                    *}
{*                 Quick Zip HTML support                *}
{*     Copyright (c) 2003 Joseph Leung Yat Chun          *}
{*                 All rights reserved.                  *}
{*********************************************************}

interface

uses
  Windows, Messages, SysUtils, Classes, Controls, Graphics,StdCtrls,ShellApi,QzMiniHtml;

type
  TQzHtmlLabel = class(TLabel)
  private
     function getcaption : string;
     procedure setcaption(caption : string);
    { Private declarations }
  protected
    { Protected declarations }
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure paint; override;
    { Public declarations }
  published
    property Caption : string read getcaption write setcaption;
    { Published declarations }
  end;

procedure Register;
implementation
var aQzMiniHtml : TQzMiniHtml;
destructor TQzHtmlLabel.Destroy;
begin
  aQzMiniHtml.free;
  Inherited Destroy;
end;
constructor TQzHtmlLabel.Create(AOwner:TComponent);
begin
  Inherited Create(AOwner);
  AutoSize := False;
  aQzMiniHtml := TQzMiniHtml.Create(nil);
  aQzMiniHtml.Canvas := Canvas;
  aQzMiniHtml.Owner := Self;
  ParentColor := True;
  aQzMiniHtml.Color := Color;
  OnMouseMove := aQzMiniHtml.OnMMove;
  OnMouseDown := aQzMiniHtml.OnMDown;
end;

procedure TQzHtmlLabel.SetCaption(caption : string);
begin
  aQzMiniHtml.Caption := caption;
  aQzMiniHtml.update;
end;

function TQzHtmlLabel.getCaption : string;
begin
  Result := aQzMiniHtml.Caption
end;

procedure TQzHtmlLabel.paint;
begin
  aQzMiniHtml.Color := Color;
  if Caption <> '' then
  aQzMiniHtml.update;
end;

procedure Register;
begin
  RegisterComponents('QZip', [TQzHtmlLabel]);
end;

end.
