// The Initial Developer of the Original Code is
// Copyright (C) 2003 Joseph Leung Yat Chun(lycj@yahoo.com)
// All Rights Reserved
//////////////////////////////////////////////////////////////////////
// TQz BETA Component License
// Please read Carefully.
// P	Author means the initial writer of this component.
// P	Component user means the Software developer that use a
//    TQz component to develope software.
// P	Software user means the customer of Component user.
// P	This component is in BETA Stage, bug may exists and some
//    may cause any kind of damage to the Component user and
//    Software user. The Author is not responsible to any kind
//    of loss caused. Software distributed is distributed on an
//    "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
//     or implied.
// P	Component user may use this component to write application,
//    including freeware,  shareware and Commercialware. In return
//    the Author request the component user to submit any changes
//    component user made to the component to the Author.
//    Please report any bugs found to Quick Zip Message Board.
// P	Component may be re-distribute as long as it is unchanged.
// P	Component user is responsibile to make sure the Software user
//    know the software use this component. Listing Component name
//    under Credits in Help page would be sufficient for this.
// P	This licence may be changed anytime, please check regularly.
//    Latest License may be found in Quick Zip Message Board.
//
//    Quick Zip Message Board - http://qzip.cjb.net
//                              http://cake.sourceforge.net
//
//////////////////////////////////////////////////////////////////////
unit QzMiniHtml2; //Ver 1.1
{*********************************************************}
{*                    QzMiniHTML2.pas                    *}
{*                 Quick Zip HTML support                *}
{*     Copyright (c) 2003 Joseph Leung Yat Chun          *}
{*                 All rights reserved.                  *}
{*********************************************************}
{* How to install?                                       *}
{ 1.Remove previous version.                             *}
{ 2.Add QzMiniHtml2 and QzHtmlLabel2 , QzHtmlEdit2,      *}
{       QzHtmlEditor2, QzHtmlScrollBox2, QzHtmlCheckBox2 *}
{   to a Run Time Package (e.g. QzHtmlR), Compile it.    *}
{ 3.Add QzHtmlPropertyEditor to a Design Time Package    *}
{   (e.g. QzHtmlD), Compile it.                          *}
{   Design Time Package is toggle in Options\UsageOptions*}
{ 4.Install the Run Time Package (QzHtmlR)               *}
{                                                        *}
{ Delphi 7 version of packages is included               *}
{*********************************************************}
{* How to use?                                           *}
{  PQzMiniHtml2 (Draw on Canvas)                        *}
{  1.Drop QzMiniHtml2 on a Form.                         *}
{  2.Place the following line to init QzMiniHtml2        *}
{  3.QzMiniHtml2.Color := clWhite;                       *}
{    QzMiniHtml2.Canvas := yourCanvas;                   *}
{    QzMiniHtml2.Owner := Image1;                        *}
{    QzMiniHtml22.Width := yourCanvas.idth ;             *}
{    QzMiniHtml22.Height := yourCanvas.Height;           *}
{    QzMiniHtml22.Top := 0;                              *}
{    QzMiniHtml22.Left := 0;                             *}
{  4.Assign your text to Lines andthen call              *}
{    LoadFromLines                                       *}
{                                                        *}
{  PQzHtmlLabel2                                        *}
{  1.Drop QzHtmlLabel2 on a Form.                        *}
{  2.Setup Width and Height.                             *}
{  3.Use the <...> next to Caption to launch Editor or   *}
{    Assign text to QzHtmlLabel2.Html                    *}
{*********************************************************}
{* How to Enable Mouse Support?                          *}
{                                                        *}
{  URL HighLighting support :                            *}
{    QzMiniHtml21.MouseKBHandler1 :=                     *}
{               TNormalHandler.Create(Self,QzMiniHtml21);*}
{  Selection Block Support : (Not good...)               *}
{    QzMiniHtml2.MouseKBHandler2 :=                      *}
{               TBlockHandler.Create(Self,QzMiniHtml21); *}
{ Then Call QzMiniHtml2.MouseMove, MouseUp and MouseDown *}
{ when mouseaction on your form (or parent?)             *}
{*********************************************************}
{* How it Works?                                         *}
{ Each <> and text are assigned to aTag inside TagList.  *}
{ Then Update and Draw                                   *}
{ E.g. <p align="right">This is <b>a</b> Test.</p>       *}
{P1.) Convert to..                                      *}
{ TagList==>aPSTag+AText+ASpace+AText+ASpace+aBSTag+AText*}
{           +ABETag+AText+APETag                         *}
{P2.) Call Update and Call NextLine when needed.        *}
{   PaPSTag.Update will update all AText/ASpace.align   *}
{     to "right".                                        *}
{   PaText/aSpace.Update will update their width/height.*}
{   PaBSTag will update Font type in AText to bold.     *}
{P3.) Call Draw (to cache)                              *}
{   PNon Visible Tag (aInvisTag) draw nothing.          *}
{   PVisible Tag draws according their top/left         *}
{P4.) Draw on Canvas from cache                         *}
{*********************************************************}
{* To Do List                                            *}
{* Load Image from http (by InDy perhaps)                *}
{* Support Gif                                           *}
{*********************************************************}

interface

uses
   Dialogs,Forms, Windows, Messages, SysUtils, Classes, Controls, Graphics,
   StdCtrls,ShellApi,ExtCtrls,JPEG;

const TagSeperateSize = 0;
      DefaultFontsize = 8;
      DefaultFontName = 'MS Sans Serif';
      INDENTSIZE      = 50;
      HidTxtInUnkTag  = FALSE;
      LINESPACING     = TRUE;    //Support for WordWrap - Speed up if FALSE
      Border          = 5;
type
   TSelectionEvent = procedure ( Sender : TObject; Href : string) of object;
   THtmlUpdateEvent = procedure(Sender: TObject; newHtml : string; HKey : char) of object;
   TQzHtmlRec = class
             Html : string;
             Hotkey : Char;
             FHtmlUpdate : THtmlUpdateEvent;
             Owner : TComponent;
             constructor Create(o : TComponent);
             procedure SetHtml(input : string; HKey : char);
              end;
   TQzMiniHtml2 = class(TComponent)
                  private
                     InputHtml : TQzHtmlRec;
                     function SplitSelected(splitwhich : integer) : integer;
                     procedure SetCaption(value : TQzHtmlRec);
                     function GetCaption : TQzHtmlRec;
                  public
                     temp1, temp2 : integer;
                     Lines : TStrings;
                     Canvas : TCanvas;
                     TagList : TList;
                     Focused : integer;
                     Color, BackGroundColor : TColor;
                     Owner : TComponent;
                     CacheBitmap : TBitmap;
                     Selecting : boolean;
                     SelectStartFrom,SelectEndAt : integer;
                     MouseKBHandler1,MouseKBHandler2 : TComponent;
                     width, height, Left, Top, LineHeight : integer;
                     ScrollLeft,ScrollTop : integer;
                     Indent : integer;
                     LastPos, StartPos, EndPos, CurrentPos : TPoint;
                     constructor Create(AOwner: TComponent); override;
                     destructor Destroy; override;
                     procedure Readnexttag(text : string; var beforetag, aftertag, tagname, tagvars : string);
                     function processtag(variables : tstrings; tag : string) : TComponent;
                     function Extractvariables(input : string) : tstrings;
                     procedure LoadFromLines;
                     procedure LoadFromCaption;
                     procedure LoadFromFiles(filename : string);
                     procedure LoadFromStream(Stream: TStream);
                     procedure PrintText(text : string;isURL : boolean);
                     procedure NextLine;
                     procedure Update; overload;
                     procedure Update(index : integer); overload;
                     procedure Draw; overload;
                     procedure Draw(index : integer); overload;
                     procedure ReDraw;
                     procedure Clear;
                     procedure ClearCache(Left,Top,Right,Bottom : integer); overload;
                     procedure ClearCache; overload;
                     procedure UnSelectAll;
                     procedure UpdateSelection(StartPos,EndPos : TPoint);
                     procedure ScrollDown(Pixel : integer);
                     procedure ScrollUp(Pixel : integer);
                     function GetHeight(s : string; FontType : TFont) : integer;
                     function GetWidth(s : string; FontType : TFont) : integer;
                     function GetHtml : string;
                     function TotalSelected : integer;

                     procedure Bold;
                     procedure Underline;

                     procedure MouseMove(Sender: TObject; Shift: TShiftState; X,Y: Integer);
                     procedure MouseDown(Sender: TObject; Button: TMouseButton;
                                         Shift: TShiftState; X, Y: Integer);
                     procedure MouseUp(Sender: TObject; Button: TMouseButton;
                                         Shift: TShiftState; X, Y: Integer);
                     property Caption : TQzHtmlRec read GetCaption write SetCaption;
                 published

                   end;

////////////////////////////////////////////////////////////////////////////////
   atag      = class(TComponent)
               public
                  tagName : string;
                  aHtml : TQzMiniHtml2;
                  Width, Height : integer;
                  Left, Top, LineNumber : integer;
                  variables : tstrings;
                  LineHeight : integer;
                  Selected : boolean;
                  Visible : boolean;
                  constructor Create(AOwner: TComponent; Tag1 : string); overload; virtual;
                  function GetHtml : string; virtual;
                  procedure SetHtml(commands : tstrings); virtual;
                  procedure Draw(aCanvas : Tcanvas); virtual;
                  procedure Update; virtual;
                  function IsIn(aPoint : TPoint) : boolean; overload; virtual;
                  function IsIn(aRect  : TRect) : boolean; overload; virtual;
                end;
////////////////////////////////////////////////////////////////////////////////
   aVisTag   = class(aTag)
               public
               FontColor, URLColor, ActiveColor, VisitedColor : TColor;
               BackGroundColor : TColor;
               TargetURL : string;
               Visited, MouseOver : boolean;
               Font : TFont;
               align : string;
               constructor Create(AOwner: TComponent; Tag1 : string); override;
               destructor Destroy; override;
               procedure Select; virtual;
               procedure UnSelect; virtual;
               function IsIn(aPoint : TPoint) : boolean; overload; override;
               function IsIn(aRect  : TRect) : boolean; overload; override;
               end;
   aInVisTag = class(aTag)
               public
               procedure UpdateFontColor(Sender : aInVisTag; Tag : aVisTag; FontColor, URLColor, ActiveColor, VisitedColor : TColor);
               end;
 aInVisLNTag = class(aInVisTag);
 aLNInVisTag = class(aInVisTag);

////////////////////////////////////////////////////////////////////////////////
   aHtmlSTag = class(aInVisTag);
   aHtmlETag = class(aInVisTag);
   aHeadSTag = class(aInVisTag)
               public
                  procedure Update; override;
               end;
   aHeadETag = class(aInVisTag);
 aScriptSTag = class(aInVisTag)
               public
                  procedure Update; override;
               end;
 aScriptETag = class(aInVisTag);
   aBodySTag = class(aInVisTag)
               public
                  BackGroundColor, FontColor, URLColor, ActiveColor, VisitedColor : TColor;
                  procedure SetHtml(commands : tstrings); override;
                  function GetHtml : string; override;
                  procedure Update; override;
                  constructor Create(AOwner: TComponent; Tag1 : string); override;
               end;
   aBodyETag = class(aInVisTag);
   aFontSTag = class(aInVisTag)
               public
                  FontName : String;
                  absoluteFontSize : boolean;
                  FontSize : integer;
                  FontColor : TColor;
                  procedure SetHtml(commands : tstrings); override;
                  function GetHtml : string; override;
                  procedure Update; override;
                  constructor Create(AOwner: TComponent; Tag1 : string); override;
               end;
   aFontETag = class(aInVisTag);
aBlockquoteSTag = class(aLNInVisTag)
                  public
                  procedure Update; override;
                  end;
aBlockquoteETag = class(aInVisLNTag)
                  public
                  procedure Update; override;
                  end;
   aPSTag    = class(aLNInVisTag)
               public
                  Align : string;
                  BackGroundColor : TColor;
                  StartHeight,EndHeight : integer;
                  procedure SetHtml(commands : tstrings); override;
                  function GetHtml : string; override;
                  procedure Update; override;
                  procedure Draw(aCanvas : Tcanvas); override;
               end;
   aPETag    = class(aInVisLNTag);
   aBRTag   =  class(aInVisLNTag);
   aUSTag   = class(aInVisTag)
               public
                  procedure Update; override;
               end;
   aUETag   = class(aInVisTag);
   aBSTag   = class(aInVisTag)
               public
                  procedure Update; override;
               end;
   aBETag   = class(aInVisTag);
   aISTag   = class(aInVisTag)
               public
                  procedure Update; override;
               end;
   aIETag   = class(aInVisTag);
   aASTag   = class(aInVisTag)
               public
                  TargetURL : string;
                  procedure SetHtml(commands : tstrings); override;
                  function GetHtml : string; override;
                  procedure Update; override;
               end;
   aAETag   = class(aInVisTag);
   aULSTag   = class(aInVisLNTag)
               public
                  ShowType : string;
                  procedure SetHtml(commands : tstrings); override;
                  function GetHtml : string; override;
                  procedure Update; override;
               end;
   aULETag   = class(aInVisTag);
   aOLSTag   = class(aInVisLNTag)
               public
                  procedure Update; override;
               end;
   aOLETag   = class(aInVisTag);
  aTitleSTag = class(aInVisLNTag);
  aTitleETag = class(aInVisLNTag);
   aLIETag   = class(aInVisLNTag);

{   aTDETag = class(aVisTag)
               public
                  function GetHtml : string; override;
               end;
aTableSTag = class(aLNInVisTag)
               public
                 Width : integer;
                 CellsPerLine : integer;
                 procedure Update; override;
                 function GetHtml : string; override;
               end;
aTableETag = class(aInVisLNTag)
               public
                 function GetHtml : string; override;
               end;
   aTRSTag = class(aInvisSTag);
   aTRETag = class(aInvisETag);}
aTxtHideSTag = class(aLNInVisTag)
               public
                 TagName : string;
                 constructor Create(AOwner: TComponent;Tag : string); overload;
               end;

aTxtHideETag = class(aInVisLNTag)
               public
                 TagName : string;
                 procedure Update; override;
                 constructor Create(AOwner: TComponent;Tag : string); overload;
               end;

aUnknownSTag = class(aTxtHideSTag);
aUnknownETag = class(aTxtHideETag);

////////////////////////////////////////////////////////////////////////////////
   aSpace    = class(aVisTag)
               public
                  Text : string;
                  procedure Draw(aCanvas : Tcanvas); override;
                  procedure Update; override;
               end;
   aText     = class(aVisTag)
               public
                  Text : string;
                  SelStart, SelStop : integer;
                  SelStartX, SelStopX : integer;
                  procedure Draw(aCanvas : Tcanvas); override;
                  function GetHtml : string; override;
                  procedure Update; override;
                  procedure Select(TopLeft, BottomRight : TPoint; CheckLeftside, CheckRightside : boolean); overload;
                  procedure UnSelect; override;
                  constructor Create(AOwner: TComponent;input : string); override;
               end;
   aPicture  = class(aVisTag)
               public
                  Align : string;
                  PictureURL, Cache : string;
                  ActualHeight, ActualWidth : integer;
                  Text : string;
                  procedure Draw(aCanvas : Tcanvas); override;
                  constructor Create(AOwner: TComponent; Tag1 : string); override;
                  function GetHtml : string; override;
                  procedure Update; override;
               end;
   aHorizontalRule = class(aVisTag)
               public
                  rwidth, size : integer;
                  noshade : boolean;
                  procedure SetHtml(commands : tstrings); override;
                  procedure Draw(aCanvas : Tcanvas); override;
                  constructor Create(AOwner: TComponent; width : integer); overload;
                  function GetHtml : string; override;
                  procedure Update; override;
               end;
   aLISTag = class(aVisTag)
              public
                  ShowType : string;
                  Counter : integer;
                  procedure Draw(aCanvas : Tcanvas); override;
                  procedure Update; override;
               end;
{   aTDSTag = class(aVisTag)
              public
               Cell : TQzMiniHtml2;
               procedure Draw(aCanvas : Tcanvas); override;
               function GetHtml : string; override;
               procedure Update; override;
              end;}

THandler       = class(TComponent)
                  public
                     aMiniHtml : TQzMiniHtml2;
                     constructor Create(AOwner: TComponent; aHtml : TQzMiniHtml2); overload; virtual;
                     procedure MouseMove(Sender: TObject; Shift: TShiftState; X,Y: Integer); virtual;
                     procedure MouseDown(Sender: TObject; Button: TMouseButton;
                                         Shift: TShiftState; X, Y: Integer); virtual;
                     procedure MouseUp(Sender: TObject; Button: TMouseButton;
                                         Shift: TShiftState; X, Y: Integer); virtual;
                  end;
TBlockHandler = class(THandler)
                 public
                     procedure MouseMove(Sender: TObject; Shift: TShiftState; X,Y: Integer); override;
                     procedure MouseDown(Sender: TObject; Button: TMouseButton;
                                         Shift: TShiftState; X, Y: Integer); override;
                     procedure MouseUp(Sender: TObject; Button: TMouseButton;
                                         Shift: TShiftState; X, Y: Integer); override;
                 end;

TNormalHandler = class(THandler)
                  public
                     procedure MouseMove(Sender: TObject; Shift: TShiftState; X,Y: Integer); override;
                     procedure MouseDown(Sender: TObject; Button: TMouseButton;
                                         Shift: TShiftState; X, Y: Integer); override;
                     procedure MouseUp(Sender: TObject; Button: TMouseButton;
                                         Shift: TShiftState; X, Y: Integer); override;
                  end;

////////////////////////////////////////////////////////////////////////////////
function Tcolor2Webcolor(acolor : tcolor) : string;
function Webcolor2TColor(colorstring : string) : TColor;
procedure Register;

implementation
{$R QzHtml2.Res}
var MouseOver : TComponent;

function replace(source : string; fromm, too : string) : string;
var i : integer;
begin
        i := pos(fromm,'^' + source);
        if i <> 0 then
        begin
        dec(i);
        if i = 0 then
        result := too + copy(source,length(fromm),length(source)-length(fromm)+1);
        result := copy(source,0,i-1) + too + copy(source,i + length(fromm),length(source)-i-length(fromm)+1);
        end else
        result := source;
end;

procedure runwww(wwwpath : string);
begin
        if pos('mailto://',wwwpath) <> 0 then
        shellexecute(0,'open',pchar(
        'mailto:'+copy(wwwpath,10,length(wwwpath)-9)),'',
        '',SW_SHOWNORMAL) else
        shellexecute(0,'open',pchar(
        wwwpath),'',
        '',SW_SHOWNORMAL);
end;

function Tcolor2Webcolor(acolor : tcolor) : string;
begin
        Result := format('#%s%s%s',
        [inttohex(GetRValue(aColor),2),
        inttohex(GetGValue(aColor),2),
        inttohex(GetBValue(aColor),2)]);
end;

function Webcolor2TColor(colorstring : string) : TColor;
var 
    Red,Green,Blue : integer;
begin
        if colorstring = '' then Result := clBlack else
        if colorstring[1] = '#' then
        begin
        Red := StrtoInt('$' + Copy(colorstring,2,2));
        Green := StrtoInt('$' + Copy(colorstring,4,2));
        Blue := StrtoInt('$' + Copy(colorstring,6,2));
        Result := RGB(Red,Green,Blue);
        end else
        Result := StringtoColor(Colorstring);
end;

function CheckSelected(Selection : TRect; Tag : aTag) : boolean;
begin
  Result := False;
  if Tag is aVisTag then
    begin
     Result := aVisTag(Tag).IsIn(Selection);
    end;
end;

function PercentToSize(screenwidth : integer;Width : string; Default : integer) : integer;
var k : string;
begin
  k := Trim(Width);
  if Pos('%',k) = Length(k) then
    Result := ScreenWidth * StrToIntDef(Copy(k,0,Length(k)-1),100) div 100 else
    Result := StrToIntDef(Width,0);
  if Result = 0 then
    Result := Default;
  Result := Result - (Border * 2)
end;

constructor TQzHtmlRec.Create(o : TComponent);
begin
  inherited Create;
  Owner := o;
end;

procedure TQzHtmlRec.SetHtml(input : string; HKey : char);
begin
  Html := Input;
  HotKey := Hkey;
  TQzMiniHtml2(Owner).LoadFromCaption;
  if Assigned(FHtmlUpdate) then FHtmlUpdate(Owner,Input,HKey);

end;

{constructor TQzHtmlRec.Create(aMiniHtml : TComponent);
begin
  inherited Create;
  Owner := aMiniHtml;
end;

procedure TQzHtmlRec.SetHtml(html : string);
begin
  inputHtmlSyntax := html;
  TQzMiniHtml2(Owner).LoadFromCaption;
end;
}
procedure aVisTag.Select;
begin
  Selected := True;
end;

procedure aVisTag.UnSelect;
begin
  Selected := False;
end;

procedure AText.Select(TopLeft, BottomRight : TPoint; CheckLeftside, CheckRightside : boolean);
var charwidth : array of integer;
    index,total : integer;
    x1,x2,y1,y2 : integer;
function GetWidth(text : string) : integer;
begin
  Result := aHtml.GetWidth(text,Font);
end;
procedure fillCharWidth;
var i : integer;
begin
  SetLength(charwidth,Length(Text));
  for i := 1 to Length(Text) do
    CharWidth[i-1] := GetWidth(Text[i]);
end;
begin
  SelStart := -1;
  SelStop  := -1;
  if CheckLeftside then
    begin
      X1 := TopLeft.X;
      X2 := BottomRight.X;
    end else
    begin
      X2 := TopLeft.X;
      X1 := BottomRight.X;
    end;

  if TopLeft.Y < BottomRight.Y then
    begin
      Y1 := TopLeft.Y;
      Y2 := BottomRight.Y;
    end else
    begin
      Y2 := TopLeft.Y;
      Y1 := BottomRight.Y;
    end;
  fillCharWidth;

  If (X1 > Left) {and (X2 >= Left + Width)} then
  if CheckLeftSide then
  begin
  total := 0;
  index := 1;
  while (X1 > Left + total) and (index < Length(Text)) do
     begin
      Inc(Total,CharWidth[index-1]);
      Inc(index);
     end;
     SelStart := index;
     SelStartX := Left + Total;
     if SelStop = -1 then
     begin
      SelStopX := Width;
      SelStop := Length(Text);
     end;
  end;

  If CheckRightside then
  If (X2 <= Left + Width){ and (X2 < Left + Width)} then
  begin
    total := 0;
    index := Length(Text);
    while (BottomRight.X < Left + Width - Total) and (index > 0) do
     begin
      Inc(Total,CharWidth[index-1]);
      Dec(index);
     end;
     SelStop := index;
     SelStopX := Left + Width - Total;

     if SelStart = -1 then
      begin
      SelStartX := Left;
      SelStart := 1;
      end;

  end;
  //Selected := (SelStop - SelStart > 0)
end;

procedure AText.UnSelect;
begin
  Selected := False;
  SelStart := -1;
  SelStop := -1;
end;

function aTag.IsIn(aPoint : TPoint) : boolean;
begin
  Result := False;
end;

function aTag.IsIn(aRect  : TRect) : boolean;
begin
  Result := False;
end;

function aVisTag.IsIn(aPoint : TPoint) : boolean;
begin
  Result := False;
  if (height > 0) and (width > 0) then
  with aPoint do
  begin
  If ((X >= aHtml.Left+Left) and (X <= aHtml.Left+Left+width)) then
  If (Y >= Top-aHtml.Top+Height-LineHeight)  and (Y <= Top-aHtml.Top+Height)   then
    Result := True;
  end;
end;

function aVisTag.IsIn(aRect  : TRect) : boolean;
begin
  Result := False;
  if (height > 0) and (width > 0) then
  begin
  If IsIn(aRect.TopLeft) or IsIn(aRect.BottomRight) then
    Result := True;
  If ((aHtml.Left+Left>aRect.Left) and (aHtml.Left+Left+Width<aRect.Right))
  or ((aHtml.Left+Left<aRect.Left) and (aHtml.Left+Left+Width>aRect.Right)) then
  If ((Top-aHtml.Top+Height-LineHeight>aRect.Top) and (Top-aHtml.Top+Height<aRect.Bottom))
  or ((Top-aHtml.Top+Height-LineHeight<aRect.Top) and (Top-aHtml.Top+Height>aRect.Bottom)) then
    Result := True;
  end;
end;

procedure aInvisTag.UpdateFontColor(Sender : aInVisTag; Tag : aVisTag; FontColor, URLColor, ActiveColor, VisitedColor : TColor);
begin
      if FontColor <> -1 then Tag.FontColor := FontColor;
      if ActiveColor <> -1 then Tag.ActiveColor := ActiveColor;
      if VisitedColor <> -1 then Tag.VisitedColor := VisitedColor;
      if URLColor <> -1 then Tag.URLColor := URLColor;
end;

procedure aTag.SetHtml(commands : tstrings);
begin

end;

procedure aBodySTag.SetHtml(commands : tstrings);
begin
  if commands.IndexOfName('bgcolor') <> -1 then
       BackgroundColor := WebColor2TColor(commands.Values['bgcolor']);
  if commands.IndexOfName('text') <> -1 then
       FontColor := WebColor2TColor(commands.Values['text']);
  if commands.IndexOfName('link') <> -1 then
       URLColor := WebColor2TColor(commands.Values['link']);
  if commands.IndexOfName('vlink') <> -1 then
       ActiveColor := WebColor2TColor(commands.Values['vlink']);
  if commands.IndexOfName('alink') <> -1 then
       VisitedColor := WebColor2TColor(commands.Values['alink']);
end;

procedure aFontSTag.SetHtml(commands : tstrings);
var sizecmd : string;
    positive : boolean;
begin
  if commands.IndexOfName('face') <> -1 then
    fontname := commands.Values['face'];
  if commands.IndexOfName('name') <> -1 then
    fontname := commands.Values['name'];
  if commands.IndexOfName('color') <> -1 then
    fontcolor:= WebColor2TColor(commands.Values['color']);
  if commands.IndexOfName('size') <> -1 then
    begin
       sizecmd := commands.Values['size'];
       absoluteFontsize := true;
       positive := true;

       if (pos('+',sizecmd) <> 0) then
          begin
            absoluteFontsize := false;
            positive := true;
            sizecmd := Replace(sizecmd,'+',' ');
          end else
       if (pos('-',sizecmd) <> 0) then
          begin
            absoluteFontsize := false;
            positive := false;
            sizecmd := Replace(sizecmd,'-',' ');
          end;

        if positive and not absoluteFontsize then
          FontSize := DefaultFontSize + StrToIntDef(commands.Values['size'],0) else
        if not positive and not absoluteFontsize then
          FontSize := DefaultFontSize - StrToIntDef(commands.Values['size'],0) else
          FontSize := StrToIntDef(commands.Values['size'],DefaultFontSize);

    end;
end;

procedure aPSTag.SetHtml(commands : tstrings);
begin
  if commands.IndexOfName('align') <> -1 then
    Align := commands.Values['align'];
  if commands.IndexOfName('bgcolor') <> -1 then
    BackgroundColor := WebColor2TColor(commands.Values['bgcolor']);
end;

procedure aASTag.SetHtml(commands : tstrings);
begin
  if commands.IndexOfName('href') <> -1 then
    TargetURL := commands.Values['href'];
end;

procedure aULSTag.SetHtml(commands : tstrings);
begin
  if commands.IndexOfName('type') <> -1 then
    ShowType := commands.Values['type'];
end;


procedure aHorizontalRule.SetHtml(commands : tstrings);
begin
  if commands.IndexOfName('size') <> -1 then
    Size := strtointdef(commands.Values['size'],4);
  if commands.IndexOfName('width') <> -1 then
    rWidth := PercentToSize(aHtml.Width,commands.Values['width'],aHtml.width) else
  rWidth := PercentToSize(aHtml.Width,'a',aHtml.width);
  NoShade := commands.IndexOfName('noshade') <> -1;
end;


////////////////////////////////////////////////////////////////////////////////
function aTag.GetHtml : string;
begin
  Result := TagName;
end;

function aBodySTag.GetHtml : string;
var k : string;
begin
  k := '<body';
  if (variables.IndexOfName('bgcolor') <> -1) then
  k := k + Format(' bgcolor="%s"',[Tcolor2webcolor(BackGroundColor)]);
  if (variables.IndexOfName('text') <> -1) then
  k := k + Format(' text="%s"',[Tcolor2webcolor(FontColor)]);
  if (variables.IndexOfName('link') <> -1) then
  k := k + Format(' link="%s"',[Tcolor2webcolor(URLColor)]);
  if (variables.IndexOfName('vlink') <> -1) then
  k := k + Format(' vlink="%s"',[Tcolor2webcolor(ActiveColor)]);
  if (variables.IndexOfName('alink') <> -1) then
  k := k + Format(' alink="%s"',[Tcolor2webcolor(VisitedColor)]);
  k := k + '>';
  Result := k;
end;

function aFontSTag.GetHtml : string;
var k : string;
begin
  k := '<font';
  if (variables.IndexOfName('face') <> -1) or (variables.IndexOfName('name') <> -1) then
  if FontName <> '' then k := k + Format(' face="%s"',[FontName]);
  if (variables.IndexOfName('size') <> -1) then
  k := k + Format(' size="%s"',[Inttostr(FontSize)]);
  if (variables.IndexOfName('color') <> -1) then
  k := k + Format(' color="%s"',[Tcolor2webcolor(FontColor)]);
  k := k + '>';
  Result := k;
end;

function aPSTag.GetHtml : string;
var k : string;
begin
  k := '<p';
  if (variables.IndexOfName('align') <> -1) then
  k := k + Format(' align="%s"',[Align]);
    if (variables.IndexOfName('bgcolor') <> -1) then
  k := k + Format(' bgcolor="%s"',[Tcolor2webcolor(BackGroundColor)]);
  result := k + '>';
end;

function aASTag.GetHtml : string;
var k : string;
begin
  k := '<a';
  if (variables.IndexOfName('href') <> -1) then
  if TargetURL <> '' then k := k + Format(' href="%s"',[TargetURL]);
  k := k + '>';
  result := k;
end;

function aULSTag.GetHtml : string;
var k : string;
begin
  k := '<ul';
  if (variables.IndexOfName('type') <> -1) then
  if ShowType <> '' then k := k + Format(' type="%s"',[ShowType]);
  k := k + '>';
  result := k;
end;

//////////////////////////////////////////////////////////////////////////////

function aText.GetHtml : string;
begin
  Result := Text;
end;

function aPicture.GetHtml : string;
var k : string;
begin
  k := Format('<img src="%s"',[PictureURL]);
  if Width <> -1 then k := k + Format(' width="%d"',[Width]);
  if Height <> -1 then k := k + Format(' height="%d"',[Height]);
  k := k + '>';
  Result := k;
end;

function aHorizontalRule.GetHtml : string;
var k : string;
begin
  k := '<hr';
  if variables.IndexOfName('size') <> -1 then
    k := k + Format(' size="%d"',[size]);
  if variables.IndexOfName('width') <> -1 then
    k := k + Format(' width="%d"',[rwidth]);
  if variables.IndexOfName('noshade') <> -1 then
    k := k + ' noshade';
  k := k + '>';
  result := k;
end;

////////////////////////////////////////////////////////////////////////////////
procedure aTag.Update;
begin

end;

procedure aHeadSTag.Update;
var index,Level : integer;
    tag : atag;
begin
  index := aHtml.TagList.IndexOf(Self)+1;
  Level := 1;
  while (index <= aHtml.TagList.Count -1) and (level > 0) do
   begin
      tag := aHtml.TagList.Items[index];
      if (tag is aHeadSTag) then Inc(Level) else
      if (tag is aHeadETag) then Dec(Level) else
      if (tag is aVisTag) then
        begin
         aVisTag(Tag).Visible := False;
        end;
      Inc(Index);
   end;
end;

procedure aScriptSTag.Update;
var index,Level : integer;
    tag : atag;
begin
  index := aHtml.TagList.IndexOf(Self)+1;
  Level := 1;
  while (index <= aHtml.TagList.Count -1) and (level > 0) do
   begin
      tag := aHtml.TagList.Items[index];
      if (tag is aScriptSTag) then Inc(Level) else
      if (tag is aScriptETag) then Dec(Level) else
      if (tag is aVisTag) then
        begin
         aVisTag(Tag).Visible := False;
        end;
      Inc(Index);
   end;
end;

procedure aBodySTag.Update;
var index,Level : integer;
    tag : atag;
begin
  index := aHtml.TagList.IndexOf(Self)+1;
  Level := 1;
  while (index <= aHtml.TagList.Count -1) and (level > 0) do
   begin
      tag := aHtml.TagList.Items[index];
      if (tag is aBodySTag) then Inc(Level) else
      if (tag is aBodyETag) then Dec(Level) else
      if (tag is aVisTag) then
        begin
         UpdateFontColor(Self,aVisTag(Tag),FontColor,URLColor,ActiveColor,VisitedColor);
         aVisTag(Tag).BackGroundColor := BackGroundColor;
        end;
      Inc(Index);
   end;
   if (variables.IndexOfName('bgcolor') <> -1) then
   aHtml.BackGroundColor := BackGroundColor;
end;

procedure aPSTag.Update;
var index,Level : integer;
    tag : atag;
begin
  index := aHtml.TagList.IndexOf(Self)+1;
  Level := 1;
  while (index <= aHtml.TagList.Count -1) and (level > 0) do
   begin
      tag := aHtml.TagList.Items[index];
      if (tag is aPSTag) then Inc(Level) else
      if (tag is aPETag) then Dec(Level) else
      if (tag is aVisTag) then
        begin
        if (variables.IndexOfName('bgcolor') <> -1) then
         aVisTag(Tag).BackGroundColor := BackGroundColor;
        if (variables.IndexOfName('align') <> -1) then
         aVisTag(Tag).Align := Align;
        end;
      Inc(Index);
   end;
end;

procedure aFontSTag.Update;
var index,Level : integer;
    tag : atag;
begin
  index := aHtml.TagList.IndexOf(Self) + 1;
  Level := 1;
  while (index <  aHtml.TagList.Count) and (level > 0) do
   begin
      tag := aHtml.TagList.Items[index];
      if (tag is aFontSTag) then Inc(Level) else
      if (tag is aFontETag) then Dec(Level) else
      if (tag is aVisTag) then
        begin
         if (variables.IndexOfName('color') <> -1) then
         UpdateFontColor(Self,aVisTag(Tag),FontColor,-1,-1,-1);
         if (variables.IndexOfName('name') <> -1) or (variables.IndexOfName('Face') <> -1) then
         aVisTag(tag).Font.Name := FontName;
         if (variables.IndexOfName('size') <> -1) then
         aVisTag(tag).Font.Size := FontSize;
        end;
      Inc(Index);
   end;
end;

procedure aBlockquoteSTag.Update;
begin
  aHtml.Indent := INDENTSIZE;
end;

procedure aBlockquoteETag.Update;
begin
  aHtml.Indent := 0;
end;

procedure aUSTag.Update;
var index,Level : integer;
    tag : atag;
begin
  index := aHtml.TagList.IndexOf(Self) + 1;
  Level := 1;
  while (index <  aHtml.TagList.Count) and (level > 0) do
   begin
      tag := aHtml.TagList.Items[index];
      if (tag is aUSTag) then Inc(Level) else
      if (tag is aUETag) then Dec(Level) else
      if (tag is aVisTag) then
         aVisTag(tag).Font.Style := aVisTag(tag).Font.Style + [fsUnderline];
      Inc(Index);
   end;
end;

procedure aBSTag.Update;
var index,Level : integer;
    tag : atag;
begin
  index := aHtml.TagList.IndexOf(Self) + 1;
  Level := 1;
  while (index <  aHtml.TagList.Count) and (level > 0) do
   begin
      tag := aHtml.TagList.Items[index];
      if (tag is aBSTag) then Inc(Level) else
      if (tag is aBETag) then Dec(Level) else
      if (tag is aVisTag) then
         aVisTag(tag).Font.Style := aVisTag(tag).Font.Style + [fsBold];
      Inc(Index);
   end;
end;

procedure aISTag.Update;
var index,Level : integer;
    tag : atag;
begin
  index := aHtml.TagList.IndexOf(Self) + 1;
  Level := 1;
  while (index <  aHtml.TagList.Count) and (level > 0) do
   begin
      tag := aHtml.TagList.Items[index];
      if (tag is aISTag) then Inc(Level) else
      if (tag is aIETag) then Dec(Level) else
      if (tag is aVisTag) then
         aVisTag(tag).Font.Style := aVisTag(tag).Font.Style + [fsItalic];
      Inc(Index);
   end;
end;

procedure aASTag.Update;
var index,Level : integer;
    tag : atag;
begin
  index := aHtml.TagList.IndexOf(Self) + 1;
  Level := 1;
  while (index <  aHtml.TagList.Count) and (level > 0) do
   begin
      tag := aHtml.TagList.Items[index];
      if (tag is aASTag) then Inc(Level) else
      if (tag is aAETag) then Dec(Level) else
      if (tag is aVisTag) then
         aVisTag(tag).TargetURL := TargetURL;
      Inc(Index);
   end;
end;

procedure aULSTag.Update;
var index,Level : integer;
    tag : atag;
begin
  index := aHtml.TagList.IndexOf(Self) + 1;
  Level := 1;
  while (index <  aHtml.TagList.Count) and (level > 0) do
   begin
      tag := aHtml.TagList.Items[index];
      if (tag is aULSTag) then Inc(Level) else
      if (tag is aULETag) then Dec(Level) else
      if (tag is aLISTag) then
         aLISTag(tag).ShowType := ShowType;
      Inc(Index);
   end;
end;

procedure aOLSTag.Update;
var index,Level,counter : integer;
    tag : atag;
begin
  index := aHtml.TagList.IndexOf(Self) + 1;
  Level := 1;
  Counter := 0;
  while (index < aHtml.TagList.Count) and (level > 0) do
   begin
      tag := aHtml.TagList.Items[index];
      if (tag is aOLSTag) then Inc(Level) else
      if (tag is aOLETag) then Dec(Level) else
      if (tag is aLISTag) then
        begin
         Inc(Counter);
         aLISTag(tag).ShowType := 'number';
         aLISTag(tag).Counter := Counter;
        end;
      Inc(Index);
   end;
end;

procedure aTxtHideETag.Update;
var index,Level : integer;
    tag : atag;
begin
  index := aHtml.TagList.IndexOf(Self) - 1;
  Level := 1;
  while (index >= 0) and (level > 0) do
   begin
      tag := aHtml.TagList.Items[index];
      if (tag is aTxtHideETag) and (aTxtHideETag(Tag).TagName = TagName) then Inc(Level) else
      if (tag is aTxtHideSTag) and (aTxtHideSTag(Tag).TagName = TagName) then Dec(Level) else
      if (tag is aVisTag) then
        begin
         aVisTag(Tag).Visible := not HidTxtInUnkTag;
        end;
      Dec(Index);
   end;

end;

//////////////////////////////////////////////////////////////////////////////

procedure aSpace.Update;
begin
    if not Visible then
    begin
    Width := 0;
    Height := 0;
    end else
    begin
    Width := aHtml.GetWidth(' ',Font);
    Height := aHtml.GetHeight(' ',Font);
    end;
end;

procedure aText.Update;
begin
    if not Visible then
    begin
    Width := 0;
    Height := 0;
    end else
    begin
    Width := aHtml.GetWidth(Text,Font);
    Height := aHtml.GetHeight(Text,Font);
    end;
end;

procedure aPicture.Update;
var pic : TImage;
function DecodeFilename : string;
var url,protocol,value : string;
    i : integer;
begin
    if (Variables.IndexOfName('src') <> -1) then
       url := Variables.Values['src'];
    PictureURL := url;
    Result := url;
    if url <> '' then
    begin
    i := pos(':',url);
    if i <> 0 then
       protocol := copy(url,0,i-1);
    Inc(i);
    while (url[i] = '/') and (i < Length(url)) do
        Inc(i);

    value := Copy(url,i,length(url)-i+1);
    if protocol = 'file' then
       begin
       value := Replace(value,'|',':');
       value := Replace(value,'/','\');
       Result := value;
       end else
    if protocol = 'http' then
       begin
       // Not Yet
       //Result := DecodeFilename;
       end;
    end;
end;
begin
    if not Visible then
    begin
    Width := 0;
    Height := 0;
    end else
    begin
    pic := TImage.Create(nil);
    try
       pic.autosize := true;
       Cache := DecodeFilename;
       if fileexists(cache) then
       Pic.Picture.LoadFromFile(Cache);
       if (Variables.IndexOfName('height') = -1) then
           Height := Pic.Height else
           Height := StrToIntDef(Variables.Values['height'],Height);
       if (Variables.IndexOfName('width') = -1)  then
           Width := Pic.Width else
           Width := StrToIntDef(Variables.Values['height'],Width);
    finally
    pic.free;
    end;
    end;
end;

procedure aHorizontalRule.Update;
begin
    if not Visible then
    begin
    Width := 0;
    Height := 0;
    end else
    begin
    Height := Size + (20);
    Width := aHtml.width;
    end;
end;

procedure aLISTag.Update;
begin
    if not Visible then
    begin
    Width := 0;
    Height := 0;
    end else
    begin
    Width := INDENTSIZE;
    Height := aHtml.GetHeight('Test',Font);
    end;
end;


////////////////////////////////////////////////////////////////////////////////
constructor aTag.Create(AOwner: TComponent; Tag1 : string);
begin
    inherited Create(AOwner);
    TagName := Tag1;
end;

constructor aVisTag.Create(AOwner: TComponent; Tag1 : string);
begin
    inherited Create(AOwner,Tag1);
    Font := TFont.Create;
    Selected := False;
    FontColor := clBlack;
    URLColor  := clBlue;
    ActiveColor := clRed;
    VisitedColor := clPurple;
    BackGroundColor := ClNone;
    Visible := True;
end;

constructor aBodySTag.Create(AOwner: TComponent; Tag1 : string);
begin
  inherited Create(AOwner,Tag1);
  FontColor := clBlack;
  URLColor  := clBlue;
  ActiveColor := clRed;
  VisitedColor := clPurple;
end;

constructor aFontSTag.Create(AOwner: TComponent; Tag1 : string);
begin
  inherited Create(AOwner,Tag1);
  FontColor := clBlack;
  FontSize := DefaultFontSize;
  FontName := DefaultFontName;
end;

constructor aText.Create(AOwner: TComponent;input : string);
begin
  inherited Create(AOwner,input);
  Font.Name := DefaultFontName;
  Font.Size := DefaultFontSize;
  Text := '';
  SelStart := -1;
  SelStop := -1;
  Text := input;
end;

constructor aPicture.Create(AOwner: TComponent; Tag1 : string);
begin
  inherited Create(AOwner,Tag1);
  Align := '';
  PictureURL := '';
  Text := '';
end;

constructor aHorizontalRule.Create(AOwner: TComponent; width : integer);
begin
  inherited Create(AOwner);
  width := aHtml.width;
  size := 5;
  noshade := false;
end;

constructor aTxtHideSTag.Create(AOwner: TComponent;Tag : string);
begin
  inherited Create(AOwner);
  TagName := Tag;
end;

constructor aTxtHideETag.Create(AOwner: TComponent;Tag : string);
begin
  inherited Create(AOwner);
  if pos('/',Tag) = 1 then TagName := Copy(Tag,2,Length(Tag)-1) else
  TagName := Tag;
end;

destructor aVisTag.Destroy;
begin
    Font.Free;
end;
////////////////////////////////////////////////////////////////////////////////
procedure aTag.Draw(aCanvas : Tcanvas);
begin

end;
procedure aPSTag.Draw(aCanvas : Tcanvas);
var index,Level : integer;
    tag : atag;
begin
  index := aHtml.TagList.IndexOf(Self)+1;
  Level := 1;
  StartHeight := 10000;
  if (variables.IndexOfName('bgcolor') <> -1) then
  begin
  while (index <= aHtml.TagList.Count -1) and (level > 0) do
   begin
      tag := aHtml.TagList.Items[index];
      if (tag is aPSTag) then Inc(Level) else
      if (tag is aPETag) then Dec(Level) else
      if (tag is aVisTag) then
        begin
         if StartHeight > aVisTag(tag).Top then
         StartHeight := aVisTag(tag).Top;
         if EndHeight < aVisTag(tag).Top + aVisTag(tag).Height then
         EndHeight := aVisTag(tag).Top + aVisTag(tag).Height;
        end;
      Inc(Index);
   end;
  aCanvas.Brush.Color := BackgroundColor;
  aCanvas.Pen.Color := BackGroundColor;
  aCanvas.Rectangle(Border,StartHeight,aHtml.width-Border,EndHeight);
  end;
end;
procedure aSpace.Draw(aCanvas : Tcanvas);
begin
  if not Visible then exit;
  aCanvas.Pen.Color := aHtml.BackGroundColor;
  aCanvas.Brush.Color := aHtml.BackGroundColor;
  if Selected then
   begin
    aCanvas.Font.Color := aHtml.BackGroundColor;
    aCanvas.Brush.Color := BackGroundColor;//clActiveCaption;
    aCanvas.Pen.Color := clActiveCaption;
   end;
  //aCanvas.Pen.Color := clBlack;
  //aCanvas.Rectangle(Left,Top+Height-LineHeight,Left+Width,Top+Height);

  if TargetURL <> '' then
  begin
    if MouseOver then
      Font.Color := ActiveColor else
    if Visited then
      Font.Color := VisitedColor else
     Font.Color := URLColor;
    Font.Style := Font.Style + [fsUnderline];

  end;
  aCanvas.Font := Font;
  If (fsUnderline in Font.Style) then
  aCanvas.TextOut(Left,Top,' ');
end;

procedure aText.Draw(aCanvas : Tcanvas);
var x1, x2, y1, y2 : integer;
begin
  if not Visible then exit;
  if TargetURL <> '' then
    if MouseOver then
      Font.Color := ActiveColor else
    if Visited then
      Font.Color := VisitedColor else
    Font.Color := URLColor else
  Font.Color := FontColor;
  if Font.Color <> FontColor then Font.Style := Font.Style + [fsUnderline];
  aCanvas.Font := Font;

  aCanvas.Pen.Color := aHtml.BackGroundColor;

  if BackGroundColor=clNone then BackGroundColor := aHtml.BackGroundColor;

  aCanvas.Brush.Color := BackGroundColor;
  aCanvas.Rectangle(Left,Top+Height-LineHeight,Left+Width,Top+Height);


    if SelStart = -1 then
      x1 := Left else
      x1 := SelStartX;
    y1 := Top+Height-LineHeight;
    if SelStop = -1 then
      x2 := Left+Width else
      x2 := SelStopX;
    y2 := Top + Height;
  //  if Selected then aCanvas.Rectangle(x1,y1,x2,y2);

  // aCanvas.TextOut(Left,Top,Text);
  if Selected then
   begin
//    *Debug*
//    SelStart := 2;
//    SelStop := 6;
//    SelStartX := Left + 4;
//    SelStopX := Left + 8;
//    *Debug*
    aCanvas.Font.Color := aHtml.BackGroundColor;
    aCanvas.Brush.Color := clActiveCaption;
    aCanvas.Pen.Color := clActiveCaption;

   if SelStop - SelStart <> 0 then
        aCanvas.TextOut(x1,Top,Copy(Text,SelStart,SelStop-SelStart+1)) else
    aCanvas.TextOut(Left,Top,Text);

   end else  aCanvas.TextOut(Left,Top,Text);
end;

procedure aPicture.Draw(aCanvas : Tcanvas);
var pic : TImage;
    bitmap, bitmap2 : tbitmap;
begin
  if not Visible then exit;
    if cache <> '' then
        begin
         pic := TImage.Create(nil);
         bitmap := tbitmap.Create;
         bitmap2 := tbitmap.Create;
         pic.AutoSize := true;

         if fileexists(cache) then
            pic.Picture.LoadFromFile(cache);

         pic.Transparent := true;

         bitmap.Assign(pic.Picture.Graphic);
         bitmap.Transparent := true;
         bitmap.TransparentColor := clWhite;

         if (Variables.IndexOfName('width') <> -1) or
                            (Variables.IndexOfName('height') <> -1) then
         begin
         Bitmap2.Width := Width;
         Bitmap2.Height := Height;
         bitmap2.Transparent := true;
         bitmap2.TransparentColor := clWhite;

         StretchBlt(Bitmap2.Canvas.Handle,0,0,Bitmap2.Width,Bitmap2.Height,
                        Bitmap.Canvas.Handle,0,0,Bitmap.Width,Bitmap.Height,
                        SRCCOPY);

         acanvas.CopyRect(Rect(Point(Left,Top),
            Point(Left + Width,Top + Height)),
            bitmap2.Canvas,rect(0,0,Width,Height));

         end else
         acanvas.CopyRect(Rect(Point(Left,Top),
            Point(Left + Width,Top + Height)),
            bitmap.Canvas,rect(0,0,Width,Height));

         Bitmap.Free;
         Pic.Free;
         Bitmap2.Free;
         end;
end;

procedure aHorizontalRule.Draw(aCanvas : TCanvas);
var x2,y2 : integer;
begin
  if not Visible then exit;
    if Selected then
    begin
    aCanvas.Brush.Color := clActiveCaption;
    aCanvas.Pen.Color := clActiveCaption;
    aCanvas.Rectangle(Left,Top+Height-LineHeight,Left+Width,Top+Height);
    aCanvas.Pen.Color := aHtml.BackGroundColor;
    end
    else
    begin
    aCanvas.Brush.Color := aHtml.BackGroundColor;
    aCanvas.Pen.Color := aHtml.BackGroundColor;
    aCanvas.Rectangle(Left,Top+Height-LineHeight,Left+Width,Top+Height);
    aCanvas.Pen.Color := clBlack;
    end;

    if NOSHADE then
    aCanvas.Brush.Color := clGray;

    x2 := (aHtml.width - rWidth) div 2;
    y2 := Top+Height;
    aCanvas.Rectangle(x2,5+Top,Left+aHtml.width-x2-Border,5+Top+Size);
end;

procedure aLISTag.Draw(aCanvas : TCanvas);
begin
  if not Visible then exit;
  aCanvas.Font := Font;

  if BackGroundColor = clNone then BackGroundColor := aHtml.BackGroundColor;
  aCanvas.Brush.Color := BackGroundColor;
  aCanvas.Pen.Color := aCanvas.Brush.Color;
  if Selected then
   begin
    aCanvas.Font.Color := aCanvas.Brush.Color;
    aCanvas.Brush.Color := clActiveCaption;
    aCanvas.Pen.Color := clActiveCaption;
   end;

  aCanvas.Rectangle(Left,Top+Height-LineHeight,Left+Width+20,Top+Height);

  if ShowType = 'number' then
      aCanvas.TextOut(Left+(INDENTSIZE div 2),Top,Inttostr(Counter)+'.') else
  begin
  aCanvas.Brush.Color := clBlack;
  aCanvas.Brush.Style := bsSolid;

  if (ShowType = '') or (ShowType = 'round') then
      aCanvas.Ellipse(Left+(INDENTSIZE div 2),Top+4,
              Left+(INDENTSIZE div 2)+Font.Size,Top+Font.Size+4) else
  if (ShowType = 'square') or (ShowType = 'disk')then
      aCanvas.Rectangle(Left+Left+(INDENTSIZE div 2),Top+4,
              Left+(INDENTSIZE div 2)+Font.Size,Top+Font.Size+4);


  end;
end;


////////////////////////////////////////////////////////////////////////////////

constructor TQzMiniHtml2.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  TagList := TList.create;
  Lines := TStringList.Create;
  CacheBitmap := TBitmap.Create;
  CacheBitmap.Width := Width;
  Focused := -1;
  SelectStartFrom := -1;
  SelectEndAt := -1;
  Indent := 0;
  Selecting := False;
  BackGroundColor := clWhite;
  InputHtml := TQzHtmlRec.Create(Self);
  //InputHtml.Html := '<b>Test</b>';
end;

destructor TQzMiniHtml2.Destroy;
begin
  TagList.free;
  Lines.Free;
  CacheBitmap.Free;
  InputHtml.Free;
  inherited Destroy;
end;
function TQzMiniHtml2.processtag(variables : tstrings; tag : string) : TComponent;
var newTag : aTag;
    Tag1 : String;
    TagName : string;
begin
  Tag1 := Lowercase(Tag);
  TagName := '<' + Tag1 + '>';
  if Tag1 = ''       then begin Result := nil; exit; end   else
  if Tag1 = 'html'   then newTag := aHtmlSTag.Create(Self,TagName) else
  if Tag1 = '/html'  then newTag := aHtmlETag.Create(Self,TagName) else
  if Tag1 = 'head'   then newTag := aHeadSTag.Create(Self,TagName) else
  if Tag1 = '/head'  then newTag := aHeadETag.Create(Self,TagName) else
  if Tag1 = 'script' then newTag := aScriptSTag.Create(Self,TagName) else
  if Tag1 = '/script'then newTag := aScriptETag.Create(Self,TagName) else
  if Tag1 = 'body'   then newTag := aBodySTag.Create(Self,TagName) else
  if Tag1 = '/body'  then newTag := aBodyETag.Create(Self,TagName) else
  if Tag1 = 'font'   then newTag := aFontSTag.Create(Self,TagName) else
  if Tag1 = '/font'  then newTag := aFontETag.Create(Self,TagName) else
  if Tag1 = 'blockquote'   then newTag := aBlockquoteSTag.Create(Self,TagName) else
  if Tag1 = '/blockquote'  then newTag := aBlockquoteETag.Create(Self,TagName) else
  if (Tag1 = 'p') or (Tag1 = 'div')
                     then newTag := aPSTag.Create(Self,TagName)    else
  if (Tag1 = '/p') or (Tag1 = '/div')
                     then newTag := aPETag.Create(Self,TagName)    else
  if Tag1 = 'br'     then newTag := aBrTag.Create(Self,TagName) else
  if Tag1 = 'u'      then newTag := aUSTag.Create(Self,TagName)    else
  if Tag1 = '/u'     then newTag := aUETag.Create(Self,TagName)    else
  if (Tag1 = 'b')  or (Tag1 = 'strong')
                     then newTag := aBSTag.Create(Self,TagName)    else
  if (Tag1 = '/b') or (Tag1 = '/strong')
                     then newTag := aBETag.Create(Self,TagName)    else
  if (Tag1 = 'i')  or (Tag1 = 'em')
                     then newTag := aISTag.Create(Self,TagName)    else
  if (Tag1 = '/i') or (Tag1 = '/em')
                     then newTag := aIETag.Create(Self,TagName)    else
  if Tag1 = 'a'      then newTag := aASTag.Create(Self,TagName)    else
  if Tag1 = '/a'     then newTag := aAETag.Create(Self,TagName)    else
  if Tag1 = 'ul'     then newTag := aULSTag.Create(Self,TagName)   else
  if Tag1 = '/ul'    then newTag := aULETag.Create(Self,TagName)   else
  if Tag1 = 'ol'     then newTag := aOLSTag.Create(Self,TagName)   else
  if Tag1 = '/ol'    then newTag := aOLETag.Create(Self,TagName)   else
  if Tag1 = 'li'     then newTag := aLISTag.Create(Self,TagName)   else
  if Tag1 = '/li'    then newTag := aLIETag.Create(Self,TagName)   else
  if Tag1 = 'title'  then newTag := aTitleSTag.Create(Self,TagName) else
  if Tag1 = '/title' then newTag := aTitleETag.Create(Self,TagName) else
  if Tag1 = 'img'    then newTag := aPicture.Create(Self,TagName)  else
  if Tag1 = 'hr'     then newTag := aHorizontalRule.Create(Self,Width) else
  if Pos('/',Tag1)=1 then newTag := aUnknownETag.Create(Self,TagName) else
                          newTag := aUnknownSTag.Create(Self,TagName);

  newTag.aHtml := self;
  if (newTag is aVisTag) then
    aVisTag(newTag).BackGroundColor := BackGroundColor;
  newTag.variables := TStringList.Create;
  newTag.variables.addstrings(variables);
  newTag.SetHtml(variables);
  TagList.Add(newTag);
  Result := newTag;
end;

procedure TQzMiniHtml2.PrintText(text : string; isURL : boolean);
var newTag : aTag;
    i : integer;
    k,newtext : string;
begin
  k := Replace(text,'&nbsp;',' ');
  k := Replace(k,'&lt;','<');
  k := Replace(k,'&gt;','>');
  k := Replace(k,'&amp;','&');
  k := Replace(k,'&quot;','"');

  while (k <> '') do
     begin
     //k := Trim(k);
     i := pos(' ',k);
     if (i <> 0) and (not isURL) and (LINESPACING) then
      begin
       newtext := Copy(k,0,i-1);
       k := Copy(k,i+1,length(k)-i);
      end else
      begin
       newtext := k;
       k := '';
      end;

     if newtext <> '' then
     begin
     newTag := aText.Create(Owner,newtext);
     aText(newTag).Text := newtext;
     newTag.aHtml := self;
     TagList.Add(newTag);
     end;

     if i <> 0 then
     begin
     newTag := aSpace.Create(Owner,' ');
     newTag.aHtml := self;
     TagList.Add(newTag);
     end;

     end;
end;

procedure TQzMiniHtml2.LoadFromStream(Stream: TStream);
const ReadPerTurn = 100;
var i : integer;
    k : string;
    tagname,tagvar,beforetag,aftertag : string;
    variables : Tstrings;
    Tag : aTag;
function haveNonClosingTag(input : string) : boolean;
begin
    Result := False;
    if (pos('<',input) <> -1) and (pos('>',input) = -1) then
      Result := true;
end;
function ReadMore : string;
var k : string;
    Buf : array [0..ReadPerTurn-1] of Char;
    i : integer;
begin
    For i := 0 to ReadPerTurn-1 do
      Buf[i] := #0;
    While (Stream.Read(Buf,ReadPerTurn) <> 0) do
      begin
        k := k + Buf;
        if not haveNonClosingTag(k) then
          begin
            Result := k;
            exit;
          end;
      end;
    Result :=Buf;
end;
begin
  BackGroundColor := Color;
  Stream.Position := 0;
  TagList.Clear;
  k := k + ReadMore;
  While (k <> '') do
    begin
      Readnexttag(k,beforetag,aftertag,tagname,tagvar);
      if (TagList.Count > 0) then
          begin
            Tag := (TagList.Last);
            if (Tag is aASTag) or (Tag is aScriptSTag) then
            PrintText(beforetag, true) else
            PrintText(beforetag, false);
          end else PrintText(beforetag, false);

      variables := Extractvariables(tagvar);
      Tag := aTag(processtag(variables,tagname));

      k := aftertag + ReadMore;
    end;
    Update;
    Draw;
end;

procedure TQzMiniHtml2.LoadFromLines;
var aMemoryStream : TMemoryStream;
begin
  aMemoryStream := TMemoryStream.Create;
  aMemoryStream.Position := 0;
  Lines.SaveToStream(aMemoryStream);
  LoadFromStream(aMemoryStream);
  aMemoryStream.Free;
end;

procedure TQzMiniHtml2.LoadFromCaption;
var aMemoryStream : TMemoryStream;
begin
  Lines.clear;
  Lines.Add(Caption.Html);
  aMemoryStream := TMemoryStream.Create;
  aMemoryStream.Position := 0;
  Lines.SaveToStream(aMemoryStream);
  LoadFromStream(aMemoryStream);
  aMemoryStream.Free;
end;


procedure TQzMiniHtml2.LoadFromFiles(filename : string);
var aFileStream : TFileStream;
begin
  aFileStream := TFileStream.Create(filename,fmOpenRead);
  aFileStream.Position := 0;
  LoadFromStream(aFileStream);
  aFileStream.Free;
end;

function TQzMiniHtml2.Extractvariables(input : string) : tstrings;
var astrings : Tstrings;
    Working  : string;
procedure LocateNextVariables;
var i, j : integer;
    varname,varvalue : string;
begin
    Working := Trim(Working);
    i := pos('=',Working);
           varname := Copy(Working,0,i-1);
           j := pos('"',Working);
           if j <> 0 then Working := Copy(Working,j+1,length(Working)-j);
           j := pos('"',Working);

           if j = 0 then
              j := Length(Working)+1;
            varvalue:= Copy(Working,0,j-1);
            Working := Copy(Working,j+1,length(Working)-j);
           if varname <> '' then
             astrings.Values[lowercase(varname)] := lowercase(varvalue);

end;
begin
    astrings := TstringList.Create;
    Working := input;
    While (pos('=',Working) <> 0) and (Working <> '') do
       LocateNextVariables;
    if Working <> '' then
    aStrings.Values[lowercase(Trim(Working))] := lowercase('TRUE');
    Result := astrings;
end;

procedure TQzMiniHtml2.Readnexttag(text : string; var beforetag, aftertag, tagname, tagvars : string);
var i,j : integer;
    tag : string;
begin
  i := pos('<',text);
  j := pos('>',text);
  if (i = 0) or (j = 0) then
     begin
       tag := '';
       beforetag := text;
       aftertag := '';
     end else
     begin
       tag := Copy(text,i+1,j-i-1);
       beforetag := Copy(text,0,i-1);
       aftertag := Copy(text,j+1,length(text)-j);
     end;
  i := pos(' ',tag);
  if (i <> 0) and (tag <> '') then
    begin
       tagname := copy(tag,0,i-1);
       tagvars := Copy(tag,i,length(tag)-i+1);
    end else
    begin
       tagname := Copy(tag,i,length(tag)-i+1);
       tagvars := '';
    end;
end;

procedure TQzMiniHtml2.NextLine;
begin
 Canvas.MoveTo(Left,CurrentPos.Y + LineHeight);
 LineHeight := 0;
end;

procedure TQzMiniHtml2.Update(index : integer);
var Tag : aTag;
begin
 Tag := TagList.items[index];
 //ClearCache(Left+Tag.Left,Top+Tag.Top,
 //     Left+Tag.Left+Tag.Width,Top+Tag.Top+Tag.Height);
 aVisTag(Tag).Update;
 CacheBitmap.Canvas.Font := Canvas.Font;
 CacheBitmap.Canvas.Brush := Canvas.Brush;
end;

procedure TQzMiniHtml2.Update;
var i,index, MaxHeight : integer;
    Tag : aTag;
    CurrentX, CurrentY, LineHeight : integer;
    Line : integer;
    align1 : string;
procedure CheckAlign;
var current,modifier,j : integer;
    Tag : aTag;
begin
    current := i;
    Tag := TagList.items[current];
    modifier := 0;
    align1 := '';
    while (current > 0) and (Tag.LineNumber = Line) do
      begin
       If (Tag is aVisTag) then
         begin
              Inc(modifier,aVisTag(Tag).Width+TagSeperateSize);
              if aVisTag(Tag).align <> '' then
               align1 := aVisTag(Tag).align;
         end;
       Dec(current);
       Tag := TagList.items[current];
      end;
   if align1 = '' then exit;

   if align1 = 'right' then modifier := (width - modifier - Border - Border) else
   if align1 = 'centre' then modifier := (width - modifier - Border - Border) div 2 else
                           modifier := 0;
   For j := current to i do
     begin
       Tag := TagList.items[j];
       if modifier <> 0 then
       If (Tag is aVisTag) then Inc(Tag.Left,modifier);
     end;
end;
procedure NewLine;
begin
         CurrentX := Left + Border + Indent;
         CurrentY := CurrentY + LineHeight + TagSeperateSize + 5;
         LineHeight := 0;
         checkAlign;
         Inc(Line);
end;
begin
  CurrentX := Left + Border + Indent;
  CurrentY := Border;
  LineHeight := 0;
  MaxHeight := 0;
  Line := 0;
  if TagList.Count = 0 then exit;
  for i := 0 to TagList.Count -1 do
    begin
      Tag := TagList.items[i];

      Tag.Update;

      if (CurrentX + Tag.Width + Border > Width) or (Tag is aLNInVisTag) or (Tag is aHorizontalRule) then
        if (CurrentX <> Left + Border) then
          newLine;

      if (Tag is ablockquoteSTag) then
        CurrentX := Left + Border + INDENTSIZE;

      Tag.Left := CurrentX;
      if (Tag.Height <> 0) then
       if (Tag.Height >= LineHeight) and (Tag is aVisTag) then
        Tag.Top  := CurrentY else
        Tag.Top  := CurrentY + LineHeight - Tag.Height;

      Tag.LineNumber := Line;
      if Tag.Height + Tag.Top > MaxHeight then
          MaxHeight := Tag.Height + Tag.Top;

      Inc(CurrentX,Tag.Width+TagSeperateSize);
      if Tag.Height > LineHeight then
        begin
            LineHeight := Tag.Height;
            if i > 1 then
            begin
            Index := i-1;
            While (Index > 0) and
            (aTag(TagList[Index]).LineNumber = Line) do
              begin
                  aTag(TagList[Index]).Top :=
                      CurrentY + LineHeight - aTag(TagList[Index]).Height;
                  aTag(TagList[Index]).LineHeight := LineHeight;
                Dec(Index);
              end;
            end;

        end;
        if (Tag is aInVisLNTag) then
          newLine;
        Tag.LineHeight := LineHeight;
    end;
    CacheBitmap.Width := Width;
    CacheBitmap.Height := MaxHeight + Border;
end;

procedure TQzMiniHtml2.ClearCache;
begin
  CacheBitmap.Canvas.Lock;
  CacheBitmap.Canvas.Moveto(0,0);
  CacheBitmap.Canvas.Brush.Style := bsSolid;
  CacheBitmap.Canvas.Brush.Color := BackGroundColor;
  CacheBitmap.Canvas.Rectangle(0,0,CacheBitmap.Width,CacheBitmap.Height);
  CacheBitmap.Canvas.FillRect(CacheBitmap.Canvas.ClipRect);
  CacheBitmap.Canvas.UnLock;
end;
procedure TQzMiniHtml2.Clear;
begin
  Canvas.Lock;
  Canvas.Moveto(0,0);
  Canvas.Brush.Color := Color;
  Canvas.FillRect(Canvas.ClipRect);
  canvas.Brush.Style := bsSolid;
  Canvas.UnLock;
end;

procedure TQzMiniHtml2.ClearCache(Left,Top,Right,Bottom : integer);
begin
  Canvas.Lock;
  Canvas.Moveto(left,Top);
  Canvas.Brush.Color := BackGroundcolor;
  canvas.Brush.Style := bsSolid;
  Canvas.FillRect(Rect(Left,Top,Right,Bottom));
  Canvas.UnLock;
end;


procedure TQzMiniHtml2.ReDraw;
begin
  Canvas.Lock;
  //Canvas.CopyMode := cmSrcInvert	;
  //Canvas.CopyMode := cmWhiteness;
  //Clear;
{  Canvas.CopyRect(
                  Rect(Left,Top,Width,Height),
                  CacheBitmap.Canvas,
                  Rect(ScrollLeft,ScrollTop,ScrollLeft+Width,ScrollTop+Height)
                  );                           }
  Canvas.BrushCopy(
                  Rect(Left,Top,Left+CacheBitmap.Width,Top+CacheBitmap.Height),
                  CacheBitmap,
                  Rect(ScrollLeft,ScrollTop,ScrollLeft+CacheBitmap.Width,ScrollTop+CacheBitmap.Height),
                  Color
                  );
  Canvas.UnLock;
end;

procedure TQzMiniHtml2.Draw(index : integer);
begin
 CacheBitmap.Canvas.Lock;
 aVisTag(TagList[index]).Draw(CacheBitmap.Canvas);
 CacheBitmap.Canvas.UnLock;
end;

procedure TQzMiniHtml2.Draw;
var CurrentPos : TPoint;
    i : integer;
    Tag : aTag;
begin
try

  CacheBitmap.Canvas.Lock;

  //Clear;
  ClearCache;

  CacheBitmap.Canvas.MoveTo(CurrentPos.X,CurrentPos.Y);
  for i := 0 to TagList.Count -1 do
    begin
      Tag := TagList.items[i];
      CacheBitmap.Canvas.Brush := Canvas.Brush;
      CacheBitmap.Canvas.Pen := Canvas.Pen;
      Draw(i);
    end;
    finally
    CacheBitmap.Canvas.Unlock;
    end;

  Redraw;
end;

function TQzMiniHtml2.GetHeight(s : string; FontType : TFont) : integer;
begin
  Canvas.Font := Fonttype;
  Result := Canvas.TextHeight(s+'A');
end;

function TQzMiniHtml2.GetWidth(s : string; FontType : TFont) : integer;
begin
 CacheBitmap.Canvas.Font := Fonttype;
 Result := CacheBitmap.Canvas.TextWidth(s);
end;

function TQzMiniHtml2.GetHtml : string;
var i : integer;
begin
 result := '';
 for i := 0 to tagList.Count -1 do
  result := result + atag(taglist.Items[i]).GetHtml;
end;

procedure TQzMiniHtml2.UpdateSelection(StartPos,EndPos : TPoint);
var i : integer;
    tag : aTag;
procedure UpdatenDraw(too : boolean);
begin
        if Assigned(Tag) then
        if not (aVisTag(Tag).Selected = too) then
        begin
        aVisTag(Tag).Selected := too;
        if Tag is aVisTag then
           begin
            Update(i);
            Draw(i);
           end;
        end;
end;
begin
    SelectStartFrom := -1;
    SelectEndAt := -1;
    UnselectAll;
    i := 0;
    Repeat
       tag := TagList.items[i];
       Inc(i);
    Until ((Tag is aVisTag) and (CheckSelected(Rect(StartPos,EndPos),Tag)) or
          (i >= TagList.Count));

    if (i < TagList.Count) and (Tag is aVisTag) and CheckSelected(Rect(StartPos,EndPos),Tag) then
      SelectStartFrom := TagList.IndexOf(Tag) else exit;

    i := TagList.Count -1;
    Repeat
       tag := TagList.items[i];
       Dec(i);
    Until ((Tag is aVisTag) and (CheckSelected(Rect(StartPos,EndPos),Tag)) or
          (i < 0));

    if (i >=0) and (Tag is aVisTag) and CheckSelected(Rect(StartPos,EndPos),Tag) then
      SelectEndAt := TagList.IndexOf(Tag) else exit;

    If SelectStartFrom <> SelectEndAt then
      begin
        Tag := TagList.items[SelectStartFrom];
        if (Tag is AText) then AText(Tag).Select(StartPos,EndPos,True,False);
        Tag := TagList.items[SelectEndAt];
        if (Tag is AText) then AText(Tag).Select(StartPos,EndPos,False,True);
      end else
      begin
        Tag := TagList.items[SelectStartFrom];
        if (Tag is AText) then AText(Tag).Select(StartPos,EndPos,True,True);;
      end;

    if (SelectEndAt <> -1) and (SelectStartFrom <> -1) then
    begin
      for i := SelectStartFrom to SelectEndAt do
       begin
        Tag := aTag(TagList[i]);
        UpdatenDraw(True);
       end;
   end;
end;

procedure TQzMiniHtml2.MouseMove(Sender: TObject; Shift: TShiftState; X,Y: Integer);
begin
    If Assigned(MouseKBHandler1) then
      THandler(MouseKBHandler1).MouseMove(Sender,Shift,X,Y);
    If Assigned(MouseKBHandler2) then
      THandler(MouseKBHandler2).MouseMove(Sender,Shift,X,Y);
end;

procedure TQzMiniHtml2.MouseDown(Sender: TObject; Button: TMouseButton;
                                 Shift: TShiftState; X, Y: Integer);
begin
  If Assigned(MouseKBHandler1) then
      THandler(MouseKBHandler1).MouseDown(Sender,Button,Shift,X,Y);
  If Assigned(MouseKBHandler2) then
      THandler(MouseKBHandler2).MouseDown(Sender,Button,Shift,X,Y);
end;

procedure TQzMiniHtml2.MouseUp(Sender: TObject; Button: TMouseButton;
                               Shift: TShiftState; X, Y: Integer);
begin
  If Assigned(MouseKBHandler1) then
      THandler(MouseKBHandler1).MouseUp(Sender,Button,Shift,X,Y);
  If Assigned(MouseKBHandler2) then
      THandler(MouseKBHandler2).MouseUp(Sender,Button,Shift,X,Y);
end;

procedure TQzMiniHtml2.UnSelectAll;
var i : integer;
    tag : aTag;
begin
  for i := 0 to TagList.Count -1 do
    begin
       tag := TagList.items[i];
        if aVisTag(Tag).Selected then
       begin
        aVisTag(Tag).Selected := False;
        if Tag is aText then
          aText(Tag).UnSelect;
        if Tag is aVisTag then begin Update(i); Draw(i); end;
        end;
    end;
  ReDraw;
end;

procedure TQzMiniHtml2.ScrollDown(Pixel : integer);
begin
  if CacheBitmap.Height <= Height then exit;
  if ScrollTop - Pixel >= 0 then Dec(ScrollTop,Pixel) else
     ScrollTop := 0;
  ReDraw;
end;

procedure TQzMiniHtml2.ScrollUp(Pixel : integer);
begin
  if CacheBitmap.Height <= Height then exit;
  If ScrollTop + Height + Pixel <= CacheBitmap.Height  then Inc(ScrollTop,Pixel) else
     ScrollTop := CacheBitmap.Height -  Height;
  ReDraw;
end;


function TQzMiniHtml2.TotalSelected : integer;
var counter, i : integer;
begin
  Counter := 0;
  for i := 0 to TagList.Count -1 do
    if aTag(TagList.items[i]).Selected then Inc(Counter);
  Result := Counter;
end;
procedure TQzMiniHtml2.Underline;
var i, s1, s2 : integer;
    newTag,Tag4 : aTag;
begin
  If (SelectStartFrom <> -1) and (SelectEndAt <> -1) then
   begin
     s2 := SplitSelected(SelectEndAt);
     s1 := SplitSelected(SelectStartFrom);
     newTag := aUETag.Create(Self);
     newTag.aHtml := self;
     newTag.variables := TStringList.Create;
     TagList.Insert(s2+1,newTag);

     newTag := aUSTag.Create(Self);
     TagList.Insert(s1,newTag);
     newTag.aHtml := self;
     newTag.variables := TStringList.Create;

     Update;
     Draw;
     ReDraw;
   end;
end;

procedure TQzMiniHtml2.Bold;
var i, s1, s2 : integer;
    newTag,Tag4 : aTag;
begin
  If (SelectStartFrom <> -1) and (SelectEndAt <> -1) then
   begin
     s2 := SplitSelected(SelectEndAt);
     s1 := SplitSelected(SelectStartFrom);
     newTag := aBETag.Create(Self);
     newTag.aHtml := self;
     newTag.variables := TStringList.Create;
     TagList.Insert(s2+1,newTag);

     newTag := aBSTag.Create(Self);
     TagList.Insert(s1,newTag);
     newTag.aHtml := self;
     newTag.variables := TStringList.Create;

     Update;
     Draw;
     ReDraw;
   end;
end;


function TQzMiniHtml2.SplitSelected(splitwhich : integer) : integer;
var i : integer;
    Tag4 : aTag;
    Tag1,Tag2,Tag3 : aText;
    k : string;
begin
    Result := splitwhich;
    if aTag(TagList.items[splitwhich]).Selected then
     begin
       Tag4 := TagList.items[splitwhich];
       if Tag4 is aText then
        with AText(Tag4) do
        if (SelStart <> 0) or (SelStop <> Length(AText(Tag4).text)) then
        if (SelStart <> -1) and (SelStop <> -1) then
          begin
            k := Copy(Text,SelStop+1,Length(Text)-SelStop);
            if k <> '' then
              begin
               Tag3 := AText.Create(Self,k);
               Tag3.Selected := false;
               Tag3.aHtml := self;
               Tag3.variables := TStringList.Create;
               TagList.Insert(splitwhich,Tag3);
              end;
            k := Copy(Text,SelStart,SelStop-SelStart+1);
            if k <> '' then
              begin
               Tag2 := AText.Create(Self,k);
               Tag2.Selected := True;
               Tag2.aHtml := self;
               Tag2.variables := TStringList.Create;
               TagList.Insert(splitwhich,Tag2);

              end;
            k := Copy(Text,0,SelStart-1);
            if k <> '' then
              begin
               Tag1 := AText.Create(Self,k);
               Tag1.Selected := false;
               Tag1.aHtml := self;
               Tag1.variables := TStringList.Create;
               TagList.Insert(splitwhich,Tag1);
              end;

            TagList.Delete(TagList.IndexOf(Tag4));
            //Tag4.Free;
            if Assigned(Tag2) then
            Result := TagList.IndexOf(Tag2);
          end;
    end;
end;

procedure TQzMiniHtml2.SetCaption(Value : TQzHtmlRec);
begin
  InputHtml := Value;
  LoadFromCaption;
end;

function TQzMiniHtml2.GetCaption : TQzHtmlRec;
begin
  Result := InputHtml;
end;


procedure THandler.MouseMove(Sender: TObject; Shift: TShiftState; X,Y: Integer);
begin end;
procedure THandler.MouseDown(Sender: TObject; Button: TMouseButton;Shift: TShiftState; X, Y: Integer);
begin end;
procedure THandler.MouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin end;
constructor THandler.Create(AOwner: TComponent; aHtml : TQzMiniHtml2);
begin
  inherited Create(AOwner);
  aMiniHtml := aHtml;
end;


procedure TNormalHandler.MouseMove(Sender: TObject; Shift: TShiftState; X,Y: Integer);
var i : integer;
    Tag1 : aTag;
begin
  MouseOver := nil;
  with aMiniHtml do
  begin
  if taglist.Count = 0 then exit;
  if Lines.Count = 0 then exit;

  Focused := -1;
  for i := 0 to tagList.Count -1 do
    begin
    Tag1 := tagList.items[i];
    if Tag1 is aVisTag then
    begin
    if aVisTag(Tag1).IsIn(Point(X,Y)) then
      begin
      Focused := i;
      MouseOver := Tag1;
      if not aVisTag(Tag1).MouseOver then
          begin
          aVisTag(Tag1).MouseOver := True;
          Update(i);
          if aVisTag(Tag1).TargetURL <> '' then
              Draw(i);
          end;
      end
      else {ISIN}
      if aVisTag(Tag1).MouseOver then
          begin
          aVisTag(Tag1).MouseOver := False;
          Update(i);
          if aVisTag(Tag1).TargetURL <> '' then
              Draw(i);
          end;
         end;
    end;

    Redraw;
    If Sender is TControl then
    if MouseOver = nil then
        TControl(Sender).Cursor := crDefault else
         if aVisTag(MouseOver).TargetURL <> '' then
            TControl(Sender).Cursor := crHandPoint else
            TControl(Sender).Cursor := crDefault;
end;
end;

Procedure TNormalHandler.MouseDown(Sender: TObject; Button: TMouseButton;
                           Shift: TShiftState; X, Y: Integer);
var Tag1 : aTag;
begin
  with aMiniHtml do
  if (Button = mbLeft) then
  if (Focused <> -1) then
   begin
    Tag1:= tagList.items[Focused];
    if (aVisTag(Tag1).IsIn(Point(X,Y))) and
       (aVisTag(Tag1).TargetURL <> '') then
         begin
          RunWWW(aVisTag(Tag1).TargetURL);
          exit;
         end;
   end;
end;
procedure TNormalHandler.MouseUp(Sender: TObject; Button: TMouseButton;
                           Shift: TShiftState; X, Y: Integer);
begin
end;


procedure TBlockHandler.MouseMove(Sender: TObject; Shift: TShiftState; X,Y: Integer);
begin
    with aMiniHtml do
    begin
    if (Selecting) and ((Abs(LastPos.X - X) > 10) or (Abs(LastPos.Y - Y) > 10)) then
    begin
    LastPos := Point(X,Y);
    UpdateSelection(StartPos,Point(X,Y));
    end;
    ReDraw;
    end;
    If Sender is TControl then
    if MouseOver = nil then
        TControl(Sender).Cursor := crDefault else
         if aVisTag(MouseOver).TargetURL <> '' then
            TControl(Sender).Cursor := crHandPoint else
         if (MouseOver is aText) or (MouseOver is aSpace) and (aVisTag(MouseOver).MouseOver)then
            TControl(Sender).Cursor := crIBeam else
            TControl(Sender).Cursor := crDefault;
end;

Procedure TBlockHandler.MouseDown(Sender: TObject; Button: TMouseButton;
                           Shift: TShiftState; X, Y: Integer);
begin
 with aMiniHtml do
 begin
  if Lines.Count = 0 then exit;
   UnSelectAll;
   ReDraw;
   Selecting := true;

   StartPos  := Point(X,Y);
   LastPos := StartPos;
 end;
end;
procedure TBlockHandler.MouseUp(Sender: TObject; Button: TMouseButton;
                           Shift: TShiftState; X, Y: Integer);
begin
  with aMiniHtml do
  begin
  if Lines.Count = 0 then exit;

  if Selecting then
  begin
  Selecting := false;
  EndPos  := Point(X,Y);

  UpdateSelection(StartPos,Point(X,Y));
  end;

  ReDraw;
  end;
end;

procedure Register;
begin
  RegisterComponents('QZip', [TQzMiniHtml2]);
end;

end.
