unit QzHtmlPropertyEditor2;
{*********************************************************}
{*               QzHTMLPropertyEditor2.pas               *}
{*               Quick Zip HTML property Editor          *}
{*     Copyright (c) 2003 Joseph Leung Yat Chun          *}
{*                 All rights reserved.                  *}
{*********************************************************}

interface

uses
  DesignIntf, DesignEditors,
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls, ToolWin, ExtCtrls, QzMiniHtml2, ImgList,
  QzHtmlEditor2;

const HtmlEditorHeight = 260;
type
TQzHtmlProperty=class(TStringProperty{TPropertyEditor})
  public
    function GetAttributes: TPropertyAttributes; override;
    procedure SetValue(const Value: string); override;
    function GetValue: string; override;
    procedure Edit; override;
  end;

procedure Register;
implementation

function TQzHtmlProperty.GetAttributes:TPropertyAttributes;
begin
  Result:=[paDialog,paReadOnly,paMultiSelect];
end;

procedure TQzHtmlProperty.SetValue(const Value: string);
begin

end;

function TQzHtmlProperty.GetValue: string;
begin
  FmtStr(Result, '(%s)', [GetPropType^.Name]);
end;

procedure TQzHtmlProperty.Edit;
var
  aQzHtmlEditor : TQzHtmlEditor2;
  P:TPoint;
  Count : integer;
begin
aQzHtmlEditor := TQzHtmlEditor2.Create(nil);
with aQzHtmlEditor do
try
  GetCursorPos(P);
  Left:=P.X;
  If P.Y + HtmlEditorHeight < Screen.Height - 20 then
      Top := P.Y else
      Top := Screen.Height - HtmlEditorHeight - 20;
  HotKey := TQzHtmlRec(GetOrdValue).Hotkey;
  Html := TQzHtmlRec(GetOrdValue).Html;

  if Execute then
    for Count:=0 to PropCount-1 do
        begin
        TQzHtmlRec(GetOrdValueAt(Count)).SetHtml(Html,HotKey);
        end;
  Modified;
finally
  Free;
end;
end;

procedure Register;
begin
  RegisterPropertyEditor(TypeInfo(TQzHtmlRec),nil,'',TQzHtmlProperty);
end;


end.
