unit QzHtmlEditor2;
{*********************************************************}
{*                    QzHTMLEditor.pas                   *}
{*                  Quick Zip HTML Editor                *}
{*     Copyright (c) 2003 Joseph Leung Yat Chun          *}
{*                 All rights reserved.                  *}
{*********************************************************}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls, ToolWin, ExtCtrls, QzMiniHtml2, ImgList,
  QzHtmlScrollBox2, ExtDlgs;

const FONTS = 'Font Name';
      SIZE  = 'Size';
      SYMBOLS = 'Insert Symbols';
      MAXSIZE = 15;
      EditorHeight = 260;
      EditorWidth = 430;
type
  THtmlEditor_sc = class(TForm)
    ToolBar1: TToolBar;
    FontName: TComboBox;
    FontSize: TComboBox;
    Bold: TToolButton;
    Italic: TToolButton;
    Underline: TToolButton;
    Panel1: TPanel;
    Panel2: TPanel;
    Button1: TButton;
    Button2: TButton;
    ToolbarImages: TImageList;
    ToolButton4: TToolButton;
    Bullet: TToolButton;
    FontColor: TToolButton;
    ColorDialog1: TColorDialog;
    ComboBox1: TComboBox;
    Edit1: TEdit;
    Label1: TLabel;
    Link: TToolButton;
    Background: TToolButton;
    QzHtmlScrollBox21: TQzHtmlScrollBox2;
    Splitter1: TSplitter;
    ToolButton1: TToolButton;
    OpenPictureDialog1: TOpenPictureDialog;
    Memo1: TRichEdit;
    procedure FormShow(Sender: TObject);
    procedure Memo1Change(Sender: TObject);
    procedure BoldClick(Sender: TObject);
    procedure ItalicClick(Sender: TObject);
    procedure UnderlineClick(Sender: TObject);
    procedure FontNameChange(Sender: TObject);
    procedure Memo1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Memo1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FontSizeChange(Sender: TObject);
    procedure BulletClick(Sender: TObject);
    procedure FontColorClick(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure Image1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure LinkClick(Sender: TObject);
    procedure BackgroundClick(Sender: TObject);
    procedure ToolButton1Click(Sender: TObject);
    procedure Memo1SelectionChange(Sender: TObject);
  private
    { Private declarations }
    procedure GetFontNames;
  public
    Strack : boolean;
    procedure Insert2Memo(pre,post : string);
    { Public declarations }
  end;


TQzHtmlEditor2 = class(TComponent)
                 private
                 htmlinput : string;
                 Strack : boolean;
                 public
                 Hotkey : char;
                 Left,Top : integer;
                 Height, Width : integer;
                 function Execute : boolean;
                 published
                 property Html : string read htmlinput write htmlinput;
                 property SelectionTrack : boolean read strack write strack;
                 end;

procedure Register;
var showingtext : string;
implementation
{$R *.dfm}

function TQzHtmlEditor2.Execute : boolean;
var Form1 : THtmlEditor_sc;
begin
  Result := False;
  Form1 := THtmlEditor_sc.create(Self);
  Width := EditorWidth;
  Height := EditorHeight;
  Form1.Strack := sTrack;
  with Form1 do
  try
    ShowingText := Html;
    if hotkey <> ' ' then
      Edit1.Text := hotkey else
      Edit1.Text := '';

    If Self.Left = 0 then
    Form1.Left := (Screen.Width - Self.Width) div 2 else
    Form1.Left   := Self.Left;

    If Self.Top = 0 then
    Form1.Top    := (Screen.Height - Self.Height) div 2 else
    Form1.Top    := Self.Top;

    Showmodal;
    If ModalResult = MrOk then
    begin
      Html := Memo1.Text;
      if Edit1.Text = '' then
        hotkey := ' ' else
        hotkey := Edit1.Text[1];
      Result := True;
    end;
  finally
    Free;
  end;

end;

procedure THtmlEditor_sc.FormShow(Sender: TObject);
var i : integer;
begin
  FontName.Text := FONTS;
  FontSize.Text := SIZE;
  QzHtmlScrollBox21.color := clWhite;
  GetFontNames;
  for i := 1 to MAXSIZE do
    Fontsize.Items.Add(inttostr(i));
  Memo1.Text := Showingtext;
  QzHtmlScrollBox21.QzMiniHtml2.MouseKBHandler1 := TNormalHandler.Create(Self,QzHtmlScrollBox21.QzMiniHtml2);
end;

function EnumFontsProc(var LogFont: TLogFont; var TextMetric: TTextMetric;
  FontType: Integer; Data: Pointer): Integer; stdcall;
begin
  TStrings(Data).Add(LogFont.lfFaceName);
  Result := 1;
end;

procedure THtmlEditor_sc.GetFontNames;
var
  DC: HDC;
begin
  DC := GetDC(0);
  EnumFonts(DC, nil, @EnumFontsProc, Pointer(FontName.Items));
  ReleaseDC(0, DC);
  FontName.Sorted := True;
end;

procedure THtmlEditor_sc.Memo1Change(Sender: TObject);
begin
  QzHtmlScrollBox21.Html := Memo1.Lines.Text;
  QzHtmlScrollBox21.QzMiniHtml2.ScrollTop :=
      QzHtmlScrollBox21.VertScrollBar.Position;
  QzHtmlScrollBox21.QzMiniHtml2.ReDraw;
end;

procedure THtmlEditor_sc.BoldClick(Sender: TObject);
begin
  Insert2Memo(Format('<b>',[FontName.Text]),'</b>');
end;

procedure THtmlEditor_sc.ItalicClick(Sender: TObject);
begin
  Insert2Memo(Format('<i>',[FontName.Text]),'</i>');end;

procedure THtmlEditor_sc.UnderlineClick(Sender: TObject);
begin
  Insert2Memo(Format('<u>',[FontName.Text]),'</u>');
end;

procedure THtmlEditor_sc.Insert2Memo(pre,post : string);
var counter : integer;
begin
  counter := Length(pre)+Memo1.SelStart+Memo1.SelLength;
  Memo1.SelText := pre + Memo1.SelText + post;
  Memo1.SetFocus;
  Memo1.SelStart := counter;
end;

procedure THtmlEditor_sc.FontNameChange(Sender: TObject);
begin
  if (FontName.Text = '') or (FontName.Text = FONTS) then exit;
  Insert2Memo(Format('<font name="%s">',[FontName.Text]),'</font>');
end;

procedure THtmlEditor_sc.Memo1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  FontName.Text := FONTS;
  FontSize.Text := SIZE;
end;

procedure THtmlEditor_sc.Memo1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  FontName.Text := FONTS;
  FontSize.Text := SIZE;
  Case Key of
  vk_Return : if Shift = [ssShift] then Memo1.SelText := '<br>';
  Ord(',')  : if Shift = [ssShift] then Memo1.SelText := '&lt;';
  Ord('.')  : if Shift = [ssShift] then Memo1.SelText := '&gt;';
  end;

end;

procedure THtmlEditor_sc.FontSizeChange(Sender: TObject);
begin
  if (FontSize.Text = '') or (FontSize.Text = SIZE) then exit;
  Insert2Memo(Format('<font size="%s">',[FontSize.Text]),'</font>');
end;

procedure THtmlEditor_sc.BulletClick(Sender: TObject);
begin
  If Memo1.SelLength <> 0 then
   Insert2Memo('<ul><li>','</li><li>Second Bullet</li></ul>') else
   Insert2Memo('<ul><li>FirstBullet','</li><li>Second Bullet</li></ul>');
end;

procedure THtmlEditor_sc.FontColorClick(Sender: TObject);
begin
 if ColorDialog1.Execute then
 Insert2Memo(Format('<font color="%s">',[Tcolor2Webcolor(ColorDialog1.Color)]),'</font>');
end;

procedure THtmlEditor_sc.ComboBox1Change(Sender: TObject);
begin
  if Combobox1.Text <> SYMBOLS then
  Case Combobox1.ItemIndex of
  0 : Memo1.SelText := '&lt;';
  1 : Memo1.SelText := '&gt;';
  2 : Memo1.SelText := '&amp;';
  3 : Memo1.SelText := '&quot;';
  end;
//  Combobox1.ItemIndex := -1;
//  Combobox1.Text := SYMBOLS

end;

procedure THtmlEditor_sc.Image1MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  QzHtmlScrollBox21.QzMiniHtml2.MouseMove(Sender,Shift,X,Y);
end;

procedure Register;
begin
  RegisterComponents('QZip', [TQzHtmlEditor2]);
end;


procedure THtmlEditor_sc.LinkClick(Sender: TObject);
var k : string;
begin
  k := Inputbox('Insert Html Link','Please specify html link e.g. http://qzip.cjb.net','http://qzip.cjb.net');
  if k <> '' then
    Insert2Memo(Format('<a href="%s">',[k]),'</a>');
end;

procedure THtmlEditor_sc.BackgroundClick(Sender: TObject);
begin
 if ColorDialog1.Execute then
 Insert2Memo(Format('<p bgcolor="%s">',[Tcolor2Webcolor(ColorDialog1.Color)]),'</p>');
end;

procedure THtmlEditor_sc.ToolButton1Click(Sender: TObject);
begin
  if OpenPictureDialog1.Execute then
  Insert2Memo(Format('<img src="%s">',[OpenPictureDialog1.Filename]),'');
end;

procedure THtmlEditor_sc.Memo1SelectionChange(Sender: TObject);
var k,l : string;
    i,j : integer;
begin
  if sTrack then
  begin
  if Memo1.SelLength > 0 then
  begin
  with Memo1 do
  l := Copy(Text,SelStart+SelLength+1,Length(Text)-SelStart+SelLength);
  i := Pos('<',l);
  j := Pos('>',l);

  if (j >= i) or (i = 0) or (j = 0) then
  begin
  with Memo1 do
  k := Copy(Text,0,SelStart)+'<selection>'+
       SelText + '</selection>' + l;
  QzHtmlScrollBox21.html := k;
  end;
  end else
  begin
    QzHtmlScrollBox21.QzMiniHtml2.UnSelectAll;
  end;

  QzHtmlScrollBox21.VertScrollBar.Position
     := QzHtmlScrollBox21.QzMiniHtml2.ScrollTop;
  end;
end;

end.
