/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//	CONTROL.H					(c)	YoY'01						WEB: www.aestesis.org
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#ifndef							_CONTROL_H_
#define							_CONTROL_H_
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#include						"elektrodef.h"
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//	If you use directly the variables in the class API, it's at your own risks. Prefer the methods...   

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define							guidCONTROL						(Acontrol::CI.guid)

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//!  a class that manage midi/keyboard shortcuts and recording sequence.
class Acontrol : public Anode
{
public:

//! enum controler type
enum
{
	NOTHING=0,
	CONTROLER_01=1,
	CONTROLER_02,
	CONTROLER_03,
	CONTROLER_04,
	CONTROLER_05,
	CONTROLER_06,
	CONTROLER_07,
	CONTROLER_08,
	CONTROLER_09,
	CONTROLER_10,
	KEY_01=100,
	KEY_02,
	KEY_03,
	KEY_04,
	KEY_05,
	KEY_06,
	KEY_07,
	KEY_08,
	KEY_09,
	KEY_10,
	KEY_11,
	KEY_12,
	KEY_13,
	KEY_14,
	KEY_15,
	KEY_16,
	KEY_17,
	KEY_18,
	KEY_19,
	KEY_20
};

	ELIBOBJ

	EDLL						Acontrol						(char *name, class Aeffect *ef, class Aobject *o, int type=NOTHING);
	EDLL virtual				~Acontrol						();

	EDLL virtual bool			notify							(Anode *o, int event, dword p);

	EDLL virtual bool			set								(int control, int value);

	EDLL virtual bool			sequence						(int control, int value);

	class Aeffect				*effect;
	class Atable				*table;
	class Aobject				*object;						// the object with control
	int							control;

	int							id;								// todo: when save/load make give the sames ID*
	class Atrack				*track;
};

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//! a class that display the midi/keyboard shortcuts properties (elektronika internal)
class Amapping : public Aobject
{
public:
	ELIBOBJ

								Amapping						(char *name, Aobject *father, Acontrol *control);
								~Amapping						();

	virtual void				paint							(Abitmap *b);
	virtual bool				notify							(Anode *o, int event, dword p=0);
	virtual bool				mouse							(int x, int y, int state, int event);

	Acontrol					*control;
	Abutton						*close;
};

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif							//_CONTROL_H_
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
