#include <stdio.h>
#include <string.h>

#define MAXTYPELEN      2
#define MAXNAMELEN      128
#define MAXPATHLEN      512
#define MAXHOSTLEN      128
#define MAXPORTLEN      6

main()
{
   FILE* fi;
   FILE* fo;
   char  buf[512];
   char* s;
   char* a;
   char  type[MAXTYPELEN + 1];
   char  name[MAXNAMELEN + 1];
   char  path[MAXPATHLEN + 1];
   char  host[MAXHOSTLEN + 1];
   char  port[MAXPORTLEN + 1];
   int   flag = 0;
   int   line = 0;

   printf( "\nMKCACHE - By Mark Morley (mark@IslandNet.com)\n" );
   if( (fi = fopen( "menu", "r" )) == NULL )
   {
      printf( "Error opening menu file." );
      exit( 0 );
   }
   if( (fo = fopen( "cache", "w" )) == NULL )
   {
      printf( "Error opening cache file." );
      exit( 0 );
   }
   for( fgets( buf, 512, fi ); !feof( fi ); fgets( buf, 512, fi ) )
   {
      line++;
      buf[strlen( buf ) - 1] = 0;
      for( s = buf; *s == ' ' || *s == '\t'; s++ );
      if( *s == 0 || *s == '#' )
         continue;
      for( a = s; *a && *a != ' ' && *a != '\t' && *a != '='; a++ );
      if( *a )   *a++ = 0;
      while( *a == ' ' || *a == '\t' || *a == '=' )   a++;
      strlwr( s );
      if( !strcmp( s, ":" ) )
      {
         if( flag )
            fprintf( fo, "%s%s\t%s\t%s\t%s\n", type, name, path, host, port );
         flag = 0;
         fprintf( fo, "i%s\ti\t\t\n", a );
      }
      else if( !strcmp( s, "name" ) )
      {
         if( flag )
            fprintf( fo, "%s%s\t%s\t%s\t%s\n", type, name, path, host, port );
         strncpy( name, a, MAXNAMELEN );
         name[MAXNAMELEN] = 0;
         type[0] = 0;
         strcpy( port, "70" );
         flag = 1;
      }
      else if( !strcmp( s, "type" ) )
      {
         strncpy( type, a, MAXTYPELEN );
         type[MAXTYPELEN] = 0;
      }
      else if( !strcmp( s, "path" ) )
      {
         strncpy( path, a, MAXPATHLEN );
         path[MAXPATHLEN] = 0;
         if( *path == 0 )
            *type = '1';
         else if( *type == 0 )
            *type = *path;
      }
      else if( !strcmp( s, "host" ) )
      {
         strncpy( host, a, MAXHOSTLEN );
         host[MAXHOSTLEN] = 0;
      }
      else if( !strcmp( s, "port" ) )
      {
         strncpy( port, a, MAXPORTLEN );
         port[MAXPORTLEN] = 0;
      }
      else
      {
         printf( "Fatal error on line %d: %s?\n", line, s );
         fclose( fo );
         fclose( fi );
         unlink( "cache" );
         exit( 0 );
      }
   }
   if( flag )
      fprintf( fo, "%s%s\t%s\t%s\t%s\n", type, name, path, host, port );
   printf( "Compiled %d lines.\n", line );
   fclose( fo );
   fclose( fi );
}