{$DEFINE USEHEAP}    {heap usage still not implemented}
                     { X11 remarks   mark debugging keypressed breaks }
Unit ABI_DOM;
{******************************

Things that still need to be done in this unit:
 - The domain-lookup routine (resolver) should check to see if the
   address it is looking up is already a number or not.
 - I have not yet figured out the Flags and opcodes completely so it
   does not check for errors such as dTC ("Respose was larger than packet
   size"), and the respose codes (ok, format error, name error, etc).

*****************************}

Interface

Uses DOS, XSTRING, ABI;

{$I TCP.INC}


CONST
      MaxDNS  = 10;
      DOMSIZE = 512;
{Flag masks for in the DNS packet header}
      dQR     = $8000;  { query = 0, response = 1 }
      dOPCODE = $7800;  {WATTCP was wrong??? } { mask for opcode (follows next) }
      dAA     = $0400;  { Authoritative Answer }
      dTC     = $0200;  { Truncated (reponse was more than the 512 maximum) }
      dRD     = $0100;  { Recursion Desired }
      dRA     = $0080;  { Recursion Available }
      dRCODE  = $000F;  { mask for response code (follows next after opcode) }
{ possible opcode values (sent) }
      dOPQUERY = 0;    { a normal standard query }
      dOPIQ    = 1;    { an inverse query }
      dOPCQM   = 2;    { a completion query, multiple reply }
      dOPCQU   = 3;    { a completion query, single reply }
{ possible response codes (received) }
      dROK     = 0;    { ok }
      dRFORM   = 1;    { format error }
      dRFAIL   = 2;    { Domain-Name-server failure (problem on their side) }
      dRNAME   = 3;    { name error, we know name doesn't exist }
      dRNOPE   = 4;    { no can do request }
      dRNOWAY  = 5;    { name server refusing to do request }


var
  DNSIPAddr : IPAddr;
  DomainQTimeout : Word;
  DomainQTries : Byte;
  DomainCNAME:String;
  DomainPTR:String;
  DomainDNS:String;
  DomainDNSIP:IPAddr;
  DomainExtra:String[80];
  DomainError:String[150];
  LookupFail : Boolean;
  RCode,OpCodes :Word; { Byte }
  dResponse : Boolean;
  dAuthAnswer : Boolean;
  dTruncated : Boolean;
  dRecursionDesired : Boolean;
  dRecursionAvail : Boolean;
{  DomainAAIP :IPAddr; }


{ IPTOASCII - converts IPAddr format to text #.#.#.# }
Function IPTOASCII(tIPAddr : IPAddr) : String;

{ aton - converts text #.#.#.# to IPAddr format }
Procedure aton(textaddress:string; var ipaddress:IPAddr);

{ isaddress - returns 1 if string is ascii address, otherwise 0}
Function isaddress(textaddress:string):Boolean;

{ ipcompare - }
Function IPCompare(IPOne:IPAddr; IPTwo:IPAddr):Boolean;

{ ********** DNS lookup stuff *********** }
{packedtota - src = CPoint}
Function packedtota(Buffer:BufferREC; var src:Word):String;  {PACKEDTOTextAddress}

{tatopacked - }
Function tatopacked(textaddress:string):String; {TextAddressTOPACKED}

{resolve - }
Function resolve(var textaddress:string; var ipaddress:IPAddr; Opts:Integer):Integer;

Function GetHostByName(textaddress:string; var ipaddress:IPAddr; Opts:Integer):Integer;
Function GetHostByAddr(var textaddress:string; ipaddress:IPAddr; Opts:Integer):Integer;

(****************************** Implementation ******************************)
implementation

TYPE   DNSInfoREC   = RECORD
                       ID    : Word;
                       Flags : Word;
                       QDCOUNT : Word;
                       ANCOUNT : Word;
                       NSCOUNT : Word;
                       ARCOUNT : Word;
                     END;
       DNSInfo2REC  = RECORD
                       QType : Word;
                       QClass : Word;
                     END;
       RRInfoREC    = RECORD
                       RRName : String;
                       RRType : Word;
                       RRClass : Word;
                       TTL   : Word;
                       RDLength : Word;
                     END;
       QDInfoREC    = RECORD
                       QDName : String;
                       QDType : Word;
                       QDClass : Word;
                     END;
var
   PKTID  :Word;
   TmpIP  : IPAddr;
   TmpLong: LongInt;
   CPoint :Word;
   UDPDNSQ:udpSessionREC;
   DQ      :DNSInfoREC;
   DQ2     :DNSInfo2REC;
   QDInfo : QDInfoREC;
   RRInfo :RRInfoREC;
   debugf : text;
  AToSend : String[100];
  WasQuery: String[100];
  DNSDNT:Array[0..MaxDNS] of String[100];
  DNSIP :Array[0..MaxDNS] of IPAddr;
  DNSDNS, LastDNSDNS: Word;
  CurrentDNSIP:IPAddr;
  CurrentDNS, LastDNS:LongInt;



Function IPTOASCII(tIPAddr : IPAddr) : String;
var tString : String[16];            {255.255.255.255}
		tDigit	: String[3];
		tCount	: Byte;
		AddrLen : Byte;
begin
		tString:='';
		for tCount:=0 to 3 do
			 begin
					Str(Ord(tIPAddr[tCount]),tDigit);
					tString:=tString+tDigit;
          if tCount<3 then tString:=tString+'.';
			 end;
    IPTOASCII:=tString;
end;

Function IPCompare(IPOne:IPAddr; IPTwo:IPAddr):Boolean;
 var
   LA, LB : LongInt;
 begin
   Move(IPOne, LA, 4);
   Move(IPTwo, LB, 4);
   IPCompare:=(LA=LB);
 end;

Procedure aton(textaddress:string; var ipaddress:IPAddr);
 var
    i:byte;
    tmpint:integer;
    cur:array[0..4] of byte;  {0=before first digit, 1=., 2=., 3=., 4=after last digit}
    TmpByte:Byte;
    Result:Integer;
    TmpRes:IPAddr;
 begin
    For I:=0 to 3 do ipaddress[I]:=0;
    cur[3]:=Length(textaddress);
    for TmpInt:=0 to 4 do cur[TmpInt]:=0;

    i:=Instr('.',textaddress,1);
    cur[1]:=i;
    i:=Instr('.',textaddress,i+1);
    cur[2]:=i;
    i:=Instr('.',textaddress,i+1);
    cur[3]:=i;
    i:=Instr('.',textaddress,i+1);

    for TmpInt:=1 to 3 do
      begin
        if cur[TmpInt]=0 then
            begin
               TmpRes[0]:=0; TmpRes[1]:=0; TmpRes[2]:=0; TmpRes[3]:=0;
               exit;
            end;
      end;

    TmpInt:=0;
    for I:=1 to cur[1] do
         if (textaddress[I]>='0') and (textaddress[I]<='9') then
                   begin
                    cur[0]:=I-1;
                    break;
                   end;
    for I:=Length(textaddress) downto cur[3] do
         if (textaddress[I]>='0') and (textaddress[I]<='9') then
                   begin
                    cur[4]:=I;
                    If I=Length(textaddress) then
                      begin
                        cur[4]:=I+1;
                      end;
                    break;
                   end;

    for I:=0 to 3 do
      begin
       Val(' '+Copy(textaddress,cur[I]+1,(cur[I+1]-1-cur[I])), TmpByte, Result);
        If (TmpByte<0) or (TmpByte>255) or (not (result=0)) then
            begin
               TmpRes[0]:=0; TmpRes[1]:=0; TmpRes[2]:=0; TmpRes[3]:=0;
               exit;
            end;
        TmpRes[I]:=TmpByte;
      end;
    ipaddress:=TmpRes;
 end;

Function isaddress(textaddress:string):Boolean;
 var
   TmpLong:LongInt;
   TmpAddr:IPAddr;
 begin
   aton(textaddress,TmpAddr);
   TmpLong:=0;
   Move(TmpAddr,TmpLong,4);
   If TmpLong=0 then isaddress:=false  else isaddress:=true;
 end;


(******************* DNS stuff ********************)

                                                                    {packedtota}
Function packedtota(Buffer:BufferREC; var src:Word):String;
 var                                     {note: src = CPoint}
  TmpByte:Byte;
  I:Integer;
  retval:Word;                          {XHEREX}
  savesrc:Word;
  dst:String;
 begin
   savesrc:=src;
   dst:='';
   retval:=0;
     { src MUST = C }

    repeat
         TmpByte:=Ord(Buffer.Buffer[src]);

         while (TmpByte AND $C0)=$C0 do
            begin
              if retval=0 then retval:=src+2;    { C to D }
              inc(src);
              src:= (TmpByte AND $3F)*256+Ord(Buffer.Buffer[src])+1;
              TmpByte:=Ord(Buffer.Buffer[src]);      { at point E (indexed by D) }           {*1*}
             end;
          For I:=1 to (TmpByte and $3F) do
             begin
               dst:=dst+Buffer.Buffer[src+I];                                                  {*1*}
             end;
             src:=src+I+1;
             dst:=dst+'.';
    until (Ord(Buffer.Buffer[src])=0) or (src >= Buffer.Length);
   dst[Length(dst)]:=#0;
   dst[0]:=Chr(Length(dst)-1);  {we dont need no stinking null terminator}
   Inc(src);

   if retval=0 then retval:=src;
   src:=retval;
   packedtota:=dst;
 end;

                                                                   {tatopacked}
Function tatopacked(textaddress:string):String;
 var
  TmpStr:String;
  TmpRes:String;
  LSet:Byte;
  OSet:Byte;
  TmpChar:Char;
  TmpWStr:String;
 begin
  TmpStr:=textaddress;
  TmpRes:='';  LSet:=0;
  repeat
    OSet:=0;
    TmpWStr:='';
    repeat
      Inc(OSet);
      TmpChar:=TmpStr[OSet];
      If TmpChar<>'.' then TmpWStr:=TmpWStr+TmpChar;
    until (TmpChar='.') or (Length(TmpStr)=OSet);
    If Length(TmpStr)=OSet then Inc(OSet);
    TmpRes:=TmpRes+CHR(OSet-1)+TmpWStr;
    TmpStr:=Copy(TmpStr,OSet+1, Length(TmpStr)-OSet);
  until (Length(TmpStr)=0);
  tatopacked:=TmpRes+#0;
 end;

Function packdom(var dst:string; src:string):Byte;
 var
  p:Byte;  TmpChar:Char;  TmpWStr:String;
 begin
  dst:='';
  if (length(src) > 63) then
    begin
      packdom:=0;
      exit;
    end;
  repeat
    p:=0;
    TmpWStr:='';
    repeat
      Inc(p);
      TmpChar:=src[p];
      If TmpChar<>'.' then TmpWStr:=TmpWStr+TmpChar;
    until (TmpChar='.') or (Length(src)=p);
    If Length(src)=p then Inc(p);
    dst:=dst+CHR(p-1)+TmpWStr;
    src:=Copy(src,p+1, Length(src)-p);
  until (Length(src)=0);
  dst:=dst+#0;
  packdom:=length(dst);
 end;

(********** Resolvers ***********)

Procedure GetRRInfo(var RRInfo:RRInfoREC);
begin
  RRInfo.RRName:=packedtota(UDPDNSQ.Buffer, CPoint);
  RRInfo.RRType:=Ord(UDPDNSQ.Buffer.Buffer[CPoint])*256+
                         Ord(UDPDNSQ.Buffer.Buffer[CPoint+1]);
  CPoint:=CPoint+2;
  RRInfo.RRClass:=Ord(UDPDNSQ.Buffer.Buffer[CPoint])*256+
                         Ord(UDPDNSQ.Buffer.Buffer[CPoint+1]);
  CPoint:=CPoint+2;
  RRInfo.TTL:=Ord(UDPDNSQ.Buffer.Buffer[CPoint+3]);  {sheesh}
  CPoint:=CPoint+4;
  RRInfo.RDLength:=Ord(UDPDNSQ.Buffer.Buffer[CPoint])*256+
                         Ord(UDPDNSQ.Buffer.Buffer[CPoint+1]);
  CPoint:=CPoint+2;
end;

Procedure GetQDInfo(var QDInfo:QDInfoREC);
begin
  QDInfo.QDName:=packedtota(UDPDNSQ.Buffer, CPoint);
  QDInfo.QDType:=Ord(UDPDNSQ.Buffer.Buffer[CPoint])*256+
                         Ord(UDPDNSQ.Buffer.Buffer[CPoint+1]);
  CPoint:=CPoint+2;
  QDInfo.QDClass:=Ord(UDPDNSQ.Buffer.Buffer[CPoint])*256+
                         Ord(UDPDNSQ.Buffer.Buffer[CPoint+1]);
  CPoint:=CPoint+2;
end;

{ True on error, puts built packet in UDPDNSQ.Buffer }
Function BuildReverseDNSQuery(therequest:IPAddr):Boolean;
var  TmpStr  : String[28];
Begin
  BuildReverseDNSQuery := True;
  If IPCompare(therequest, NullAddr) then exit;
  Move(therequest, TmpLong, 4);
  TmpLong := Intel(TmpLong);
  Move(TmpLong, TmpIP, 4);
  TmpStr := IPTOASCII(TmpIP)+'.IN-ADDR.ARPA'; {004.003.002.001.IN-ADDR.ARPA}
  WasQuery := TmpStr;
  AToSend := tatopacked(TmpStr);
  DQ.ID      := Intel16( PKTID );
  DQ.Flags   := Intel16( dRD );     { DomainRecursionDesired }
  DQ.qdcount := Intel16( 1 );       { just one query}
  DQ.ancount := 0;   DQ.nscount := 0;   DQ.arcount := 0;
  DQ2.qtype  := Intel16( $0C );     { requesting just the Host_Address rrecord }
  DQ2.qclass := Intel16( 1 );       { ARPA internet class }
  Move(DQ, UDPDNSQ.Buffer.Buffer, SizeOf(DQ));
  UDPDNSQ.Buffer.Length := SizeOf(DQ);
  AddBuffer(UDPDNSQ.Buffer, 1, AToSend);
  Move(DQ2, AToSend[1], SizeOf(DQ2));      { replacing AToSend with DQ2 record }
  AToSend[0]:=Chr(SizeOf(DQ2));
  AddBuffer(UDPDNSQ.Buffer, 1, AToSend);
  BuildReverseDNSQuery := False;
End;

{ True on error, puts built packet in UDPDNSQ.Buffer }
Function BuildDNSQuery(therequest:String):Boolean;
Begin
  BuildDNSQuery := True;
  If Length(therequest)=0 then exit;
  AToSend    := tatopacked(therequest);
  WasQuery   := therequest;
  DQ.ID      := Intel16( PKTID );
  DQ.Flags   := Intel16( DRD );
  DQ.qdcount := Intel16( 1 );
  DQ.ancount := 0;    DQ.nscount := 0;   DQ.arcount := 0;
  DQ2.qtype  := Intel16( 1 );    { Requesting Host_Address rrecord }
  DQ2.qclass := Intel16( 1 );    { ARPA internet class }
  Move(DQ, UDPDNSQ.Buffer.Buffer, SizeOf(DQ));
  UDPDNSQ.Buffer.Length := SizeOf(DQ);
  AddBuffer(UDPDNSQ.Buffer, 1, AToSend);
  Move(DQ2, AToSend[1], SizeOf(DQ2));    { replacing AToSend with DQ2 record }
  AToSend[0]:=Chr(SizeOf(DQ2));
  AddBuffer(UDPDNSQ.Buffer, 1, AToSend);
  BuildDNSQuery := False;
End;

Function resolve(var textaddress:string; var ipaddress:IPAddr; Opts:Integer):Integer;
 var
   TmpStr:String;
   AToSend:String;
   TmpWStr:String;
   TmpChar:Char;
   TmpByte:Byte;
   TmpWord:Word;
   RCount:Word;
   WasIP :IPAddr;
  TmpSeg:Word;
  TmpOff:Word;
  ToDisLength:Word;
  wCount:Word;
  TmpHex:String;
  Depth:Word;


     Procedure GetUDPDNSPacket(domainname:string; dnsserver:IPAddr);
      label ReSend;
      var
       I:Integer;
       Tries:Integer;
       TmpB:Boolean;
      begin

       If udp_Open(UDPDNSQ, 0, CurrentDNSIP, 0, DOMAIN_PORT)<>0 then
         begin
            DomainError:='Not able to open UDP port to DNS Server?';
            Resolve:=0;
            LookupFail:=True;
            exit;
         end;

       Tries:=0;
ReSend:
       aton(domainname, TmpIP);
       If IsAddress(domainname) then TmpB:=BuildReverseDNSQuery(TmpIP)
                                else TmpB:=BuildDNSQuery(domainname);
       If TmpB then
         begin
           DomainError:='Unable to build DNS Query packet';
           Resolve :=0;
           LookupFail:=True;
           result:=udp_Close(UDPDNSQ, 0);
           CPoint:=13;
           Exit;
         end;

       Result:=udp_Send(UDPDNSQ, 0, PKTID, 0, 0, DomainQTimeOut);
       if Result<>0 then
         begin
           DomainError:='Can''t send UDP packet?';
           exit;
         end;

       UDPDNSQ.pktInfo.id:=0;
       wCount:=0;

       Result:=udp_Recv(UDPDNSQ, 0, DomainQTimeout);
       If (Result=err_timeout) and (Tries < DomainQTries) then
           begin
             Inc(Tries);
             GOTO ReSend;
           end;

       If Result<>0 then
         begin
           DomainError:='No Response from DomainNameServer';
           LookupFail:=True;
           exit;
         end;

       {OpCodes bits 2, 4, 8, 16 of Hi = 0=standard, 1=inverse, 2=status}
       {RCode bits 16, 32, 64, 128 = 0=noerror, 1=formaterr, 2=server failure
                                     3=name error (does not exist if authoritive)
                                     4=not implementend (query kind unknown)
                                     5=refused}

       Move(UDPDNSQ.Buffer.Buffer, DQ, SizeOf(DQ));
       DQ.Flags   := Intel16(DQ.Flags);
       DQ.QDCOUNT := Intel16(DQ.QDCOUNT);
       DQ.ANCOUNT := Intel16(DQ.ANCOUNT);
       DQ.NSCOUNT := Intel16(DQ.NSCOUNT);
       DQ.ARCOUNT := Intel16(DQ.ARCOUNT);

(********************************* debug
  Assign(DebugF, 'DEBUG.DNS');
  ReWrite(DebugF);
  If UDPDNSQ.Buffer.Length>0 then
    begin
       If (DQ.FlagsHi AND  1 )=1   Then Write(debugf,'QR_ ') else Write(debugf,'qr  ');
       If (DQ.FlagsHi AND  32)=32  Then Write(debugf,'AA_ ') else Write(debugf,'aa  ');
       If (DQ.FlagsHi AND  64)=64  Then Write(debugf,'TC_ ') else Write(debugf,'tc  ');
       If (DQ.FlagsHi AND 128)=128 Then Write(debugf,'RD_ ') else Write(debugf,'rd  ');
       If (DQ.FlagsLo AND  1 )=1   Then Write(debugf,'RA_ ') else Write(debugf,'ra  ');
       Writeln(debugf,#13+#10);
       Writeln(debugf,'   RCode = ',RCode,'        OpCodes = ',OpCodes);
       Writeln(debugf,#13+#10);
            TmpSeg:=Seg(UDPDNSQ.Buffer.Buffer);
            TmpOff:=Ofs(UDPDNSQ.Buffer.Buffer);
            ToDisLength:=UDPDNSQ.Buffer.Length;
            wCount:=0;
             TmpStr:='';
             TmpHex:='';
            repeat
             if ((wCount/8)=Trunc(wCount/8)) then Write(Debugf,' ');
             if ((wCount/16)=Trunc(wCount/16)) then
               begin
                Writeln(Debugf, ' '+TmpStr); TmpStr:=''; TmpHex:='';
                Write(Debugf, WordToHexASCII(wCount),': ');
               end;
             TmpByte:=Mem[TmpSeg:TmpOff+wCount];
             Write(Debugf, ByteToHexASCII(TmpByte)+' ');
             TmpStr:=TmpStr+Chr(TmpByte);   { CleanChr[TmpByte] }
            inc(wCount);
            until wCount=ToDisLength;
             Writeln(debugf, ' '+TmpStr);
    end;
  Close(DebugF);
*******************************************************)

   If UDPDNSQ.pktInfo.id<>PKTID then DomainError:='Someone says its mismatched?';

   If Verbose then Writeln(' Flags: '+WordToHexASCII(DQ.Flags));

   OpCodes := Trunc( (DQ.Flags AND dOPCODE)  / ($800));
   RCode   := Trunc( (DQ.Flags AND dRCODE) );

   If Verbose then
     Begin
       Case OpCodes of
         0 : Writeln('OpCodes: Normal Query');
         1 : Writeln('OpCodes: Inverse Query');
         2 : Writeln('OpCodes: Completion Query, multiple reply [Status Query?]');
         3 : Writeln('OpCodes: Completion Query, single reply');
       Else
         Writeln('Unknown OpCodes: ',OpCodes);
       End;
       Case RCode of
          0 : Writeln(' No Error');
          1 : Writeln(' Format Error ');
          2 : Writeln(' DNS Server Failed ');
          3 : Writeln(' Name Error, (we know the name doesn''t exist?) ');
          4 : Writeln(' No-Can-Do request (not Implemented)');
          5 : Writeln(' Name-Server Refusing to do request ');
         else
           Writeln('Unknown RCode = ',Rcode);
       End;
       Writeln; Write('Flags: ');
       If DQ.Flags AND dQR=dQR    Then Write('QR_ ') else Write('qr  ');
       If DQ.Flags AND dAA=dAA    Then Write('AA_ ') else Write('aa  ');
       If DQ.Flags AND dTC=dTC    Then Write('TC_ ') else Write('tc  ');
       If DQ.Flags AND dRD=dRD    Then Write('RD_ ') else Write('rd  ');
       If DQ.Flags AND dRA=dRA    Then Write('RA_ ') else Write('ra  ');
       Writeln;
     End;

       Case RCode of
          0 : ;            { DomainError:=''; }
          1 : DomainError:=' Format Error ';
          2 : DomainError:=' DNS Server Failed ';
          3 : DomainError:=' Name Error, name does not exist ';
          4 : DomainError:=' No-Can-Do request (not Implemented)';
          5 : DomainError:=' Name-Server Refusing to do request ';
         else
           Str(RCode, TmpStr);
           DomainError:= 'Unknown RCode = '+TmpStr;
       End;

      dResponse   := (DQ.Flags AND dQR=dQR);
      dAuthAnswer := (DQ.Flags AND dAA=dAA);
      dTruncated  := (DQ.Flags AND dTC=dTC);
      dRecursionDesired := (DQ.Flags AND dRD=dRD);
      dRecursionAvail := (DQ.Flags AND dRA=dRA);

       result:=udp_Close(UDPDNSQ, 0);
       CPoint:=13;                                                                                 {*1* was 12}
      end;

LABEL
   TryAnotherServer;

 begin
    DomainExtra:='';
    DomainError:='';
    LookupFail:=False;
    DomainDNS:='';
    DomainDNSIP:=NullAddr;
    Inc(PKTID);
    If textaddress='' then
      begin
        IPAddress[0]:=0;
        IPAddress[1]:=0;
        IPAddress[2]:=0;
        IPAddress[3]:=0;
        resolve:=0;
        DomainError:='No Address Given';
        exit;
     end;
    aton(textaddress, WasIP);
    LastDNS:=0;

   For DNSDNS:=1 to MaxDNS do
      begin
         DNSDNT[DNSDNS]:='';
         DNSIP[DNSDNS]:=NullAddr;
      end;
    LastDNSDNS:=0; DNSDNS:=0;
    CurrentDNSIP:=TcpDrvInfo.dnsserver;
    DNSDNT[0]:=IPTOASCII(TcpDrvInfo.dnsserver);
    FillChar(DQ, SizeOf(DQ), #0);
    FillChar(DQ2, SizeOf(DQ2), #0);
    DNSIP[0]:=TcpDrvInfo.dnsserver;


TryAnotherServer:
    DomainCNAME:='';  DomainPTR:='';
    Move(CurrentDNSIP,CurrentDNS,4);
    If IPCompare(CurrentDNSIP,NullAddr) then
      Begin
        LookupFail:=True;
        resolve:=0;
        Str(DNSDNS, DomainExtra);
        DomainExtra := 'Dead-End  after '+DomainExtra+' servers';
        exit;
      End;
    If Verbose then
        Writeln('Trying server ',IPTOASCII(CurrentDNSIP));
    If LastDNS <> CurrentDNS then
            GetUDPDNSPacket(textaddress, CurrentDNSIP)
            else
            LookupFail:=True;

    LastDNS:=CurrentDNS;

    If LookupFail then
     begin
        IPAddress[0]:=0;
        IPAddress[1]:=0;
        IPAddress[2]:=0;
        IPAddress[3]:=0;
        DomainExtra := 'Out of DNS'' to try';
        resolve:=0;
     end;
  If (DQ.ANCOUNT=0) and (DQ.NSCOUNT=0) then
     begin
        IPAddress[0]:=0;
        IPAddress[1]:=0;
        IPAddress[2]:=0;
        IPAddress[3]:=0;

        If Verbose then
            Writeln('No "Answer" record returned - Address not found? (lookup failed)');
        DomainExtra := 'No "Answer" record returned - Address non-existant?';
        resolve:=0;
        exit;
     end;

   If DQ.QDCOUNT<>0 then
     begin
       For RCount:=1 to DQ.QDCOUNT do  GetQDInfo(QDInfo);
     end;

{   Writeln('****Just after QDs***** ',CPoint); }

   DomainCNAME:=''; DomainPTR:='';

{   Writeln('ANSWERS:');}
   Depth:=DQ.ANCOUNT+DQ.NSCOUNT+DQ.ARCOUNT;
   For RCount:=1 to Depth do   {(DQ.ANCOUNT+DQ.NSCOUNT) do}
    begin
{     If KeyPressed then break;   }          {For Debugging purposes}             {X11}
     If CPoint>UDPDNSQ.Buffer.Length then break;   {For Safety}
     GetRRInfo(RRInfo);
{     Writeln('    RR*NAME *= ',#34+RRInfo.RRName+#34);  }
{     Writeln('    RR*TYPE *= ',RRInfo.RRType);          }
{     Writeln('    RR*CLASS*= ',RRInfo.RRClass);         }
{     Writeln('    TTL (n/a)= ',RRInfo.TTL);             }
{     Writeln('    RDLength = ',RRInfo.RDLength);        }
       {next we handle RDATA records}
     If RRInfo.RRClass=1 then
      begin
       case RRInfo.RRType of
       $1 : begin   { A }
              Move(UDPDNSQ.Buffer.Buffer[CPoint], TmpIP, 4);
              CPoint:=CPoint+4;
{              Writeln('  RRName   =',#34,RRInfo.RRName,#34);  }
{              Writeln('textaddress=',#34,textaddress,#34);    }
{              Writeln('DomainCNAME   =',#34,DomainCNAME,#34); }
{              Writeln('DomainPTR     =',#34,DomainPTR,#34);   }
              If Verbose then Writeln(' - ',RRInfo.RRName,' IN  A ',IPTOASCII(TmpIP));

{ ***********  If ((RRInfo.RRName=textaddress)) then Writeln('YES ITS HERE');}

              If ((RRInfo.RRName=textaddress) OR
                  (RRInfo.RRName=DomainCNAME) OR
                  (RRInfo.RRName=DomainPTR))  AND (DQ.ANCOUNT>0) then
                     begin
                        IPAddress:=TmpIp;
                     end;

              If IPCompare(TmpIp, DNSIP[0]) then DNSDNT[0]:=RRInfo.RRName;
              If DNSDNS>0 then
                  begin
                    for I:=1 to DNSDNS do
                        begin
                          If DNSDNT[I]=RRInfo.RRName then DNSIP[I]:=TmpIp;
                        end;
                  end;
            end;
       $2 : begin   { NS }
              TmpStr:=packedtota(UDPDNSQ.Buffer, CPoint);
              If Verbose then Write(' - NS  ');
              If DNSDNS<MaxDNS-1 then
                begin
                  Inc(DNSDNS);
                  Str(DNSDNS,TmpWStr);
                  If Verbose then Write('*',DNSDNS,'*');
                  DNSDNT[DNSDNS]:=TmpStr;
                end;
              If Verbose then Writeln('   ',TmpStr);
            end;
       $5 : begin   { CNAME }
              TmpStr:=packedtota(UDPDNSQ.Buffer, CPoint);
              If Verbose then Writeln(' - CNAME  ',tmpstr);
              DomainCNAME:=TmpStr;
            end;
       $6 : begin   { SOA }
              If Verbose then Writeln('SOA: ');
              TmpStr:=packedtota(UDPDNSQ.Buffer, CPoint);   {MNAME}
              If Verbose then Writeln('     -MNAME=',#34+TmpStr+#34);
              TmpStr:=packedtota(UDPDNSQ.Buffer, CPoint);   {RNAME}
              If Verbose then Writeln('     -RNAME=',#34+TmpStr+#34);
              CPoint:=CPoint+4; {unsigned 32-bit SERIAL}
              CPoint:=CPoint+4; {32-bit REFRESH time}
              CPoint:=CPoint+4; {32-bit RETRY time}
              CPoint:=CPoint+4; {32-bit EXPIRE time}
              CPoint:=CPoint+4; {unsigned 32-bit minimum TTL}
            end;
       $A : begin   { NULL }
              CPoint:=CPoint+RRInfo.RDLength;
              If Verbose then Writeln(' - NULL');
{              Writeln('Note for Errors, CPoint increased by RDLength');}
            end;
       $B : begin   { WKS }
              If Verbose then Write('WKS: Len=',RRInfo.RDLength,'    ');
              TmpWord:=Ord(UDPDNSQ.Buffer.Buffer[CPoint])*256+
                                Ord(UDPDNSQ.Buffer.Buffer[CPoint+1]);
              TmpByte:=Ord(UDPDNSQ.Buffer.Buffer[CPoint+2]);
              If Verbose then Writeln('Address=',TmpWord,'    Protocol=',TmpByte);
              CPoint:=CPoint+RRInfo.RDLength;
            end;
       $C : begin   { PTR }
              TmpStr:=packedtota(UDPDNSQ.Buffer, CPoint);
              If Verbose then Writeln(' - PTR    ',packedtota(UDPDNSQ.Buffer, CPoint));
              If RRInfo.RRName = WasQuery then
                begin
                  DomainPTR:=TmpStr;
                  TextAddress := DomainPTR;
                  If Pos('IN-ADDR.ARPA',WasQuery)>0 then Move(WasIP, IPAddress,4);
                end;
            end;
       $D : begin   { HINFO }       {see RFC1010}
              TmpByte:=Ord(UDPDNSQ.Buffer.Buffer[CPoint]);
              Move(UDPDNSQ.Buffer.Buffer[CPoint], TmpStr[0], TmpByte+1);
              If Verbose then Write('HINFO = ');
              If Verbose then Write('CPU :'+#34+TmpStr+#34);
              CPoint:=CPoint+TmpByte+1;
              TmpByte:=Ord(UDPDNSQ.Buffer.Buffer[CPoint]);
              Move(UDPDNSQ.Buffer.Buffer[CPoint], TmpStr[0], TmpByte+1);
              If Verbose then Writeln('     OS  :'+#34+TmpStr+#34);
              CPoint:=CPoint+TmpByte+1;
            end;
       $10: begin   { TXT }
             If Verbose then Writeln('*TEXT START*');
             for I:=1 to RRInfo.RDLength do
                begin
                 TmpByte:=Ord(UDPDNSQ.Buffer.Buffer[CPoint]);
                 Move(UDPDNSQ.Buffer.Buffer[CPoint], TmpStr[0], TmpByte+1);
                 If Verbose then Writeln(#34+TmpStr+#34);
                 CPoint:=CPoint+TmpByte+1;
                 I:=I+TmpByte+1;
                end;
             If Verbose then Writeln('*TEXT END*');
            end;
       else begin
             CPoint:=CPoint+RRInfo.RDLength;
             Writeln('Unimplemented: 0x',WordToHEXASCII(RRInfo.RRType));
             resolve:=0;
             exit;
{             Writeln('Note for Errors, CPoint increased by RDLength');}
            end;

       end; {case}
      end;  {if RRClass=1}
    end;    {For .. DQ.ANCOUNT}

  If (DQ.ANCOUNT=0) AND IPCompare(IPAddress,NullAddr) then
    begin
       If (DNSDNS>0) and (LastDNSDNS<MaxDNS-1) then
         begin
           Inc(LastDNSDNS);
           IF (LastDNSDNS< (DNSDNS+1)) then
             begin
                CurrentDNSIP:=DNSIP[LastDNSDNS];
                If Verbose then
                  begin
                    Writeln('Trying another server:');
                    Writeln(DNSDNT[LastDNSDNS], IPTOASCII(CurrentDNSIP));
                  end;
                Goto TryAnotherServer;
              end else begin
                If Verbose then Writeln('Out of servers to try');
             end;
         end;
    end;

  If IPCompare(IPAddress,NullAddr) then
    begin
      DomainDNS:='';
      DomainDNSIP:=NullAddr;
     end else begin
      DomainDNS:=DNSDNT[LastDNSDNS];
      DomainDNSIP:=DNSIP[LastDNSDNS];
      If DNSDNS>0 then
         begin
          for I:=1 to DNSDNS do
             begin
               if IPCompare(DomainDNSIP,DNSIP[I]) then DomainDNS:=DNSDNT[I];
             end;
         end;
    end;
  resolve:=DQ.ANCOUNT;
 end;

Function GetHostByName(textaddress:string; var ipaddress:IPAddr; Opts:Integer):Integer;
Begin
  GetHostByName := 0;

End;

{*NEWHERE*}
Function GetHostByAddr(var textaddress:string; ipaddress:IPAddr; Opts:Integer):Integer;
 var
   OSet:Byte;
   LSet:Byte;
   TmpStr:String;
   AToSend:String;
   TmpWStr:String;
   TmpChar:Char;
   TmpByte:Byte;
   TmpWord:Word;
   RCount:Word;
   ID:Word;
  TmpSeg:Word;
  TmpOff:Word;
  ToDisLength:Word;
  wCount:Word;
  TmpHex:String;
  Depth:Word;

     Procedure GetUDPDNSPacket(domainname:string; dnsserver:IPAddr);
      label ReSend;
      var
       DQ : DNSInfoREC;
       DQ2: DNSInfo2REC;
       I:Integer;
       Tries:Integer;
      begin
       AToSend:=''; LSet:=0;
       AToSend:=tatopacked(domainname);
       CurrentDNSIP:=dnsserver;
       Result:=udp_Open(UDPDNSQ, 0, CurrentDNSIP, 0, DOMAIN_PORT);
       If Not (Result=0) then
         begin
            Writeln('*** Error not able to open UDP connect to DNS Server?');
            GetHostByAddr:=0;
            LookupFail:=True;
            exit;
         end;

       Tries:=0;
ReSend:


       ID:=PKTID;    {  $1313; }
         {  ID                           FLAGS    QDCOUNT   ANCOUNT
                       NSCOUNT   ARCOUNT  recr80}
                                             {80}
       TmpStr:=CHR(hi(ID))+CHR(lo(ID))+#$01+#$00+#$00+#$01+#$00+#$00;
       TmpStr:=TmpStr+#$00+#$00+#$00+#$00+AToSend+#$00+#$01+#$00+#$01;
       DQ.ID    := Intel16(ID);
       DQ.flags := Intel16( DRD );   {DomainRecursionDesired}
       DQ.qdcount := Intel16 ( 1 );  { just one query }
       DQ.ancount := 0;
       DQ.nscount := 0;
       DQ.arcount := 0;
       DQ2.qtype  := Intel16( 1 );   { Host Address resource record }
       DQ2.qclass := Intel16( 1 );   { ARPA internet class }

       Move(DQ, UDPDNSQ.Buffer.Buffer, SizeOf(DQ));
       UDPDNSQ.Buffer.Length := 12;
       AddBuffer(UDPDNSQ.Buffer, 1, AToSend);
{       Move(AToSend[1], UDPDNSQ.Buffer.Buffer[UDPDNSQ.Buffer.Length+1], Length(AToSend)); }
       Move(DQ2, AToSend[1], SizeOf(DQ2));
       AToSend[0]:=Chr(SizeOf(DQ2));
       AddBuffer(UDPDNSQ.Buffer, 1, AToSend);

{       Move(DQ2, UDPDNSQ.Buffer.Buffer[UDPDNSQ.Buffer.Length+1], 4); }
{       Inc( UDPDNSQ.Buffer.Length, 4); }

       Result:=udp_Send(UDPDNSQ, 0, ID, 0, 0, DomainQTimeOut);
       if Result<>0 then
         begin
           Writeln('ERROR: can''t send UDP packet?');
           result:=udp_Close(UDPDNSQ, 0);
           CPoint:=13;
           exit;
         end;

       If Verbose then
           Writeln('ToSend:',UDPDNSQ.Buffer.Length,'    Sent:',UDPDNSQ.BytesTransd);

       UDPDNSQ.pktInfo.id:=0;

       wCount:=0;

       Result:=udp_Recv(UDPDNSQ, 0, DomainQTimeout);
       If (Result=err_timeout) and (Tries < DomainQTries) then
           begin
             Inc(Tries);
             GOTO ReSend;
           end;

       If Result<>0 then Writeln('ERROR: Did not Receive UDP packet or not correctly');

       Move(UDPDNSQ.Buffer.Buffer, DQ, SizeOf(DQ));
       DQ.Flags   := Intel16(DQ.Flags);
       DQ.QDCOUNT := Intel16(DQ.QDCOUNT);
       DQ.ANCOUNT := Intel16(DQ.ANCOUNT);
       DQ.NSCOUNT := Intel16(DQ.NSCOUNT);
       DQ.ARCOUNT := Intel16(DQ.ARCOUNT);

       {OpCodes bits 2, 4, 8, 16 of Hi = 0=standard, 1=inverse, 2=status}
       {RCode bits 16, 32, 64, 128 = 0=noerror, 1=formaterr, 2=server failure
                                     3=name error (does not exist if authoritive)
                                     4=not implementend (query kind unknown)
                                     5=refused}

       Writeln(' Flags: '+WordToHexASCII(DQ.Flags));
        OpCodes := Trunc( (DQ.Flags AND dOPCODE)  / ($800));
        RCode   := Trunc( (DQ.Flags AND dRCODE) );
       Writeln('   RCode = ',RCode,'        OpCodes = ',OpCodes);

       Case OpCodes of
          0 : Writeln('Normal Query');
          1 : Writeln('Inverse Query');
          2 : Writeln('Status Query');
         Else
           Writeln('Opcode = ',OpCodes);
       End;
       Case RCode of
          0 : Writeln('No Error?');
          1 : Writeln(' Format Error ');
          2 : Writeln(' DNS Server Failed ');
          3 : Writeln(' Name Error, (we know the name doesn''t exist?) ');
          4 : Writeln(' No-Can-Do request (not Implemented)');
          5 : Writeln(' Name-Server Refusing to do request ');
         else
           Writeln( 'RCode = ',Rcode);
       End;

       If DQ.Flags AND dQR=dQR    Then Write('QR_ ') else Write('qr  ');
       If DQ.Flags AND dAA=dAA    Then Write('AA_ ') else Write('aa  ');
       If DQ.Flags AND dTC=dTC    Then Write('TC_ ') else Write('tc  ');
       If DQ.Flags AND dRD=dRD    Then Write('RD_ ') else Write('rd  ');
       If DQ.Flags AND dRA=dRA    Then Write('RA_ ') else Write('ra  ');

       Writeln;

   If UDPDNSQ.pktInfo.id<>ID then Writeln('Someone says its mismatched?');

       result:=udp_Close(UDPDNSQ, 0);
       CPoint:=13;                                                                                 {*1* was 12}
      end;

LABEL
   TryAnotherServer;

 begin
    LookupFail:=False;
    DomainDNS:='';
    DomainDNSIP:=NullAddr;
    Inc(PKTID);
    If textaddress='' then
      begin
        IPAddress[0]:=0;
        IPAddress[1]:=0;
        IPAddress[2]:=0;
        IPAddress[3]:=0;
        GetHostByAddr:=1;
        exit;
     end;
    LastDNS:=0;

   For DNSDNS:=1 to 10 do
      begin
         DNSDNT[DNSDNS]:='';
         DNSIP[DNSDNS]:=NullAddr;
      end;
    LastDNSDNS:=0; DNSDNS:=0;
    CurrentDNSIP:=TcpDrvInfo.dnsserver;
    DNSDNT[0]:=IPTOASCII(TcpDrvInfo.dnsserver);
    FillChar(DQ, SizeOf(DQ), #0);
    DNSIP[0]:=TcpDrvInfo.dnsserver;


TryAnotherServer:
    DomainCNAME:='';  DomainPTR:='';
    Move(CurrentDNSIP,CurrentDNS,4);
    If Verbose then
        Writeln('Trying server ',IPTOASCII(CurrentDNSIP));
    If LastDNS <> CurrentDNS then
            GetUDPDNSPacket(textaddress, CurrentDNSIP)
            else
            LookupFail:=True;

    LastDNS:=CurrentDNS;

    If LookupFail then
     begin
        IPAddress[0]:=0;
        IPAddress[1]:=0;
        IPAddress[2]:=0;
        IPAddress[3]:=0;
        GetHostByAddr:=0;
     end;
  If (DQ.ANCOUNT=0) and (DQ.NSCOUNT=0) then
     begin
        IPAddress[0]:=0;
        IPAddress[1]:=0;
        IPAddress[2]:=0;
        IPAddress[3]:=0;

        If Verbose then
            Writeln('No "Answer" record returned - Address not found? (lookup failed)');
        GetHostByAddr:=0;
        exit;
     end;

   If DQ.QDCOUNT<>0 then
     begin
       For RCount:=1 to DQ.QDCOUNT do  GetQDInfo(QDInfo);
     end;

   DomainCNAME:=''; DomainPTR:='';

   Depth:=DQ.ANCOUNT+DQ.NSCOUNT+DQ.ARCOUNT;
   For RCount:=1 to Depth do   {(DQ.ANCOUNT+DQ.NSCOUNT) do}
    begin
     If CPoint>UDPDNSQ.Buffer.Length then break;   {For Safety}
     GetRRInfo(RRInfo);

     If RRInfo.RRClass=1 then
      begin
       case RRInfo.RRType of
       $1 : begin   { A }
              Move(UDPDNSQ.Buffer.Buffer[CPoint], TmpIP, 4);
              CPoint:=CPoint+4;
{              Writeln('  RRName   =',#34,RRInfo.RRName,#34);  }
{              Writeln('textaddress=',#34,textaddress,#34);    }
{              Writeln('DomainCNAME   =',#34,DomainCNAME,#34); }
{              Writeln('DomainPTR     =',#34,DomainPTR,#34);   }
              If Verbose then Writeln(' - ',RRInfo.RRName,' IN  A ',IPTOASCII(TmpIP));

{ ***********  If ((RRInfo.RRName=textaddress)) then Writeln('YES ITS HERE');}

              If ((RRInfo.RRName=textaddress) OR
                  (RRInfo.RRName=DomainCNAME) OR
                  (RRInfo.RRName=DomainPTR)       ) AND (DQ.ANCOUNT>0) then
                       IPAddress:=TmpIp;
              If IPCompare(TmpIp, DNSIP[0]) then DNSDNT[0]:=RRInfo.RRName;
              If DNSDNS>0 then
                  begin
                    for I:=1 to DNSDNS do
                        begin
                          If DNSDNT[I]=RRInfo.RRName then DNSIP[I]:=TmpIp;
                        end;
                  end;
            end;
       $2 : begin   { NS }
              TmpStr:=packedtota(UDPDNSQ.Buffer, CPoint);
              If Verbose then Write(' - NS  ');
              If DNSDNS<10 then
                begin
                  Inc(DNSDNS);
                  Str(DNSDNS,TmpWStr);
                  If Verbose then Write('*',DNSDNS,'*');
                  DNSDNT[DNSDNS]:=TmpStr;
                end;
              If Verbose then Writeln('   ',TmpStr);
            end;
       $5 : begin   { CNAME }
              TmpStr:=packedtota(UDPDNSQ.Buffer, CPoint);
              If Verbose then Writeln(' - CNAME  ',tmpstr);
              DomainCNAME:=TmpStr;
            end;
       $6 : begin   { SOA }
              If Verbose then Writeln('SOA: ');
              TmpStr:=packedtota(UDPDNSQ.Buffer, CPoint);   {MNAME}
              If Verbose then Writeln('     -MNAME=',#34+TmpStr+#34);
              TmpStr:=packedtota(UDPDNSQ.Buffer, CPoint);   {RNAME}
              If Verbose then Writeln('     -RNAME=',#34+TmpStr+#34);
              CPoint:=CPoint+4; {unsigned 32-bit SERIAL}
              CPoint:=CPoint+4; {32-bit REFRESH time}
              CPoint:=CPoint+4; {32-bit RETRY time}
              CPoint:=CPoint+4; {32-bit EXPIRE time}
              CPoint:=CPoint+4; {unsigned 32-bit minimum TTL}
            end;
       $A : begin   { NULL }
              CPoint:=CPoint+RRInfo.RDLength;
              If Verbose then Writeln(' - NULL');
            end;
       $B : begin   { WKS }
              If Verbose then Write('WKS: Len=',RRInfo.RDLength,'    ');
              TmpWord:=Ord(UDPDNSQ.Buffer.Buffer[CPoint])*256+
                                Ord(UDPDNSQ.Buffer.Buffer[CPoint+1]);
              TmpByte:=Ord(UDPDNSQ.Buffer.Buffer[CPoint+2]);
              If Verbose then Writeln('Address=',TmpWord,'    Protocol=',TmpByte);
              CPoint:=CPoint+RRInfo.RDLength;
            end;
       $C : begin   { PTR }
              TmpStr:=packedtota(UDPDNSQ.Buffer, CPoint);
              If Verbose then Writeln(' - PTR    ',packedtota(UDPDNSQ.Buffer, CPoint));
              DomainPTR:=TmpStr;
            end;
       $D : begin   { HINFO }       {see RFC1010}
              TmpByte:=Ord(UDPDNSQ.Buffer.Buffer[CPoint]);
              Move(UDPDNSQ.Buffer.Buffer[CPoint], TmpStr[0], TmpByte+1);
              If Verbose then Write('HINFO = ');
              If Verbose then Write('CPU :'+#34+TmpStr+#34);
              CPoint:=CPoint+TmpByte+1;
              TmpByte:=Ord(UDPDNSQ.Buffer.Buffer[CPoint]);
              Move(UDPDNSQ.Buffer.Buffer[CPoint], TmpStr[0], TmpByte+1);
              If Verbose then Writeln('     OS  :'+#34+TmpStr+#34);
              CPoint:=CPoint+TmpByte+1;
            end;
       $10: begin   { TXT }
             If Verbose then Writeln('*TEXT START*');
             for I:=1 to RRInfo.RDLength do
                begin
                 TmpByte:=Ord(UDPDNSQ.Buffer.Buffer[CPoint]);
                 Move(UDPDNSQ.Buffer.Buffer[CPoint], TmpStr[0], TmpByte+1);
                 If Verbose then Writeln(#34+TmpStr+#34);
                 CPoint:=CPoint+TmpByte+1;
                 I:=I+TmpByte+1;
                end;
             If Verbose then Writeln('*TEXT END*');
            end;
       else begin
             CPoint:=CPoint+RRInfo.RDLength;
             Writeln('Unimplemented: 0x',WordToHEXASCII(RRInfo.RRType));
             GetHostByAddr:=0;
             exit;
{             Writeln('Note for Errors, CPoint increased by RDLength');}
            end;

       end; {case}
      end;  {if RRClass=1}
    end;    {For .. DQ.ANCOUNT}

  If (DQ.ANCOUNT=0) AND IPCompare(IPAddress,NullAddr) then
    begin
       If (DNSDNS>0) and (LastDNSDNS<10) then
         begin
           Inc(LastDNSDNS);
           IF (LastDNSDNS< (DNSDNS+1)) then
             begin
                CurrentDNSIP:=DNSIP[LastDNSDNS];
                If Verbose then
                  begin
                    Writeln('Trying another server:');
                    Writeln(DNSDNT[LastDNSDNS], IPTOASCII(CurrentDNSIP));
                  end;
                Goto TryAnotherServer;
              end else begin
                If Verbose then Writeln('Out of servers to try');
             end;
         end;
    end;

  If IPCompare(IPAddress,NullAddr) then
    begin
      DomainDNS:='';
      DomainDNSIP:=NullAddr;
     end else begin
      DomainDNS:=DNSDNT[LastDNSDNS];
      DomainDNSIP:=DNSIP[LastDNSDNS];
      If DNSDNS>0 then
         begin
          for I:=1 to DNSDNS do
             begin
               if IPCompare(DomainDNSIP,DNSIP[I]) then DomainDNS:=DNSDNT[I];
             end;
         end;
    end;
  GetHostByAddr:=DQ.ANCOUNT;
 end;
BEGIN
  PktID:=0;
  DomainQTimeout := 275;
  DomainQTries    := 3;
END.

