{$UNDEF JPIRCWIN}

Unit IDENTD;        {    IDENT Server for use with JP's Trumpet ABI unit  }

Interface

Uses ABI, ABI_DOM, ABI_JP, JP_UNIT,
{$IFDEF JPIRCWIN}
     JPIRCWIN,
{$ENDIF}
     INI_MGR;

CONST IDENT_PORT = 113;  { AUTH_PORT; }    { 113  tcp }
      INIFileName = 'JPTCP.INI';

var IDENTDState:Byte;
    Queries:Word;
      IDENTDS    : ^tcpSessionREC;
      IDENTDUserName : ^String;
      IDENTD_OS      : ^String;
      IDENTDStatus   : ^String;
      IDENTDPort     : Word;
      SpacesGalor    : Boolean;

Procedure ProcessTcpIDENTD;

Implementation

var   SaveExitProc : Pointer;
      Result       : Word;
      IdentBuffer  : ^BufferREC;
      A, B, C      : ^String;
      IdentLog     : text;

Procedure ProcessTcpIDENTD;
var tResult:Integer;
    tSPort, tCPort : Word;
Begin

tResult:=tcp_Status(IDENTDS^, 0);

Str(IDENTDState,IDENTDStatus^);
IDENTDStatus^:='['+IDENTDStatus^+'] ';

Case IDENTDState of
 0 :  Begin   {Check for Connection}
       If IDENTDS^.Status.State=4 then
           begin
             result:=tcp_status(IDENTDS^, 0);
             Writeln(IdentLog, 'Connected Rcvd: '+IPTOASCII(IDENTDS^.Status.ip_dest)+
                               ':',IDENTDS^.Status.port_dest);

{$IFDEF JPIRCWIN}
             Str(IDENTDS^.Status.port_dest, A^);
             WlnWrite(1, 'IDENT Rcvd From '+IPTOASCII(IDENTDS^.Status.ip_dest)+
                               ':'+A^);
{$ENDIF}
             IDENTDState:=2;
             Queries:=0;
           end;
      End;
 1 :  Begin
       asm nop end;
       IDENTDState:=5;
      End;
 2 :  Begin   {Recieve Line of Data}
        DoShowTcpError:=False;
        If not tcp_IsConnected(IDENTDS^) then
            begin
              Writeln(IdentLog, 'Was disconnected while waiting for Line of Data');
              IDENTDState:=5;
              exit;
            end;
        If ReadlnBuff(IDENTDS^, IdentBuffer^) then IDENTDState:=3;
        DoShowTcpError:=True;
      End;
 3 :  Begin   {Process Line of Data}
         InvalidChar:=#0+#13+#10+#32;
         B^ := ShowBuffer(IdentBuffer^, 4);
         Writeln(IdentLog, 'Rcvd: "'+B^+'"');
         IDENTDStatus^:=IDENTDStatus^+'Received: '+B^;
         If Pos(',',B^)=0 then
               begin
                  IDENTDState:=5;
                  exit;
               end;
         A^ := Copy(B^, 1, Pos(',',B^)-1);           {Port of Server (We)   }
         B^ := Copy(B^, Pos(',',B^)+1, Length(B^));   {Port of Client (They) }
         Writeln(IdentLog, 'Split A: "'+A^+'"');
         Writeln(IdentLog, 'Split B: "'+B^+'"');
      If SpacesGalor then C^ := A^+' , '+B^+' : USERID : '+IDENTD_OS^+' :'+IDENTDUserName^
                     else C^ := A^+','+B^+':USERID:'+IDENTD_OS^+':'+IDENTDUserName^;
         { Else}
         { C^ := A^+','+'B^'+':ERROR:NO-USER'; }
         AddBuffer(IDENTDS^.Buffer, 0, C^);
         IdentBuffer^.Length:=0;
         IDENTDState:=4;
      End;
 4 :  Begin   { Send Reply Non-Blockingly }
        Inc(Queries);
        If not tcp_IsConnected(IDENTDS^) then
            begin
              IDENTDState:=5;
              B^ := ShowBuffer(IDENTDS^.Buffer, 4);
                  Writeln(IdentLog, 'Sent?: "'+B^+'"');
              exit;
            end;

        { tcp_Put(IDENTDS^, 2+4, 375); }

        Result:=tcp_Put(IDENTDS^, 6, 375);
        B^:=ShowBuffer(IDENTDS^.Buffer, 0);
        If Result=0 then
          begin
           Writeln(IdentLog, 'Send: "'+B^+'"');
{$IFDEF JPIRCWIN}
           WlnWrite(1, 'IDENT Reply Sent: '+B^);
{$ENDIF}
          end;
        IDENTDState:=2;
        DelayMS(25);
        If Queries>4 then IDENTDState:=5;
      End;
 5 :  Begin   { Reclose connection }
          DelayMS(100);
          Result:=tcp_Close(IDENTDS^, 1, 0);
          DelayMS(25);
          Result:=Tcp_Open(IDENTDS^, 1, NullAddr, IDENTDPort, 0, 0);
          If Result<>0 then
              begin
                Writeln('ERROR with close->ReOpenning Listening connection on port ',IDENTDPort);
              end;
        Writeln(IdentLog, 'Closed for reopen.');
          IDENTDState:=0;
      End;
  Else
     IDENTDState:=0;
 End;

asm nop end;
If (Tcp_State(IDENTDS^)=7) and (IDENTDS^.Buffer.Length=0) then IDENTDState:=5;
If (Tcp_State(IDENTDS^)=1) and (IDENTDS^.Buffer.Length=0) then IDENTDState:=0;

End;


Procedure InitIDENTD;
Begin
 FillChar(IDENTDS^, SizeOf(IDENTDS^), #0);
 IDENTDState:=0;
 IDENTDPort := IDENT_PORT;
 IDENTDUserName^:='USERID';
 IDENTD_OS^     :='MSDOS,US-ASCII';
 IdentBuffer^.Length:=0;
End;


{$F+}
Procedure IDENTD_NewExitProc; far;
 begin
   ExitProc:=SaveExitProc;
   Close(IdentLog);
   Result:=tcp_Close(IDENTDS^, 0, 350);
   If Result<>0 then Writeln('Error with IDENTD closing IDENTDS! ',Result);

   Dispose(IDENTD_OS);  Dispose(IDENTDUserName);
   Dispose(C);  Dispose(B);  Dispose(A);
   Dispose(IdentBuffer);
   Dispose(IDENTDS);
   Dispose(IDENTDStatus);
 end;

var  FAP          : FieldType;

BEGIN
 New(IDENTDStatus);
 New(IDENTDS);
 New(IdentBuffer);
 New(A);   New(B);  New(C);
 New(IDENTDUserName);
 New(IDENTD_OS);

 InitIDENTD;

 FAP.Field:='UserName';   FAP.Value:='';
 LoadINISection(INIFileName, 'IdentD', 1, @FAP);
 If FAP.Value<>'' then IDENTDUserName^ := FAP.Value;

 FAP.Field:='OS';   FAP.Value:='';
 LoadINISection(INIFileName, 'IdentD', 1, @FAP);
 If FAP.Value<>'' then IDENTD_OS^ := FAP.Value;

 FAP.Field:='Port';   FAP.Value:='';
 LoadINISection(INIFileName, 'Port', 1, @FAP);
 If FAP.Value<>'' then
   begin
     Val(FAP.Value, IDENTDPort, Result);
     If (Result<>0) or (IDENTDPort=0) then IDENTDPort := IDENT_PORT;
   end;

 Result:=Tcp_Open(IDENTDS^, 1, NullAddr, IDENTDPort, 0, 0);
 If Result<>0 then
     begin
       Writeln('Error initializing NTCPDRV to listen on port ',IDENTDPort);
       DelayMS(500);
       Halt(113);
     end;
 SaveExitProc:=ExitProc;
 ExitProc:=@IDENTD_NewExitProc;
 Assign(IdentLog, 'IDENTD.LOG');
 ReWrite(IdentLog);
 SpacesGalor := False;
END.    (C) 1997 - Copyright ParSoft, by Jeff Patterson

