
PROGRAM NNGETART;                           {NNTP Get Articles}

{$A+,B-,D+,E+,F-,G+,I+,L+,N-,O-,P-,Q-,R+,S+,T-,V+,X+}
{$M 16384,0,655360}


Uses DOS,ABI,CRT,XSTRING,ABI_DOM,ABI_JP;

{$I TCP.INC}

CONST VerifyArticle: Boolean = FALSE;


var
    ArtEstimate:LongInt;
    ArtFirst:LongInt;
    ArtLast :LongInt;
    ArtGroup:String;
    ArtLines:LongInt; {Lines: }
    ArtLine:LongInt;  {current}
    ArtNum:LongInt;
    ArtCount:Word;
    Result: Integer;
    TmpAddr: IPAddr;
    TmpPort: Word;
    TmpLong: LongInt;
    TmpStr:String;
    TmpDis:String;
    StatusBarLU:LongInt;     {StatusBar last update}
    Spinner:Word;
    I : Integer;
    A : String;
    B : String;

Procedure ShowStatus(C:tcpSessionREC);
 begin
     Write(ByteToHexASCII(C.Handle)+' ');
     Write('FROM:'+IPTOASCII(TcpDrvInfo.myip)+':');
     if C.Tcp_srce=0 then Write('[',C.LocalPort,']')
                               else Write(C.Tcp_srce);
     Write('      =>  TO:  '+IPTOASCII(C.IPDest)+':');
     Writeln(C.Tcp_dest,'       ',tcpState[C.Status.State]);

     Writeln('State         : ',C.Status.State);
     Write('BytesReady    : ',C.Status.BytesReady);
     Writeln('    BytesGoing    : ',C.Status.BytesGoing);
     Write('Source IP     : ',IPTOASCII(C.Status.ip_srce));
     Writeln('    Destination IP: ',IPTOASCII(C.Status.ip_dest));
     Writeln(' IP Prot      : ',C.Status.ip_prot);
     Writeln('  A C T I V E?: ',C.Status.Active);
     Writeln;
 end;

Procedure CrashNBurn(ToShow:String);
 begin
  Writeln(ToShow);
  Result:=Tcp_Close(CurSession, 0, 150);
  Halt(10);
 end;

Function BWStr(var TmpNum:word; Len:Byte):String;
 var
  TmpStr:String;
 begin
    case Len of
      0: Str(TmpNum,TmpStr);
      1: Str(TmpNum:1,TmpStr);
      2: Str(TmpNum:2,TmpStr);
      3: Str(TmpNum:3,TmpStr);
      4: Str(TmpNum:4,TmpStr);
      5: Str(TmpNum:5,TmpStr);
      6: Str(TmpNum:6,TmpStr);
      7: Str(TmpNum:7,TmpStr);
     else
        Str(TmpNum,TmpStr);
    end;
  BWStr:=TmpStr;
 end;

Function BLStr(var TmpNum:LongInt; Len:Byte):String;
 var
  TmpStr:String;
 begin
    case Len of
      0: Str(TmpNum,TmpStr);
      1: Str(TmpNum:1,TmpStr);
      2: Str(TmpNum:2,TmpStr);
      3: Str(TmpNum:3,TmpStr);
      4: Str(TmpNum:4,TmpStr);
      5: Str(TmpNum:5,TmpStr);
      6: Str(TmpNum:6,TmpStr);
      7: Str(TmpNum:7,TmpStr);
     else
        Str(TmpNum,TmpStr);
    end;
  BLStr:=TmpStr;
 end;

Procedure ShowStatusBar(Other:String);
 var
	 ToShow:String;
	 LastX:Byte;
	 LastY:Byte;
	 TmpX:Byte;
	 TmpY:Byte;
	 LWX:Byte;
	 LWY:Byte;
	 LWXX:Byte;
	 LWYY:Byte;
   ha, ma, sa, sa100 : Word;
 begin
   GetTime(ha, ma, sa, sa100);
   If StatusBarLU=Trunc(sa100/10) then exit;
   StatusBarLU:=Trunc(sa100/10);
   TmpX:=WHEREX; TmpY:=WHEREY;
	 Window(1, 1, 80, 1);
   If Spinner> 3 then Spinner:=0;
	 Inc(Spinner);
	 GotoXY(1,1);
	 TextColor(9);
   If Spinner=1 then Write('/\');
   If Spinner=2 then Write('--');
   If Spinner=3 then Write('\/');
   If Spinner=4 then Write('||');

   Write(' Time= ',ha:2,':',ma:2,':',sa:2,'  ',ArtCount);
   If Other<>'' then Write(Other);
   ClrEol;
	 NormVideo;
   Window(1, 2, 80, 25);
   GotoXY(TmpX, TmpY);
 end;


  (* Number of substrings in a string *)
  function PARSENFN (sj : string) : integer;
  var i, n, p : integer;
  begin
    p := Length(sj);
    n := 0;
    i := 1;
    repeat
      while (sj[i] <= #32) and (i <= p) do Inc(i);
      if i > p then begin parsenfn := n; exit; end;
      while (sj[i] > #32) and (i <= p) do Inc(i);
      Inc(n);
      if i > p then begin parsenfn := n; exit; end;
    until false;
  end;  (* parsenfn *)
  {}
  (* Get substrings from a string *)
  function PARSERFN (sj : string; PartNumber : integer) : string;
  var i, j, n, p : integer;
      stash      : string;
  begin
    if (PartNumber < 1) or (PartNumber > PARSENFN(sj)) then
      begin PARSERFN := ''; exit; end;
    p := Length(sj);
    n := 0;
    i := 1;
    repeat
      while (sj[i] <= #32) and (i <= p) do Inc(i);
      Inc(n);
      if n = PartNumber then
        begin
          j := 0;
          while (sj[i] > #32) and (i <= p) do
            begin
              Inc(j);
              stash[0] := chr(j);
              stash[j] := sj[i];
              Inc(i);
            end;
          PARSERFN := stash;
          exit;
        end
       else
         while (sj[i] > #32) and (i <= p) do Inc(i);
    until false;
  end;  (* parserfn *)

Function SelectNewsGroup(newsgroup: string):Boolean;
 var
   TmpRes:Boolean;
   tW:Word;
   Result:Integer;
   TmpStr:String;
   ArtTmp:String;
 begin
   SelectNewsGroup:=False;
   TmpRes:=False;
      Writeln('Sending Group Message: ',newsgroup);
      tcp_sendtextln(CurSession, 'GROUP '+newsgroup);
      If CurSession.Result<>0 then Writeln('Send: ',Result);

      Write(#34);
      ShowBuffer(CurSession.Buffer, 1);
      Writeln(#34);
      Result:=tcp_get(CurSession, 2, 1000);
      If Result<>0 then
        begin
         Writeln('Timeout on Reply for GROUP');
         exit;
        end;

      Write(#34);
      TmpStr:=ShowBuffer(CurSession.Buffer, 3);
      Writeln(#34);

      If (Msg.Pro='4') AND (Msg.Cat='1') then
        begin
          Writeln('*NO SUCH NEWS GROUP*');
          exit;
        end;
      If (Msg.Pro='2') AND (Msg.Cat='1') then
        begin
          If PARSENFN(TmpStr)<5 then Writeln('*REPLY DOES NOT GIVE DETAILS*');
          ArtTmp:=PARSERFN(TmpStr, 2);
          Val(ArtTmp,ArtEstimate,Result);

          ArtTmp:=PARSERFN(TmpStr, 3);
          Val(ArtTmp,ArtFirst,Result);

          ArtTmp:=PARSERFN(TmpStr, 4);
          Val(ArtTmp,ArtLast,Result);

          ArtGroup:=PARSERFN(TmpStr, 5);
          Writeln('*** Confirmed Selection of Group: ',#34,ArtGroup,#34);
          Writeln;
          Writeln(' There is approximately ',ArtEstimate,' message(s) in this newsgroup.');
          Writeln(' The numbers of the messages range from ',ArtFirst,' to ',ArtLast,'.');


          TmpRes:=True;
          SelectNewsGroup:=TmpRes;
          exit;
        end;
     Writeln('Unknown Error With GROUP');
   SelectNewsGroup:=TmpRes;
 end;

Function GetArticle(Article:LongInt):Boolean;
 var
  TmpRes:Boolean;
  TmpLong:LongInt;
  output:text;
  OutputFileName:String;
  Result:Integer;
  TmpStr:string;
  ArtStr:string;
  LastStr:String;
  Retries:Integer;
 begin
  TmpRes:=False;
  GetArticle:=False;
  Str(Article, ArtStr);
  OutputFileName:='in\'+ArtStr+'.';             {XHEREX}



      If VerifyArticle then
        begin
           tcp_sendtextln(CurSession, 'HEAD '+ArtStr);

           Result:=tcp_get(CurSession, 2, 1000);
            If Result<>0 then
              begin
               Writeln('Timeout on Reply for HEADer');
               exit;
              end;
            Writeln('WATCH THIS BELOW');
            Write(#34);  ShowBuffer(CurSession.Buffer, 3);  Write(#34);

            If (Msg.Pro='2') and (Msg.Cat='2') then
              begin
                Writeln('Ready to receive');
              end;
            If (Msg.Pro='4') and (Msg.Cat='2') then
              begin
                Writeln('Bad article?');
                GetArticle:=False;
                exit;
              end;

            Repeat
              Result:=tcp_get(CurSession, 2, 850);
              TmpStr:=ShowBuffer(CurSession.Buffer, 3); Writeln;


            Until (TmpStr='.') OR (Result<>0);
            If Result<>0 then Writeln('Error on reply of HEADer');

            {Ask if they want it}
            If Result<>0 then
              begin
                GetArticle:=True;  {It isn't an error if they pick not to get it}
                exit;
              end;
        end;



      tcp_sendtextln(CurSession, 'ARTICLE '+ArtStr);
      If CurSession.Result<>0 then Writeln('Send: ',Result);

      Write(#34);
      ShowBuffer(CurSession.Buffer, 3);
      Write(#34);

      Result:=tcp_get(CurSession, 2, 750);
      If Result<>0 then
        begin
         Writeln('Timeout on 1st line Reply for ARTICLE');
         exit;
        end;
      Write(#34);
      TmpStr:=ShowBuffer(CurSession.Buffer, 1);
      Writeln(#34);
      Writeln('Recieving');
  ArtLines:=0;
  ArtLine:=0;
  Assign(output,OutputFileName);
  ReWrite(output);
            Retries:=0;
            Repeat
              LastStr:=TmpStr;
              Result:=tcp_get(CurSession, 3, 0);             {XHEREX}
              TmpStr:=ShowBuffer(CurSession.Buffer, 3);
              If (Copy(TmpStr,1,7)='Lines: ') and (ArtLines=0) then
                  Val(Copy(TmpStr,8,Length(TmpStr)-7), ArtLines, I);
              If (TmpStr<>'.') and (TmpStr<>'') then
                 begin
                  Write(output, TmpStr);
                 end;
              If (CurSession.DAT.ReadCRLF) AND (CurSession.Result=0) then
                begin
                  If ArtLine<>0 then Inc(ArtLine);
                  If (ArtLine=0) and (TmpStr='') then Inc(ArtLine);
                  Write(output,#13+#10);
                  Writeln;
                end;
            Result:=tcp_Status(CurSession,0);
      TmpDis:='  Article: '+BLStr(ArtNum,6)+'  Lines= '+BLStr(ArtLine,0)+'/'+BLStr(ArtLines,0)+' ';
            ShowStatusBar(TmpDis+'['+tcpState[CurSession.Status.State]+']');

            Until ((TmpStr='.') and (CurSession.DAT.ReadCRLF)) or (KeyPressed);
            If (Result=0) and (TmpStr='.') then GetArticle:=True;
            If (Result<>0) then
               begin
                Writeln('Error on reply of ARTICLE');
                Writeln(output, '[ERROR WITH ARTICLE]');
               end;
            If (KeyPressed) then
               begin
                Writeln(' Aborted ARTICLE');
                Writeln(output, '[ARTICLE_ABORTED]');
                GetArticle:=False;
               end;
  Close(Output);
 end;

Function MainNNTPGetArt(newsgroup:string; artlistfile:string; host:IPAddr; hoststring:string):Integer;
var
  ArtList:text;
  TmpStr:String;
  ArtInfo:String;
  Result:Integer;
  tmpBoolean:Boolean;
begin
  MainNNTPGetArt:=-1;
  TmpPort:=NNTP_PORT;
  TmpDis:=IPTOASCII(TcpDrvInfo.myip)+':'+
          BWStr(CurSession.LocalPort,0)+' => '+IPTOASCII(host)+':'+BWStr(TmpPort,0)+' ';

  ShowStatusBar(TmpDis+' attempting connection');
  Result:=Tcp_Open(CurSession,0,host,0,TmpPort,450);
  if Result=no_error then Writeln('Connection Established');
  If Result=err_nohandles then CrashNBurn('No Handles on Open');
  If Result=err_badsession then CrashNBurn('Bad Session on Open');

  ShowStatusBar(ByteToHEXASCII(CurSession.Handle)+TmpDis+tcpState[CurSession.Status.State]);

  if Result=err_timeout then
    begin
      Writeln('No Response from '+IPTOASCII(CurSession.IPDest));
      MainNNTPGETArt:=-5;
      exit;
    end;
  Result:=Tcp_Status(CurSession,0);

  Result:=tcp_get(CurSession, 2, 1550);
  If Result=err_timeout then
    begin
      Writeln('No Response from NNTP Server');
      MainNNTPGETART:=-1;
      exit;
    end;
  If Result<>0 then
    begin
      Writeln('Error on NNTP negotiation (first receive)');
      If Result = err_badhandle then Writeln('Bad Handle with tcp_get');
      MainNNTPGETART:=-1;
      exit;
    end;

  Result:=Tcp_Status(CurSession,0);
  ShowStatus(CurSession);
{
  Writeln('CRLF=',CurSession.DAT.ReadCRLF,'          Urgent=',CurSession.DAT.Urgent);
}

  Write(#34);
  TmpStr:=ShowBuffer(CurSession.Buffer, 1);
  Writeln(#34);


 If SelectNewsGroup(newsgroup) then
   begin
     Writeln('*!* Select OK  YEAH');
     Assign(ArtList, ArtListFile);
     {.$I-}  Reset(ArtList);  {.$I+}

    repeat
       Readln(ArtList,TmpStr);
       If Pos(' ',TmpStr)>0 then Val(Copy(TmpStr,1,Pos(' ',TmpStr)-1), ArtNum, Result);
       If Pos(' ',TmpStr)=0 then Val(TmpStr, ArtNum, Result);
       Writeln(ArtNum,'   ',Result);
       If Result<>0 then ArtNum:=0;
       ArtInfo:=Copy(TmpStr,Pos(' ',TmpStr), Length(TmpStr)-Pos(' ',TmpStr));
       Writeln('ARTICLE:',TmpStr);
       If (ArtNum<>0) then
         begin
            Inc(ArtCount);
            TmpBoolean:=GetArticle(ArtNum);
            If TmpBoolean then Writeln('OK[',ArtNum,']');
         end;

     until EOF(ArtList) or (ArtNum=0) or (TmpStr='.') or (TmpBoolean=False) or (keypressed);
      If TmpBoolean=False then Writeln('Retrieve attempt aborted');
      Close(ArtList);


{     If GetArticle(ArtFirst) then Writeln('*!* Retrieve OK  YEAH');}
           Writeln('[Sending Quit]');
           tcp_sendtextln(CurSession, 'QUIT');
           Result:=tcp_get(CurSession, 2, 750);
            If Result<>0 then
              begin
               Writeln('Timeout on Reply for QUIT');
               exit;
              end;
            Write(#34);  ShowBuffer(CurSession.Buffer, 3);  Write(#34);

   end;


 ShowTcpError('[EOT]');
 Result:=Tcp_Close(CurSession, 0, 350);
 MainNNTPGetArt:=0;
end;




BEGIN
 Writeln;
 Writeln('Turbo Pascal 7.0 - NNTPGETART for DOS');
 Writeln;

 TmpAddr:=NullAddr;

 if ParamCount<3 then
    begin
     Writeln('NNTPGETART <group> <nntp-art-list> <server>');
     Halt(3);
    end;

 A:=ParamStr(3);
 B:=ParamStr(2);
 aton(A,TmpAddr);
 TmpLong:=0;
 Move(TmpAddr,TmpLong,4);
 If TmpLong=0 then
   begin
    Writeln('Resolving ',A);
    Result:=resolve(A, TmpAddr, 0);
    TmpLong:=0;
    Move(TmpAddr,TmpLong,4);
    If Result=0 then Writeln('DNS lookup failure');
   end;

if TmpLong=0 then
   begin
    Writeln;
    Writeln('Invalid Address was specified: '+#34,A,#34);
    Halt(2);
   end;
 NormVideo;
 Window(1,2,80,25);
 ClrScr;
 ShowStatusBar('STARTING-UP');
 Result:=MainNNTPGETART(ParamStr(1), ParamStr(2), TmpAddr, A);
 ShowTcpError('[EOP]');
 Writeln;
 If Result=0 then Writeln('Article Retreival Completed');

END.

