{ Generation of Penrose aperiodic tilings

Thanks to Herb Savage, who showed it was possible to generate those tilings
with L-systems and Fractint.

Based on decomposition of tilings described in Tilings and Pattern, by
Branko Grunbaum and G.C. Shepard, W.H. Freeman and Company, chapter 10

Philippe Hurbain
49 rue Jules Fossier
95380 LOUVRES
FRANCE
}

Penrose1 { ;; by Herb Savage
           ;; based on Martin Gardner's "Penrose Tiles to Trapdoor Ciphers",
           ;; Roger Penrose's rhombuses
  Angle 10
  Axiom +WF--XF---YF--ZF
  W=YF++ZF----XF[-YF----WF]++
  X=+YF--ZF[---WF--XF]+
  Y=-WF++XF[+++YF++ZF]-
  Z=--YF++++WF[+ZF++++XF]--XF
  F=
}

Losanges {
           ;; by Philippe Hurbain
           ;; Penrose's rhombuses, generated by decomposition rules
           ;; x generate the fat rhombus, y the thin one
           ;; Individualization of rhombuses allows easy coloring
           ;; 0.618034 is ({5-1)/2
  Angle 10
  Axiom x
  x=@.618034+f[|y]--f[|x][|+@.618034g@i.618034x]---[x]f--[y]f
  y=@.618034++[x]f|+f[|y]-[y]f|+f[|x]
  f=g
}

PentaColor {
             ;; by Philippe Hurbain
             ;; Simple coloring of Penrose's rhombuses, showing pentagons
  Angle 20
  Axiom c04[x]++++[x]++++[x]++++[x]++++[x]
  x=@.618034++f[c10@1.1755-------f][|y]----f[|x]
  x=[|++@.618034g@i.618034x]------[x]f----[y]f
  y=@.618034++++[x]f|++f[|y]--[y]f|++f[|x]
  f=g
}

Penta {
        ;; by Philippe Hurbain
        ;; Same as PentaColor, but showing only the coloring
  Angle 20
  Axiom [x]++++[x]++++[x]++++[x]++++[x]
  x=@.618034++g[@1.1755-------f][|y]----g[|x]
  x=[|++@.618034g@i.618034x]------[x]g----[y]g
  y=@.618034++++[x]g|++g[|y]--[y]g|++g[|x]
  f=g
}


Kites&Darts {
              ;; by Philippe Hurbain
              ;; Penrose's kites and darts
              ;; k generates the kite, a generates the dart
  Angle 10
  Axiom k
  k=+[@.618034a]f@.618034---[-k]f-f---[-k]@i.618034f[@.618034|a]
  a=[@.618034k]+f@.618034[|a]----f+f----[a]@i.618034f
  f=g
}

Kites&Darts2 {
               ;; by Philippe Hurbain
               ;; Penrose's kites and darts, with kites seed
  Angle 10
  Axiom [k]++[k]++[k]++[k]++[k]
  k=+[@.618034a]f@.618034---[-k]f-f---[-k]@i.618034f[@.618034|a]
  a=[@.618034k]+f@.618034[|a]----f+f----[a]@i.618034f
  f=g
}

Kites&Darts3 {
               ;; by Philippe Hurbain
               ;; Penrose's kites and darts, with darts seed
  Angle 10
  Axiom [a]++[a]++[a]++[a]++[a]
  k=+[@.618034a]f@.618034---[-k]f-f---[-k]@i.618034f[@.618034|a]
  a=[@.618034k]+f@.618034[|a]----f+f----[a]@i.618034f
  f=g
}

Kites&DartsColor {
                   ;; by Philippe Hurbain
                   ;; Penrose's kites and darts, with serpentine coloring
  Angle 10
  Axiom c4[k]++[k]++[k]++[k]++[k]
  k=+[@.618034a[g---@.618c10f][--g+++@.618c10f]]
  k=f@.618034---[-k]f-f---[-k]@i.618034f[@.618034|a]
  a=[@.618034k]+f@.618034[|a][|g++@.382c10f]----f+
  a=f----[a][g--@.382c10f]@i.618034f
  f=g
}


AmmannPolyColor {  
                  ;; by Philippe Hurbain
                  ;; Ammann's coloring of Penrose's rhombuses, giving an
                  ;; aperiodic tiling of 2 pentagons and 1 hexagon
  Angle 10
  Axiom c1x
  x=@.618034/36[c3\9@.66D]D[c3/196.5@.363D][/180y]\72D[/180x]
  x=[\144@.618034M@i.618034x]\108[c3\36@.509D@1.18\30D][x]D[c3\153@.66D]\72[y]D
  y=@.618034/72[x][c3\36@.509D]D\144[c3\9@.66D]D[/180y][c3/196.5@.363D]
  y=\36[y]D\144D[/180x]
  D=M
}

AmmannPoly {     
             ;; by Philippe Hurbain
             ;; Same as AmmanPolyColor, showing only the
             ;; pentagon/hexagon tiling
  Angle 10
  Axiom x
  x=@.618034/36[\9@.66D]M[/196.5@.363D][/180y]\72M[/180x]
  x=[\144@.618034M@i.618034x]\108[\36@.509D@1.18\30D][x]M[\153@.66D]\72[y]M
  y=@.618034/72[x][\36@.509D]M\144[\9@.66D]M[/180y][/196.5@.363D]
  y=\36[y]M\144M[/180x]
  D=M
}

Stars&PentasColor {
                ;; by Philippe Hurbain
                ;; Penrose's stars and pentagon tiling, generated as
                ;; a coloring of kites and darts
  Angle 20
  Axiom c04k
  k=++[@.618034[g-c10@.5878[f]------ff++++f]a]f@.618034------
  k=[--k]f--f------[--k]@i.618034f[@.618034|a]
  a=[@.618034k]++f@.618034[|[gc10@.5878+++++++f]a]--------f
  a=++f--------[c10g@.5878-------f][a]@i.618034f
  f=g
}

Stars&Pentas1 {
                ;; by Philippe Hurbain
                ;; Same as Stars&PentasColor, showing only coloring
  Angle 20
  Axiom [k]++++[k]++++[k]++++[k]++++[k]
  k=++[@.618034[g-@.5878[f]------ff++++f]a]g@.618034------
  k=[--k]g--g------[--k]@i.618034g[@.618034|a]
  a=[@.618034k]++g@.618034[|[g@.5878+++++++f]a]--------g
  a=++g--------[g@.5878-------f][a]@i.618034g
  f=g
}


Stars&Pentas2  {
                 ;; by Philippe Hurbain
                 ;; Penrose's stars and pentagons, generated from
                 ;; decomposition rules
                 ;; u is the star, v is the boat, w is the thin rhombus
                 ;; x, y and z are the pentagons
  Angle 10
  Axiom u
  u=@.381966[v]F[|y][-u]++F|+[v]F[|y]++F|+[v]F[|y]++F|+
  u=[v]F[|y]++F|+[v]F[|y]++F
  v=@.381966[v]F[|y]++F|+[v]F[|y]-[u]F-F|+[v]F[|y]++F
  w=@.381966G++[u]F|+F-F|+[v]F[|y]
  y=@.381966[x][y][w]F[|!y]++F++[y][w]F[|!y]++F++[z]F
  x=@.381966G++G++[!x][!z]F--[!z]F--[!z]F--[!z]F--[!z]F
  z=@.381966[z][x]F++[z]F++[w][y]F[|!y]++F++[z]F
  F=G
}

