; DAC_INIT.ASM
;
; Modified September 30, 1996 to add DAC_FOUND (formerly done in Pascal).
;
; External assembler subroutines for Recwav.pas and Testdiv.pas, to detect
; and initialize the DAC chip.
;
; The Turbo Pascal invocation syntax is:
;
; function dac_found:
;     boolean; external;
; procedure dac_init; external;
;

CODE		SEGMENT	BYTE PUBLIC
		ASSUME	CS:CODE,DS:CODE
;
; DAC_FOUND routine, detects the DAC.  Returns TRUE (1) if found, FALSE
; (0) if not.  No parameters.
;
		PUBLIC	DAC_FOUND
DAC_FOUND	PROC	NEAR
		;
		; Check for PCMCIA Socket Services.
		;
		MOV	AX,8003h
		XOR	CX,CX
		INT	1Ah
		CMP	CX,5353h
		JE	CHKDAC_NODAC
		;
		; Check for Tandy DAC.
		;
		MOV	AX,8100h
		INT	1Ah
		CMP	AX,8000h
		JAE	CHKDAC_NODAC
		MOV	DX,AX		; DX = base DAC port + 2
		ADD	DX,2
		CLI
		IN	AL,DX		; get current value and save in CL
		MOV	CL,AL
		MOV	CH,0		; set CH=0 (assume no DAC)
		XOR	AL,AL		; clear all the bits
		OUT	DX,AL
		IN	AL,DX		; read them back
		OR	AL,AL			; all clear?
		JNZ	CHKDAC_DACCHKDONE	; if not, no DAC
		NOT	AL			; set all the bits
		OUT	DX,AL
		IN	AL,DX			; read them back
		NOT	AL			; all set?
		JNZ	CHKDAC_DACCHKDONE	; if not, no DAC
		MOV	CH,1		; CH=1 (definitely a DAC here)
CHKDAC_DACCHKDONE:
		MOV	AL,CL	; restore previous value at DAC base + 2
		OUT	DX,AL
		STI
		MOV	AL,CH	; AX=1 if DAC was there
		MOV	AH,0
		JMP	CHKDAC_END
CHKDAC_NODAC:
		XOR	AX,AX	; AX=0 => no DAC present
CHKDAC_END:
		RET
DAC_FOUND	ENDP
;
; DAC_INIT routine, initializes the DAC.  Assumes it has previously been
; detected.  No parameters, returns nothing.
;
		PUBLIC	DAC_INIT
DAC_INIT	PROC	NEAR
		JMP	START
		;
		; Local data.
		;
SOUNDHALTED	DB	0	; flag, 1 when Int 1Ah function complete
INT15OLD	DD	0	; default vector for Int 15h
		;
		; Temporary Int 15h handler.
		;
INT15NEW:	CMP	AX,91FBh
		JE	>L0
		JMP	DWORD PTR CS:INT15OLD
L0:		MOV	CS:SOUNDHALTED,1
		IRET
		;
		; Body of the procedure.  DS addresses code segment.
		;
START:		PUSH	DS
		MOV	AX,CS
		MOV	DS,AX
		;
		; Save the default Int 15h vector.
		;
		MOV	AX,3515h
		INT	21h
		MOV	WORD PTR INT15OLD,BX
		MOV	WORD PTR INT15OLD+2,ES
		;
		; Use the new Int 15h handler now.
		;
		MOV	DX,OFFSET INT15NEW
		MOV	AX,2515h
		INT	21h
		;
		; Prepare the sound chip.  (Mr. Terry's code.)
		;
		MOV	SOUNDHALTED,0
L1:		MOV	AH,84h
		INT	1Ah
L2:		MOV	AH,81h
		INT	1Ah
		JC	L2
		CMP	SOUNDHALTED,0
		JE	L1
		;
		; Restore the default Int 15h vector.
		;
		MOV	DX,WORD PTR INT15OLD
		MOV	DS,WORD PTR INT15OLD+2
		MOV	AX,2515h
		INT	21h
		;
		; Restore DS and exit.
		;
		POP	DS
		RET
DAC_INIT	ENDP
CODE		ENDS
		END
