;------------------------------------------------------------------------
;                                                                        
; CSRBASE.INC Base Include File for DMCSR
;                                                                        
; This include file contains common/miscellaneous defines and            
; structures, including:                                                 
;     Compatibility defines                                    
;     Tags                                                               
;     General defines                                                    
;     Common key codes                                                   
;     Mapping rectangles                                                 
;     Title line constants                                               
;     Common graphic primitives                                          
;     Event Manager defines and structures                               
;     HELP structure                                                     
;     ALARM structure                                                    
;                                                                        
; Last update: 03/24/89
;                                                                        
;------------------------------------------------------------------------

; CSR/Application version defines 
USER88      equ 0   ; current CSR User is a 1988 version 
USER89      equ 1   ; current CSR User is a 1989 version 

; Return code tags 
ASCII_TAG   equ 0000h      ; ASCII key codes 
SYS_TAG     equ 0FF00h      ; system defined return codes 
ALT_TAG     equ 0FE00h      ; ALT'ed key codes 
CTRL_TAG    equ 0FD00h      ; CTRL'ed key codes 
BIG_TAG     equ 0FC00h      ; big select key codes 
MOUSE_TAG   equ 0FB00h      ; mouse event manager codes 
MENU_TAG    equ 0FA00h      ; menubar component codes 
ARROW_TAG   equ 0F900h      ; arrow key and menubar arrow codes 
CMP_TAG     equ 0F800h      ; component code 
MSG_TAG     equ 0F700h      ; message box codes 
FILE_TAG    equ 0F600h      ; form manager codes 
APP_TAG     equ 0F500h      ; application defined return codes 
F11_TAG     equ 0F400h      ; F11 DeskMate extended codes 
WDG_TAG     equ 8400h      ; keyboard wedge modified key codes 

; General defines 
CHAR_XEXT       equ 100         ; world coordinate width of character 
CHAR_YEXT       equ 220         ; world coordinate height of character 

CSR_NULL         equ 0          ; null or not available code 
CSR_ERROR       equ -1          ; error or exception code 
CSR_DEFAULT     equ -2          ; default state code 

HCR             equ 0Dh        ; hard carriage return 
SCR             equ 0Ah        ; soft carraige return 

LINE_FEED       equ 0Ah        ; line feed control code 
FORM_FEED       equ 0Ch        ; form feed control code 

END_OF_FILE     equ 1Ah        ; end of file marker 

BELL            equ 7           ; bell character 

ENABLED         equ 1           ; item or feature enabled 
DISABLED        equ 0           ; item or feature disabled 

SELECTED        equ ENABLED     ; item or feature selected 
DESELECTED      equ DISABLED    ; item or feature deselected 

BUTTON_UP       equ DESELECTED  ; button is up, item not selected 
BUTTON_DOWN     equ SELECTED    ; button is down, item selected 

BUSY_PRESERVE       equ SELECTED    ; preserve bgnd of busy icon (TBD) 
BUSY_NO_PRESERVE    equ DESELECTED  ; do not preserve bgnd (TBD) 

; Common key codes 
RETURN_KEY      equ (ASCII_TAG+0Dh)
ESC_KEY         equ (ASCII_TAG+1Bh)
ALT_SPACE_KEY   equ (WDG_TAG+06h)

; These are the different accessories available & their associated codes 
ACC_CALC        equ 00h
; 0x01 must remain undefined due to MS-DOS parameter limitations 
ACC_NOTEPD      equ 02h
ACC_CORKBRD     equ 02h
ACC_CAL         equ 03h
ACC_CLIPBD      equ 04h
ACC_COLORS      equ 05h
ACC_COMM        equ 06h
ACC_DATTIM      equ 07h
ACC_MOUSE       equ 08h
ACC_PRINTR      equ 09h
ACC_HELP        equ 0Ah
ACC_PGSETUP     equ 0Bh
ACC_PHONE       equ 0Ch
ACC_DESKLINK    equ 0Dh
ACC_VIDEO       equ 0Eh
ACC_TASKSWITCH  equ 0Fh
ACC_SPELL       equ 10h
ACC_ALARM       equ 11h
ACC_SETUP       equ 12h
ACC_TALK        equ 13h

ACC_TODO        equ 14h
ACC_MORE        equ 15h


; 02-06-89 - equates moved form the dmexec.inc 
;---------------------------------------------------------------------------
; The executive is responsible for providing the Core Services Resource     
; with two blocks of memory. The first is a single block used by the CSR    
; for CSR task independent data.  The second block is for the data for the  
; currently execing task.  The segment addresses for the blocks of data     
; will be placed in an unused location in the vector table. It is the execs 
; responsibility to make sure the second (task specific) address is always  
; correct.                                                                  
;---------------------------------------------------------------------------
CSR_RAM_VECTOR_SEG	 equ 0000h	; Segment add of task independent data  
CSR_RAM_VECTOR_ADD	 equ 0384h	; 0:offset of the task independent data  
CSR_TASK_VECTOR_ADD equ 0386h	; 0:offset of the task dependent data   



; Mapping rectangles 
RECT struc
    RECT_x1                   dw  ?   ;rectangle x1 coordinate 
    RECT_y1                   dw  ?   ;rectangle y1 coordinate 
    RECT_x2                   dw  ?   ;rectangle x2 coordinate 
    RECT_y2                   dw  ?   ;rectangle y2 coordinate 
RECT ends



MAPRECT struc
    MAPRECT_xorg              dw  ?   ;rectangle x origin 
    MAPRECT_yorg              dw  ?   ;rectangle y origin 
    MAPRECT_xext              dw  ?   ;rectangle x extent 
    MAPRECT_yext              dw  ?   ;rectangle y extent 
MAPRECT ends



; Title Line constants 
TTL_XORG    equ 29*CHAR_XEXT    ; x origin of usable area of title line 
TTL_YORG    equ 12              ; y origin of usable area of title line 
TTL_XEXT    equ 40*CHAR_XEXT    ; x extent of usable area of title line 

; graphic primitive structures 
ARC struc
    ARC_base1_x               dw  ?   ;first base point x 
    ARC_base1_y               dw  ?   ;first base point y 
    ARC_base2_x               dw  ?   ;second base point x 
    ARC_base2_y               dw  ?   ;second base point y 
    ARC_apogee_x              dw  ?   ;apogee x 
    ARC_apogee_y              dw  ?   ;apogee y 
ARC ends



IMAGE struc
    IMAGE_maprect             db  size MAPRECT dup (?)   ;maprect on device to size image to 
    IMAGE_bTransparent        db  ?   ;flag for COLOR1 transparency 
    IMAGE_bitmap_xext         dw  ?   ;number of pels in x extent of image 
    IMAGE_bitmap_yext         dw  ?   ;number of pels in y extent of image 
    IMAGE_nColors             db  ?   ;IMAGE_2COLORS, IMAGE_4COLORS, etc. 
    IMAGE_pBitmap             dw  ?   ;pointer to generic bitmap 
IMAGE ends



; Number of colors in a bitmap definition 
IMAGE_2COLORS   equ 1
IMAGE_4COLORS   equ 2
IMAGE_16COLORS  equ 4
IMAGE_256COLORS equ 8

; Event Manager 
EVENT struc
    EVENT_msg                 db  ?   ;event type 
    EVENT_param               dw  ?   ;event parameter 
    EVENT_x                   dw  ?   ;event mouse x 
    EVENT_y                   dw  ?   ;event mouse y 
EVENT ends



; Event types for msg element 
EVENT_NULL          equ 0   ; no event 
EVENT_CHAR          equ 1   ; character event 
EVENT_MOUSE         equ 2   ; mouse click event 
EVENT_COMMAND       equ 3   ; command event 
EVENT_OUTSIDE       equ 4   ; outside event 
EVENT_REEVALUATE    equ 5   ; reevaluate raw event (for event_write) 
EVENT_APPL          equ 6   ; special application message 
EVENT_MENU          equ 7   ; special menubar event 

; Mouse event types for param element 
MS_CLICK        equ (MOUSE_TAG+1)   ; single click 
MS_DBL_CLICK    equ (MOUSE_TAG+2)   ; double click 
MS_BUTTON_DOWN  equ (MOUSE_TAG+3)   ; button down (begin repeat) 
MS_HOLD         equ (MOUSE_TAG+4)   ; button held (repeating) 
MS_BUTTON_UP    equ (MOUSE_TAG+5)   ; button released (end repeat) 
MS_SHFT_CLICK   equ (MOUSE_TAG+6)   ; shifted click 

; Application messages for param element 
APPL_REDRAW_VID     equ 1   ; redraw video 
APPL_REDRAW_VGM     equ 2   ; redraw form 
APPL_ACCESS         equ 3   ; accessory executed 
APPL_TASK_SWITCH    equ 4   ; task switch requested 
APPL_STAT           equ 5   ; request for immediate Appl attention 
APPL_ALARM          equ 6   ; an alarm item has been selected 

; Definable event drivers and interpreters 
EDRIVER struc
    EDRIVER_pInit             dd  ?   ;event driver init routine pointer 
    EDRIVER_pRead             dd  ?   ;event driver scan routine pointer 
    EDRIVER_pResrv1           dd  ?   ;reserved for future use 
    EDRIVER_pResrv2           dd  ?   ;reserved for future use 
EDRIVER ends



INTERP struc
    INTERP_priority           db  ?   ;priority relative to internal interps 
    INTERP_pInterp            dd  ?   ;far pointer to interpreter routine 
INTERP ends



EVENT_HIGH_PRIORITY equ 1
EVENT_LOW_PRIORITY  equ 2

; Mouse status 
MOUSE_STAT struc
    MOUSE_STAT_bDriver        db  ?   ;enable state of driver 
    MOUSE_STAT_bPointer       db  ?   ;on/off state of pointer 
    MOUSE_STAT_bRegions       db  ?   ;enable state of pointer regions 
    MOUSE_STAT_button_state   db  ?   ;status of the mouse buttons 
    MOUSE_STAT_pointer_x      dw  ?   ;mouse pointer wc x position 
    MOUSE_STAT_pointer_y      dw  ?   ;mouse pointer wc y position 
MOUSE_STAT ends



MS_BUTTON_OPEN      equ 0   ; mouse button is up 
MS_BUTTON_CLOSED    equ 1   ; mouse button is closed 

; Mouse pointer regions 
PTR_REGION struc
    PTR_REGION_id             db  ?   ;application defined id for region 
    PTR_REGION_maprect        db  size MAPRECT dup (?)
    PTR_REGION_focal_x        db  ?   ;mouse hot spot x 
    PTR_REGION_focal_y        db  ?   ;mouse hot spot y 
    PTR_REGION_pPointer       dw  ?   ;pointer to mouse pointer definition 
PTR_REGION ends



; Help levels 
HELP struc
    HELP_pMenubar             dd  ?
    HELP_state                dw  ?
    HELP_level                db  ?
HELP ends



HELP_NULL   equ 0   ; no help available for category 

; Main Menubar Manager ALARM sturcture 
ALARM struc
    ALARM_pType               dw  ?   ;<=16 char ASCIIZ string for menuitem 
    ALARM_pMessage            dw  ?   ;<=120 char ASCIIZ string for message 
    ALARM_bRemove             db  ?   ;remove alarm on User selection flag 
    ALARM_pSelected           dd  ?   ;far call upon User selection address 
ALARM ends

;end of CSRBASE.INC
